/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.impl;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.semanticmetadata.lire.AbstractImageSearcher;
import net.semanticmetadata.lire.ImageDuplicates;
import net.semanticmetadata.lire.ImageSearchHits;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.impl.SimpleImageSearchHits;
import net.semanticmetadata.lire.impl.SimpleResult;
import net.semanticmetadata.lire.utils.ImageUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.util.Bits;

public class ParallelImageSearcher
extends AbstractImageSearcher {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    Class<?> descriptorClass;
    String fieldName;
    private int maxHits = 10;
    private TreeSet<SimpleResult>[] parDocs;

    public ParallelImageSearcher(int maxHits, Class<?> descriptorClass, String fieldName) {
        this.maxHits = maxHits;
        this.descriptorClass = descriptorClass;
        this.fieldName = fieldName;
    }

    @Override
    public ImageSearchHits search(BufferedImage image, IndexReader reader) throws IOException {
        throw new UnsupportedOperationException("Not implemented in this searcher");
    }

    public ImageSearchHits[] search(BufferedImage[] image, IndexReader reader) throws IOException {
        this.logger.finer("Starting extraction.");
        LireFeature[] lireFeature = new LireFeature[image.length];
        ImageSearchHits[] searchHits = new SimpleImageSearchHits[image.length];
        for (int i = 0; i < image.length; ++i) {
            BufferedImage img = image[i];
            try {
                lireFeature[i] = (LireFeature)this.descriptorClass.newInstance();
                BufferedImage bimg = img;
                if (Math.max(img.getHeight(), img.getWidth()) > 1024) {
                    bimg = ImageUtils.scaleImage(img, 1024);
                }
                lireFeature[i].extract(bimg);
                this.logger.fine("Extraction from image finished");
                continue;
            }
            catch (InstantiationException e) {
                this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
                continue;
            }
            catch (IllegalAccessException e) {
                this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
            }
        }
        float[] distance = this.findSimilar(reader, lireFeature);
        for (int i = 0; i < distance.length; ++i) {
            searchHits[i] = new SimpleImageSearchHits(this.parDocs[i], distance[i]);
        }
        return searchHits;
    }

    public ImageSearchHits[] search(Document[] doc, IndexReader reader) throws IOException {
        LireFeature[] lireFeature = new LireFeature[doc.length];
        ImageSearchHits[] searchHits = new SimpleImageSearchHits[doc.length];
        for (int i = 0; i < doc.length; ++i) {
            Document doc_ = doc[i];
            try {
                lireFeature[i] = (LireFeature)this.descriptorClass.newInstance();
                String[] cls = doc_.getValues(this.fieldName);
                if (cls == null || cls.length <= 0) continue;
                lireFeature[i].setStringRepresentation(cls[0]);
                continue;
            }
            catch (InstantiationException e) {
                this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
                continue;
            }
            catch (IllegalAccessException e) {
                this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
            }
        }
        float[] distance = this.findSimilar(reader, lireFeature);
        for (int i = 0; i < distance.length; ++i) {
            searchHits[i] = new SimpleImageSearchHits(this.parDocs[i], distance[i]);
        }
        return searchHits;
    }

    private float[] findSimilar(IndexReader reader, LireFeature[] lireFeature) throws IOException {
        int i;
        float[] maxDistance = new float[lireFeature.length];
        float[] overallMaxDistance = new float[lireFeature.length];
        for (i = 0; i < overallMaxDistance.length; ++i) {
            overallMaxDistance[i] = -1.0f;
            maxDistance[i] = -1.0f;
        }
        this.parDocs = new TreeSet[lireFeature.length];
        for (i = 0; i < this.parDocs.length; ++i) {
            this.parDocs[i] = new TreeSet();
        }
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
        int docs = reader.numDocs();
        for (int i2 = 0; i2 < docs; ++i2) {
            if (reader.hasDeletions() && !liveDocs.get(i2)) continue;
            Document d = reader.document(i2);
            float[] distance = this.getDistance(d, lireFeature);
            for (int j = 0; j < distance.length; ++j) {
                float f = distance[j];
                if (overallMaxDistance[j] < f) {
                    overallMaxDistance[j] = f;
                }
                if (maxDistance[j] < 0.0f) {
                    maxDistance[j] = f;
                }
                if (this.parDocs[j].size() < this.maxHits) {
                    this.parDocs[j].add(new SimpleResult(f, d, i2));
                    if (!(f > maxDistance[j])) continue;
                    maxDistance[j] = f;
                    continue;
                }
                if (!(f < maxDistance[j])) continue;
                this.parDocs[j].remove(this.parDocs[j].last());
                this.parDocs[j].add(new SimpleResult(f, d, i2));
                maxDistance[j] = this.parDocs[j].last().getDistance();
            }
        }
        return maxDistance;
    }

    private float[] getDistance(Document d, LireFeature[] lireFeature) {
        float[] distance = new float[lireFeature.length];
        try {
            LireFeature lf = (LireFeature)this.descriptorClass.newInstance();
            String[] cls = d.getValues(this.fieldName);
            if (cls != null && cls.length > 0) {
                lf.setStringRepresentation(cls[0]);
                for (int i = 0; i < lireFeature.length; ++i) {
                    distance[i] = lireFeature[i].getDistance(lf);
                }
            } else {
                this.logger.warning("No feature stored in this document!");
            }
        }
        catch (InstantiationException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        return distance;
    }

    @Override
    public ImageSearchHits search(Document doc, IndexReader reader) throws IOException {
        throw new UnsupportedOperationException("Not implemented in this searcher");
    }

    @Override
    public ImageDuplicates findDuplicates(IndexReader reader) throws IOException {
        throw new UnsupportedOperationException("Not implemented in this searcher");
    }

    public String toString() {
        return "GenericSearcher using " + this.descriptorClass.getName();
    }
}

