/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.impl;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import net.semanticmetadata.lire.AbstractDocumentBuilder;
import net.semanticmetadata.lire.imageanalysis.sift.Extractor;
import net.semanticmetadata.lire.imageanalysis.sift.Feature;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;

public class SiftDocumentBuilder
extends AbstractDocumentBuilder {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private Extractor extractor = new Extractor();

    @Override
    public Field[] createDescriptorFields(BufferedImage image) {
        Field[] result = null;
        try {
            List<Feature> features = this.extractor.computeSiftFeatures(image);
            result = new Field[features.size()];
            int count = 0;
            for (Feature f : features) {
                result[count] = new StoredField("featureSift", f.getByteArrayRepresentation());
                ++count;
            }
        }
        catch (IOException e) {
            this.logger.severe(e.getMessage());
        }
        return result;
    }

    @Override
    public Document createDocument(BufferedImage image, String identifier) {
        Document doc = null;
        try {
            List<Feature> features = this.extractor.computeSiftFeatures(image);
            doc = new Document();
            for (Feature f : features) {
                doc.add((IndexableField)new StoredField("featureSift", f.getByteArrayRepresentation()));
            }
            if (identifier != null) {
                doc.add((IndexableField)new StringField("descriptorImageIdentifier", identifier, Field.Store.YES));
            }
        }
        catch (IOException e) {
            this.logger.severe(e.getMessage());
        }
        return doc;
    }
}

