/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.solr;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.util.Base64;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;

public class BinaryDocValuesField
extends FieldType {
    private String toBase64String(ByteBuffer byteBuffer) {
        return Base64.byteArrayToBase64((byte[])byteBuffer.array(), (int)byteBuffer.position(), (int)(byteBuffer.limit() - byteBuffer.position()));
    }

    public void write(TextResponseWriter textResponseWriter, String string, IndexableField indexableField) throws IOException {
        textResponseWriter.writeStr(string, this.toBase64String(this.toObject(indexableField)), false);
    }

    public SortField getSortField(SchemaField schemaField, boolean bl) {
        throw new RuntimeException("Cannot sort on a Binary field");
    }

    public String toExternal(IndexableField indexableField) {
        return this.toBase64String(this.toObject(indexableField));
    }

    public ByteBuffer toObject(IndexableField indexableField) {
        BytesRef bytesRef = indexableField.binaryValue();
        return ByteBuffer.wrap(bytesRef.bytes, bytesRef.offset, bytesRef.length);
    }

    public IndexableField createField(SchemaField schemaField, Object object, float f) {
        Object object2;
        if (object == null) {
            return null;
        }
        if (!schemaField.stored()) {
            return null;
        }
        byte[] byArray = null;
        int n = 0;
        int n2 = 0;
        if (object instanceof byte[]) {
            byArray = (byte[])object;
            n2 = byArray.length;
        } else if (object instanceof ByteBuffer && ((ByteBuffer)object).hasArray()) {
            object2 = (ByteBuffer)object;
            byArray = ((ByteBuffer)object2).array();
            n = ((Buffer)object2).position();
            n2 = ((Buffer)object2).limit() - ((Buffer)object2).position();
        } else {
            object2 = object.toString();
            byArray = Base64.base64ToByteArray((String)object2);
            n = 0;
            n2 = byArray.length;
        }
        object2 = new org.apache.lucene.document.BinaryDocValuesField(schemaField.getName(), new BytesRef(byArray, n, n2));
        object2.setBoost(f);
        return object2;
    }
}

