/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.solr;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.semanticmetadata.lire.imageanalysis.ColorLayout;
import net.semanticmetadata.lire.imageanalysis.EdgeHistogram;
import net.semanticmetadata.lire.imageanalysis.JCD;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.imageanalysis.OpponentHistogram;
import net.semanticmetadata.lire.imageanalysis.PHOG;
import net.semanticmetadata.lire.indexing.hashing.BitSampling;
import net.semanticmetadata.lire.solr.ParallelSolrIndexer;
import org.apache.commons.codec.binary.Base64;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.EntityProcessorBase;

public class LireEntityProcessor
extends EntityProcessorBase {
    protected boolean done = false;
    protected LireFeature[] listOfFeatures = new LireFeature[]{new ColorLayout(), new PHOG(), new EdgeHistogram(), new JCD(), new OpponentHistogram()};
    protected static HashMap<Class, String> classToPrefix = new HashMap(5);
    int count = 0;

    protected void firstInit(Context context) {
        super.firstInit(context);
        this.done = false;
    }

    public Map<String, Object> nextRow() {
        if (this.done) {
            this.done = false;
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        DataSource dataSource = this.context.getDataSource();
        InputStream inputStream = (InputStream)dataSource.getData(this.context.getResolvedEntityAttribute("url"));
        hashMap.put("id", this.context.getResolvedEntityAttribute("url"));
        try {
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            hashMap.put("id", this.context.getResolvedEntityAttribute("url"));
            for (int i = 0; i < this.listOfFeatures.length; ++i) {
                LireFeature lireFeature = this.listOfFeatures[i];
                lireFeature.extract(bufferedImage);
                String string = classToPrefix.get(lireFeature.getClass()) + "_hi";
                String string2 = classToPrefix.get(lireFeature.getClass()) + "_ha";
                hashMap.put(string, Base64.encodeBase64String((byte[])lireFeature.getByteArrayRepresentation()));
                hashMap.put(string2, ParallelSolrIndexer.arrayToString(BitSampling.generateHashes(lireFeature.getDoubleHistogram())));
            }
        }
        catch (IOException iOException) {
            DataImportHandlerException.wrapAndThrow((int)500, (Exception)iOException, (String)"Error loading image or extracting features.");
        }
        this.done = true;
        return hashMap;
    }

    static {
        classToPrefix.put(ColorLayout.class, "cl");
        classToPrefix.put(EdgeHistogram.class, "eh");
        classToPrefix.put(PHOG.class, "ph");
        classToPrefix.put(OpponentHistogram.class, "oh");
        classToPrefix.put(JCD.class, "jc");
    }
}

