/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.solr;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import net.semanticmetadata.lire.imageanalysis.ColorLayout;
import net.semanticmetadata.lire.imageanalysis.EdgeHistogram;
import net.semanticmetadata.lire.imageanalysis.JCD;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.imageanalysis.OpponentHistogram;
import net.semanticmetadata.lire.imageanalysis.PHOG;
import net.semanticmetadata.lire.impl.SimpleResult;
import net.semanticmetadata.lire.indexing.hashing.BitSampling;
import net.semanticmetadata.lire.utils.ImageUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrIndexSearcher;

public class LireRequestHandler
extends RequestHandlerBase {
    private static HashMap<String, Class> fieldToClass = new HashMap(5);
    private long time = 0L;
    private int countRequests = 0;
    private int defaultNumberOfResults = 60;
    private int candidateResultNumber = 1500;

    public void init(NamedList namedList) {
        super.init(namedList);
    }

    public void handleRequestBody(SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) throws Exception {
        if (solrQueryRequest.getParams().get("hashes") != null) {
            this.handleHashSearch(solrQueryRequest, solrQueryResponse);
        } else if (solrQueryRequest.getParams().get("url") != null) {
            this.handleUrlSearch(solrQueryRequest, solrQueryResponse);
        } else if (solrQueryRequest.getParams().get("id") != null) {
            this.handleIdSearch(solrQueryRequest, solrQueryResponse);
        } else if (solrQueryRequest.getParams().get("extract") != null) {
            this.handleExtract(solrQueryRequest, solrQueryResponse);
        } else {
            this.handleRandomSearch(solrQueryRequest, solrQueryResponse);
        }
    }

    private void handleIdSearch(SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) throws IOException, InstantiationException, IllegalAccessException {
        SolrIndexSearcher solrIndexSearcher = solrQueryRequest.getSearcher();
        try {
            TopDocs topDocs = solrIndexSearcher.search((Query)new TermQuery(new Term("id", solrQueryRequest.getParams().get("id"))), 1);
            String string = "cl_ha";
            if (solrQueryRequest.getParams().get("field") != null) {
                string = solrQueryRequest.getParams().get("field");
            }
            LireFeature lireFeature = (LireFeature)fieldToClass.get(string).newInstance();
            solrQueryResponse.add("QueryField", (Object)string);
            solrQueryResponse.add("QueryFeature", (Object)lireFeature.getClass().getName());
            if (topDocs.scoreDocs.length > 0) {
                BinaryDocValues binaryDocValues = MultiDocValues.getBinaryValues((IndexReader)solrIndexSearcher.getIndexReader(), (String)string.replace("_ha", "_hi"));
                if (binaryDocValues == null) {
                    System.err.println("Could not find the DocValues of the query document. Are they in the index?");
                }
                BytesRef bytesRef = new BytesRef();
                binaryDocValues.get(topDocs.scoreDocs[0].doc, bytesRef);
                String string2 = string.replace("_ha", "_hi");
                lireFeature.setByteArrayRepresentation(bytesRef.bytes, bytesRef.offset, bytesRef.length);
                int n = this.defaultNumberOfResults;
                if (solrQueryRequest.getParams().getInt("rows") != null) {
                    n = solrQueryRequest.getParams().getInt("rows");
                }
                int[] nArray = BitSampling.generateHashes(lireFeature.getDoubleHistogram());
                BooleanQuery booleanQuery = this.createQuery(nArray, string, 0.5);
                this.doSearch(solrQueryResponse, solrIndexSearcher, string, n, booleanQuery, lireFeature);
            } else {
                solrQueryResponse.add("Error", (Object)("Did not find an image with the given id " + solrQueryRequest.getParams().get("id")));
            }
        }
        catch (Exception exception) {
            solrQueryResponse.add("Error", (Object)("There was an error with your search for the image with the id " + solrQueryRequest.getParams().get("id") + ": " + exception.getMessage()));
        }
    }

    private void handleRandomSearch(SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) throws IOException {
        SolrIndexSearcher solrIndexSearcher = solrQueryRequest.getSearcher();
        DirectoryReader directoryReader = solrIndexSearcher.getIndexReader();
        double d = directoryReader.maxDoc();
        int n = this.defaultNumberOfResults;
        if (solrQueryRequest.getParams().getInt("rows") != null) {
            n = solrQueryRequest.getParams().getInt("rows");
        }
        LinkedList linkedList = new LinkedList();
        while (linkedList.size() < n) {
            HashMap<String, String> hashMap = new HashMap<String, String>(2);
            Document document = directoryReader.document((int)Math.floor(Math.random() * d));
            hashMap.put("id", document.getValues("id")[0]);
            hashMap.put("title", document.getValues("title")[0]);
            linkedList.add(hashMap);
        }
        solrQueryResponse.add("docs", linkedList);
    }

    private void handleUrlSearch(SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) throws IOException, InstantiationException, IllegalAccessException {
        SolrParams solrParams = solrQueryRequest.getParams();
        String string = solrParams.get("url");
        String string2 = "cl_ha";
        if (solrQueryRequest.getParams().get("field") != null) {
            string2 = solrQueryRequest.getParams().get("field");
        }
        int n = this.defaultNumberOfResults;
        if (solrParams.get("rows") != null) {
            n = solrParams.getInt("rows");
        }
        LireFeature lireFeature = null;
        BooleanQuery booleanQuery = null;
        try {
            BufferedImage bufferedImage = ImageIO.read(new URL(string).openStream());
            bufferedImage = ImageUtils.trimWhiteSpace(bufferedImage);
            lireFeature = string2 == null ? new EdgeHistogram() : (string2.equals("cl_ha") ? new ColorLayout() : (string2.equals("jc_ha") ? new JCD() : (string2.equals("ph_ha") ? new PHOG() : (string2.equals("oh_ha") ? new OpponentHistogram() : new EdgeHistogram()))));
            lireFeature.extract(bufferedImage);
            int[] nArray = BitSampling.generateHashes(lireFeature.getDoubleHistogram());
            booleanQuery = this.createQuery(nArray, string2, 0.5);
        }
        catch (Exception exception) {
            solrQueryResponse.add("Error", (Object)("Error reading image from URL: " + string + ": " + exception.getMessage()));
            exception.printStackTrace();
        }
        if (lireFeature != null) {
            this.doSearch(solrQueryResponse, solrQueryRequest.getSearcher(), string2, n, booleanQuery, lireFeature);
        }
    }

    private void handleExtract(SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) throws IOException, InstantiationException, IllegalAccessException {
        SolrParams solrParams = solrQueryRequest.getParams();
        String string = solrParams.get("extract");
        String string2 = "cl_ha";
        if (solrQueryRequest.getParams().get("field") != null) {
            string2 = solrQueryRequest.getParams().get("field");
        }
        LireFeature lireFeature = null;
        try {
            BufferedImage bufferedImage = ImageIO.read(new URL(string).openStream());
            bufferedImage = ImageUtils.trimWhiteSpace(bufferedImage);
            lireFeature = string2 == null ? new EdgeHistogram() : (string2.equals("cl_ha") ? new ColorLayout() : (string2.equals("jc_ha") ? new JCD() : (string2.equals("ph_ha") ? new PHOG() : (string2.equals("oh_ha") ? new OpponentHistogram() : new EdgeHistogram()))));
            lireFeature.extract(bufferedImage);
            solrQueryResponse.add("histogram", (Object)Base64.encodeBase64String((byte[])lireFeature.getByteArrayRepresentation()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void handleHashSearch(SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) throws IOException, IllegalAccessException, InstantiationException {
        SolrParams solrParams = solrQueryRequest.getParams();
        SolrIndexSearcher solrIndexSearcher = solrQueryRequest.getSearcher();
        String[] stringArray = solrParams.get("hashes").trim().split(" ");
        byte[] byArray = Base64.decodeBase64((String)solrParams.get("feature"));
        String string = "cl_ha";
        if (solrQueryRequest.getParams().get("field") != null) {
            string = solrQueryRequest.getParams().get("field");
        }
        int n = this.defaultNumberOfResults;
        if (solrParams.getInt("rows") != null) {
            n = solrParams.getInt("rows");
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
            if (stringArray[i].length() <= 0) continue;
            booleanQuery.add(new BooleanClause((Query)new TermQuery(new Term(string, stringArray[i].trim())), BooleanClause.Occur.SHOULD));
        }
        LireFeature lireFeature = (LireFeature)fieldToClass.get(string).newInstance();
        lireFeature.setByteArrayRepresentation(byArray);
        this.doSearch(solrQueryResponse, solrIndexSearcher, string, n, booleanQuery, lireFeature);
    }

    private void doSearch(SolrQueryResponse solrQueryResponse, SolrIndexSearcher solrIndexSearcher, String string, int n, BooleanQuery booleanQuery, LireFeature lireFeature) throws IOException, IllegalAccessException, InstantiationException {
        LireFeature lireFeature2 = (LireFeature)lireFeature.getClass().newInstance();
        this.time = System.currentTimeMillis();
        TopDocs topDocs = solrIndexSearcher.search((Query)booleanQuery, this.candidateResultNumber);
        this.time = System.currentTimeMillis() - this.time;
        solrQueryResponse.add("RawDocsCount", (Object)(topDocs.scoreDocs.length + ""));
        solrQueryResponse.add("RawDocsSearchTime", (Object)(this.time + ""));
        this.time = System.currentTimeMillis();
        TreeSet<SimpleResult> treeSet = new TreeSet<SimpleResult>();
        float f = -1.0f;
        String string2 = string.replace("_ha", "_hi");
        BinaryDocValues binaryDocValues = MultiDocValues.getBinaryValues((IndexReader)solrIndexSearcher.getIndexReader(), (String)string2);
        BytesRef bytesRef = new BytesRef();
        for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
            binaryDocValues.get(topDocs.scoreDocs[i].doc, bytesRef);
            lireFeature2.setByteArrayRepresentation(bytesRef.bytes, bytesRef.offset, bytesRef.length);
            float f2 = lireFeature.getDistance(lireFeature2);
            if (treeSet.size() < n) {
                treeSet.add(new SimpleResult(f2, solrIndexSearcher.doc(topDocs.scoreDocs[i].doc), topDocs.scoreDocs[i].doc));
                f = ((SimpleResult)treeSet.last()).getDistance();
                continue;
            }
            if (!(f2 < f)) continue;
            treeSet.remove(treeSet.last());
            treeSet.add(new SimpleResult(f2, solrIndexSearcher.doc(topDocs.scoreDocs[i].doc), topDocs.scoreDocs[i].doc));
            f = ((SimpleResult)treeSet.last()).getDistance();
        }
        this.time = System.currentTimeMillis() - this.time;
        solrQueryResponse.add("ReRankSearchTime", (Object)(this.time + ""));
        LinkedList linkedList = new LinkedList();
        for (SimpleResult simpleResult : treeSet) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
            hashMap.put("d", Float.valueOf(simpleResult.getDistance()));
            hashMap.put("id", simpleResult.getDocument().get("id"));
            hashMap.put("title", simpleResult.getDocument().get("title"));
            linkedList.add(hashMap);
        }
        solrQueryResponse.add("docs", linkedList);
    }

    public String getDescription() {
        return "LIRE Request Handler to add images to an index and search them. Search images by id, by url and by extracted features.";
    }

    public String getSource() {
        return "http://lire-project.net";
    }

    public NamedList<Object> getStatistics() {
        NamedList namedList = super.getStatistics();
        namedList.add("Number of Requests", (Object)this.countRequests);
        return namedList;
    }

    private BooleanQuery createQuery(int[] nArray, String string, double d) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(nArray[i]);
        }
        Collections.shuffle(arrayList);
        BooleanQuery booleanQuery = new BooleanQuery();
        int n = (int)Math.min((double)nArray.length, Math.floor((double)nArray.length * d));
        if (n < 5) {
            n = nArray.length;
        }
        for (int i = 0; i < n; ++i) {
            booleanQuery.add(new BooleanClause((Query)new TermQuery(new Term(string, Integer.toHexString(nArray[i]))), BooleanClause.Occur.SHOULD));
        }
        return booleanQuery;
    }

    static {
        fieldToClass.put("cl_ha", ColorLayout.class);
        fieldToClass.put("ph_ha", PHOG.class);
        fieldToClass.put("oh_ha", OpponentHistogram.class);
        fieldToClass.put("eh_ha", EdgeHistogram.class);
        fieldToClass.put("jc_ha", JCD.class);
        try {
            BitSampling.readHashFunctions();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

