/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.solr;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import net.semanticmetadata.lire.imageanalysis.ColorLayout;
import net.semanticmetadata.lire.imageanalysis.EdgeHistogram;
import net.semanticmetadata.lire.imageanalysis.JCD;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.imageanalysis.OpponentHistogram;
import net.semanticmetadata.lire.imageanalysis.PHOG;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DocTermsIndexDocValues;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.util.Base64;

public class LireValueSource
extends ValueSource {
    String field = "cl_hi";
    byte[] histogramData;
    LireFeature feature;
    LireFeature tmpFeature;
    double maxDistance = -1.0;
    String objectHashBase = null;

    public LireValueSource(String string, byte[] byArray, double d) {
        if (string != null) {
            this.field = string;
        }
        if (!this.field.endsWith("_hi")) {
            this.field = this.field + "_hi";
        }
        this.histogramData = byArray;
        this.maxDistance = d;
        if (this.field == null) {
            this.feature = new EdgeHistogram();
            this.tmpFeature = new EdgeHistogram();
        } else if (this.field.startsWith("cl")) {
            this.feature = new ColorLayout();
            this.tmpFeature = new ColorLayout();
        } else if (this.field.startsWith("jc")) {
            this.feature = new JCD();
            this.tmpFeature = new JCD();
        } else if (this.field.startsWith("ph")) {
            this.feature = new PHOG();
            this.tmpFeature = new PHOG();
        } else if (this.field.startsWith("oh")) {
            this.feature = new OpponentHistogram();
            this.tmpFeature = new OpponentHistogram();
        } else {
            this.feature = new EdgeHistogram();
            this.tmpFeature = new EdgeHistogram();
        }
        System.out.println("Setting " + this.feature.getClass().getName() + " to " + Base64.byteArrayToBase64((byte[])byArray, (int)0, (int)byArray.length));
        this.objectHashBase = this.field + Arrays.toString(byArray) + d;
        this.feature.setByteArrayRepresentation(byArray);
    }

    public FunctionValues getValues(Map map, AtomicReaderContext atomicReaderContext) throws IOException {
        FieldInfo fieldInfo = atomicReaderContext.reader().getFieldInfos().fieldInfo(this.field);
        if (fieldInfo != null && fieldInfo.getDocValuesType() == FieldInfo.DocValuesType.BINARY) {
            final BinaryDocValues binaryDocValues = FieldCache.DEFAULT.getTerms(atomicReaderContext.reader(), this.field);
            return new FunctionValues(){
                BytesRef tmp = new BytesRef();

                public boolean exists(int n) {
                    return this.bytesVal(n, this.tmp);
                }

                public boolean bytesVal(int n, BytesRef bytesRef) {
                    binaryDocValues.get(n, bytesRef);
                    return bytesRef.length > 0;
                }

                public float floatVal(int n) {
                    binaryDocValues.get(n, this.tmp);
                    if (this.tmp.length > 0) {
                        LireValueSource.this.tmpFeature.setByteArrayRepresentation(this.tmp.bytes, this.tmp.offset, this.tmp.length);
                        return LireValueSource.this.tmpFeature.getDistance(LireValueSource.this.feature);
                    }
                    return (float)LireValueSource.this.maxDistance;
                }

                public Object objectVal(int n) {
                    return Float.valueOf(this.floatVal(n));
                }

                public String toString(int n) {
                    return LireValueSource.this.description() + '=' + this.strVal(n);
                }

                public double doubleVal(int n) {
                    return this.floatVal(n);
                }
            };
        }
        return new DocTermsIndexDocValues(this, atomicReaderContext, this.field){

            protected String toTerm(String string) {
                return Double.toString(LireValueSource.this.maxDistance);
            }

            public Object objectVal(int n) {
                return LireValueSource.this.maxDistance;
            }

            public String toString(int n) {
                return LireValueSource.this.description() + '=' + this.strVal(n);
            }

            public double doubleVal(int n) {
                return LireValueSource.this.maxDistance;
            }
        };
    }

    public boolean equals(Object object) {
        if (object instanceof LireValueSource) {
            return this.objectHashBase.equals(((LireValueSource)((Object)object)).objectHashBase);
        }
        return false;
    }

    public int hashCode() {
        return this.objectHashBase.hashCode();
    }

    public String description() {
        return "distance to a given feature vector";
    }
}

