/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.solr;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.imageio.ImageIO;
import net.semanticmetadata.lire.imageanalysis.ColorLayout;
import net.semanticmetadata.lire.imageanalysis.EdgeHistogram;
import net.semanticmetadata.lire.imageanalysis.JCD;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.imageanalysis.OpponentHistogram;
import net.semanticmetadata.lire.imageanalysis.PHOG;
import net.semanticmetadata.lire.indexing.hashing.BitSampling;
import net.semanticmetadata.lire.indexing.parallel.WorkItem;
import net.semanticmetadata.lire.utils.ImageUtils;
import org.apache.commons.codec.binary.Base64;

public class ParallelSolrIndexer
implements Runnable {
    private static HashMap<Class, String> classToPrefix = new HashMap(5);
    private static boolean force = false;
    private static boolean individualFiles = false;
    private static int numberOfThreads = 4;
    Stack<WorkItem> images = new Stack();
    boolean ended = false;
    int overallCount = 0;
    OutputStream dos = null;
    LinkedList<LireFeature> listOfFeatures = new LinkedList();
    File fileList = null;
    File outFile = null;
    private int monitoringInterval = 10;
    private int maxSideLength = -1;

    public static void setNumberOfThreads(int n) {
        numberOfThreads = n;
    }

    public static void main(String[] stringArray) throws IOException {
        BitSampling.readHashFunctions();
        ParallelSolrIndexer parallelSolrIndexer = new ParallelSolrIndexer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith("-i")) {
                if (i + 1 < stringArray.length) {
                    parallelSolrIndexer.setFileList(new File(stringArray[i + 1]));
                    continue;
                }
                ParallelSolrIndexer.printHelp();
                continue;
            }
            if (string.startsWith("-o")) {
                if (i + 1 < stringArray.length) {
                    parallelSolrIndexer.setOutFile(new File(stringArray[i + 1]));
                    continue;
                }
                ParallelSolrIndexer.printHelp();
                continue;
            }
            if (string.startsWith("-m")) {
                if (i + 1 < stringArray.length) {
                    try {
                        int n = Integer.parseInt(stringArray[i + 1]);
                        if (n <= 10) continue;
                        parallelSolrIndexer.setMaxSideLength(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                        ParallelSolrIndexer.printHelp();
                    }
                    continue;
                }
                ParallelSolrIndexer.printHelp();
                continue;
            }
            if (string.startsWith("-f")) {
                force = true;
                continue;
            }
            if (string.startsWith("-h")) {
                ParallelSolrIndexer.printHelp();
                continue;
            }
            if (!string.startsWith("-n")) continue;
            if (i + 1 < stringArray.length) {
                try {
                    numberOfThreads = Integer.parseInt(stringArray[i + 1]);
                }
                catch (Exception exception) {
                    System.err.println("Could not set number of threads to \"" + stringArray[i + 1] + "\".");
                    exception.printStackTrace();
                }
                continue;
            }
            ParallelSolrIndexer.printHelp();
        }
        if (!parallelSolrIndexer.isConfigured()) {
            ParallelSolrIndexer.printHelp();
        } else {
            parallelSolrIndexer.run();
        }
    }

    private static void printHelp() {
        System.out.println("Help for the ParallelSolrIndexer class.\n=============================\nThis help text is shown if you start the ParallelSolrIndexer with the '-h' option.\n\n1. Usage\n========\n$> ParallelSolrIndexer -i <infile> [-o <outfile>] [-n <threads>] [-f] [-m <max_side_length>]\n\nNote: if you don't specify an outfile just \".xml\" is appended to the infile for output.\n\n");
    }

    public static String arrayToString(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder(nArray.length * 8);
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(Integer.toHexString(nArray[i]));
        }
        return stringBuilder.toString();
    }

    public void addFeature(LireFeature lireFeature) {
        this.listOfFeatures.add(lireFeature);
    }

    public void setFileList(File file) {
        this.fileList = file;
    }

    public void setOutFile(File file) {
        this.outFile = file;
    }

    public int getMaxSideLength() {
        return this.maxSideLength;
    }

    public void setMaxSideLength(int n) {
        this.maxSideLength = n;
    }

    private boolean isConfigured() {
        boolean bl = true;
        if (this.fileList == null || !this.fileList.exists()) {
            bl = false;
        } else if (this.outFile == null) {
            individualFiles = true;
        } else if (this.outFile.exists() && !force) {
            System.err.println(this.outFile.getName() + " already exists. Please delete or choose another outfile.");
            bl = false;
        }
        return bl;
    }

    @Override
    public void run() {
        if (this.fileList == null || !this.fileList.exists()) {
            System.err.println("No text file with a list of images given.");
            return;
        }
        try {
            Object object;
            if (!individualFiles) {
                this.dos = new BufferedOutputStream(new FileOutputStream(this.outFile));
                this.dos.write("<add>\n".getBytes());
            }
            Thread thread = new Thread(new Producer());
            thread.start();
            LinkedList<Thread> linkedList = new LinkedList<Thread>();
            long l = System.currentTimeMillis();
            for (int i = 0; i < numberOfThreads; ++i) {
                object = new Thread(new Consumer());
                ((Thread)object).start();
                linkedList.add((Thread)object);
            }
            Thread thread2 = new Thread(new Monitoring());
            thread2.start();
            object = linkedList.iterator();
            while (object.hasNext()) {
                ((Thread)object.next()).join();
            }
            long l2 = System.currentTimeMillis() - l;
            System.out.println("Analyzed " + this.overallCount + " images in " + l2 / 1000L + " seconds, ~" + (this.overallCount > 0 ? Long.valueOf(l2 / (long)this.overallCount) : "inf.") + " ms each.");
            if (!individualFiles) {
                this.dos.write("</add>\n".getBytes());
                this.dos.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void addFeatures(List list) {
        list.add(new PHOG());
        list.add(new ColorLayout());
        list.add(new EdgeHistogram());
        list.add(new JCD());
    }

    static {
        classToPrefix.put(ColorLayout.class, "cl");
        classToPrefix.put(EdgeHistogram.class, "eh");
        classToPrefix.put(PHOG.class, "ph");
        classToPrefix.put(OpponentHistogram.class, "oh");
        classToPrefix.put(JCD.class, "jc");
    }

    class Consumer
    implements Runnable {
        WorkItem tmp = null;
        LinkedList<LireFeature> features = new LinkedList();
        int count = 0;
        boolean locallyEnded = false;
        StringBuilder sb = new StringBuilder(1024);

        Consumer() {
            ParallelSolrIndexer.this.addFeatures(this.features);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] byArray = new byte[0xA00000];
            boolean bl = false;
            while (!this.locallyEnded) {
                Object object = ParallelSolrIndexer.this.images;
                synchronized (object) {
                    while (ParallelSolrIndexer.this.images.empty() && !ParallelSolrIndexer.this.ended) {
                        try {
                            ParallelSolrIndexer.this.images.wait(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                    if (ParallelSolrIndexer.this.images.empty() && ParallelSolrIndexer.this.ended) {
                        this.locallyEnded = true;
                    }
                    if (!ParallelSolrIndexer.this.images.empty() && !this.locallyEnded) {
                        this.tmp = ParallelSolrIndexer.this.images.pop();
                        ++this.count;
                        ++ParallelSolrIndexer.this.overallCount;
                    }
                }
                try {
                    Object object2;
                    if (this.locallyEnded) continue;
                    this.sb.delete(0, this.sb.length());
                    object = new ByteArrayInputStream(this.tmp.getBuffer());
                    BufferedImage bufferedImage = ImageUtils.trimWhiteSpace(ImageIO.read((InputStream)object));
                    if (ParallelSolrIndexer.this.maxSideLength > 50) {
                        bufferedImage = ImageUtils.scaleImage(bufferedImage, ParallelSolrIndexer.this.maxSideLength);
                    } else if (bufferedImage.getWidth() < 32 || bufferedImage.getHeight() < 32) {
                        double d = 128.0;
                        d = bufferedImage.getWidth() > bufferedImage.getHeight() ? 128.0 / (double)bufferedImage.getWidth() : 128.0 / (double)bufferedImage.getHeight();
                        bufferedImage = ImageUtils.scaleImage(bufferedImage, (int)(d * (double)bufferedImage.getWidth()), (int)(d * (double)bufferedImage.getHeight()));
                    }
                    byte[] byArray2 = this.tmp.getFileName().getBytes();
                    this.sb.append("<doc>");
                    this.sb.append("<field name=\"id\">");
                    this.sb.append(this.tmp.getFileName());
                    this.sb.append("</field>");
                    this.sb.append("<field name=\"title\">");
                    this.sb.append(new File(this.tmp.getFileName()).getName());
                    this.sb.append("</field>");
                    for (LireFeature lireFeature : this.features) {
                        if (classToPrefix.get(lireFeature.getClass()) == null) continue;
                        lireFeature.extract(bufferedImage);
                        String string = (String)classToPrefix.get(lireFeature.getClass()) + "_hi";
                        String string2 = (String)classToPrefix.get(lireFeature.getClass()) + "_ha";
                        this.sb.append("<field name=\"" + string + "\">");
                        this.sb.append(Base64.encodeBase64String((byte[])lireFeature.getByteArrayRepresentation()));
                        this.sb.append("</field>");
                        this.sb.append("<field name=\"" + string2 + "\">");
                        this.sb.append(ParallelSolrIndexer.arrayToString(BitSampling.generateHashes(lireFeature.getDoubleHistogram())));
                        this.sb.append("</field>");
                    }
                    this.sb.append("</doc>\n");
                    if (!individualFiles) {
                        object2 = ParallelSolrIndexer.this.dos;
                        synchronized (object2) {
                            ParallelSolrIndexer.this.dos.write(this.sb.toString().getBytes());
                            ParallelSolrIndexer.this.dos.flush();
                            continue;
                        }
                    }
                    object2 = new BufferedOutputStream(new FileOutputStream(this.tmp.getFileName() + "_solr.xml"));
                    ((OutputStream)object2).write(this.sb.toString().getBytes());
                    ((OutputStream)object2).flush();
                    ((OutputStream)object2).close();
                }
                catch (Exception exception) {
                    System.err.println("Error processing file " + this.tmp.getFileName());
                    exception.printStackTrace();
                }
            }
        }
    }

    class Producer
    implements Runnable {
        Producer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            int n = 0;
            try {
                object = new BufferedReader(new FileReader(ParallelSolrIndexer.this.fileList));
                String string = null;
                File file = null;
                while ((string = ((BufferedReader)object).readLine()) != null) {
                    file = new File(string);
                    Object var5_6 = null;
                    try {
                        int n2 = (int)file.length();
                        byte[] byArray = new byte[n2];
                        FileInputStream fileInputStream = new FileInputStream(file);
                        fileInputStream.read(byArray);
                        String string2 = file.getCanonicalPath();
                        Stack<WorkItem> stack = ParallelSolrIndexer.this.images;
                        synchronized (stack) {
                            ParallelSolrIndexer.this.images.add(new WorkItem(string2, byArray));
                            n = ParallelSolrIndexer.this.images.size();
                            if (n > 500) {
                                ParallelSolrIndexer.this.images.wait(500L);
                            }
                            ParallelSolrIndexer.this.images.notify();
                        }
                    }
                    catch (Exception exception) {
                        System.err.println("Could not read image " + string + ": " + exception.getMessage());
                    }
                    try {
                        if (n <= 500) continue;
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            object = ParallelSolrIndexer.this.images;
            synchronized (object) {
                ParallelSolrIndexer.this.ended = true;
                ParallelSolrIndexer.this.images.notifyAll();
            }
        }
    }

    class Monitoring
    implements Runnable {
        Monitoring() {
        }

        @Override
        public void run() {
            long l = System.currentTimeMillis();
            try {
                Thread.sleep(1000 * ParallelSolrIndexer.this.monitoringInterval);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            while (!ParallelSolrIndexer.this.ended) {
                try {
                    long l2 = System.currentTimeMillis() - l;
                    System.out.println("Analyzed " + ParallelSolrIndexer.this.overallCount + " images in " + l2 / 1000L + " seconds, " + (ParallelSolrIndexer.this.overallCount > 0 ? Long.valueOf(l2 / (long)ParallelSolrIndexer.this.overallCount) : "n.a.") + " ms each (" + ParallelSolrIndexer.this.images.size() + " images currently in queue).");
                    Thread.sleep(1000 * ParallelSolrIndexer.this.monitoringInterval);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }
}

