/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.utils.cv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.semanticmetadata.lire.utils.MetricsUtils;

public class KMeans {
    List<double[]> features;
    Cluster[] clusters;

    public KMeans(List<double[]> featureList, int numberOfClusters) {
        this.features = new ArrayList<double[]>(featureList);
        this.clusters = new Cluster[numberOfClusters];
        HashSet<double[]> means = new HashSet<double[]>();
        while (means.size() < Math.min(numberOfClusters, featureList.size() / 2)) {
            double[] e = this.features.get((int)Math.floor(Math.random() * (double)this.features.size()));
            double[] tmp = new double[e.length];
            System.arraycopy(e, 0, tmp, 0, e.length);
            means.add(tmp);
        }
        Iterator iterator = means.iterator();
        for (int i = 0; i < this.clusters.length; ++i) {
            this.clusters[i] = new Cluster((double[])iterator.next());
        }
    }

    public double step() {
        int i;
        int i2;
        for (i2 = 0; i2 < this.clusters.length; ++i2) {
            this.clusters[i2].clearMembers();
            assert (this.clusters[i2].members.size() == 0);
        }
        for (int id = 0; id < this.features.size(); ++id) {
            double tmpDistance = Double.MAX_VALUE;
            int currentCluster = -1;
            for (i = 0; i < this.clusters.length; ++i) {
                double distance = this.clusters[i].getDistance(this.features.get(id));
                assert (distance >= 0.0);
                if (!(distance < tmpDistance)) continue;
                tmpDistance = distance;
                currentCluster = i;
            }
            this.clusters[currentCluster].addMember(id);
        }
        for (i2 = 0; i2 < this.clusters.length; ++i2) {
            this.clusters[i2].recomputeMeans(this.features);
        }
        double stress = 0.0;
        double num = 0.0;
        for (i = 0; i < this.clusters.length; ++i) {
            stress += this.clusters[i].calculateStress(this.features);
            num += (double)this.clusters[i].members.size();
        }
        return stress;
    }

    public List<double[]> getMeans() {
        ArrayList<double[]> r = new ArrayList<double[]>(this.clusters.length);
        for (int i = 0; i < this.clusters.length; ++i) {
            r.add(this.clusters[i].center);
        }
        return r;
    }

    class Cluster {
        double[] center;
        HashSet<Integer> members;

        public Cluster(double[] center) {
            this.center = center;
            this.members = new HashSet();
        }

        public double getDistance(double[] feature) {
            return MetricsUtils.distL2(this.center, feature);
        }

        public void clearMembers() {
            this.members.clear();
        }

        public void addMember(int id) {
            this.members.add(id);
        }

        public void recomputeMeans(List<double[]> features) {
            if (this.members.size() > 0) {
                Arrays.fill(this.center, 0.0);
                for (int member : this.members) {
                    double[] feature = features.get(member);
                    for (int i = 0; i < feature.length; ++i) {
                        int n = i;
                        this.center[n] = this.center[n] + feature[i];
                    }
                }
                for (int i = 0; i < this.center.length; ++i) {
                    this.center[i] = this.center[i] / (double)this.members.size();
                }
            }
        }

        public double calculateStress(List<double[]> features) {
            double result = 0.0;
            for (int member : this.members) {
                double[] feature = features.get(member);
                result += MetricsUtils.distL2(this.center, feature);
            }
            return result;
        }
    }
}

