/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire;

import net.semanticmetadata.lire.DocumentBuilder;
import net.semanticmetadata.lire.imageanalysis.AutoColorCorrelogram;
import net.semanticmetadata.lire.imageanalysis.CEDD;
import net.semanticmetadata.lire.imageanalysis.ColorLayout;
import net.semanticmetadata.lire.imageanalysis.EdgeHistogram;
import net.semanticmetadata.lire.imageanalysis.FCTH;
import net.semanticmetadata.lire.imageanalysis.Gabor;
import net.semanticmetadata.lire.imageanalysis.JCD;
import net.semanticmetadata.lire.imageanalysis.JpegCoefficientHistogram;
import net.semanticmetadata.lire.imageanalysis.LuminanceLayout;
import net.semanticmetadata.lire.imageanalysis.OpponentHistogram;
import net.semanticmetadata.lire.imageanalysis.PHOG;
import net.semanticmetadata.lire.imageanalysis.ScalableColor;
import net.semanticmetadata.lire.imageanalysis.SimpleColorHistogram;
import net.semanticmetadata.lire.imageanalysis.Tamura;
import net.semanticmetadata.lire.imageanalysis.joint.JointHistogram;
import net.semanticmetadata.lire.impl.ChainedDocumentBuilder;
import net.semanticmetadata.lire.impl.GenericDocumentBuilder;

public class DocumentBuilderFactory {
    public static DocumentBuilder getDefaultDocumentBuilder() {
        return new GenericDocumentBuilder(CEDD.class, "featureCEDD");
    }

    public static DocumentBuilder getExtensiveDocumentBuilder() {
        ChainedDocumentBuilder cb = new ChainedDocumentBuilder();
        cb.addBuilder(DocumentBuilderFactory.getColorLayoutBuilder());
        cb.addBuilder(DocumentBuilderFactory.getEdgeHistogramBuilder());
        cb.addBuilder(DocumentBuilderFactory.getScalableColorBuilder());
        return cb;
    }

    public static DocumentBuilder getColorLayoutBuilder() {
        return new GenericDocumentBuilder(ColorLayout.class, "descriptorColorLayout");
    }

    public static DocumentBuilder getEdgeHistogramBuilder() {
        return new GenericDocumentBuilder(EdgeHistogram.class, "descriptorEdgeHistogram");
    }

    public static DocumentBuilder getScalableColorBuilder() {
        return new GenericDocumentBuilder(ScalableColor.class, "descriptorScalableColor");
    }

    public static DocumentBuilder getColorOnlyDocumentBuilder() {
        return DocumentBuilderFactory.getScalableColorBuilder();
    }

    public static DocumentBuilder getFastDocumentBuilder() {
        return DocumentBuilderFactory.getColorLayoutBuilder();
    }

    public static DocumentBuilder getAutoColorCorrelogramDocumentBuilder() {
        return new GenericDocumentBuilder(AutoColorCorrelogram.class, "featureAutoColorCorrelogram", GenericDocumentBuilder.Mode.Fast);
    }

    public static DocumentBuilder getCEDDDocumentBuilder() {
        return new GenericDocumentBuilder(CEDD.class, "featureCEDD");
    }

    public static DocumentBuilder getHashingCEDDDocumentBuilder() {
        return new GenericDocumentBuilder(CEDD.class, "featureCEDD", true);
    }

    public static DocumentBuilder getFCTHDocumentBuilder() {
        return new GenericDocumentBuilder(FCTH.class, "featureFCTH", GenericDocumentBuilder.Mode.Fast);
    }

    public static DocumentBuilder getJCDDocumentBuilder() {
        return new GenericDocumentBuilder(JCD.class, "featureJCD");
    }

    public static DocumentBuilder getJpegCoefficientHistogramDocumentBuilder() {
        return new GenericDocumentBuilder(JpegCoefficientHistogram.class, "featureJpegCoeffs", GenericDocumentBuilder.Mode.Fast);
    }

    public static DocumentBuilder getColorHistogramDocumentBuilder() {
        return new GenericDocumentBuilder(SimpleColorHistogram.class, "featureColorHistogram", GenericDocumentBuilder.Mode.Fast);
    }

    public static DocumentBuilder getTamuraDocumentBuilder() {
        return new GenericDocumentBuilder(Tamura.class, "featureTAMURA");
    }

    public static DocumentBuilder getGaborDocumentBuilder() {
        return new GenericDocumentBuilder(Gabor.class, "featureGabor");
    }

    public static DocumentBuilder getJointHistogramDocumentBuilder() {
        return new GenericDocumentBuilder(JointHistogram.class, "featureJointHist");
    }

    public static DocumentBuilder getOpponentHistogramDocumentBuilder() {
        return new GenericDocumentBuilder(OpponentHistogram.class, "featOpHist");
    }

    public static DocumentBuilder getPHOGDocumentBuilder() {
        return new GenericDocumentBuilder(PHOG.class, "featPHOG");
    }

    public static DocumentBuilder getLuminanceLayoutDocumentBuilder() {
        return new GenericDocumentBuilder(LuminanceLayout.class, "featLumLay");
    }

    public static DocumentBuilder getFullDocumentBuilder() {
        ChainedDocumentBuilder cdb = new ChainedDocumentBuilder();
        cdb.addBuilder(DocumentBuilderFactory.getColorLayoutBuilder());
        cdb.addBuilder(DocumentBuilderFactory.getEdgeHistogramBuilder());
        cdb.addBuilder(DocumentBuilderFactory.getScalableColorBuilder());
        cdb.addBuilder(DocumentBuilderFactory.getAutoColorCorrelogramDocumentBuilder());
        cdb.addBuilder(DocumentBuilderFactory.getCEDDDocumentBuilder());
        cdb.addBuilder(DocumentBuilderFactory.getFCTHDocumentBuilder());
        cdb.addBuilder(DocumentBuilderFactory.getColorHistogramDocumentBuilder());
        cdb.addBuilder(DocumentBuilderFactory.getTamuraDocumentBuilder());
        cdb.addBuilder(DocumentBuilderFactory.getGaborDocumentBuilder());
        cdb.addBuilder(DocumentBuilderFactory.getJointHistogramDocumentBuilder());
        return cdb;
    }
}

