/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire;

import net.semanticmetadata.lire.ImageSearcher;
import net.semanticmetadata.lire.imageanalysis.AutoColorCorrelogram;
import net.semanticmetadata.lire.imageanalysis.CEDD;
import net.semanticmetadata.lire.imageanalysis.ColorLayout;
import net.semanticmetadata.lire.imageanalysis.EdgeHistogram;
import net.semanticmetadata.lire.imageanalysis.FCTH;
import net.semanticmetadata.lire.imageanalysis.Gabor;
import net.semanticmetadata.lire.imageanalysis.JCD;
import net.semanticmetadata.lire.imageanalysis.JpegCoefficientHistogram;
import net.semanticmetadata.lire.imageanalysis.LuminanceLayout;
import net.semanticmetadata.lire.imageanalysis.OpponentHistogram;
import net.semanticmetadata.lire.imageanalysis.PHOG;
import net.semanticmetadata.lire.imageanalysis.ScalableColor;
import net.semanticmetadata.lire.imageanalysis.SimpleColorHistogram;
import net.semanticmetadata.lire.imageanalysis.Tamura;
import net.semanticmetadata.lire.imageanalysis.joint.JointHistogram;
import net.semanticmetadata.lire.impl.BitSamplingImageSearcher;
import net.semanticmetadata.lire.impl.GenericFastImageSearcher;

public class ImageSearcherFactory {
    public static int NUM_MAX_HITS = 100;

    public static ImageSearcher createSimpleSearcher(int maximumHits) {
        return ImageSearcherFactory.createColorLayoutImageSearcher(maximumHits);
    }

    public static ImageSearcher createDefaultSearcher() {
        return new GenericFastImageSearcher(NUM_MAX_HITS, CEDD.class, "featureCEDD");
    }

    public static ImageSearcher createColorOnlySearcher(int maximumHits) {
        return ImageSearcherFactory.createScalableColorImageSearcher(maximumHits);
    }

    public static ImageSearcher createAutoColorCorrelogramImageSearcher(int maximumHits) {
        return new GenericFastImageSearcher(maximumHits, AutoColorCorrelogram.class, "featureAutoColorCorrelogram");
    }

    public static ImageSearcher createCEDDImageSearcher(int maximumHits) {
        return new GenericFastImageSearcher(maximumHits, CEDD.class, "featureCEDD");
    }

    public static ImageSearcher createHashingCEDDImageSearcher(int maximumHits) {
        return new BitSamplingImageSearcher(maximumHits, "featureCEDD", "featureCEDD_hash", new CEDD());
    }

    public static ImageSearcher createFCTHImageSearcher(int maximumHits) {
        return new GenericFastImageSearcher(maximumHits, FCTH.class, "featureFCTH");
    }

    public static ImageSearcher createJCDImageSearcher(int maximumHits) {
        return new GenericFastImageSearcher(maximumHits, JCD.class, "featureJCD");
    }

    public static ImageSearcher createJpegCoefficientHistogramImageSearcher(int maximumHits) {
        return new GenericFastImageSearcher(maximumHits, JpegCoefficientHistogram.class, "featureJpegCoeffs");
    }

    public static ImageSearcher createColorHistogramImageSearcher(int maximumHits) {
        return new GenericFastImageSearcher(maximumHits, SimpleColorHistogram.class, "featureColorHistogram");
    }

    public static ImageSearcher createTamuraImageSearcher(int maximumHits) {
        return new GenericFastImageSearcher(maximumHits, Tamura.class, "featureTAMURA");
    }

    public static ImageSearcher createGaborImageSearcher(int maximumHits) {
        return new GenericFastImageSearcher(maximumHits, Gabor.class, "featureGabor");
    }

    public static ImageSearcher createColorLayoutImageSearcher(int maximumHits) {
        return new GenericFastImageSearcher(maximumHits, ColorLayout.class, "descriptorColorLayout");
    }

    public static ImageSearcher createScalableColorImageSearcher(int maximumHits) {
        return new GenericFastImageSearcher(maximumHits, ScalableColor.class, "descriptorScalableColor");
    }

    public static ImageSearcher createEdgeHistogramImageSearcher(int maximumHits) {
        return new GenericFastImageSearcher(maximumHits, EdgeHistogram.class, "descriptorEdgeHistogram");
    }

    public static ImageSearcher createJointHistogramImageSearcher(int maximumHits) {
        return new GenericFastImageSearcher(maximumHits, JointHistogram.class, "featureJointHist");
    }

    public static ImageSearcher createOpponentHistogramSearcher(int maximumHits) {
        return new GenericFastImageSearcher(maximumHits, OpponentHistogram.class, "featOpHist");
    }

    public static ImageSearcher createLuminanceLayoutImageSearcher(int maximumHits) {
        return new GenericFastImageSearcher(maximumHits, LuminanceLayout.class, "featLumLay");
    }

    public static ImageSearcher createPHOGImageSearcher(int maximumHits) {
        return new GenericFastImageSearcher(maximumHits, PHOG.class, "featPHOG");
    }

    private static boolean isAppropriateWeight(float f) {
        boolean result = false;
        if (f <= 1.0f && f >= 0.0f) {
            result = true;
        }
        return result;
    }
}

