/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.clustering;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import net.semanticmetadata.lire.imageanalysis.Histogram;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class Cluster
implements Comparable<Object> {
    double[] mean;
    HashSet<Integer> members = new HashSet();
    private double stress = 0.0;

    public Cluster() {
        this.mean = new double[128];
        Arrays.fill(this.mean, 0.0);
    }

    public Cluster(double[] mean) {
        this.mean = mean;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        for (Integer integer : this.members) {
            sb.append(integer);
            sb.append(", ");
        }
        for (int i = 0; i < this.mean.length; ++i) {
            sb.append(this.mean[i]);
            sb.append(';');
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Object o) {
        return ((Cluster)o).members.size() - this.members.size();
    }

    public double getDistance(Histogram f) {
        return this.getDistance(f.descriptor);
    }

    public double getDistance(double[] f) {
        double d = 0.0;
        for (int i = 0; i < f.length; ++i) {
            d += Math.abs(this.mean[i] - f[i]);
        }
        return d;
    }

    public byte[] getByteRepresentation() {
        return SerializationUtils.toByteArray(this.mean);
    }

    public void setByteRepresentation(byte[] data) {
        this.mean = SerializationUtils.toDoubleArray(data);
    }

    public static void writeClusters(Cluster[] clusters, String file) throws IOException {
        FileOutputStream fout = new FileOutputStream(file);
        fout.write(SerializationUtils.toBytes(clusters.length));
        for (int i = 0; i < clusters.length; ++i) {
            fout.write(clusters[i].getByteRepresentation());
        }
        fout.close();
    }

    public static Cluster[] readClusters(String file) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        byte[] tmp = new byte[4];
        fin.read(tmp, 0, 4);
        Cluster[] result = new Cluster[SerializationUtils.toInt(tmp)];
        tmp = new byte[1024];
        for (int i = 0; i < result.length; ++i) {
            int bytesRead = fin.read(tmp, 0, 1024);
            if (bytesRead != 1024) {
                System.err.println("Didn't read enough bytes ...");
            }
            result[i] = new Cluster();
            result[i].setByteRepresentation(tmp);
        }
        fin.close();
        return result;
    }

    public double getStress() {
        return this.stress;
    }

    public void setStress(double stress) {
        this.stress = stress;
    }

    public HashSet<Integer> getMembers() {
        return this.members;
    }

    public void setMembers(HashSet<Integer> members) {
        this.members = members;
    }

    public double[] getMean() {
        return this.mean;
    }
}

