/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.StringTokenizer;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.imageanalysis.correlogram.DynamicProgrammingAutoCorrelogramExtraction;
import net.semanticmetadata.lire.imageanalysis.correlogram.IAutoCorrelogramFeatureExtractor;
import net.semanticmetadata.lire.imageanalysis.correlogram.MLuxAutoCorrelogramExtraction;
import net.semanticmetadata.lire.imageanalysis.correlogram.NaiveAutoCorrelogramExtraction;
import net.semanticmetadata.lire.utils.ConversionUtils;

public class AutoColorCorrelogram
implements LireFeature {
    private static final int DEFAULT_NUMBER_COLORS = 256;
    private float quantH;
    private float quantV;
    private float quantS;
    private float[][] correlogram;
    private int[] distanceSet;
    private int numBins;
    private float quantH_f;
    private float quantS_f;
    private float quantV_f;
    private static final ExtractionMethod DEFAULT_EXTRACTION_METHOD = ExtractionMethod.NaiveHuangAlgorithm;
    private IAutoCorrelogramFeatureExtractor extractionAlgorithm;

    public AutoColorCorrelogram() {
        this(256, new int[]{1, 2, 3, 4}, null);
    }

    public AutoColorCorrelogram(int maxDistance) {
    }

    public AutoColorCorrelogram(int maxDistance, Mode mode) {
        this(256, null, new MLuxAutoCorrelogramExtraction(mode));
        int[] D = new int[maxDistance];
        for (int i = 0; i < maxDistance; ++i) {
            D[i] = i + 1;
        }
        this.distanceSet = D;
    }

    public AutoColorCorrelogram(int[] distanceSet) {
        this(256, distanceSet, null);
    }

    public AutoColorCorrelogram(int[] distanceSet, IAutoCorrelogramFeatureExtractor extractionAlgorith) {
        this(256, distanceSet, extractionAlgorith);
    }

    public AutoColorCorrelogram(IAutoCorrelogramFeatureExtractor extractionAlgorith) {
        this(256, new int[]{1, 2, 3, 4}, extractionAlgorith);
    }

    public AutoColorCorrelogram(int numBins, int[] distanceSet, IAutoCorrelogramFeatureExtractor extractionAlgorith) {
        this.numBins = numBins;
        this.distanceSet = distanceSet;
        if (extractionAlgorith == null) {
            switch (DEFAULT_EXTRACTION_METHOD) {
                case LireAlgorithm: {
                    this.extractionAlgorithm = new MLuxAutoCorrelogramExtraction();
                    break;
                }
                case NaiveHuangAlgorithm: {
                    this.extractionAlgorithm = new NaiveAutoCorrelogramExtraction();
                    break;
                }
                case DynamicProgrammingHuangAlgorithm: {
                    this.extractionAlgorithm = DynamicProgrammingAutoCorrelogramExtraction.getInstance();
                }
            }
        } else {
            this.extractionAlgorithm = extractionAlgorith;
        }
        if (numBins < 17) {
            this.quantH_f = 4.0f;
            this.quantS_f = 2.0f;
            this.quantV_f = 2.0f;
            this.numBins = 16;
        } else if (numBins < 33) {
            this.quantH_f = 8.0f;
            this.quantS_f = 2.0f;
            this.quantV_f = 2.0f;
            this.numBins = 32;
        } else if (numBins < 65) {
            this.quantH_f = 8.0f;
            this.quantS_f = 4.0f;
            this.quantV_f = 2.0f;
            this.numBins = 64;
        } else if (numBins < 129) {
            this.quantH_f = 8.0f;
            this.quantS_f = 4.0f;
            this.quantV_f = 4.0f;
            this.numBins = 128;
        } else {
            this.quantH_f = 16.0f;
            this.quantS_f = 4.0f;
            this.quantV_f = 4.0f;
            this.numBins = 256;
        }
        this.quantH = 360.0f / this.quantH_f;
        this.quantS = 256.0f / this.quantS_f;
        this.quantV = 256.0f / this.quantV_f;
    }

    private static int[][][] hsvImage(Raster r) {
        int[][][] pixels = new int[r.getWidth()][r.getHeight()][3];
        int[] pixel = new int[3];
        for (int x = 0; x < r.getWidth(); ++x) {
            for (int y = 0; y < r.getHeight(); ++y) {
                int[] hsv = new int[3];
                AutoColorCorrelogram.convertRgbToHsv(r.getPixel(x, y, pixel), hsv);
                pixels[x][y] = hsv;
            }
        }
        return pixels;
    }

    @Override
    public void extract(BufferedImage bi) {
        WritableRaster r = bi.getRaster();
        int[][][] hsvImage = AutoColorCorrelogram.hsvImage(r);
        this.extract(hsvImage);
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        byte[] result = new byte[this.correlogram.length * this.correlogram[0].length / 2];
        int position = 0;
        for (int i = 0; i < this.correlogram.length; ++i) {
            float[] floats = this.correlogram[i];
            for (int j = 0; j < floats.length - 1; j += 2) {
                int tmp = (int)floats[j] << 4;
                result[position] = (byte)((tmp |= (int)floats[j + 1]) - 128);
                ++position;
            }
        }
        return result;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.setByteArrayRepresentation(in, 0, in.length);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        this.correlogram = new float[this.numBins][4];
        int count = 0;
        for (int i = offset; i < offset + length; ++i) {
            int tmp = in[i] + 128;
            this.correlogram[count / 4][count % 4] = tmp >> 4;
            this.correlogram[count / 4][++count % 4] = tmp & 0xF;
            ++count;
        }
    }

    @Override
    public double[] getDoubleHistogram() {
        return ConversionUtils.toDouble(this.getFloatHistogram());
    }

    private float[] getFloatHistogram() {
        float[] result = new float[this.correlogram.length * this.correlogram[0].length];
        for (int i = 0; i < this.correlogram.length; ++i) {
            System.arraycopy(this.correlogram[i], 0, result, i * this.correlogram[0].length, this.correlogram[0].length);
        }
        return result;
    }

    public void extract(int[][][] img) {
        int W = img.length;
        int H = img[0].length;
        int[][] quantPixels = new int[W][H];
        for (int x = 0; x < W; ++x) {
            for (int y = 0; y < H; ++y) {
                quantPixels[x][y] = this.quantize(img[x][y]);
            }
        }
        this.correlogram = this.extractionAlgorithm.extract(this.numBins, this.distanceSet, quantPixels);
    }

    private int quantize(int[] pixel) {
        return (int)((float)((int)((float)pixel[0] / this.quantH)) * this.quantV_f * this.quantS_f + (float)((int)((float)pixel[1] / this.quantS)) * this.quantV_f + (float)((int)((float)pixel[2] / this.quantV)));
    }

    private static void convertRgbToHsv(int[] rgb, int[] hsv) {
        if (hsv.length < 3) {
            throw new IndexOutOfBoundsException("HSV array too small, a minim of three elements is required.");
        }
        int R = rgb[0];
        int G = rgb[1];
        int B = rgb[2];
        float hue = 0.0f;
        int max = Math.max(R, G);
        max = Math.max(max, B);
        int min = Math.min(R, G);
        min = Math.min(min, B);
        hsv[1] = max == 0 ? 0 : (int)((float)(max - min) / (float)max * 255.0f);
        if (max == min) {
            hue = 0.0f;
        } else {
            float maxMinusMin = max - min;
            if (R == max) {
                hue = (float)(G - B) / maxMinusMin;
            } else if (G == max) {
                hue = 2.0f + (float)(B - R) / maxMinusMin;
            } else if (B == max) {
                hue = 4.0f + (float)(R - G) / maxMinusMin;
            }
            hue *= 60.0f;
            if (hue < 0.0f) {
                hue += 360.0f;
            }
        }
        hsv[0] = (int)hue;
        hsv[2] = max;
    }

    @Override
    public float getDistance(LireFeature vd) {
        if (!(vd instanceof AutoColorCorrelogram)) {
            return -1.0f;
        }
        return this.jsd(((AutoColorCorrelogram)vd).correlogram);
    }

    private float l1(float[][] vdCorrelogram) {
        float result = 0.0f;
        for (int i = 0; i < this.correlogram.length; ++i) {
            float[] ints = this.correlogram[i];
            for (int j = 0; j < ints.length; ++j) {
                result += Math.abs(this.correlogram[i][j] - vdCorrelogram[i][j]);
            }
        }
        return result;
    }

    private float jsd(float[][] vdCorrelogram) {
        float result = 0.0f;
        for (int i = 0; i < this.correlogram.length; ++i) {
            float[] ints = this.correlogram[i];
            for (int j = 0; j < ints.length; ++j) {
                result = (float)((double)result + ((this.correlogram[i][j] > 0.0f ? (double)(this.correlogram[i][j] / 2.0f) * Math.log(2.0f * this.correlogram[i][j] / (this.correlogram[i][j] + vdCorrelogram[i][j])) : 0.0) + (vdCorrelogram[i][j] > 0.0f ? (double)(vdCorrelogram[i][j] / 2.0f) * Math.log(2.0f * vdCorrelogram[i][j] / (this.correlogram[i][j] + vdCorrelogram[i][j])) : 0.0)));
            }
        }
        return result;
    }

    @Override
    public String getStringRepresentation() {
        int maxDistance = this.distanceSet.length;
        StringBuilder sb = new StringBuilder(this.numBins * maxDistance);
        sb.append(maxDistance);
        sb.append(' ');
        for (int i = 0; i < this.correlogram.length; ++i) {
            for (int j = 0; j < this.correlogram[i].length; ++j) {
                sb.append(this.correlogram[i][j]);
                sb.append(' ');
            }
        }
        return sb.toString().trim();
    }

    @Override
    public void setStringRepresentation(String string) {
        StringTokenizer st = new StringTokenizer(string);
        this.correlogram = new float[this.numBins][Integer.parseInt(st.nextToken())];
        for (int i = 0; i < this.correlogram.length; ++i) {
            for (int j = 0; j < this.correlogram[i].length; ++j) {
                if (!st.hasMoreTokens()) {
                    throw new IndexOutOfBoundsException("Too few numbers in string representation!");
                }
                this.correlogram[i][j] = Float.parseFloat(st.nextToken());
            }
        }
    }

    @Override
    public String getFeatureName() {
        return "Auto Color Correlogram";
    }

    @Override
    public String getFieldName() {
        return "featureAutoColorCorrelogram";
    }

    public static enum ExtractionMethod {
        LireAlgorithm,
        NaiveHuangAlgorithm,
        DynamicProgrammingHuangAlgorithm;

    }

    public static enum Mode {
        FullNeighbourhood,
        QuarterNeighbourhood,
        SuperFast;

    }
}

