/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis;

import java.awt.image.BufferedImage;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.utils.MetricsUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class GenericDoubleLireFeature
implements LireFeature {
    double[] data = null;

    @Override
    public String getFeatureName() {
        return "GenericDoubleFeature";
    }

    @Override
    public String getFieldName() {
        return "featGenericDouble";
    }

    @Override
    public void extract(BufferedImage image) {
        throw new UnsupportedOperationException("Extraction not supported.");
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        if (this.data == null) {
            throw new UnsupportedOperationException("You need to set the histogram first.");
        }
        return SerializationUtils.toByteArray(this.data);
    }

    @Override
    public void setByteArrayRepresentation(byte[] featureData) {
        this.setByteArrayRepresentation(featureData, 0, featureData.length);
    }

    @Override
    public void setByteArrayRepresentation(byte[] featureData, int offset, int length) {
        this.data = SerializationUtils.toDoubleArray(featureData, offset, length);
    }

    @Override
    public double[] getDoubleHistogram() {
        return this.data;
    }

    @Override
    public float getDistance(LireFeature feature) {
        assert (feature.getDoubleHistogram().length == this.data.length);
        return (float)MetricsUtils.distL1(feature.getDoubleHistogram(), this.data);
    }

    @Override
    public String getStringRepresentation() {
        if (this.data == null) {
            throw new UnsupportedOperationException("You need to set the histogram first.");
        }
        return SerializationUtils.toString(this.data);
    }

    @Override
    public void setStringRepresentation(String featureVector) {
        this.data = SerializationUtils.toDoubleArray(featureVector);
    }

    public void setData(double[] data) {
        this.data = data;
    }
}

