/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.mser;

import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.semanticmetadata.lire.imageanalysis.mser.BoundaryPixel;
import net.semanticmetadata.lire.imageanalysis.mser.ImageMask;
import net.semanticmetadata.lire.imageanalysis.mser.ImagePoint;
import net.semanticmetadata.lire.imageanalysis.mser.MSERComponent;
import net.semanticmetadata.lire.imageanalysis.mser.MSERFeature;
import net.semanticmetadata.lire.imageanalysis.mser.MSERGrowthHistory;
import net.semanticmetadata.lire.imageanalysis.mser.MSERHeap;
import net.semanticmetadata.lire.imageanalysis.mser.MSERParameter;
import net.semanticmetadata.lire.imageanalysis.mser.fourier.Fourier;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class MSER {
    public static int MAX_GREY = 256;
    private MSERParameter params;
    private ImageMask imageMask;
    private MSERHeap heap;
    private Stack<MSERComponent> componentStack;
    private ArrayList<MSERGrowthHistory> ers = new ArrayList();
    private MSERGrowthHistory[] mers = null;
    public static final double COARSE_ANGLE = 0.6283185307179586;

    public MSER() {
        this.params = new MSERParameter();
    }

    public MSER(int delta, double minArea, double maxArea, double maxVariation, double minDiversity, int maxEvolution, double areaThreshold, double minMargin, int edgeBlurSize) {
        this.params = new MSERParameter(delta, minArea, maxArea, maxVariation, minDiversity, maxEvolution, areaThreshold, minMargin, edgeBlurSize);
    }

    private void prepare() {
        for (int i = 0; i < this.ers.size(); ++i) {
            this.ers.get(i).setIndex(i);
        }
    }

    public MSERGrowthHistory[] extractMSER(BufferedImage image) {
        int i;
        this.ers.clear();
        this.mers = null;
        int imageLength = image.getWidth() * image.getHeight();
        this.imageMask = new ImageMask(image);
        this.heap = new MSERHeap(MAX_GREY);
        this.componentStack = new Stack();
        this.componentStack.push(new MSERComponent(MAX_GREY));
        BoundaryPixel currentPixel = this.imageMask.getBoundaryPixel(0);
        this.imageMask.getAccess(currentPixel.getIndex());
        int currentLevel = this.imageMask.getValue(currentPixel.getIndex());
        this.componentStack.push(new MSERComponent(currentLevel));
        while (currentPixel != null) {
            BoundaryPixel nextEdge = currentPixel.getNextBoundary();
            while (nextEdge != null) {
                if (!this.imageMask.hasAccess(nextEdge.getIndex())) {
                    this.imageMask.getAccess(nextEdge.getIndex());
                    if (this.imageMask.getValue(nextEdge.getIndex()) < currentLevel) {
                        this.heap.push(currentPixel, this.imageMask.getValue(currentPixel.getIndex()));
                        currentPixel = nextEdge;
                        currentLevel = this.imageMask.getValue(currentPixel.getIndex());
                        this.componentStack.push(new MSERComponent(currentLevel));
                    } else {
                        this.heap.push(nextEdge, this.imageMask.getValue(nextEdge.getIndex()));
                    }
                }
                nextEdge = currentPixel.getNextBoundary();
            }
            assert (this.imageMask.getValue(currentPixel.getIndex()) == currentLevel);
            assert (this.componentStack.peek().getGreyLevel() == currentLevel);
            this.componentStack.peek().addPixel(currentPixel);
            currentPixel = this.heap.pop();
            if (currentPixel != null && this.imageMask.getValue(currentPixel.getIndex()) > currentLevel) {
                this.processStack(this.imageMask.getValue(currentPixel.getIndex()));
                currentLevel = this.imageMask.getValue(currentPixel.getIndex());
                continue;
            }
            if (currentPixel != null) continue;
            this.processStack(MAX_GREY);
        }
        this.prepare();
        float[] areavar = new float[this.ers.size()];
        boolean[] maxstable = new boolean[this.ers.size()];
        int[] top = new int[this.ers.size()];
        int[] bottom = new int[this.ers.size()];
        for (i = 0; i < this.ers.size(); ++i) {
            top[i] = imageLength;
        }
        block3: for (i = 0; i < this.ers.size(); ++i) {
            MSERGrowthHistory region = this.ers.get(i);
            int valr0 = region.maxGreyValue;
            MSERGrowthHistory actRegion = region;
            int valri = actRegion.maxGreyValue;
            MSERGrowthHistory parent = actRegion.getParent();
            int valr1 = parent.maxGreyValue;
            while (true) {
                int valp = parent.maxGreyValue;
                if (valr0 <= valri - this.params.delta && valri - this.params.delta < valr1) {
                    bottom[actRegion.getIndex()] = Math.max(bottom[actRegion.getIndex()], region.getSize());
                }
                if (valri <= valr0 + this.params.delta && valr0 + this.params.delta < valp) {
                    top[region.getIndex()] = actRegion.getSize();
                }
                if (valr1 <= valri - this.params.delta && valr0 + this.params.delta < valri || actRegion == parent) continue block3;
                actRegion = parent;
                valri = actRegion.maxGreyValue;
                parent = actRegion.getParent();
            }
        }
        for (i = 0; i < this.ers.size(); ++i) {
            MSERGrowthHistory er = this.ers.get(i);
            int atop = top[er.getIndex()];
            int abot = bottom[er.getIndex()];
            areavar[i] = (float)(atop - abot) / (float)er.getSize();
            maxstable[i] = true;
        }
        int maxcount = this.ers.size();
        for (int i2 = 0; i2 < this.ers.size(); ++i2) {
            int notstable;
            MSERGrowthHistory er = this.ers.get(i2);
            float var = areavar[i2];
            float pvar = areavar[er.getParent().getIndex()];
            if (er.getParent().maxGreyValue != er.maxGreyValue + 1 || !maxstable[notstable = var < pvar ? er.getParent().getIndex() : i2]) continue;
            --maxcount;
            maxstable[notstable] = false;
        }
        int imaxsize = (int)((double)imageLength * this.params.maxArea);
        int iminsize = (int)((double)imageLength * this.params.minArea);
        for (int i3 = this.ers.size() - 1; i3 >= 0; --i3) {
            int parent;
            if (!maxstable[i3]) continue;
            boolean remove = false;
            MSERGrowthHistory er = this.ers.get(i3);
            if (er.getSize() > imaxsize) {
                remove = true;
            }
            if (er.getSize() < iminsize || er.getSize() < 25) {
                remove = true;
            }
            if ((double)areavar[i3] >= this.params.maxVariation) {
                remove = true;
            }
            if (!remove && (parent = er.getParent().getIndex()) != i3) {
                int parea;
                float d;
                while (!maxstable[parent] && parent != this.ers.get(parent).getParent().getIndex()) {
                    parent = this.ers.get(parent).getParent().getIndex();
                }
                if (maxstable[parent] && (double)(d = (float)((parea = this.ers.get(parent).getSize()) - er.getSize()) / (float)er.getSize()) < this.params.minDiversity) {
                    remove = true;
                }
            }
            if (!remove) continue;
            maxstable[i3] = false;
            --maxcount;
        }
        int idx = 0;
        this.mers = new MSERGrowthHistory[maxcount];
        for (int i4 = 0; i4 < this.ers.size(); ++i4) {
            if (!maxstable[i4]) continue;
            this.mers[idx++] = this.ers.get(i4);
        }
        return this.mers;
    }

    protected void processStack(int newPixelGreyLevel) {
        while (newPixelGreyLevel > this.componentStack.peek().getGreyLevel()) {
            MSERComponent topOfStack = this.componentStack.pop();
            topOfStack.addHistory();
            this.ers.add(topOfStack.getHistory());
            if (newPixelGreyLevel < this.componentStack.peek().getGreyLevel()) {
                topOfStack.setGreyLevel(newPixelGreyLevel);
                this.componentStack.push(topOfStack);
                continue;
            }
            if (topOfStack.getSize() >= this.componentStack.peek().getPastSize()) {
                MSERComponent second = this.componentStack.pop();
                topOfStack.mergeComponents(second, second.getGreyLevel());
                this.componentStack.push(topOfStack);
                continue;
            }
            this.componentStack.peek().mergeComponents(topOfStack, this.componentStack.peek().getGreyLevel());
        }
    }

    public List<MSERFeature> computeMSERFeatures(BufferedImage image) {
        MSERGrowthHistory[] msers = this.extractMSER(image);
        return this.computeFourier(msers, image.getWidth(), image.getHeight());
    }

    public List<MSERFeature> computeFourier(MSERGrowthHistory[] msers, int width, int height) {
        ArrayList<MSERFeature> features = new ArrayList<MSERFeature>();
        for (MSERGrowthHistory mser : msers) {
            ImagePoint[] border = mser.getBorderPoints(width, height);
            double[][] coarsedPoly = this.coarsenPoly(this.pointToMatrix(border, border.length - 1), 0.6283185307179586);
            Fourier f = new Fourier(this.matrixToPoints(coarsedPoly, true));
            f.computeFourier(32);
            f.createInvariants2(1);
            features.add(new MSERFeature(mser, SerializationUtils.toDoubleArray(f.getInvariants())));
        }
        return features;
    }

    public Point2D.Double[] matrixToPoints(double[][] coarsedPoly, boolean closeShape) {
        int n = closeShape ? coarsedPoly[0].length + 1 : coarsedPoly[0].length;
        int mod = coarsedPoly[0].length;
        Point2D.Double[] points = new Point2D.Double[n];
        for (int i = 0; i < n; ++i) {
            points[i] = new Point2D.Double(coarsedPoly[0][i % mod], coarsedPoly[1][i % mod]);
        }
        return points;
    }

    protected double[][] cycltrans(double[][] matrix, int m, int n) {
        int ys = matrix.length;
        int xs = matrix[0].length;
        m = (m % ys + ys) % ys;
        n = (n % xs + xs) % xs;
        double[][] doublematrix = new double[ys + ys][xs + xs];
        for (int i = 0; i < doublematrix.length; ++i) {
            for (int j = 0; j < doublematrix[i].length; ++j) {
                doublematrix[i][j] = matrix[i % ys][j % xs];
            }
        }
        double[][] res = new double[ys][xs];
        for (int i = 0; i < ys; ++i) {
            for (int j = 0; j < xs; ++j) {
                res[i][j] = doublematrix[i + m % ys][j + n % xs];
            }
        }
        return res;
    }

    public double[][] coarsenPoly(double[][] p, double angle) {
        int n = p[0].length;
        double[][] q = this.cycltrans(p, 0, 1);
        double[][] v1 = new double[2][n];
        for (int i = 0; i < n; ++i) {
            v1[0][i] = q[0][i] - p[0][i];
            v1[1][i] = q[1][i] - p[1][i];
        }
        double[][] v2 = this.cycltrans(v1, 0, 1);
        double[][] dp = new double[2][n];
        double[] num = new double[n];
        for (int i = 0; i < n; ++i) {
            dp[0][i] = v1[0][i] * v2[0][i];
            dp[1][i] = v1[1][i] * v2[1][i];
            num[i] = dp[0][i] + dp[1][i];
        }
        double[] l1 = new double[n];
        double[] l2 = new double[n];
        double[] den = new double[n];
        for (int i = 0; i < n; ++i) {
            l1[i] = Math.sqrt(v1[0][i] * v1[0][i] + v1[1][i] * v1[1][i]);
            l2[i] = Math.sqrt(v2[0][i] * v2[0][i] + v2[1][i] * v2[1][i]);
            den[i] = l1[i] * l2[i];
        }
        double[] a = new double[n];
        int counter = 0;
        for (int i = 0; i < n; ++i) {
            a[i] = Math.acos(-num[i] / den[i]);
            if (!(a[i] <= Math.PI - angle)) continue;
            ++counter;
        }
        double[][] cq = new double[2][counter];
        counter = 0;
        for (int i = 0; i < n; ++i) {
            if (!(a[i] <= Math.PI - angle)) continue;
            cq[0][counter] = q[0][i];
            cq[1][counter++] = q[1][i];
        }
        if (cq[0][cq[0].length - 1] == q[0][q[0].length - 1] && cq[1][cq[1].length - 1] == q[1][q[1].length - 1]) {
            return this.cycltrans(cq, 0, -1);
        }
        return cq;
    }

    public double[][] pointToMatrix(Point2D.Double[] poly) {
        double[][] res = new double[2][poly.length];
        for (int i = 0; i < poly.length; ++i) {
            res[0][i] = poly[i].getX();
            res[1][i] = poly[i].getY();
        }
        return res;
    }

    public double[][] pointToMatrix(ImagePoint[] poly, int length) {
        double[][] res = new double[2][length];
        for (int i = 0; i < length; ++i) {
            res[0][i] = poly[i].getX();
            res[1][i] = poly[i].getY();
        }
        return res;
    }

    public void printMatrix(String name, double[][] matrix) {
        System.out.println("MATRIX " + name + ":");
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                System.out.print(matrix[i][j]);
                System.out.print(",");
            }
            System.out.println();
        }
    }

    private void printArray(String name, double[] array) {
        System.out.println("ARRAY " + name + ":");
        for (int i = 0; i < array.length; ++i) {
            System.out.print(array[i]);
            System.out.print(",");
            System.out.println();
        }
    }

    public void printPoints(String name, Point2D.Double[] points) {
        System.out.println("points " + name + ":");
        for (int i = 0; i < points.length; ++i) {
            System.out.print("," + points[i].getX() + "," + points[i].getY());
        }
    }

    public static void printPoints(String name, ImagePoint[] points) {
        System.out.println("points " + name + ":");
        for (int i = 0; i < points.length; ++i) {
            System.out.print("," + points[i].toString());
        }
    }
}

