/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.mser;

import java.util.ArrayList;
import java.util.HashMap;
import net.semanticmetadata.lire.imageanalysis.mser.BoundaryPixel8Edge;
import net.semanticmetadata.lire.imageanalysis.mser.ImagePoint;
import net.semanticmetadata.lire.imageanalysis.mser.LinkedImagePoint;

public class MSERGrowthHistory
implements Comparable {
    int index;
    int size;
    int maxGreyValue;
    LinkedImagePoint head;
    ImagePoint[] points = null;
    ImagePoint[] borderPoints = null;
    MSERGrowthHistory parent;

    public MSERGrowthHistory(int size, int value, LinkedImagePoint head) {
        this.size = size;
        this.maxGreyValue = value;
        this.head = head;
        this.parent = this;
    }

    public int getSize() {
        return this.size;
    }

    public ImagePoint[] getPoints() {
        if (this.points == null) {
            this.points = new ImagePoint[this.size];
            LinkedImagePoint temp = this.head;
            for (int i = 0; i < this.size; ++i) {
                this.points[i] = temp.getPoint();
                temp = temp.getNext();
            }
        }
        return this.points;
    }

    public ImagePoint[] getBorderPoints(int width, int height) {
        if (this.borderPoints == null) {
            ImagePoint topLeft = null;
            HashMap<String, ImagePoint> imagePoints = new HashMap<String, ImagePoint>();
            for (ImagePoint p : this.getPoints()) {
                if (topLeft == null || topLeft.getIndex() > p.getIndex()) {
                    topLeft = p;
                }
                imagePoints.put(p.getX() + "_" + p.getY(), p);
            }
            ArrayList<ImagePoint> boundary = new ArrayList<ImagePoint>();
            boundary.add(topLeft);
            BoundaryPixel8Edge currentPoint = new BoundaryPixel8Edge(topLeft, width, height, false, imagePoints);
            BoundaryPixel8Edge neighbor = currentPoint.getNextBoundary();
            ImagePoint stopConditionCurrentPoint = currentPoint.getPoint();
            ImagePoint stopConditionNeighborPoint = neighbor.getPoint();
            boundary.add(imagePoints.get(neighbor.getX() + "_" + neighbor.getY()));
            neighbor.setCurrentEdge(currentPoint.getNeighbourEdge());
            currentPoint = neighbor;
            neighbor = currentPoint.getNextBoundary();
            while (stopConditionCurrentPoint.getIndex() != currentPoint.getIndex() || stopConditionNeighborPoint.getIndex() != neighbor.getIndex()) {
                boundary.add(imagePoints.get(neighbor.getX() + "_" + neighbor.getY()));
                neighbor.setCurrentEdge(currentPoint.getNeighbourEdge());
                currentPoint = neighbor;
                neighbor = currentPoint.getNextBoundary();
            }
            this.borderPoints = new ImagePoint[boundary.size()];
            boundary.toArray(this.borderPoints);
        }
        return this.borderPoints;
    }

    public MSERGrowthHistory getParent() {
        return this.parent;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public int compareTo(Object o) {
        if (this.maxGreyValue < ((MSERGrowthHistory)o).maxGreyValue) {
            return -1;
        }
        if (this.maxGreyValue > ((MSERGrowthHistory)o).maxGreyValue) {
            return 1;
        }
        return 0;
    }

    public static void main(String[] args) {
        LinkedImagePoint current;
        LinkedImagePoint head;
        int[] points = new int[]{12, 21, 22, 23, 25, 30, 31, 32, 33, 34, 35, 36, 38, 39, 40, 41, 42, 43, 44, 45, 48, 50, 51, 53, 54, 55, 56, 58, 59, 63, 64, 65, 66, 67, 68, 71, 72, 73, 74, 75, 76, 80, 81, 82, 83, 84, 91, 92, 93};
        int width = 10;
        LinkedImagePoint last = head = new LinkedImagePoint(new ImagePoint(points[0], width));
        for (int i = 1; i < points.length; ++i) {
            current = new LinkedImagePoint(new ImagePoint(points[i], width));
            last.setNext(current);
            current.setPrev(last);
            last = current;
        }
        MSERGrowthHistory test = new MSERGrowthHistory(49, 36, head);
        ImagePoint[] border = test.getBorderPoints(10, 10);
        String borderPoints = "";
        for (ImagePoint p : border) {
            borderPoints = borderPoints + " " + p.getIndex();
        }
        System.out.println(borderPoints);
        String expectedBorderPoints = " 12 21 30 40 50 51 42 53 63 72 71 80 91 92 93 84 75 76 67 68 59 48 39 38 48 58 67 56 45 36 25 34 23 12";
        System.out.println(expectedBorderPoints);
        System.out.println("SAME =" + (borderPoints.equals(expectedBorderPoints) ? "true" : "false"));
        points = new int[]{23, 26, 27, 31, 32, 33, 34, 35, 36, 37, 44, 45, 46, 47, 55, 56, 57, 65, 66};
        width = 10;
        last = head = new LinkedImagePoint(new ImagePoint(points[0], width));
        for (int i = 1; i < points.length; ++i) {
            current = new LinkedImagePoint(new ImagePoint(points[i], width));
            last.setNext(current);
            current.setPrev(last);
            last = current;
        }
        test = new MSERGrowthHistory(19, 36, head);
        border = test.getBorderPoints(width, 10);
        borderPoints = "";
        for (ImagePoint p : border) {
            borderPoints = borderPoints + " " + p.getIndex();
        }
        System.out.println(borderPoints);
        expectedBorderPoints = " 23 32 31 32 33 44 55 65 66 57 47 37 27 26 35 34 23";
        System.out.println(expectedBorderPoints);
        System.out.println("SAME =" + (borderPoints.equals(expectedBorderPoints) ? "true" : "false"));
    }
}

