/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.indexing.fastmap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.semanticmetadata.lire.indexing.fastmap.DistanceCalculator;
import net.semanticmetadata.lire.indexing.fastmap.FastmapDistanceMatrix;
import net.semanticmetadata.lire.matrix.SimilarityMatrix;

public class ArrayFastmapDistanceMatrix
implements FastmapDistanceMatrix {
    private double[][] distance;
    private ArrayList<?> objects;
    private HashMap<Object, Integer> objects2position;
    private DistanceCalculator distanceFct;
    private int dimension;
    private boolean distributeObjects = false;

    public ArrayFastmapDistanceMatrix(List userObjects, DistanceCalculator distanceFunction) {
        this.init(distanceFunction, userObjects);
    }

    public ArrayFastmapDistanceMatrix(List<?> userObjects, DistanceCalculator distanceFunction, boolean distributeObjects) {
        this.init(distanceFunction, userObjects);
        this.distributeObjects = distributeObjects;
    }

    private void init(DistanceCalculator distanceFunction, List userObjects) {
        this.distanceFct = distanceFunction;
        this.objects = new ArrayList(userObjects.size());
        this.objects.addAll(userObjects);
        this.dimension = this.objects.size();
        this.distance = new double[this.dimension][this.dimension];
        for (int i = 0; i < this.distance.length; ++i) {
            double[] floats = this.distance[i];
            for (int j = 0; j < floats.length; ++j) {
                floats[j] = -1.0;
            }
        }
        this.objects2position = new HashMap(this.dimension);
        int count = 0;
        for (Object o : this.objects) {
            this.objects2position.put(o, count);
            ++count;
        }
    }

    @Override
    public double getDistance(Object o1, Object o2) {
        int num1 = this.objects2position.get(o1);
        int num2 = this.objects2position.get(o2);
        return this.getDistance(num1, num2);
    }

    @Override
    public double getDistance(int index1, int index2) {
        if (index1 == index2) {
            return 0.0;
        }
        if (index1 > index2) {
            int tmp = index1;
            index1 = index2;
            index2 = tmp;
        }
        if (this.distance[index1][index2] < 0.0) {
            double distance = this.distanceFct.getDistance(this.objects.get(index1), this.objects.get(index2));
            if (this.distributeObjects && distance == 0.0) {
                distance = 0.2f;
            }
            this.distance[index1][index2] = distance;
        }
        return this.distance[index1][index2];
    }

    @Override
    public double getDistance(int index1, int index2, int k, double[] x1, double[] x2) {
        if (index1 == index2) {
            return 0.0;
        }
        double originalDistance = this.getDistance(index1, index2);
        if (k == 0) {
            return originalDistance;
        }
        double distance = originalDistance * originalDistance;
        for (int i = 0; i < k; ++i) {
            double xDifference = x1[i] - x2[i];
            distance -= xDifference * xDifference;
        }
        return (float)Math.sqrt(Math.abs(distance));
    }

    @Override
    public int getMaximumDistance(int row, int k, double[][] points) {
        double max = 0.0;
        int result = 0;
        for (int i = 0; i < this.dimension; ++i) {
            double currentDistance;
            double[] point1 = null;
            double[] point2 = null;
            if (points != null) {
                point1 = points[row];
                point2 = points[i];
            }
            if (!((currentDistance = this.getDistance(row, i, k, point1, point2)) > max)) continue;
            max = currentDistance;
            result = i;
        }
        return result;
    }

    @Override
    public int getMaximumDistance(int row) {
        return this.getMaximumDistance(row, 0, null);
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public Object getUserObject(int rowNumber) {
        return this.objects.get(rowNumber);
    }

    @Override
    public int getIndexOfObject(Object o) {
        Integer index = this.objects2position.get(o);
        if (index == null) {
            return -1;
        }
        return index;
    }

    @Override
    public SimilarityMatrix getSimilarityMatrix() {
        return null;
    }

    @Override
    public void normalize() {
        double maximumDistance = 0.0;
        for (int i = 0; i < this.getDimension(); ++i) {
            int maxDist = this.getMaximumDistance(i);
            double distance = this.getDistance(i, maxDist);
            if (!(distance > maximumDistance)) continue;
            maximumDistance = distance;
        }
        double[][] newDistances = new double[this.dimension][this.dimension];
        for (int i = 0; i < newDistances.length; ++i) {
            for (int j = 0; j < newDistances[i].length; ++j) {
                newDistances[i][j] = this.getDistance(i, j) / maximumDistance;
            }
        }
        this.distance = newDistances;
    }
}

