# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplianceSsidsArgs', 'ApplianceSsids']

@pulumi.input_type
class ApplianceSsidsArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 number: pulumi.Input[builtins.int],
                 auth_mode: Optional[pulumi.Input[builtins.str]] = None,
                 default_vlan_id: Optional[pulumi.Input[builtins.int]] = None,
                 dhcp_enforced_deauthentication: Optional[pulumi.Input['ApplianceSsidsDhcpEnforcedDeauthenticationArgs']] = None,
                 dot11w: Optional[pulumi.Input['ApplianceSsidsDot11wArgs']] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 encryption_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 psk: Optional[pulumi.Input[builtins.str]] = None,
                 radius_servers: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSsidsRadiusServerArgs']]]] = None,
                 visible: Optional[pulumi.Input[builtins.bool]] = None,
                 wpa_encryption_mode: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ApplianceSsids resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.int] number: The number of the SSID.
        :param pulumi.Input[builtins.str] auth_mode: The association control method for the SSID.
        :param pulumi.Input[builtins.int] default_vlan_id: The VLAN ID of the VLAN associated to this SSID.
        :param pulumi.Input['ApplianceSsidsDhcpEnforcedDeauthenticationArgs'] dhcp_enforced_deauthentication: DHCP Enforced Deauthentication enables the disassociation of wireless clients in addition to Mandatory DHCP. This param is only valid on firmware versions >= MX 17.0 where the associated LAN has Mandatory DHCP Enabled
        :param pulumi.Input['ApplianceSsidsDot11wArgs'] dot11w: The current setting for Protected Management Frames (802.11w).
        :param pulumi.Input[builtins.bool] enabled: Whether or not the SSID is enabled.
        :param pulumi.Input[builtins.str] encryption_mode: The psk encryption mode for the SSID.
        :param pulumi.Input[builtins.str] name: The name of the SSID.
        :param pulumi.Input[builtins.str] psk: The passkey for the SSID. This param is only valid if the authMode is 'psk'.
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceSsidsRadiusServerArgs']]] radius_servers: The RADIUS 802.1x servers to be used for authentication.
        :param pulumi.Input[builtins.bool] visible: Boolean indicating whether the MX should advertise or hide this SSID.
        :param pulumi.Input[builtins.str] wpa_encryption_mode: WPA encryption mode for the SSID.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "number", number)
        if auth_mode is not None:
            pulumi.set(__self__, "auth_mode", auth_mode)
        if default_vlan_id is not None:
            pulumi.set(__self__, "default_vlan_id", default_vlan_id)
        if dhcp_enforced_deauthentication is not None:
            pulumi.set(__self__, "dhcp_enforced_deauthentication", dhcp_enforced_deauthentication)
        if dot11w is not None:
            pulumi.set(__self__, "dot11w", dot11w)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if encryption_mode is not None:
            pulumi.set(__self__, "encryption_mode", encryption_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)
        if radius_servers is not None:
            pulumi.set(__self__, "radius_servers", radius_servers)
        if visible is not None:
            pulumi.set(__self__, "visible", visible)
        if wpa_encryption_mode is not None:
            pulumi.set(__self__, "wpa_encryption_mode", wpa_encryption_mode)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def number(self) -> pulumi.Input[builtins.int]:
        """
        The number of the SSID.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "number", value)

    @property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The association control method for the SSID.
        """
        return pulumi.get(self, "auth_mode")

    @auth_mode.setter
    def auth_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auth_mode", value)

    @property
    @pulumi.getter(name="defaultVlanId")
    def default_vlan_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The VLAN ID of the VLAN associated to this SSID.
        """
        return pulumi.get(self, "default_vlan_id")

    @default_vlan_id.setter
    def default_vlan_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "default_vlan_id", value)

    @property
    @pulumi.getter(name="dhcpEnforcedDeauthentication")
    def dhcp_enforced_deauthentication(self) -> Optional[pulumi.Input['ApplianceSsidsDhcpEnforcedDeauthenticationArgs']]:
        """
        DHCP Enforced Deauthentication enables the disassociation of wireless clients in addition to Mandatory DHCP. This param is only valid on firmware versions >= MX 17.0 where the associated LAN has Mandatory DHCP Enabled
        """
        return pulumi.get(self, "dhcp_enforced_deauthentication")

    @dhcp_enforced_deauthentication.setter
    def dhcp_enforced_deauthentication(self, value: Optional[pulumi.Input['ApplianceSsidsDhcpEnforcedDeauthenticationArgs']]):
        pulumi.set(self, "dhcp_enforced_deauthentication", value)

    @property
    @pulumi.getter
    def dot11w(self) -> Optional[pulumi.Input['ApplianceSsidsDot11wArgs']]:
        """
        The current setting for Protected Management Frames (802.11w).
        """
        return pulumi.get(self, "dot11w")

    @dot11w.setter
    def dot11w(self, value: Optional[pulumi.Input['ApplianceSsidsDot11wArgs']]):
        pulumi.set(self, "dot11w", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not the SSID is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The psk encryption mode for the SSID.
        """
        return pulumi.get(self, "encryption_mode")

    @encryption_mode.setter
    def encryption_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "encryption_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the SSID.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def psk(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The passkey for the SSID. This param is only valid if the authMode is 'psk'.
        """
        return pulumi.get(self, "psk")

    @psk.setter
    def psk(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "psk", value)

    @property
    @pulumi.getter(name="radiusServers")
    def radius_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSsidsRadiusServerArgs']]]]:
        """
        The RADIUS 802.1x servers to be used for authentication.
        """
        return pulumi.get(self, "radius_servers")

    @radius_servers.setter
    def radius_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSsidsRadiusServerArgs']]]]):
        pulumi.set(self, "radius_servers", value)

    @property
    @pulumi.getter
    def visible(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean indicating whether the MX should advertise or hide this SSID.
        """
        return pulumi.get(self, "visible")

    @visible.setter
    def visible(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "visible", value)

    @property
    @pulumi.getter(name="wpaEncryptionMode")
    def wpa_encryption_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        WPA encryption mode for the SSID.
        """
        return pulumi.get(self, "wpa_encryption_mode")

    @wpa_encryption_mode.setter
    def wpa_encryption_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "wpa_encryption_mode", value)


@pulumi.input_type
class _ApplianceSsidsState:
    def __init__(__self__, *,
                 auth_mode: Optional[pulumi.Input[builtins.str]] = None,
                 default_vlan_id: Optional[pulumi.Input[builtins.int]] = None,
                 dhcp_enforced_deauthentication: Optional[pulumi.Input['ApplianceSsidsDhcpEnforcedDeauthenticationArgs']] = None,
                 dot11w: Optional[pulumi.Input['ApplianceSsidsDot11wArgs']] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 encryption_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 number: Optional[pulumi.Input[builtins.int]] = None,
                 psk: Optional[pulumi.Input[builtins.str]] = None,
                 radius_servers: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSsidsRadiusServerArgs']]]] = None,
                 radius_servers_responses: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSsidsRadiusServersResponseArgs']]]] = None,
                 visible: Optional[pulumi.Input[builtins.bool]] = None,
                 wpa_encryption_mode: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApplianceSsids resources.
        :param pulumi.Input[builtins.str] auth_mode: The association control method for the SSID.
        :param pulumi.Input[builtins.int] default_vlan_id: The VLAN ID of the VLAN associated to this SSID.
        :param pulumi.Input['ApplianceSsidsDhcpEnforcedDeauthenticationArgs'] dhcp_enforced_deauthentication: DHCP Enforced Deauthentication enables the disassociation of wireless clients in addition to Mandatory DHCP. This param is only valid on firmware versions >= MX 17.0 where the associated LAN has Mandatory DHCP Enabled
        :param pulumi.Input['ApplianceSsidsDot11wArgs'] dot11w: The current setting for Protected Management Frames (802.11w).
        :param pulumi.Input[builtins.bool] enabled: Whether or not the SSID is enabled.
        :param pulumi.Input[builtins.str] encryption_mode: The psk encryption mode for the SSID.
        :param pulumi.Input[builtins.str] name: The name of the SSID.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.int] number: The number of the SSID.
        :param pulumi.Input[builtins.str] psk: The passkey for the SSID. This param is only valid if the authMode is 'psk'.
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceSsidsRadiusServerArgs']]] radius_servers: The RADIUS 802.1x servers to be used for authentication.
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceSsidsRadiusServersResponseArgs']]] radius_servers_responses: The RADIUS 802.1x servers to be used for authentication.
        :param pulumi.Input[builtins.bool] visible: Boolean indicating whether the MX should advertise or hide this SSID.
        :param pulumi.Input[builtins.str] wpa_encryption_mode: WPA encryption mode for the SSID.
        """
        if auth_mode is not None:
            pulumi.set(__self__, "auth_mode", auth_mode)
        if default_vlan_id is not None:
            pulumi.set(__self__, "default_vlan_id", default_vlan_id)
        if dhcp_enforced_deauthentication is not None:
            pulumi.set(__self__, "dhcp_enforced_deauthentication", dhcp_enforced_deauthentication)
        if dot11w is not None:
            pulumi.set(__self__, "dot11w", dot11w)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if encryption_mode is not None:
            pulumi.set(__self__, "encryption_mode", encryption_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if number is not None:
            pulumi.set(__self__, "number", number)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)
        if radius_servers is not None:
            pulumi.set(__self__, "radius_servers", radius_servers)
        if radius_servers_responses is not None:
            pulumi.set(__self__, "radius_servers_responses", radius_servers_responses)
        if visible is not None:
            pulumi.set(__self__, "visible", visible)
        if wpa_encryption_mode is not None:
            pulumi.set(__self__, "wpa_encryption_mode", wpa_encryption_mode)

    @property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The association control method for the SSID.
        """
        return pulumi.get(self, "auth_mode")

    @auth_mode.setter
    def auth_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auth_mode", value)

    @property
    @pulumi.getter(name="defaultVlanId")
    def default_vlan_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The VLAN ID of the VLAN associated to this SSID.
        """
        return pulumi.get(self, "default_vlan_id")

    @default_vlan_id.setter
    def default_vlan_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "default_vlan_id", value)

    @property
    @pulumi.getter(name="dhcpEnforcedDeauthentication")
    def dhcp_enforced_deauthentication(self) -> Optional[pulumi.Input['ApplianceSsidsDhcpEnforcedDeauthenticationArgs']]:
        """
        DHCP Enforced Deauthentication enables the disassociation of wireless clients in addition to Mandatory DHCP. This param is only valid on firmware versions >= MX 17.0 where the associated LAN has Mandatory DHCP Enabled
        """
        return pulumi.get(self, "dhcp_enforced_deauthentication")

    @dhcp_enforced_deauthentication.setter
    def dhcp_enforced_deauthentication(self, value: Optional[pulumi.Input['ApplianceSsidsDhcpEnforcedDeauthenticationArgs']]):
        pulumi.set(self, "dhcp_enforced_deauthentication", value)

    @property
    @pulumi.getter
    def dot11w(self) -> Optional[pulumi.Input['ApplianceSsidsDot11wArgs']]:
        """
        The current setting for Protected Management Frames (802.11w).
        """
        return pulumi.get(self, "dot11w")

    @dot11w.setter
    def dot11w(self, value: Optional[pulumi.Input['ApplianceSsidsDot11wArgs']]):
        pulumi.set(self, "dot11w", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not the SSID is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The psk encryption mode for the SSID.
        """
        return pulumi.get(self, "encryption_mode")

    @encryption_mode.setter
    def encryption_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "encryption_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the SSID.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def number(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of the SSID.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "number", value)

    @property
    @pulumi.getter
    def psk(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The passkey for the SSID. This param is only valid if the authMode is 'psk'.
        """
        return pulumi.get(self, "psk")

    @psk.setter
    def psk(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "psk", value)

    @property
    @pulumi.getter(name="radiusServers")
    def radius_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSsidsRadiusServerArgs']]]]:
        """
        The RADIUS 802.1x servers to be used for authentication.
        """
        return pulumi.get(self, "radius_servers")

    @radius_servers.setter
    def radius_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSsidsRadiusServerArgs']]]]):
        pulumi.set(self, "radius_servers", value)

    @property
    @pulumi.getter(name="radiusServersResponses")
    def radius_servers_responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSsidsRadiusServersResponseArgs']]]]:
        """
        The RADIUS 802.1x servers to be used for authentication.
        """
        return pulumi.get(self, "radius_servers_responses")

    @radius_servers_responses.setter
    def radius_servers_responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceSsidsRadiusServersResponseArgs']]]]):
        pulumi.set(self, "radius_servers_responses", value)

    @property
    @pulumi.getter
    def visible(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean indicating whether the MX should advertise or hide this SSID.
        """
        return pulumi.get(self, "visible")

    @visible.setter
    def visible(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "visible", value)

    @property
    @pulumi.getter(name="wpaEncryptionMode")
    def wpa_encryption_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        WPA encryption mode for the SSID.
        """
        return pulumi.get(self, "wpa_encryption_mode")

    @wpa_encryption_mode.setter
    def wpa_encryption_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "wpa_encryption_mode", value)


@pulumi.type_token("meraki:networks/applianceSsids:ApplianceSsids")
class ApplianceSsids(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_mode: Optional[pulumi.Input[builtins.str]] = None,
                 default_vlan_id: Optional[pulumi.Input[builtins.int]] = None,
                 dhcp_enforced_deauthentication: Optional[pulumi.Input[Union['ApplianceSsidsDhcpEnforcedDeauthenticationArgs', 'ApplianceSsidsDhcpEnforcedDeauthenticationArgsDict']]] = None,
                 dot11w: Optional[pulumi.Input[Union['ApplianceSsidsDot11wArgs', 'ApplianceSsidsDot11wArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 encryption_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 number: Optional[pulumi.Input[builtins.int]] = None,
                 psk: Optional[pulumi.Input[builtins.str]] = None,
                 radius_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplianceSsidsRadiusServerArgs', 'ApplianceSsidsRadiusServerArgsDict']]]]] = None,
                 visible: Optional[pulumi.Input[builtins.bool]] = None,
                 wpa_encryption_mode: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.ApplianceSsids("example",
            auth_mode="8021x-radius",
            default_vlan_id=1,
            dhcp_enforced_deauthentication={
                "enabled": True,
            },
            dot11w={
                "enabled": True,
                "required": True,
            },
            enabled=True,
            encryption_mode="wpa",
            name="My SSID",
            network_id="string",
            number="string",
            psk="psk",
            radius_servers=[{
                "host": "0.0.0.0",
                "port": 1000,
                "secret": "secret",
            }],
            visible=True,
            wpa_encryption_mode="WPA2 only")
        pulumi.export("merakiNetworksApplianceSsidsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceSsids:ApplianceSsids example "network_id,number"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] auth_mode: The association control method for the SSID.
        :param pulumi.Input[builtins.int] default_vlan_id: The VLAN ID of the VLAN associated to this SSID.
        :param pulumi.Input[Union['ApplianceSsidsDhcpEnforcedDeauthenticationArgs', 'ApplianceSsidsDhcpEnforcedDeauthenticationArgsDict']] dhcp_enforced_deauthentication: DHCP Enforced Deauthentication enables the disassociation of wireless clients in addition to Mandatory DHCP. This param is only valid on firmware versions >= MX 17.0 where the associated LAN has Mandatory DHCP Enabled
        :param pulumi.Input[Union['ApplianceSsidsDot11wArgs', 'ApplianceSsidsDot11wArgsDict']] dot11w: The current setting for Protected Management Frames (802.11w).
        :param pulumi.Input[builtins.bool] enabled: Whether or not the SSID is enabled.
        :param pulumi.Input[builtins.str] encryption_mode: The psk encryption mode for the SSID.
        :param pulumi.Input[builtins.str] name: The name of the SSID.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.int] number: The number of the SSID.
        :param pulumi.Input[builtins.str] psk: The passkey for the SSID. This param is only valid if the authMode is 'psk'.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplianceSsidsRadiusServerArgs', 'ApplianceSsidsRadiusServerArgsDict']]]] radius_servers: The RADIUS 802.1x servers to be used for authentication.
        :param pulumi.Input[builtins.bool] visible: Boolean indicating whether the MX should advertise or hide this SSID.
        :param pulumi.Input[builtins.str] wpa_encryption_mode: WPA encryption mode for the SSID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplianceSsidsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.ApplianceSsids("example",
            auth_mode="8021x-radius",
            default_vlan_id=1,
            dhcp_enforced_deauthentication={
                "enabled": True,
            },
            dot11w={
                "enabled": True,
                "required": True,
            },
            enabled=True,
            encryption_mode="wpa",
            name="My SSID",
            network_id="string",
            number="string",
            psk="psk",
            radius_servers=[{
                "host": "0.0.0.0",
                "port": 1000,
                "secret": "secret",
            }],
            visible=True,
            wpa_encryption_mode="WPA2 only")
        pulumi.export("merakiNetworksApplianceSsidsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceSsids:ApplianceSsids example "network_id,number"
        ```

        :param str resource_name: The name of the resource.
        :param ApplianceSsidsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplianceSsidsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_mode: Optional[pulumi.Input[builtins.str]] = None,
                 default_vlan_id: Optional[pulumi.Input[builtins.int]] = None,
                 dhcp_enforced_deauthentication: Optional[pulumi.Input[Union['ApplianceSsidsDhcpEnforcedDeauthenticationArgs', 'ApplianceSsidsDhcpEnforcedDeauthenticationArgsDict']]] = None,
                 dot11w: Optional[pulumi.Input[Union['ApplianceSsidsDot11wArgs', 'ApplianceSsidsDot11wArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 encryption_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 number: Optional[pulumi.Input[builtins.int]] = None,
                 psk: Optional[pulumi.Input[builtins.str]] = None,
                 radius_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplianceSsidsRadiusServerArgs', 'ApplianceSsidsRadiusServerArgsDict']]]]] = None,
                 visible: Optional[pulumi.Input[builtins.bool]] = None,
                 wpa_encryption_mode: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplianceSsidsArgs.__new__(ApplianceSsidsArgs)

            __props__.__dict__["auth_mode"] = auth_mode
            __props__.__dict__["default_vlan_id"] = default_vlan_id
            __props__.__dict__["dhcp_enforced_deauthentication"] = dhcp_enforced_deauthentication
            __props__.__dict__["dot11w"] = dot11w
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["encryption_mode"] = encryption_mode
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            if number is None and not opts.urn:
                raise TypeError("Missing required property 'number'")
            __props__.__dict__["number"] = number
            __props__.__dict__["psk"] = psk
            __props__.__dict__["radius_servers"] = radius_servers
            __props__.__dict__["visible"] = visible
            __props__.__dict__["wpa_encryption_mode"] = wpa_encryption_mode
            __props__.__dict__["radius_servers_responses"] = None
        super(ApplianceSsids, __self__).__init__(
            'meraki:networks/applianceSsids:ApplianceSsids',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_mode: Optional[pulumi.Input[builtins.str]] = None,
            default_vlan_id: Optional[pulumi.Input[builtins.int]] = None,
            dhcp_enforced_deauthentication: Optional[pulumi.Input[Union['ApplianceSsidsDhcpEnforcedDeauthenticationArgs', 'ApplianceSsidsDhcpEnforcedDeauthenticationArgsDict']]] = None,
            dot11w: Optional[pulumi.Input[Union['ApplianceSsidsDot11wArgs', 'ApplianceSsidsDot11wArgsDict']]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            encryption_mode: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            number: Optional[pulumi.Input[builtins.int]] = None,
            psk: Optional[pulumi.Input[builtins.str]] = None,
            radius_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplianceSsidsRadiusServerArgs', 'ApplianceSsidsRadiusServerArgsDict']]]]] = None,
            radius_servers_responses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplianceSsidsRadiusServersResponseArgs', 'ApplianceSsidsRadiusServersResponseArgsDict']]]]] = None,
            visible: Optional[pulumi.Input[builtins.bool]] = None,
            wpa_encryption_mode: Optional[pulumi.Input[builtins.str]] = None) -> 'ApplianceSsids':
        """
        Get an existing ApplianceSsids resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] auth_mode: The association control method for the SSID.
        :param pulumi.Input[builtins.int] default_vlan_id: The VLAN ID of the VLAN associated to this SSID.
        :param pulumi.Input[Union['ApplianceSsidsDhcpEnforcedDeauthenticationArgs', 'ApplianceSsidsDhcpEnforcedDeauthenticationArgsDict']] dhcp_enforced_deauthentication: DHCP Enforced Deauthentication enables the disassociation of wireless clients in addition to Mandatory DHCP. This param is only valid on firmware versions >= MX 17.0 where the associated LAN has Mandatory DHCP Enabled
        :param pulumi.Input[Union['ApplianceSsidsDot11wArgs', 'ApplianceSsidsDot11wArgsDict']] dot11w: The current setting for Protected Management Frames (802.11w).
        :param pulumi.Input[builtins.bool] enabled: Whether or not the SSID is enabled.
        :param pulumi.Input[builtins.str] encryption_mode: The psk encryption mode for the SSID.
        :param pulumi.Input[builtins.str] name: The name of the SSID.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.int] number: The number of the SSID.
        :param pulumi.Input[builtins.str] psk: The passkey for the SSID. This param is only valid if the authMode is 'psk'.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplianceSsidsRadiusServerArgs', 'ApplianceSsidsRadiusServerArgsDict']]]] radius_servers: The RADIUS 802.1x servers to be used for authentication.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplianceSsidsRadiusServersResponseArgs', 'ApplianceSsidsRadiusServersResponseArgsDict']]]] radius_servers_responses: The RADIUS 802.1x servers to be used for authentication.
        :param pulumi.Input[builtins.bool] visible: Boolean indicating whether the MX should advertise or hide this SSID.
        :param pulumi.Input[builtins.str] wpa_encryption_mode: WPA encryption mode for the SSID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplianceSsidsState.__new__(_ApplianceSsidsState)

        __props__.__dict__["auth_mode"] = auth_mode
        __props__.__dict__["default_vlan_id"] = default_vlan_id
        __props__.__dict__["dhcp_enforced_deauthentication"] = dhcp_enforced_deauthentication
        __props__.__dict__["dot11w"] = dot11w
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["encryption_mode"] = encryption_mode
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["number"] = number
        __props__.__dict__["psk"] = psk
        __props__.__dict__["radius_servers"] = radius_servers
        __props__.__dict__["radius_servers_responses"] = radius_servers_responses
        __props__.__dict__["visible"] = visible
        __props__.__dict__["wpa_encryption_mode"] = wpa_encryption_mode
        return ApplianceSsids(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> pulumi.Output[builtins.str]:
        """
        The association control method for the SSID.
        """
        return pulumi.get(self, "auth_mode")

    @property
    @pulumi.getter(name="defaultVlanId")
    def default_vlan_id(self) -> pulumi.Output[builtins.int]:
        """
        The VLAN ID of the VLAN associated to this SSID.
        """
        return pulumi.get(self, "default_vlan_id")

    @property
    @pulumi.getter(name="dhcpEnforcedDeauthentication")
    def dhcp_enforced_deauthentication(self) -> pulumi.Output['outputs.ApplianceSsidsDhcpEnforcedDeauthentication']:
        """
        DHCP Enforced Deauthentication enables the disassociation of wireless clients in addition to Mandatory DHCP. This param is only valid on firmware versions >= MX 17.0 where the associated LAN has Mandatory DHCP Enabled
        """
        return pulumi.get(self, "dhcp_enforced_deauthentication")

    @property
    @pulumi.getter
    def dot11w(self) -> pulumi.Output['outputs.ApplianceSsidsDot11w']:
        """
        The current setting for Protected Management Frames (802.11w).
        """
        return pulumi.get(self, "dot11w")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Whether or not the SSID is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> pulumi.Output[builtins.str]:
        """
        The psk encryption mode for the SSID.
        """
        return pulumi.get(self, "encryption_mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the SSID.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def number(self) -> pulumi.Output[builtins.int]:
        """
        The number of the SSID.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter
    def psk(self) -> pulumi.Output[builtins.str]:
        """
        The passkey for the SSID. This param is only valid if the authMode is 'psk'.
        """
        return pulumi.get(self, "psk")

    @property
    @pulumi.getter(name="radiusServers")
    def radius_servers(self) -> pulumi.Output[Sequence['outputs.ApplianceSsidsRadiusServer']]:
        """
        The RADIUS 802.1x servers to be used for authentication.
        """
        return pulumi.get(self, "radius_servers")

    @property
    @pulumi.getter(name="radiusServersResponses")
    def radius_servers_responses(self) -> pulumi.Output[Sequence['outputs.ApplianceSsidsRadiusServersResponse']]:
        """
        The RADIUS 802.1x servers to be used for authentication.
        """
        return pulumi.get(self, "radius_servers_responses")

    @property
    @pulumi.getter
    def visible(self) -> pulumi.Output[builtins.bool]:
        """
        Boolean indicating whether the MX should advertise or hide this SSID.
        """
        return pulumi.get(self, "visible")

    @property
    @pulumi.getter(name="wpaEncryptionMode")
    def wpa_encryption_mode(self) -> pulumi.Output[builtins.str]:
        """
        WPA encryption mode for the SSID.
        """
        return pulumi.get(self, "wpa_encryption_mode")

