# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEventsResult',
    'AwaitableGetEventsResult',
    'get_events',
    'get_events_output',
]

@pulumi.output_type
class GetEventsResult:
    """
    A collection of values returned by getEvents.
    """
    def __init__(__self__, client_ip=None, client_mac=None, client_name=None, device_mac=None, device_name=None, device_serial=None, ending_before=None, excluded_event_types=None, id=None, included_event_types=None, item=None, network_id=None, per_page=None, product_type=None, sm_device_mac=None, sm_device_name=None, starting_after=None):
        if client_ip and not isinstance(client_ip, str):
            raise TypeError("Expected argument 'client_ip' to be a str")
        pulumi.set(__self__, "client_ip", client_ip)
        if client_mac and not isinstance(client_mac, str):
            raise TypeError("Expected argument 'client_mac' to be a str")
        pulumi.set(__self__, "client_mac", client_mac)
        if client_name and not isinstance(client_name, str):
            raise TypeError("Expected argument 'client_name' to be a str")
        pulumi.set(__self__, "client_name", client_name)
        if device_mac and not isinstance(device_mac, str):
            raise TypeError("Expected argument 'device_mac' to be a str")
        pulumi.set(__self__, "device_mac", device_mac)
        if device_name and not isinstance(device_name, str):
            raise TypeError("Expected argument 'device_name' to be a str")
        pulumi.set(__self__, "device_name", device_name)
        if device_serial and not isinstance(device_serial, str):
            raise TypeError("Expected argument 'device_serial' to be a str")
        pulumi.set(__self__, "device_serial", device_serial)
        if ending_before and not isinstance(ending_before, str):
            raise TypeError("Expected argument 'ending_before' to be a str")
        pulumi.set(__self__, "ending_before", ending_before)
        if excluded_event_types and not isinstance(excluded_event_types, list):
            raise TypeError("Expected argument 'excluded_event_types' to be a list")
        pulumi.set(__self__, "excluded_event_types", excluded_event_types)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if included_event_types and not isinstance(included_event_types, list):
            raise TypeError("Expected argument 'included_event_types' to be a list")
        pulumi.set(__self__, "included_event_types", included_event_types)
        if item and not isinstance(item, dict):
            raise TypeError("Expected argument 'item' to be a dict")
        pulumi.set(__self__, "item", item)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if per_page and not isinstance(per_page, int):
            raise TypeError("Expected argument 'per_page' to be a int")
        pulumi.set(__self__, "per_page", per_page)
        if product_type and not isinstance(product_type, str):
            raise TypeError("Expected argument 'product_type' to be a str")
        pulumi.set(__self__, "product_type", product_type)
        if sm_device_mac and not isinstance(sm_device_mac, str):
            raise TypeError("Expected argument 'sm_device_mac' to be a str")
        pulumi.set(__self__, "sm_device_mac", sm_device_mac)
        if sm_device_name and not isinstance(sm_device_name, str):
            raise TypeError("Expected argument 'sm_device_name' to be a str")
        pulumi.set(__self__, "sm_device_name", sm_device_name)
        if starting_after and not isinstance(starting_after, str):
            raise TypeError("Expected argument 'starting_after' to be a str")
        pulumi.set(__self__, "starting_after", starting_after)

    @property
    @pulumi.getter(name="clientIp")
    def client_ip(self) -> Optional[builtins.str]:
        """
        clientIp query parameter. The IP of the client which the list of events will be filtered with. Only supported for track-by-IP networks.
        """
        return pulumi.get(self, "client_ip")

    @property
    @pulumi.getter(name="clientMac")
    def client_mac(self) -> Optional[builtins.str]:
        """
        clientMac query parameter. The MAC address of the client which the list of events will be filtered with. Only supported for track-by-MAC networks.
        """
        return pulumi.get(self, "client_mac")

    @property
    @pulumi.getter(name="clientName")
    def client_name(self) -> Optional[builtins.str]:
        """
        clientName query parameter. The name, or partial name, of the client which the list of events will be filtered with
        """
        return pulumi.get(self, "client_name")

    @property
    @pulumi.getter(name="deviceMac")
    def device_mac(self) -> Optional[builtins.str]:
        """
        deviceMac query parameter. The MAC address of the Meraki device which the list of events will be filtered with
        """
        return pulumi.get(self, "device_mac")

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[builtins.str]:
        """
        deviceName query parameter. The name of the Meraki device which the list of events will be filtered with
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="deviceSerial")
    def device_serial(self) -> Optional[builtins.str]:
        """
        deviceSerial query parameter. The serial of the Meraki device which the list of events will be filtered with
        """
        return pulumi.get(self, "device_serial")

    @property
    @pulumi.getter(name="endingBefore")
    def ending_before(self) -> Optional[builtins.str]:
        """
        endingBefore query parameter. A token used by the server to indicate the end of the page. Often this is a timestamp or an ID but it is not limited to those. This parameter should not be defined by client applications. The link for the first, last, prev, or next page in the HTTP Link header should define it.
        """
        return pulumi.get(self, "ending_before")

    @property
    @pulumi.getter(name="excludedEventTypes")
    def excluded_event_types(self) -> Optional[Sequence[builtins.str]]:
        """
        excludedEventTypes query parameter. A list of event types. The returned events will be filtered to exclude events with these types.
        """
        return pulumi.get(self, "excluded_event_types")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includedEventTypes")
    def included_event_types(self) -> Optional[Sequence[builtins.str]]:
        """
        includedEventTypes query parameter. A list of event types. The returned events will be filtered to only include events with these types.
        """
        return pulumi.get(self, "included_event_types")

    @property
    @pulumi.getter
    def item(self) -> 'outputs.GetEventsItemResult':
        return pulumi.get(self, "item")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> builtins.str:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="perPage")
    def per_page(self) -> Optional[builtins.int]:
        """
        perPage query parameter. The number of entries per page returned. Acceptable range is 3 1000. Default is 10.
        """
        return pulumi.get(self, "per_page")

    @property
    @pulumi.getter(name="productType")
    def product_type(self) -> Optional[builtins.str]:
        """
        productType query parameter. The product type to fetch events for. This parameter is required for networks with multiple device types. Valid types are wireless, appliance, switch, systemsManager, camera, and cellularGateway
        """
        return pulumi.get(self, "product_type")

    @property
    @pulumi.getter(name="smDeviceMac")
    def sm_device_mac(self) -> Optional[builtins.str]:
        """
        smDeviceMac query parameter. The MAC address of the Systems Manager device which the list of events will be filtered with
        """
        return pulumi.get(self, "sm_device_mac")

    @property
    @pulumi.getter(name="smDeviceName")
    def sm_device_name(self) -> Optional[builtins.str]:
        """
        smDeviceName query parameter. The name of the Systems Manager device which the list of events will be filtered with
        """
        return pulumi.get(self, "sm_device_name")

    @property
    @pulumi.getter(name="startingAfter")
    def starting_after(self) -> Optional[builtins.str]:
        """
        startingAfter query parameter. A token used by the server to indicate the start of the page. Often this is a timestamp or an ID but it is not limited to those. This parameter should not be defined by client applications. The link for the first, last, prev, or next page in the HTTP Link header should define it.
        """
        return pulumi.get(self, "starting_after")


class AwaitableGetEventsResult(GetEventsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEventsResult(
            client_ip=self.client_ip,
            client_mac=self.client_mac,
            client_name=self.client_name,
            device_mac=self.device_mac,
            device_name=self.device_name,
            device_serial=self.device_serial,
            ending_before=self.ending_before,
            excluded_event_types=self.excluded_event_types,
            id=self.id,
            included_event_types=self.included_event_types,
            item=self.item,
            network_id=self.network_id,
            per_page=self.per_page,
            product_type=self.product_type,
            sm_device_mac=self.sm_device_mac,
            sm_device_name=self.sm_device_name,
            starting_after=self.starting_after)


def get_events(client_ip: Optional[builtins.str] = None,
               client_mac: Optional[builtins.str] = None,
               client_name: Optional[builtins.str] = None,
               device_mac: Optional[builtins.str] = None,
               device_name: Optional[builtins.str] = None,
               device_serial: Optional[builtins.str] = None,
               ending_before: Optional[builtins.str] = None,
               excluded_event_types: Optional[Sequence[builtins.str]] = None,
               included_event_types: Optional[Sequence[builtins.str]] = None,
               network_id: Optional[builtins.str] = None,
               per_page: Optional[builtins.int] = None,
               product_type: Optional[builtins.str] = None,
               sm_device_mac: Optional[builtins.str] = None,
               sm_device_name: Optional[builtins.str] = None,
               starting_after: Optional[builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEventsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.networks.get_events(client_ip="string",
        client_mac="string",
        client_name="string",
        device_mac="string",
        device_name="string",
        device_serial="string",
        ending_before="string",
        excluded_event_types=["string"],
        included_event_types=["string"],
        network_id="string",
        per_page=1,
        product_type="string",
        sm_device_mac="string",
        sm_device_name="string",
        starting_after="string")
    pulumi.export("merakiNetworksEventsExample", example.item)
    ```


    :param builtins.str client_ip: clientIp query parameter. The IP of the client which the list of events will be filtered with. Only supported for track-by-IP networks.
    :param builtins.str client_mac: clientMac query parameter. The MAC address of the client which the list of events will be filtered with. Only supported for track-by-MAC networks.
    :param builtins.str client_name: clientName query parameter. The name, or partial name, of the client which the list of events will be filtered with
    :param builtins.str device_mac: deviceMac query parameter. The MAC address of the Meraki device which the list of events will be filtered with
    :param builtins.str device_name: deviceName query parameter. The name of the Meraki device which the list of events will be filtered with
    :param builtins.str device_serial: deviceSerial query parameter. The serial of the Meraki device which the list of events will be filtered with
    :param builtins.str ending_before: endingBefore query parameter. A token used by the server to indicate the end of the page. Often this is a timestamp or an ID but it is not limited to those. This parameter should not be defined by client applications. The link for the first, last, prev, or next page in the HTTP Link header should define it.
    :param Sequence[builtins.str] excluded_event_types: excludedEventTypes query parameter. A list of event types. The returned events will be filtered to exclude events with these types.
    :param Sequence[builtins.str] included_event_types: includedEventTypes query parameter. A list of event types. The returned events will be filtered to only include events with these types.
    :param builtins.str network_id: networkId path parameter. Network ID
    :param builtins.int per_page: perPage query parameter. The number of entries per page returned. Acceptable range is 3 1000. Default is 10.
    :param builtins.str product_type: productType query parameter. The product type to fetch events for. This parameter is required for networks with multiple device types. Valid types are wireless, appliance, switch, systemsManager, camera, and cellularGateway
    :param builtins.str sm_device_mac: smDeviceMac query parameter. The MAC address of the Systems Manager device which the list of events will be filtered with
    :param builtins.str sm_device_name: smDeviceName query parameter. The name of the Systems Manager device which the list of events will be filtered with
    :param builtins.str starting_after: startingAfter query parameter. A token used by the server to indicate the start of the page. Often this is a timestamp or an ID but it is not limited to those. This parameter should not be defined by client applications. The link for the first, last, prev, or next page in the HTTP Link header should define it.
    """
    __args__ = dict()
    __args__['clientIp'] = client_ip
    __args__['clientMac'] = client_mac
    __args__['clientName'] = client_name
    __args__['deviceMac'] = device_mac
    __args__['deviceName'] = device_name
    __args__['deviceSerial'] = device_serial
    __args__['endingBefore'] = ending_before
    __args__['excludedEventTypes'] = excluded_event_types
    __args__['includedEventTypes'] = included_event_types
    __args__['networkId'] = network_id
    __args__['perPage'] = per_page
    __args__['productType'] = product_type
    __args__['smDeviceMac'] = sm_device_mac
    __args__['smDeviceName'] = sm_device_name
    __args__['startingAfter'] = starting_after
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('meraki:networks/getEvents:getEvents', __args__, opts=opts, typ=GetEventsResult).value

    return AwaitableGetEventsResult(
        client_ip=pulumi.get(__ret__, 'client_ip'),
        client_mac=pulumi.get(__ret__, 'client_mac'),
        client_name=pulumi.get(__ret__, 'client_name'),
        device_mac=pulumi.get(__ret__, 'device_mac'),
        device_name=pulumi.get(__ret__, 'device_name'),
        device_serial=pulumi.get(__ret__, 'device_serial'),
        ending_before=pulumi.get(__ret__, 'ending_before'),
        excluded_event_types=pulumi.get(__ret__, 'excluded_event_types'),
        id=pulumi.get(__ret__, 'id'),
        included_event_types=pulumi.get(__ret__, 'included_event_types'),
        item=pulumi.get(__ret__, 'item'),
        network_id=pulumi.get(__ret__, 'network_id'),
        per_page=pulumi.get(__ret__, 'per_page'),
        product_type=pulumi.get(__ret__, 'product_type'),
        sm_device_mac=pulumi.get(__ret__, 'sm_device_mac'),
        sm_device_name=pulumi.get(__ret__, 'sm_device_name'),
        starting_after=pulumi.get(__ret__, 'starting_after'))
def get_events_output(client_ip: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      client_mac: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      client_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      device_mac: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      device_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      device_serial: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      ending_before: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      excluded_event_types: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                      included_event_types: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                      network_id: Optional[pulumi.Input[builtins.str]] = None,
                      per_page: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                      product_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      sm_device_mac: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      sm_device_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      starting_after: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEventsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.networks.get_events(client_ip="string",
        client_mac="string",
        client_name="string",
        device_mac="string",
        device_name="string",
        device_serial="string",
        ending_before="string",
        excluded_event_types=["string"],
        included_event_types=["string"],
        network_id="string",
        per_page=1,
        product_type="string",
        sm_device_mac="string",
        sm_device_name="string",
        starting_after="string")
    pulumi.export("merakiNetworksEventsExample", example.item)
    ```


    :param builtins.str client_ip: clientIp query parameter. The IP of the client which the list of events will be filtered with. Only supported for track-by-IP networks.
    :param builtins.str client_mac: clientMac query parameter. The MAC address of the client which the list of events will be filtered with. Only supported for track-by-MAC networks.
    :param builtins.str client_name: clientName query parameter. The name, or partial name, of the client which the list of events will be filtered with
    :param builtins.str device_mac: deviceMac query parameter. The MAC address of the Meraki device which the list of events will be filtered with
    :param builtins.str device_name: deviceName query parameter. The name of the Meraki device which the list of events will be filtered with
    :param builtins.str device_serial: deviceSerial query parameter. The serial of the Meraki device which the list of events will be filtered with
    :param builtins.str ending_before: endingBefore query parameter. A token used by the server to indicate the end of the page. Often this is a timestamp or an ID but it is not limited to those. This parameter should not be defined by client applications. The link for the first, last, prev, or next page in the HTTP Link header should define it.
    :param Sequence[builtins.str] excluded_event_types: excludedEventTypes query parameter. A list of event types. The returned events will be filtered to exclude events with these types.
    :param Sequence[builtins.str] included_event_types: includedEventTypes query parameter. A list of event types. The returned events will be filtered to only include events with these types.
    :param builtins.str network_id: networkId path parameter. Network ID
    :param builtins.int per_page: perPage query parameter. The number of entries per page returned. Acceptable range is 3 1000. Default is 10.
    :param builtins.str product_type: productType query parameter. The product type to fetch events for. This parameter is required for networks with multiple device types. Valid types are wireless, appliance, switch, systemsManager, camera, and cellularGateway
    :param builtins.str sm_device_mac: smDeviceMac query parameter. The MAC address of the Systems Manager device which the list of events will be filtered with
    :param builtins.str sm_device_name: smDeviceName query parameter. The name of the Systems Manager device which the list of events will be filtered with
    :param builtins.str starting_after: startingAfter query parameter. A token used by the server to indicate the start of the page. Often this is a timestamp or an ID but it is not limited to those. This parameter should not be defined by client applications. The link for the first, last, prev, or next page in the HTTP Link header should define it.
    """
    __args__ = dict()
    __args__['clientIp'] = client_ip
    __args__['clientMac'] = client_mac
    __args__['clientName'] = client_name
    __args__['deviceMac'] = device_mac
    __args__['deviceName'] = device_name
    __args__['deviceSerial'] = device_serial
    __args__['endingBefore'] = ending_before
    __args__['excludedEventTypes'] = excluded_event_types
    __args__['includedEventTypes'] = included_event_types
    __args__['networkId'] = network_id
    __args__['perPage'] = per_page
    __args__['productType'] = product_type
    __args__['smDeviceMac'] = sm_device_mac
    __args__['smDeviceName'] = sm_device_name
    __args__['startingAfter'] = starting_after
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('meraki:networks/getEvents:getEvents', __args__, opts=opts, typ=GetEventsResult)
    return __ret__.apply(lambda __response__: GetEventsResult(
        client_ip=pulumi.get(__response__, 'client_ip'),
        client_mac=pulumi.get(__response__, 'client_mac'),
        client_name=pulumi.get(__response__, 'client_name'),
        device_mac=pulumi.get(__response__, 'device_mac'),
        device_name=pulumi.get(__response__, 'device_name'),
        device_serial=pulumi.get(__response__, 'device_serial'),
        ending_before=pulumi.get(__response__, 'ending_before'),
        excluded_event_types=pulumi.get(__response__, 'excluded_event_types'),
        id=pulumi.get(__response__, 'id'),
        included_event_types=pulumi.get(__response__, 'included_event_types'),
        item=pulumi.get(__response__, 'item'),
        network_id=pulumi.get(__response__, 'network_id'),
        per_page=pulumi.get(__response__, 'per_page'),
        product_type=pulumi.get(__response__, 'product_type'),
        sm_device_mac=pulumi.get(__response__, 'sm_device_mac'),
        sm_device_name=pulumi.get(__response__, 'sm_device_name'),
        starting_after=pulumi.get(__response__, 'starting_after')))
