# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetWirelessRfProfilesResult',
    'AwaitableGetWirelessRfProfilesResult',
    'get_wireless_rf_profiles',
    'get_wireless_rf_profiles_output',
]

@pulumi.output_type
class GetWirelessRfProfilesResult:
    """
    A collection of values returned by getWirelessRfProfiles.
    """
    def __init__(__self__, id=None, include_template_profiles=None, item=None, network_id=None, rf_profile_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include_template_profiles and not isinstance(include_template_profiles, bool):
            raise TypeError("Expected argument 'include_template_profiles' to be a bool")
        pulumi.set(__self__, "include_template_profiles", include_template_profiles)
        if item and not isinstance(item, dict):
            raise TypeError("Expected argument 'item' to be a dict")
        pulumi.set(__self__, "item", item)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if rf_profile_id and not isinstance(rf_profile_id, str):
            raise TypeError("Expected argument 'rf_profile_id' to be a str")
        pulumi.set(__self__, "rf_profile_id", rf_profile_id)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includeTemplateProfiles")
    def include_template_profiles(self) -> Optional[builtins.bool]:
        """
        includeTemplateProfiles query parameter. If the network is bound to a template, this parameter controls whether or not the non-basic RF profiles defined on the template should be included in the response alongside the non-basic profiles defined on the bound network. Defaults to false.
        """
        return pulumi.get(self, "include_template_profiles")

    @property
    @pulumi.getter
    def item(self) -> 'outputs.GetWirelessRfProfilesItemResult':
        return pulumi.get(self, "item")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="rfProfileId")
    def rf_profile_id(self) -> Optional[builtins.str]:
        """
        rfProfileId path parameter. Rf profile ID
        """
        return pulumi.get(self, "rf_profile_id")


class AwaitableGetWirelessRfProfilesResult(GetWirelessRfProfilesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWirelessRfProfilesResult(
            id=self.id,
            include_template_profiles=self.include_template_profiles,
            item=self.item,
            network_id=self.network_id,
            rf_profile_id=self.rf_profile_id)


def get_wireless_rf_profiles(include_template_profiles: Optional[builtins.bool] = None,
                             network_id: Optional[builtins.str] = None,
                             rf_profile_id: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWirelessRfProfilesResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.networks.get_wireless_rf_profiles(include_template_profiles=False,
        network_id="string")
    pulumi.export("merakiNetworksWirelessRfProfilesExample", example.item)
    ```


    :param builtins.bool include_template_profiles: includeTemplateProfiles query parameter. If the network is bound to a template, this parameter controls whether or not the non-basic RF profiles defined on the template should be included in the response alongside the non-basic profiles defined on the bound network. Defaults to false.
    :param builtins.str network_id: networkId path parameter. Network ID
    :param builtins.str rf_profile_id: rfProfileId path parameter. Rf profile ID
    """
    __args__ = dict()
    __args__['includeTemplateProfiles'] = include_template_profiles
    __args__['networkId'] = network_id
    __args__['rfProfileId'] = rf_profile_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('meraki:networks/getWirelessRfProfiles:getWirelessRfProfiles', __args__, opts=opts, typ=GetWirelessRfProfilesResult).value

    return AwaitableGetWirelessRfProfilesResult(
        id=pulumi.get(__ret__, 'id'),
        include_template_profiles=pulumi.get(__ret__, 'include_template_profiles'),
        item=pulumi.get(__ret__, 'item'),
        network_id=pulumi.get(__ret__, 'network_id'),
        rf_profile_id=pulumi.get(__ret__, 'rf_profile_id'))
def get_wireless_rf_profiles_output(include_template_profiles: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                    network_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    rf_profile_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWirelessRfProfilesResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.networks.get_wireless_rf_profiles(include_template_profiles=False,
        network_id="string")
    pulumi.export("merakiNetworksWirelessRfProfilesExample", example.item)
    ```


    :param builtins.bool include_template_profiles: includeTemplateProfiles query parameter. If the network is bound to a template, this parameter controls whether or not the non-basic RF profiles defined on the template should be included in the response alongside the non-basic profiles defined on the bound network. Defaults to false.
    :param builtins.str network_id: networkId path parameter. Network ID
    :param builtins.str rf_profile_id: rfProfileId path parameter. Rf profile ID
    """
    __args__ = dict()
    __args__['includeTemplateProfiles'] = include_template_profiles
    __args__['networkId'] = network_id
    __args__['rfProfileId'] = rf_profile_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('meraki:networks/getWirelessRfProfiles:getWirelessRfProfiles', __args__, opts=opts, typ=GetWirelessRfProfilesResult)
    return __ret__.apply(lambda __response__: GetWirelessRfProfilesResult(
        id=pulumi.get(__response__, 'id'),
        include_template_profiles=pulumi.get(__response__, 'include_template_profiles'),
        item=pulumi.get(__response__, 'item'),
        network_id=pulumi.get(__response__, 'network_id'),
        rf_profile_id=pulumi.get(__response__, 'rf_profile_id')))
