# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDevicesItemResult',
    'GetDevicesItemDetailResult',
    'GetNetworksItemResult',
    'GetOrganizationsItemResult',
    'GetOrganizationsItemApiResult',
    'GetOrganizationsItemCloudResult',
    'GetOrganizationsItemCloudRegionResult',
    'GetOrganizationsItemLicensingResult',
    'GetOrganizationsItemManagementResult',
    'GetOrganizationsItemManagementDetailResult',
]

@pulumi.output_type
class GetDevicesItemResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 details: Sequence['outputs.GetDevicesItemDetailResult'],
                 firmware: builtins.str,
                 imei: builtins.float,
                 lan_ip: builtins.str,
                 lat: builtins.float,
                 lng: builtins.float,
                 mac: builtins.str,
                 model: builtins.str,
                 name: builtins.str,
                 network_id: builtins.str,
                 notes: builtins.str,
                 product_type: builtins.str,
                 serial: builtins.str,
                 tags: Sequence[builtins.str]):
        """
        :param builtins.str address: Physical address of the device
        :param Sequence['GetDevicesItemDetailArgs'] details: Additional device information
        :param builtins.str firmware: Firmware version of the device
        :param builtins.float imei: IMEI of the device, if applicable
        :param builtins.str lan_ip: LAN IP address of the device
        :param builtins.float lat: Latitude of the device
        :param builtins.float lng: Longitude of the device
        :param builtins.str mac: MAC address of the device
        :param builtins.str model: Model of the device
        :param builtins.str name: Name of the device
        :param builtins.str network_id: ID of the network the device belongs to
        :param builtins.str notes: Notes for the device, limited to 255 characters
        :param builtins.str product_type: Product type of the device
        :param builtins.str serial: Serial number of the device
        :param Sequence[builtins.str] tags: List of tags assigned to the device
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "firmware", firmware)
        pulumi.set(__self__, "imei", imei)
        pulumi.set(__self__, "lan_ip", lan_ip)
        pulumi.set(__self__, "lat", lat)
        pulumi.set(__self__, "lng", lng)
        pulumi.set(__self__, "mac", mac)
        pulumi.set(__self__, "model", model)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "notes", notes)
        pulumi.set(__self__, "product_type", product_type)
        pulumi.set(__self__, "serial", serial)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        Physical address of the device
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.GetDevicesItemDetailResult']:
        """
        Additional device information
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def firmware(self) -> builtins.str:
        """
        Firmware version of the device
        """
        return pulumi.get(self, "firmware")

    @property
    @pulumi.getter
    def imei(self) -> builtins.float:
        """
        IMEI of the device, if applicable
        """
        return pulumi.get(self, "imei")

    @property
    @pulumi.getter(name="lanIp")
    def lan_ip(self) -> builtins.str:
        """
        LAN IP address of the device
        """
        return pulumi.get(self, "lan_ip")

    @property
    @pulumi.getter
    def lat(self) -> builtins.float:
        """
        Latitude of the device
        """
        return pulumi.get(self, "lat")

    @property
    @pulumi.getter
    def lng(self) -> builtins.float:
        """
        Longitude of the device
        """
        return pulumi.get(self, "lng")

    @property
    @pulumi.getter
    def mac(self) -> builtins.str:
        """
        MAC address of the device
        """
        return pulumi.get(self, "mac")

    @property
    @pulumi.getter
    def model(self) -> builtins.str:
        """
        Model of the device
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the device
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> builtins.str:
        """
        ID of the network the device belongs to
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def notes(self) -> builtins.str:
        """
        Notes for the device, limited to 255 characters
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="productType")
    def product_type(self) -> builtins.str:
        """
        Product type of the device
        """
        return pulumi.get(self, "product_type")

    @property
    @pulumi.getter
    def serial(self) -> builtins.str:
        """
        Serial number of the device
        """
        return pulumi.get(self, "serial")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        """
        List of tags assigned to the device
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetDevicesItemDetailResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: Additional property name
        :param builtins.str value: Additional property value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Additional property name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Additional property value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetNetworksItemResult(dict):
    def __init__(__self__, *,
                 enrollment_string: builtins.str,
                 id: builtins.str,
                 is_bound_to_config_template: builtins.bool,
                 name: builtins.str,
                 notes: builtins.str,
                 organization_id: builtins.str,
                 product_types: Sequence[builtins.str],
                 tags: Sequence[builtins.str],
                 time_zone: builtins.str,
                 url: builtins.str):
        """
        :param builtins.str enrollment_string: Enrollment string for the network
        :param builtins.str id: Network ID
        :param builtins.bool is_bound_to_config_template: If the network is bound to a config template
        :param builtins.str name: Network name
        :param builtins.str notes: Notes for the network
        :param builtins.str organization_id: Organization ID
        :param Sequence[builtins.str] product_types: List of the product types that the network supports
        :param Sequence[builtins.str] tags: Network tags
        :param builtins.str time_zone: Timezone of the network
        :param builtins.str url: URL to the network Dashboard UI
        """
        pulumi.set(__self__, "enrollment_string", enrollment_string)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_bound_to_config_template", is_bound_to_config_template)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "notes", notes)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "product_types", product_types)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="enrollmentString")
    def enrollment_string(self) -> builtins.str:
        """
        Enrollment string for the network
        """
        return pulumi.get(self, "enrollment_string")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Network ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isBoundToConfigTemplate")
    def is_bound_to_config_template(self) -> builtins.bool:
        """
        If the network is bound to a config template
        """
        return pulumi.get(self, "is_bound_to_config_template")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Network name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def notes(self) -> builtins.str:
        """
        Notes for the network
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> builtins.str:
        """
        Organization ID
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="productTypes")
    def product_types(self) -> Sequence[builtins.str]:
        """
        List of the product types that the network supports
        """
        return pulumi.get(self, "product_types")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        """
        Network tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> builtins.str:
        """
        Timezone of the network
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        URL to the network Dashboard UI
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetOrganizationsItemResult(dict):
    def __init__(__self__, *,
                 api: 'outputs.GetOrganizationsItemApiResult',
                 cloud: 'outputs.GetOrganizationsItemCloudResult',
                 id: builtins.str,
                 licensing: 'outputs.GetOrganizationsItemLicensingResult',
                 management: 'outputs.GetOrganizationsItemManagementResult',
                 name: builtins.str,
                 url: builtins.str):
        """
        :param 'GetOrganizationsItemApiArgs' api: API related settings
        :param 'GetOrganizationsItemCloudArgs' cloud: Data for this organization
        :param builtins.str id: Organization ID
        :param 'GetOrganizationsItemLicensingArgs' licensing: Licensing related settings
        :param 'GetOrganizationsItemManagementArgs' management: Information about the organization's management system
        :param builtins.str name: Organization name
        :param builtins.str url: Organization URL
        """
        pulumi.set(__self__, "api", api)
        pulumi.set(__self__, "cloud", cloud)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "licensing", licensing)
        pulumi.set(__self__, "management", management)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def api(self) -> 'outputs.GetOrganizationsItemApiResult':
        """
        API related settings
        """
        return pulumi.get(self, "api")

    @property
    @pulumi.getter
    def cloud(self) -> 'outputs.GetOrganizationsItemCloudResult':
        """
        Data for this organization
        """
        return pulumi.get(self, "cloud")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Organization ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def licensing(self) -> 'outputs.GetOrganizationsItemLicensingResult':
        """
        Licensing related settings
        """
        return pulumi.get(self, "licensing")

    @property
    @pulumi.getter
    def management(self) -> 'outputs.GetOrganizationsItemManagementResult':
        """
        Information about the organization's management system
        """
        return pulumi.get(self, "management")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Organization name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        Organization URL
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetOrganizationsItemApiResult(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        :param builtins.bool enabled: Enable API access
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Enable API access
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetOrganizationsItemCloudResult(dict):
    def __init__(__self__, *,
                 region: 'outputs.GetOrganizationsItemCloudRegionResult'):
        """
        :param 'GetOrganizationsItemCloudRegionArgs' region: Region info
        """
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def region(self) -> 'outputs.GetOrganizationsItemCloudRegionResult':
        """
        Region info
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetOrganizationsItemCloudRegionResult(dict):
    def __init__(__self__, *,
                 name: builtins.str):
        """
        :param builtins.str name: Name of region
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of region
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetOrganizationsItemLicensingResult(dict):
    def __init__(__self__, *,
                 model: builtins.str):
        """
        :param builtins.str model: Organization licensing model. Can be 'co-term', 'per-device', or 'subscription'.
        """
        pulumi.set(__self__, "model", model)

    @property
    @pulumi.getter
    def model(self) -> builtins.str:
        """
        Organization licensing model. Can be 'co-term', 'per-device', or 'subscription'.
        """
        return pulumi.get(self, "model")


@pulumi.output_type
class GetOrganizationsItemManagementResult(dict):
    def __init__(__self__, *,
                 details: Sequence['outputs.GetOrganizationsItemManagementDetailResult']):
        """
        :param Sequence['GetOrganizationsItemManagementDetailArgs'] details: Details related to organization management, possibly empty. Details may be named 'MSP ID', 'IP restriction mode for API', or 'IP restriction mode for dashboard', if the organization admin has configured any.
        """
        pulumi.set(__self__, "details", details)

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.GetOrganizationsItemManagementDetailResult']:
        """
        Details related to organization management, possibly empty. Details may be named 'MSP ID', 'IP restriction mode for API', or 'IP restriction mode for dashboard', if the organization admin has configured any.
        """
        return pulumi.get(self, "details")


@pulumi.output_type
class GetOrganizationsItemManagementDetailResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: Name of management data
        :param builtins.str value: Value of management data
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of management data
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of management data
        """
        return pulumi.get(self, "value")


