import unittest
from moya.context import Context
from moya.context.expressionrange import *



class TestExpressionRange(unittest.TestCase):

    def test_exclusive_integer(self):
        c = Context()
        r = ExclusiveIntegerRange(c, 2, 4)
        self.assertEqual(list(r), [2, 3])
        self.assertEqual(len(r), 2)
        self.assert_(1 not in r)
        self.assert_(2 in r)
        self.assert_(3 in r)
        self.assert_(4 not in r)
        self.assertEqual(r + 5, [2, 3, 5])
        self.assertEqual(5 + r, [5, 2, 3])
        self.assertEqual(list(r.keys()), [0, 1])
        self.assertEqual(list(r.values()), [2, 3])
        self.assertEqual(r.items(), [(0, 2), (1, 3)])
        self.assertEqual(r[0], 2)
        self.assertEqual(r[1], 3)

        r = ExclusiveIntegerRange(c, 4, 2)
        self.assertEqual(len(r), 2)
        self.assertEqual(list(r), [4, 3])
        self.assert_(1 not in r)
        self.assert_(2 not in r)
        self.assert_(3 in r)
        self.assert_(4 in r)
        self.assert_(5 not in r)
        self.assertEqual(r + 5, [4, 3, 5])
        self.assertEqual(5 + r, [5, 4, 3])
        self.assertEqual(list(r.keys()), [0, 1])
        self.assertEqual(list(r.values()), [4, 3])
        self.assertEqual(list(r.items()), [(0, 4), (1, 3)])
        self.assertEqual(r[0], 4)
        self.assertEqual(r[1], 3)

    def test_inclusive_integer(self):
        c = Context()
        r = InclusiveIntegerRange(c, 2, 4)
        self.assertEqual(list(r), [2, 3, 4])
        self.assertEqual(len(r), 3)
        self.assert_(1 not in r)
        self.assert_(2 in r)
        self.assert_(3 in r)
        self.assert_(4 in r)
        self.assert_(5 not in r)
        self.assertEqual(r + 5, [2, 3, 4, 5])
        self.assertEqual(5 + r, [5, 2, 3, 4])
        self.assertEqual(list(r.keys()), [0, 1, 2])
        self.assertEqual(list(r.values()), [2, 3, 4])
        self.assertEqual(list(r.items()), [(0, 2), (1, 3), (2, 4)])
        self.assertEqual(r[0], 2)
        self.assertEqual(r[1], 3)
        self.assertEqual(r[2], 4)

        r = InclusiveIntegerRange(c, 4, 2)
        self.assertEqual(list(r), [4, 3, 2])
        self.assertEqual(len(r), 3)
        self.assert_(1 not in r)
        self.assert_(2 in r)
        self.assert_(3 in r)
        self.assert_(4 in r)
        self.assert_(5 not in r)
        self.assertEqual(r + 5, [4, 3, 2, 5])
        self.assertEqual(5 + r, [5, 4, 3, 2])
        self.assertEqual(list(r.keys()), [0, 1, 2])
        self.assertEqual(list(r.values()), [4, 3, 2])
        self.assertEqual(list(r.items()), [(0, 4), (1, 3), (2, 2)])
        self.assertEqual(r[0], 4)
        self.assertEqual(r[1], 3)
        self.assertEqual(r[2], 2)

    def test_exclusive_character(self):
        c = Context()
        r = ExclusiveCharacterRange(c, 'b', 'd')
        self.assertEqual(list(r), ['b', 'c'])
        self.assertEqual(len(r), 2)
        self.assert_('a' not in r)
        self.assert_('b' in r)
        self.assert_('c' in r)
        self.assert_('d' not in r)
        self.assertEqual(r + 'e', ['b', 'c', 'e'])
        self.assertEqual('e' + r, ['e', 'b', 'c'])
        self.assertEqual(list(r.keys()), [0, 1])
        self.assertEqual(list(r.values()), ['b', 'c'])
        self.assertEqual(list(r.items()), [(0, 'b'), (1, 'c')])
        self.assertEqual(r[0], 'b')
        self.assertEqual(r[1], 'c')

        r = ExclusiveCharacterRange(c, 'd', 'b')
        self.assertEqual(list(r), ['d', 'c'])
        self.assertEqual(len(r), 2)
        self.assert_('a' not in r)
        self.assert_('b' not in r)
        self.assert_('c' in r)
        self.assert_('d' in r)
        self.assert_('e' not in r)
        self.assertEqual(r + 'e', ['d', 'c', 'e'])
        self.assertEqual('e' + r, ['e', 'd', 'c'])
        self.assertEqual(list(r.keys()), [0, 1])
        self.assertEqual(list(r.values()), ['d', 'c'])
        self.assertEqual(list(r.items()), [(0, 'd'), (1, 'c')])
        self.assertEqual(r[0], 'd')
        self.assertEqual(r[1], 'c')

    def test_inclusive_character(self):
        c = Context()
        r = InclusiveCharacterRange(c, 'b', 'd')
        self.assertEqual(list(r), ['b', 'c', 'd'])
        self.assertEqual(len(r), 3)
        self.assert_('a' not in r)
        self.assert_('b' in r)
        self.assert_('c' in r)
        self.assert_('d' in r)
        self.assert_('e' not in r)
        self.assertEqual(r + 'e', ['b', 'c', 'd', 'e'])
        self.assertEqual('e' + r, ['e', 'b', 'c', 'd'])
        self.assertEqual(list(r.keys()), [0, 1, 2])
        self.assertEqual(list(r.values()), ['b', 'c', 'd'])
        self.assertEqual(list(r.items()), [(0, 'b'), (1, 'c'), (2, 'd')])
        self.assertEqual(r[0], 'b')
        self.assertEqual(r[1], 'c')
        self.assertEqual(r[2], 'd')

        r = InclusiveCharacterRange(c, 'd', 'b')
        self.assertEqual(list(r), ['d', 'c', 'b'])
        self.assertEqual(len(r), 3)
        self.assert_('a' not in r)
        self.assert_('b' in r)
        self.assert_('c' in r)
        self.assert_('d' in r)
        self.assert_('e' not in r)
        self.assertEqual(r + 'e', ['d', 'c', 'b', 'e'])
        self.assertEqual('e' + r, ['e', 'd', 'c', 'b'])
        self.assertEqual(list(r.keys()), [0, 1, 2])
        self.assertEqual(list(r.values()), ['d', 'c', 'b'])
        self.assertEqual(list(r.items()), [(0, 'd'), (1, 'c'), (2, 'b')])
        self.assertEqual(r[0], 'd')
        self.assertEqual(r[1], 'c')
        self.assertEqual(r[2], 'b')
