# coding: utf-8

"""
    NetHSM
    All endpoints expect exactly the specified JSON. Additional properties will cause a Bad Request Error (400). All HTTP errors contain a JSON structure with an explanation of type string. All [base64](https://tools.ietf.org/html/rfc4648#section-4) encoded values are Big Endian.   # noqa: E501
    The version of the OpenAPI document: v1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

from __future__ import annotations
from pynitrokey.nethsm.client.shared_imports.schema_imports import *  # pyright: ignore [reportWildcardImportFromLibrary]

IpAddress: typing_extensions.TypeAlias = schemas.StrSchema
Netmask: typing_extensions.TypeAlias = schemas.StrSchema
Gateway: typing_extensions.TypeAlias = schemas.StrSchema
Properties = typing.TypedDict(
    'Properties',
    {
        "ipAddress": typing.Type[IpAddress],
        "netmask": typing.Type[Netmask],
        "gateway": typing.Type[Gateway],
    }
)


class NetworkConfigDict(schemas.immutabledict[str, str]):

    __required_keys__: typing.FrozenSet[str] = frozenset({
        "gateway",
        "ipAddress",
        "netmask",
    })
    __optional_keys__: typing.FrozenSet[str] = frozenset({
    })
    
    def __new__(
        cls,
        *,
        gateway: str,
        ipAddress: str,
        netmask: str,
        configuration_: typing.Optional[schema_configuration.SchemaConfiguration] = None,
        **kwargs: schemas.INPUT_TYPES_ALL,
    ):
        arg_: typing.Dict[str, typing.Any] = {
            "gateway": gateway,
            "ipAddress": ipAddress,
            "netmask": netmask,
        }
        arg_.update(kwargs)
        used_arg_ = typing.cast(NetworkConfigDictInput, arg_)
        return NetworkConfig.validate(used_arg_, configuration=configuration_)
    
    @staticmethod
    def from_dict_(
        arg: typing.Union[
            NetworkConfigDictInput,
            NetworkConfigDict
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> NetworkConfigDict:
        return NetworkConfig.validate(arg, configuration=configuration)
    
    @property
    def gateway(self) -> str:
        return typing.cast(
            str,
            self.__getitem__("gateway")
        )
    
    @property
    def ipAddress(self) -> str:
        return typing.cast(
            str,
            self.__getitem__("ipAddress")
        )
    
    @property
    def netmask(self) -> str:
        return typing.cast(
            str,
            self.__getitem__("netmask")
        )
    
    def get_additional_property_(self, name: str) -> typing.Union[schemas.OUTPUT_BASE_TYPES, schemas.Unset]:
        schemas.raise_if_key_known(name, self.__required_keys__, self.__optional_keys__)
        return self.get(name, schemas.unset)
NetworkConfigDictInput = typing.Mapping[str, schemas.INPUT_TYPES_ALL]


@dataclasses.dataclass(frozen=True)
class NetworkConfig(
    schemas.Schema[NetworkConfigDict, tuple]
):
    """NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
    Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator

    Do not edit the class manually.
    """
    types: typing.FrozenSet[typing.Type] = frozenset({schemas.immutabledict})
    required: typing.FrozenSet[str] = frozenset({
        "gateway",
        "ipAddress",
        "netmask",
    })
    properties: Properties = dataclasses.field(default_factory=lambda: schemas.typed_dict_to_instance(Properties)) # type: ignore
    type_to_output_cls: typing.Mapping[
        typing.Type,
        typing.Type
    ] = dataclasses.field(
        default_factory=lambda: {
            schemas.immutabledict: NetworkConfigDict
        }
    )

    @classmethod
    def validate(
        cls,
        arg: typing.Union[
            NetworkConfigDictInput,
            NetworkConfigDict,
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> NetworkConfigDict:
        return super().validate_base(
            arg,
            configuration=configuration,
        )

