# coding: utf-8

"""
    NetHSM
    All endpoints expect exactly the specified JSON. Additional properties will cause a Bad Request Error (400). All HTTP errors contain a JSON structure with an explanation of type string. All [base64](https://tools.ietf.org/html/rfc4648#section-4) encoded values are Big Endian.   # noqa: E501
    The version of the OpenAPI document: v1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

from __future__ import annotations
from pynitrokey.nethsm.client.shared_imports.schema_imports import *  # pyright: ignore [reportWildcardImportFromLibrary]



class SignModeEnums:

    @schemas.classproperty
    def PKCS1(cls) -> typing.Literal["PKCS1"]:
        return SignMode.validate("PKCS1")

    @schemas.classproperty
    def PSS_MD5(cls) -> typing.Literal["PSS_MD5"]:
        return SignMode.validate("PSS_MD5")

    @schemas.classproperty
    def PSS_SHA1(cls) -> typing.Literal["PSS_SHA1"]:
        return SignMode.validate("PSS_SHA1")

    @schemas.classproperty
    def PSS_SHA224(cls) -> typing.Literal["PSS_SHA224"]:
        return SignMode.validate("PSS_SHA224")

    @schemas.classproperty
    def PSS_SHA256(cls) -> typing.Literal["PSS_SHA256"]:
        return SignMode.validate("PSS_SHA256")

    @schemas.classproperty
    def PSS_SHA384(cls) -> typing.Literal["PSS_SHA384"]:
        return SignMode.validate("PSS_SHA384")

    @schemas.classproperty
    def PSS_SHA512(cls) -> typing.Literal["PSS_SHA512"]:
        return SignMode.validate("PSS_SHA512")

    @schemas.classproperty
    def ED_DSA(cls) -> typing.Literal["EdDSA"]:
        return SignMode.validate("EdDSA")

    @schemas.classproperty
    def ECDSA(cls) -> typing.Literal["ECDSA"]:
        return SignMode.validate("ECDSA")


@dataclasses.dataclass(frozen=True)
class SignMode(
    schemas.Schema
):
    """NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
    Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator

    Do not edit the class manually.
    """
    types: typing.FrozenSet[typing.Type] = frozenset({
        str,
    })
    enum_value_to_name: typing.Mapping[typing.Union[int, float, str, schemas.Bool, None], str] = dataclasses.field(
        default_factory=lambda: {
            "PKCS1": "PKCS1",
            "PSS_MD5": "PSS_MD5",
            "PSS_SHA1": "PSS_SHA1",
            "PSS_SHA224": "PSS_SHA224",
            "PSS_SHA256": "PSS_SHA256",
            "PSS_SHA384": "PSS_SHA384",
            "PSS_SHA512": "PSS_SHA512",
            "EdDSA": "ED_DSA",
            "ECDSA": "ECDSA",
        }
    )
    enums = SignModeEnums

    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["PKCS1"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["PKCS1"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["PSS_MD5"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["PSS_MD5"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["PSS_SHA1"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["PSS_SHA1"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["PSS_SHA224"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["PSS_SHA224"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["PSS_SHA256"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["PSS_SHA256"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["PSS_SHA384"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["PSS_SHA384"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["PSS_SHA512"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["PSS_SHA512"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["EdDSA"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["EdDSA"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: typing.Literal["ECDSA"],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["ECDSA"]: ...
    @typing.overload
    @classmethod
    def validate(
        cls,
        arg: str,
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal["PKCS1","PSS_MD5","PSS_SHA1","PSS_SHA224","PSS_SHA256","PSS_SHA384","PSS_SHA512","EdDSA","ECDSA",]: ...
    @classmethod
    def validate(
        cls,
        arg,
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> typing.Literal[
        "PKCS1",
        "PSS_MD5",
        "PSS_SHA1",
        "PSS_SHA224",
        "PSS_SHA256",
        "PSS_SHA384",
        "PSS_SHA512",
        "EdDSA",
        "ECDSA",
    ]:
        validated_arg = super().validate_base(
            arg,
            configuration=configuration,
        )
        return typing.cast(typing.Literal[
                "PKCS1",
                "PSS_MD5",
                "PSS_SHA1",
                "PSS_SHA224",
                "PSS_SHA256",
                "PSS_SHA384",
                "PSS_SHA512",
                "EdDSA",
                "ECDSA",
            ],
            validated_arg
        )
