/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;

public class BurleighReader
extends FormatReader {
    private int pixelsOffset;

    public BurleighReader() {
        super("Burleigh", "img");
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
        this.suffixSufficient = false;
        this.suffixNecessary = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        byte[] magic = new byte[4];
        stream.read(magic);
        return magic[0] == 102 && magic[1] == 102 && magic[3] == 64 && (magic[2] == 70 || magic[2] == 6);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.pixelsOffset);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelsOffset = 0;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.littleEndian = true;
        this.in.order(this.isLittleEndian());
        int version = (int)this.in.readFloat() - 1;
        m.sizeX = this.in.readShort();
        m.sizeY = this.in.readShort();
        double xSize = 0.0;
        double ySize = 0.0;
        double zSize = 0.0;
        int n = this.pixelsOffset = version == 1 ? 8 : 260;
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            double timePerPixel = 0.0;
            int mode = 0;
            int gain = 0;
            int mag = 0;
            double sampleVolts = 0.0;
            double tunnelCurrent = 0.0;
            if (version == 1) {
                this.in.seek(this.in.length() - 40L);
                this.in.skipBytes(12);
                xSize = this.in.readInt();
                ySize = this.in.readInt();
                zSize = this.in.readInt();
                timePerPixel = this.in.readShort() * 50;
                mag = this.in.readShort();
                switch (mag) {
                    case 3: {
                        mag = 10;
                        break;
                    }
                    case 4: {
                        mag = 50;
                        break;
                    }
                    case 5: {
                        mag = 250;
                    }
                }
                xSize /= (double)mag;
                ySize /= (double)mag;
                zSize /= (double)mag;
                mode = this.in.readShort();
                gain = this.in.readShort();
                sampleVolts = this.in.readFloat() / 1000.0f;
                tunnelCurrent = this.in.readFloat();
            } else if (version == 2) {
                this.in.skipBytes(14);
                xSize = this.in.readInt();
                ySize = this.in.readInt();
                zSize = this.in.readInt();
                mode = this.in.readShort();
                this.in.skipBytes(4);
                gain = this.in.readShort();
                timePerPixel = this.in.readShort() * 50;
                this.in.skipBytes(12);
                sampleVolts = this.in.readFloat();
                tunnelCurrent = this.in.readFloat();
                this.addGlobalMeta("Force", this.in.readFloat());
            }
            this.addGlobalMeta("Version", version);
            this.addGlobalMeta("Image mode", mode);
            this.addGlobalMeta("Z gain", gain);
            this.addGlobalMeta("Time per pixel (s)", timePerPixel);
            this.addGlobalMeta("Sample volts", sampleVolts);
            this.addGlobalMeta("Tunnel current", tunnelCurrent);
            this.addGlobalMeta("Magnification", mag);
        }
        m.pixelType = 3;
        m.sizeZ = 1;
        m.sizeC = 1;
        m.sizeT = 1;
        m.imageCount = 1;
        m.dimensionOrder = "XYZCT";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            Length sizeX = FormatTools.getPhysicalSizeX(xSize / (double)this.getSizeX());
            Length sizeY = FormatTools.getPhysicalSizeY(ySize / (double)this.getSizeY());
            Length sizeZ = FormatTools.getPhysicalSizeZ(zSize / (double)this.getSizeZ());
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            if (sizeZ != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, 0);
            }
        }
    }
}

