/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;

public class NikonTiffReader
extends BaseTiffReader {
    private static final String[] TOP_LEVEL_KEYS = new String[]{"document document", "document", "history Acquisition", "history objective", "history history", "history laser", "history step", "history", "sensor s_params", "sensor", "view"};
    private double physicalSizeX;
    private double physicalSizeY;
    private double physicalSizeZ;
    private List<String> filterModels;
    private List<String> dichroicModels;
    private List<String> laserIDs;
    private Double magnification;
    private double lensNA;
    private double workingDistance;
    private double pinholeSize;
    private String correction;
    private String immersion;
    private List<Double> gain;
    private List<Double> wavelength;
    private List<Double> emWave;
    private List<Double> exWave;

    public NikonTiffReader() {
        super("Nikon TIFF", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Light Microscopy"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        String software = ifd.getIFDTextValue(305);
        return software != null && software.toString().indexOf("EZ-C1") != -1;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.physicalSizeZ = 0.0;
            this.physicalSizeY = 0.0;
            this.physicalSizeX = 0.0;
            this.laserIDs = null;
            this.filterModels = null;
            this.dichroicModels = null;
            this.magnification = null;
            this.pinholeSize = 0.0;
            this.workingDistance = 0.0;
            this.lensNA = 0.0;
            this.immersion = null;
            this.correction = null;
            this.gain = null;
            this.exWave = null;
            this.emWave = null;
            this.wavelength = null;
        }
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) {
            return;
        }
        this.filterModels = new ArrayList<String>();
        this.dichroicModels = new ArrayList<String>();
        this.laserIDs = new ArrayList<String>();
        this.gain = new ArrayList<Double>();
        this.wavelength = new ArrayList<Double>();
        this.emWave = new ArrayList<Double>();
        this.exWave = new ArrayList<Double>();
        String comment = ((IFD)this.ifds.get(0)).getComment();
        this.metadata.remove("Comment");
        String[] lines = comment.split("\n");
        String[] dimensionLabels = null;
        String[] dimensionSizes = null;
        for (String line : lines) {
            int i;
            String[] tokens = line.split("\t");
            line = line.replaceAll("\t", " ");
            int nTokensInKey = 0;
            for (String key : TOP_LEVEL_KEYS) {
                if (!line.startsWith(key)) continue;
                nTokensInKey = key.indexOf(32) != -1 ? 3 : 2;
                break;
            }
            StringBuilder k = new StringBuilder();
            for (int i2 = 0; i2 < nTokensInKey; ++i2) {
                k.append(tokens[i2]);
                if (i2 >= nTokensInKey - 1) continue;
                k.append(" ");
            }
            StringBuilder v = new StringBuilder();
            for (int i3 = nTokensInKey; i3 < tokens.length; ++i3) {
                v.append(tokens[i3]);
                if (i3 >= tokens.length - 1) continue;
                v.append(" ");
            }
            String key = k.toString();
            String value = v.toString();
            if (key.equals("document label")) {
                dimensionLabels = value.toLowerCase().split(" ");
            } else if (key.equals("document scale")) {
                dimensionSizes = value.split(" ");
            } else if (key.startsWith("history Acquisition") && key.indexOf("Filter") != -1) {
                this.filterModels.add(value);
            } else if (key.startsWith("history Acquisition") && key.indexOf("Dichroic") != -1) {
                this.dichroicModels.add(value);
            } else if (key.equals("history objective Type")) {
                this.correction = value;
            } else if (key.equals("history objective Magnification")) {
                this.magnification = new Double(value);
            } else if (key.equals("history objective NA")) {
                this.lensNA = Double.parseDouble(value);
            } else if (key.equals("history objective WorkingDistance")) {
                this.workingDistance = Double.parseDouble(value);
            } else if (key.equals("history objective Immersion")) {
                this.immersion = value;
            } else if (key.startsWith("history gain")) {
                this.gain.add(new Double(value));
            } else if (key.equals("history pinhole")) {
                this.pinholeSize = new Double(value.substring(0, value.indexOf(32)));
            } else if (key.startsWith("history laser") && key.endsWith("wavelength")) {
                this.wavelength.add(new Double(value.replaceAll("\\D", "")));
            } else if (key.startsWith("history laser") && key.endsWith("name")) {
                this.laserIDs.add(value);
            } else if (key.equals("sensor s_params LambdaEx")) {
                for (i = nTokensInKey; i < tokens.length; ++i) {
                    this.exWave.add(new Double(tokens[i]));
                }
            } else if (key.equals("sensor s_params LambdaEm")) {
                for (i = nTokensInKey; i < tokens.length; ++i) {
                    this.emWave.add(new Double(tokens[i]));
                }
            }
            this.addGlobalMeta(key, value);
        }
        this.parseDimensionSizes(dimensionLabels, dimensionSizes);
    }

    @Override
    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            int i;
            store.setImageDescription("", 0);
            Length sizeX = FormatTools.getPhysicalSizeX(this.physicalSizeX);
            Length sizeY = FormatTools.getPhysicalSizeY(this.physicalSizeY);
            Length sizeZ = FormatTools.getPhysicalSizeZ(this.physicalSizeZ);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            if (sizeZ != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, 0);
            }
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objectiveID, 0, 0);
            store.setObjectiveSettingsID(objectiveID, 0);
            store.setObjectiveNominalMagnification(this.magnification, 0, 0);
            if (this.correction == null) {
                this.correction = "Other";
            }
            store.setObjectiveCorrection(this.getCorrection(this.correction), 0, 0);
            store.setObjectiveLensNA(this.lensNA, 0, 0);
            store.setObjectiveWorkingDistance(new Length(this.workingDistance, UNITS.MICROMETER), 0, 0);
            if (this.immersion == null) {
                this.immersion = "Other";
            }
            store.setObjectiveImmersion(this.getImmersion(this.immersion), 0, 0);
            for (i = 0; i < this.wavelength.size(); ++i) {
                String laser = MetadataTools.createLSID("LightSource", 0, i);
                store.setLaserID(laser, 0, i);
                store.setLaserModel(this.laserIDs.get(i), 0, i);
                Length wave = FormatTools.getWavelength(this.wavelength.get(i));
                if (wave != null) {
                    store.setLaserWavelength(wave, 0, i);
                }
                store.setLaserType(this.getLaserType("Other"), 0, i);
                store.setLaserLaserMedium(this.getLaserMedium("Other"), 0, i);
            }
            for (i = 0; i < this.gain.size(); ++i) {
                store.setDetectorID(MetadataTools.createLSID("Detector", 0, i), 0, i);
                store.setDetectorGain(this.gain.get(i), 0, i);
                store.setDetectorType(this.getDetectorType("Other"), 0, i);
            }
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                Length wave;
                store.setChannelPinholeSize(new Length(this.pinholeSize, UNITS.MICROMETER), 0, c);
                if (c < this.exWave.size() && (wave = FormatTools.getExcitationWavelength(this.exWave.get(c))) != null) {
                    store.setChannelExcitationWavelength(wave, 0, c);
                }
                if (c >= this.emWave.size() || (wave = FormatTools.getEmissionWavelength(this.emWave.get(c))) == null) continue;
                store.setChannelEmissionWavelength(wave, 0, c);
            }
            for (i = 0; i < this.filterModels.size(); ++i) {
                String filter = MetadataTools.createLSID("Filter", 0, i);
                store.setFilterID(filter, 0, i);
                store.setFilterModel(this.filterModels.get(i), 0, i);
            }
            for (i = 0; i < this.dichroicModels.size(); ++i) {
                String dichroic = MetadataTools.createLSID("Dichroic", 0, i);
                store.setDichroicID(dichroic, 0, i);
                store.setDichroicModel(this.dichroicModels.get(i), 0, i);
            }
        }
    }

    private void parseDimensionSizes(String[] labels, String[] sizes) {
        for (int i = 0; i < labels.length; ++i) {
            if (labels[i].startsWith("z")) {
                this.physicalSizeZ = Double.parseDouble(sizes[i]);
                continue;
            }
            if (labels[i].equals("x")) {
                this.physicalSizeX = Double.parseDouble(sizes[i]);
                continue;
            }
            if (!labels[i].equals("y")) continue;
            this.physicalSizeY = Double.parseDouble(sizes[i]);
        }
    }
}

