/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.units.quantity.Length;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.AffineTransform;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.Union;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.FillRule;
import ome.xml.model.enums.FontFamily;
import ome.xml.model.enums.FontStyle;
import ome.xml.model.enums.UnitsLength;
import ome.xml.model.enums.handlers.UnitsLengthEnumHandler;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Shape
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Shape.class);
    private String strokeDashArray;
    private Length strokeWidth;
    private Boolean locked;
    private FillRule fillRule;
    private String text;
    private NonNegativeInteger theC;
    private FontFamily fontFamily;
    private FontStyle fontStyle;
    private Length fontSize;
    private Color fillColor;
    private Color strokeColor;
    private NonNegativeInteger theT;
    private String id;
    private NonNegativeInteger theZ;
    private AffineTransform transform;
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();
    private Union union;

    public Shape() {
    }

    public Shape(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Shape(Shape orig) {
        this.strokeDashArray = orig.strokeDashArray;
        this.strokeWidth = orig.strokeWidth;
        this.locked = orig.locked;
        this.fillRule = orig.fillRule;
        this.text = orig.text;
        this.theC = orig.theC;
        this.fontFamily = orig.fontFamily;
        this.fontStyle = orig.fontStyle;
        this.fontSize = orig.fontSize;
        this.fillColor = orig.fillColor;
        this.strokeColor = orig.strokeColor;
        this.theT = orig.theT;
        this.id = orig.id;
        this.theZ = orig.theZ;
        this.transform = orig.transform;
        this.annotationLinks = orig.annotationLinks;
        this.union = orig.union;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Transform_nodeList;
        Object baseValue;
        UnitsLength modelUnit;
        String unitSymbol;
        super.update(element, model);
        String tagName = element.getTagName();
        if (element.hasAttribute("StrokeDashArray")) {
            this.setStrokeDashArray(String.valueOf(element.getAttribute("StrokeDashArray")));
        }
        if (element.hasAttribute("StrokeWidth")) {
            unitSymbol = element.getAttribute("StrokeWidthUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = Shape.getStrokeWidthUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            baseValue = Double.valueOf(element.getAttribute("StrokeWidth"));
            if (baseValue != null) {
                this.setStrokeWidth(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
            }
        }
        if (element.hasAttribute("Locked")) {
            this.setLocked(Boolean.valueOf(element.getAttribute("Locked")));
        }
        if (element.hasAttribute("FillRule")) {
            this.setFillRule(FillRule.fromString(element.getAttribute("FillRule")));
        }
        if (element.hasAttribute("Text")) {
            this.setText(String.valueOf(element.getAttribute("Text")));
        }
        if (element.hasAttribute("TheC")) {
            this.setTheC(NonNegativeInteger.valueOf(element.getAttribute("TheC")));
        }
        if (element.hasAttribute("FontFamily")) {
            this.setFontFamily(FontFamily.fromString(element.getAttribute("FontFamily")));
        }
        if (element.hasAttribute("FontStyle")) {
            this.setFontStyle(FontStyle.fromString(element.getAttribute("FontStyle")));
        }
        if (element.hasAttribute("FontSize")) {
            unitSymbol = element.getAttribute("FontSizeUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = Shape.getFontSizeUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            baseValue = NonNegativeInteger.valueOf(element.getAttribute("FontSize"));
            if (baseValue != null) {
                this.setFontSize(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
            }
        }
        if (element.hasAttribute("FillColor")) {
            this.setFillColor(Color.valueOf(element.getAttribute("FillColor")));
        }
        if (element.hasAttribute("StrokeColor")) {
            this.setStrokeColor(Color.valueOf(element.getAttribute("StrokeColor")));
        }
        if (element.hasAttribute("TheT")) {
            this.setTheT(NonNegativeInteger.valueOf(element.getAttribute("TheT")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Shape missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("TheZ")) {
            this.setTheZ(NonNegativeInteger.valueOf(element.getAttribute("TheZ")));
        }
        if ((Transform_nodeList = Shape.getChildrenByTagName(element, "Transform")).size() > 1) {
            throw new RuntimeException(String.format("Transform node list size %d != 1", Transform_nodeList.size()));
        }
        if (Transform_nodeList.size() != 0) {
            this.setTransform(new AffineTransform(Transform_nodeList.get(0), model));
        }
        List<Element> AnnotationRef_nodeList = Shape.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkShape(this);
            this.annotationLinks.add(o_casted);
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public String getStrokeDashArray() {
        return this.strokeDashArray;
    }

    public void setStrokeDashArray(String strokeDashArray) {
        this.strokeDashArray = strokeDashArray;
    }

    public Length getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(Length strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public FillRule getFillRule() {
        return this.fillRule;
    }

    public void setFillRule(FillRule fillRule) {
        this.fillRule = fillRule;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public NonNegativeInteger getTheC() {
        return this.theC;
    }

    public void setTheC(NonNegativeInteger theC) {
        this.theC = theC;
    }

    public static String getStrokeWidthUnitXsdDefault() {
        return "pixel";
    }

    public FontFamily getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(FontFamily fontFamily) {
        this.fontFamily = fontFamily;
    }

    public static String getFontSizeUnitXsdDefault() {
        return "pt";
    }

    public FontStyle getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(FontStyle fontStyle) {
        this.fontStyle = fontStyle;
    }

    public Length getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Length fontSize) {
        this.fontSize = fontSize;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    public NonNegativeInteger getTheT() {
        return this.theT;
    }

    public void setTheT(NonNegativeInteger theT) {
        this.theT = theT;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public NonNegativeInteger getTheZ() {
        return this.theZ;
    }

    public void setTheZ(NonNegativeInteger theZ) {
        this.theZ = theZ;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setTransform(AffineTransform transform) {
        this.transform = transform;
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkShape(this);
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkShape(this);
        return this.annotationLinks.remove(o);
    }

    public Union getUnion() {
        return this.union;
    }

    public void setUnion(Union union_BackReference) {
        this.union = union_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Shape_element) {
        UnitsLength enumUnits;
        if (Shape_element == null) {
            Shape_element = document.createElementNS(NAMESPACE, "Shape");
        }
        super.asXMLElement(document, Shape_element);
        if (this.strokeDashArray != null) {
            Shape_element.setAttribute("StrokeDashArray", this.strokeDashArray.toString());
        }
        if (this.strokeWidth != null) {
            if (this.strokeWidth.value() != null) {
                Shape_element.setAttribute("StrokeWidth", this.strokeWidth.value().toString());
            }
            if (this.strokeWidth.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.strokeWidth.unit().getSymbol());
                    Shape_element.setAttribute("StrokeWidthUnit", enumUnits.toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for Shape:StrokeWidthUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.locked != null) {
            Shape_element.setAttribute("Locked", this.locked.toString());
        }
        if (this.fillRule != null) {
            Shape_element.setAttribute("FillRule", this.fillRule.toString());
        }
        if (this.text != null) {
            Shape_element.setAttribute("Text", this.text.toString());
        }
        if (this.theC != null) {
            Shape_element.setAttribute("TheC", this.theC.toString());
        }
        if (this.fontFamily != null) {
            Shape_element.setAttribute("FontFamily", this.fontFamily.toString());
        }
        if (this.fontStyle != null) {
            Shape_element.setAttribute("FontStyle", this.fontStyle.toString());
        }
        if (this.fontSize != null) {
            if (this.fontSize.value() != null) {
                Shape_element.setAttribute("FontSize", Long.toString(this.fontSize.value().longValue()));
            }
            if (this.fontSize.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.fontSize.unit().getSymbol());
                    Shape_element.setAttribute("FontSizeUnit", enumUnits.toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for Shape:FontSizeUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.fillColor != null) {
            Shape_element.setAttribute("FillColor", this.fillColor.toString());
        }
        if (this.strokeColor != null) {
            Shape_element.setAttribute("StrokeColor", this.strokeColor.toString());
        }
        if (this.theT != null) {
            Shape_element.setAttribute("TheT", this.theT.toString());
        }
        if (this.id != null) {
            Shape_element.setAttribute("ID", this.id.toString());
        }
        if (this.theZ != null) {
            Shape_element.setAttribute("TheZ", this.theZ.toString());
        }
        if (this.transform != null) {
            Element child = document.createElementNS(NAMESPACE, "Transform");
            this.transform.asXMLElement(document, child);
            Shape_element.appendChild(child);
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationLinks_value.getID());
                Element child = document.createElementNS(NAMESPACE, "AnnotationRef");
                o.asXMLElement(document, child);
                Shape_element.appendChild(child);
            }
        }
        if (this.union != null) {
            // empty if block
        }
        return Shape_element;
    }
}

