/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.time;

import java.util.Date;
import java.util.Formatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarPeriod;

@Immutable
public class CalendarDateUnit {
    private static final String byCalendarString = "calendar ";
    public static final String udunitPatternString = "(\\w*)\\s*since\\s*([\\+\\-\\d]+)([ t]([\\.\\:\\d]*)([ \\+\\-]\\S*)?z?)?$";
    private static final Pattern udunitPattern = Pattern.compile("(\\w*)\\s*since\\s*([\\+\\-\\d]+)([ t]([\\.\\:\\d]*)([ \\+\\-]\\S*)?z?)?$");
    private final Calendar cal;
    private final String unitString;
    private final CalendarPeriod.Field periodField;
    private final CalendarDate baseDate;
    private final boolean isCalendarField;

    public static CalendarDateUnit of(String calendarName, String udunitString) {
        Calendar calt = Calendar.get(calendarName);
        if (calt == null) {
            calt = Calendar.getDefault();
        }
        return new CalendarDateUnit(calt, udunitString);
    }

    public static CalendarDateUnit withCalendar(Calendar calt, String udunitString) {
        if (calt == null) {
            calt = Calendar.getDefault();
        }
        return new CalendarDateUnit(calt, udunitString);
    }

    private CalendarDateUnit(Calendar calt, String dateUnitString) {
        Matcher m;
        this.cal = calt;
        dateUnitString = dateUnitString.trim();
        dateUnitString = dateUnitString.toLowerCase();
        this.isCalendarField = dateUnitString.startsWith(byCalendarString);
        if (this.isCalendarField) {
            dateUnitString = dateUnitString.substring(byCalendarString.length()).trim();
        }
        if (!(m = udunitPattern.matcher(dateUnitString)).matches()) {
            throw new IllegalArgumentException(dateUnitString + " does not match " + udunitPatternString);
        }
        this.unitString = m.group(1);
        this.periodField = CalendarPeriod.fromUnitString(this.unitString);
        int pos = dateUnitString.indexOf("since");
        String iso = dateUnitString.substring(pos + 5);
        this.baseDate = CalendarDateFormatter.isoStringToCalendarDate(this.cal, iso);
    }

    public CalendarDate makeCalendarDate(double value) {
        if (this.isCalendarField) {
            return this.baseDate.add(CalendarPeriod.of((int)value, this.periodField));
        }
        return this.baseDate.add(value, this.periodField);
    }

    public CalendarDate makeCalendarDate(int value) {
        if (this.isCalendarField) {
            return this.baseDate.add(CalendarPeriod.of(value, this.periodField));
        }
        return this.baseDate.add(value, this.periodField);
    }

    public String toString() {
        Formatter f = new Formatter();
        if (this.isCalendarField) {
            f.format("%s", byCalendarString);
        }
        f.format("%s since %s", this.unitString, CalendarDateFormatter.toDateTimeString(this.baseDate));
        return f.toString();
    }

    public CalendarDate getBaseCalendarDate() {
        return this.baseDate;
    }

    public CalendarPeriod getTimeUnit() {
        return CalendarPeriod.of(1, CalendarPeriod.fromUnitString(this.unitString));
    }

    public Calendar getCalendar() {
        return this.cal;
    }

    public boolean isCalendarField() {
        return this.isCalendarField;
    }

    Date getBaseDate() {
        return this.baseDate.toDate();
    }

    public static void main(String[] args) {
        String s = "calendar Month since 2012-01-19T18:00:00.000Z";
        CalendarDateUnit cdu = CalendarDateUnit.of(null, s);
        System.out.printf("%s == %s%n", s, cdu);
    }
}

