# fewsats


<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

This file will become your README and also the index of your
documentation.

## Developer Guide

If you are new to using `nbdev` here are some useful pointers to get you
started.

### Install fewsats_python in Development mode

``` sh
# make sure fewsats_python package is installed in development mode
$ pip install -e .

# make changes under nbs/ directory
# ...

# compile to have changes apply to fewsats_python
$ nbdev_prepare
```

## Usage

### Installation

Install latest from the GitHub
[repository](https://github.com/Fewsats/fewsats-python):

``` sh
$ pip install git+https://github.com/Fewsats/fewsats-python.git
```

or from [pypi](https://pypi.org/project/fewsats-python/)

``` sh
$ pip install fewsats
```

### Documentation

Documentation can be found hosted on this GitHub
[repository](https://github.com/Fewsats/fewsats-python)’s
[pages](https://Fewsats.github.io/fewsats-python/). Additionally you can
find package manager specific guidelines on
[conda](https://anaconda.org/Fewsats/fewsats-python) and
[pypi](https://pypi.org/project/fewsats-python/) respectively.

## How to use

The library allows you to check which payment methods you have available
and to pay for an offer.

``` python
from fewsats.core import * 
from dotenv import load_dotenv
```

``` python
load_dotenv()
```

    True

``` python
fs = Client()
fs.payment_methods()
```

    [{'id': 5,
      'last4': '4242',
      'brand': 'Visa',
      'exp_month': 12,
      'exp_year': 2034,
      'is_default': True}]

``` python
fs.balance()
```

    [{'id': 15, 'balance': 9998, 'currency': 'usd'}]

`Client().balance()` returns how much balance you have in your wallet in
cents.

``` python
# Example offer from stock.l402.org
ofs = {
   "offers":[
      {
         "amount":1,
         "balance":1,
         "currency":"USD",
         "description":"Purchase 1 credit for API access",
         "offer_id":"offer_c668e0c0",
         "payment_methods":[
            "lightning"
         ],
         "title":"1 Credit Package",
         "type":"top-up"
      },
      {
         "amount":100,
         "balance":120,
         "currency":"USD",
         "description":"Purchase 120 credits for API access",
         "offer_id":"offer_97bf23f7",
         "payment_methods":[
            "lightning",
            "coinbase_commerce"
         ],
         "title":"120 Credits Package",
         "type":"top-up"
      },
      {
         "amount":499,
         "balance":750,
         "currency":"USD",
         "description":"Purchase 750 credits for API access",
         "offer_id":"offer_a896b13c",
         "payment_methods":[
            "lightning",
            "coinbase_commerce",
            "credit_card"
         ],
         "title":"750 Credits Package",
         "type":"top-up"
      }
   ],
   "payment_context_token":"edb53dec-28f5-4cbb-924a-20e9003c20e1",
   "payment_request_url":"https://stock.l402.org/l402/payment-request",
   "terms_url":"https://link-to-terms.com",
   "version":"0.2.1"
}
```

``` python
from claudette import Chat, models
```

``` python
chat = Chat(models[1], sp='You are a helpful assistant that can pay offers.', tools=[fs.pay])
pr = f"Could you pay the cheapest offer using lightning {ofs}?"
r = chat.toolloop(pr, trace_func=print)
r
```

    Message(id='msg_01NFdtyUuDPMMjKnqP2d1aug', content=[TextBlock(text='Certainly! I\'d be happy to help you pay for the cheapest offer using Lightning. Let\'s analyze the information you\'ve provided and proceed with the payment.\n\nThe cheapest offer from the given list is:\n\n- Amount: 1 cent (USD 0.01)\n- Balance: 1 credit\n- Currency: USD\n- Description: "Purchase 1 credit for API access"\n- Offer ID: offer_c668e0c0\n- Payment Method: Lightning\n- Title: "1 Credit Package"\n- Type: top-up\n\nNow, let\'s use the `pay` function to process this payment. I\'ll use the information you\'ve provided along with the details of the cheapest offer.', type='text'), ToolUseBlock(id='toolu_018nMWXuDMmqLBZVGsscAzAU', input={'purl': 'https://stock.l402.org/l402/payment-request', 'pct': 'edb53dec-28f5-4cbb-924a-20e9003c20e1', 'amount': 1, 'balance': 1, 'currency': 'USD', 'description': 'Purchase 1 credit for API access', 'offer_id': 'offer_c668e0c0', 'payment_methods': ['lightning'], 'title': '1 Credit Package', 'type': 'top-up'}, name='pay', type='tool_use')], model='claude-3-5-sonnet-20240620', role='assistant', stop_reason='tool_use', stop_sequence=None, type='message', usage=In: 959; Out: 426; Cache create: 0; Cache read: 0; Total: 1385)
    Message(id='msg_01Fqheb9pR4YfDVDdKuRLhbC', content=[TextBlock(text='Great! The payment request has been successfully submitted. The response status code 200 OK indicates that the transaction was processed successfully.\n\nTo summarize:\n1. You\'ve purchased the "1 Credit Package" for 1 cent (USD 0.01).\n2. This package provides you with 1 credit for API access.\n3. The payment was made using the Lightning network.\n\nIs there anything else you\'d like to know about this transaction or any other assistance you need?', type='text')], model='claude-3-5-sonnet-20240620', role='assistant', stop_reason='end_turn', stop_sequence=None, type='message', usage=In: 1402; Out: 108; Cache create: 0; Cache read: 0; Total: 1510)

Great! The payment request has been successfully submitted. The response
status code 200 OK indicates that the transaction was processed
successfully.

To summarize: 1. You’ve purchased the “1 Credit Package” for 1 cent (USD
0.01). 2. This package provides you with 1 credit for API access. 3. The
payment was made using the Lightning network.

Is there anything else you’d like to know about this transaction or any
other assistance you need?

<details>

- id: `msg_01Fqheb9pR4YfDVDdKuRLhbC`
- content:
  `[{'text': 'Great! The payment request has been successfully submitted. The response status code 200 OK indicates that the transaction was processed successfully.\n\nTo summarize:\n1. You\'ve purchased the "1 Credit Package" for 1 cent (USD 0.01).\n2. This package provides you with 1 credit for API access.\n3. The payment was made using the Lightning network.\n\nIs there anything else you\'d like to know about this transaction or any other assistance you need?', 'type': 'text'}]`
- model: `claude-3-5-sonnet-20240620`
- role: `assistant`
- stop_reason: `end_turn`
- stop_sequence: `None`
- type: `message`
- usage:
  `{'cache_creation_input_tokens': 0, 'cache_read_input_tokens': 0, 'input_tokens': 1402, 'output_tokens': 108}`

</details>

``` python
fs.balance()
```

    [{'id': 15, 'balance': 9997, 'currency': 'usd'}]
