import abc
from _typeshed import Incomplete
from datetime import datetime
from decimal import Decimal
from gnewcash.commodity import Commodity as Commodity
from gnewcash.enums import AccountType as AccountType
from gnewcash.guid_object import GuidObject as GuidObject
from gnewcash.slot import Slot as Slot, SlottableObject as SlottableObject
from typing import NamedTuple

class LoanStatus(NamedTuple):
    iterator_balance: Incomplete
    iterator_date: Incomplete
    interest: Incomplete
    amount_to_capital: Incomplete

class LoanExtraPayment(NamedTuple):
    payment_date: Incomplete
    payment_amount: Incomplete

class Account(GuidObject, SlottableObject):
    name: Incomplete
    type: Incomplete
    description: Incomplete
    children: Incomplete
    code: Incomplete
    commodity: Incomplete
    commodity_scu: Incomplete
    non_std_scu: Incomplete
    def __init__(self, guid: str | None = None, slots: list[Slot] | None = None, name: str = '', account_type: str | None = None, description: str | None = None, children: list['Account'] | None = None, code: str | None = None, commodity: Commodity | None = None, commodity_scu: str | None = None, non_std_scu: int | None = None) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def as_dict(self, account_hierarchy: dict[str, 'Account'] | None = None, path_to_self: str = '/') -> dict[str, 'Account']: ...
    @property
    def dict_entry_name(self) -> str: ...
    def get_parent_commodity(self) -> Commodity | None: ...
    def get_subaccount_by_id(self, subaccount_id: str) -> Account | None: ...
    @property
    def parent(self) -> Account | None: ...
    @parent.setter
    def parent(self, value: Account) -> None: ...
    @property
    def color(self) -> str: ...
    @color.setter
    def color(self, value: str) -> None: ...
    @property
    def notes(self) -> str: ...
    @notes.setter
    def notes(self, value: str) -> None: ...
    @property
    def hidden(self) -> bool: ...
    @hidden.setter
    def hidden(self, value: bool) -> None: ...
    @property
    def placeholder(self) -> bool: ...
    @placeholder.setter
    def placeholder(self, value: bool) -> None: ...
    def get_account_guids(self, account_guids: list[str] | None = None) -> list[str]: ...

class BankAccount(Account):
    type: Incomplete
    def __init__(self, name: str = '', description: str | None = None, children: list['Account'] | None = None, code: str | None = None, commodity: Commodity | None = None, commodity_scu: str | None = None, non_std_scu: int | None = None) -> None: ...

class IncomeAccount(Account):
    type: Incomplete
    def __init__(self, name: str = '', description: str | None = None, children: list['Account'] | None = None, code: str | None = None, commodity: Commodity | None = None, commodity_scu: str | None = None, non_std_scu: int | None = None) -> None: ...

class AssetAccount(Account):
    type: Incomplete
    def __init__(self, name: str = '', description: str | None = None, children: list['Account'] | None = None, code: str | None = None, commodity: Commodity | None = None, commodity_scu: str | None = None, non_std_scu: int | None = None) -> None: ...

class CreditAccount(Account):
    type: Incomplete
    def __init__(self, name: str = '', description: str | None = None, children: list['Account'] | None = None, code: str | None = None, commodity: Commodity | None = None, commodity_scu: str | None = None, non_std_scu: int | None = None) -> None: ...

class ExpenseAccount(Account):
    type: Incomplete
    def __init__(self, name: str = '', description: str | None = None, children: list['Account'] | None = None, code: str | None = None, commodity: Commodity | None = None, commodity_scu: str | None = None, non_std_scu: int | None = None) -> None: ...

class EquityAccount(Account):
    type: Incomplete
    def __init__(self, name: str = '', description: str | None = None, children: list['Account'] | None = None, code: str | None = None, commodity: Commodity | None = None, commodity_scu: str | None = None, non_std_scu: int | None = None) -> None: ...

class LiabilityAccount(Account):
    type: Incomplete
    def __init__(self, name: str = '', description: str | None = None, children: list['Account'] | None = None, code: str | None = None, commodity: Commodity | None = None, commodity_scu: str | None = None, non_std_scu: int | None = None) -> None: ...

class InterestAccountBase(abc.ABC, metaclass=abc.ABCMeta):
    @property
    @abc.abstractmethod
    def starting_date(self) -> datetime: ...
    @property
    @abc.abstractmethod
    def interest_percentage(self) -> Decimal: ...
    @property
    @abc.abstractmethod
    def payment_amount(self) -> Decimal: ...
    @property
    @abc.abstractmethod
    def starting_balance(self) -> Decimal: ...
    @abc.abstractmethod
    def get_info_at_date(self, date: datetime) -> LoanStatus: ...
    @abc.abstractmethod
    def get_all_payments(self, skip_additional_payments: bool = False) -> list[tuple[datetime, Decimal, Decimal]]: ...

class InterestAccount(InterestAccountBase):
    additional_payments: Incomplete
    skip_payment_dates: Incomplete
    interest_start_date: Incomplete
    def __init__(self, starting_balance: Decimal, starting_date: datetime, interest_percentage: Decimal, payment_amount: Decimal, additional_payments: list[LoanExtraPayment] | None = None, skip_payment_dates: list[datetime] | None = None, interest_start_date: datetime | None = None) -> None: ...
    @property
    def starting_date(self) -> datetime: ...
    @starting_date.setter
    def starting_date(self, new_starting_date: datetime) -> None: ...
    @property
    def interest_percentage(self) -> Decimal: ...
    @interest_percentage.setter
    def interest_percentage(self, new_interest_percentage: Decimal) -> None: ...
    @property
    def payment_amount(self) -> Decimal: ...
    @payment_amount.setter
    def payment_amount(self, new_payment_amount: Decimal) -> None: ...
    @property
    def starting_balance(self) -> Decimal: ...
    @starting_balance.setter
    def starting_balance(self, new_starting_balance: Decimal) -> None: ...
    def get_info_at_date(self, date: datetime) -> LoanStatus: ...
    def get_all_payments(self, skip_additional_payments: bool = False) -> list[tuple[datetime, Decimal, Decimal]]: ...

class InterestAccountWithSubaccounts(InterestAccountBase):
    additional_payments: Incomplete
    skip_payment_dates: Incomplete
    subaccounts: Incomplete
    def __init__(self, subaccounts: list[InterestAccount], additional_payments: list[dict[str, Decimal | datetime]] | None = None, skip_payment_dates: list[datetime] | None = None) -> None: ...
    @property
    def starting_date(self) -> datetime: ...
    @property
    def interest_percentage(self) -> Decimal: ...
    @property
    def payment_amount(self) -> Decimal: ...
    @property
    def starting_balance(self) -> Decimal: ...
    def get_info_at_date(self, date: datetime) -> LoanStatus: ...
    def get_all_payments(self, skip_additional_payments: bool = False) -> list[tuple[datetime, Decimal, Decimal]]: ...
