import enum
import sqlite3
from _typeshed import Incomplete
from gnewcash.account import Account as Account
from gnewcash.commodity import Commodity as Commodity
from gnewcash.file_formats.base import BaseFileFormat as BaseFileFormat, BaseFileReader as BaseFileReader, BaseFileWriter as BaseFileWriter
from gnewcash.gnucash_file import Book as Book, Budget as Budget, GnuCashFile as GnuCashFile
from gnewcash.slot import Slot as Slot
from gnewcash.transaction import ScheduledTransaction as ScheduledTransaction, SortingMethod as SortingMethod, Split as Split, Transaction as Transaction, TransactionManager as TransactionManager
from typing import Any

SQLITE_SLOT_TYPE_MAPPING: Incomplete

class DBAction(enum.Enum):
    INSERT = 1
    UPDATE = 2
    @staticmethod
    def get_db_action(sqlite_cursor: sqlite3.Cursor, table_name: str, column_name: str, row_identifier: Any) -> DBAction: ...

class GnuCashSQLiteReader(BaseFileReader):
    LOGGER: Incomplete
    @classmethod
    def load(cls, *args: Any, source_file: str = '', sort_transactions: bool = True, sort_method: SortingMethod | None = None, **kwargs: Any) -> GnuCashFile: ...
    @classmethod
    def create_books_from_sqlite(cls, sqlite_cursor: sqlite3.Cursor, sort_transactions: bool, sort_method: SortingMethod | None = None) -> list[Book]: ...
    @classmethod
    def create_account_from_sqlite(cls, sqlite_cursor: sqlite3.Cursor, account_id: str) -> Account: ...
    @classmethod
    def create_slots_from_sqlite(cls, sqlite_cursor: sqlite3.Cursor, object_id: str) -> list[Slot]: ...
    @classmethod
    def create_commodity_from_sqlite(cls, sqlite_cursor: sqlite3.Cursor, commodity_guid: str) -> Commodity: ...
    @classmethod
    def create_commodities_from_sqlite(cls, sqlite_cursor: sqlite3.Cursor) -> list[Commodity]: ...
    @classmethod
    def create_transactions_from_sqlite(cls, sqlite_cursor: sqlite3.Cursor, root_account: Account | None, template_root_account: Account | None) -> list[Transaction]: ...
    @classmethod
    def create_scheduled_transactions_from_sqlite(cls, sqlite_cursor: sqlite3.Cursor, template_root_account: Account | None) -> list[ScheduledTransaction]: ...
    @classmethod
    def create_budget_from_sqlite(cls, sqlite_cursor: sqlite3.Cursor) -> list[Budget]: ...
    @classmethod
    def create_splits_from_sqlite(cls, sqlite_cursor: sqlite3.Cursor, transaction_guid: str, root_account: Account | None, template_root_account: Account | None) -> list[Split]: ...
    @classmethod
    def get_sqlite_table_data(cls, sqlite_cursor: sqlite3.Cursor, table_name: str, where_condition: str | None = None, where_parameters: tuple[Any] | None = None) -> list[dict[str, Any]]: ...

class GnuCashSQLiteWriter(BaseFileWriter):
    @classmethod
    def dump(cls, gnucash_file: GnuCashFile, *args: Any, target_file: str = '', **kwargs: Any) -> None: ...
    @classmethod
    def write_book_to_sqlite(cls, book: Book, sqlite_cursor: sqlite3.Cursor) -> None: ...
    @classmethod
    def write_budget_to_sqlite(cls, budget: Budget, sqlite_cursor: sqlite3.Cursor) -> None: ...
    @classmethod
    def write_recurrence_to_sqlite(cls, obj: Budget, sqlite_cursor: sqlite3.Cursor) -> None: ...
    @classmethod
    def write_commodity_to_sqlite(cls, commodity: Commodity, sqlite_cursor: sqlite3.Cursor) -> None: ...
    @classmethod
    def write_slot_to_sqlite(cls, slot: Slot, sqlite_cursor: sqlite3.Cursor, object_guid: str) -> None: ...
    @classmethod
    def write_account_to_sqlite(cls, account: Account, sqlite_cursor: sqlite3.Cursor) -> None: ...
    @classmethod
    def write_transaction_to_sqlite(cls, transaction: Transaction, sqlite_cursor: sqlite3.Cursor) -> None: ...
    @classmethod
    def delete_transaction_from_sqlite(cls, deleted_transaction_guid: str, sqlite_cursor: sqlite3.Cursor) -> None: ...
    @classmethod
    def write_split_to_sqlite(cls, split: Split, sqlite_cursor: sqlite3.Cursor, transaction_guid: str) -> None: ...
    @classmethod
    def write_scheduled_transaction_to_sqlite(cls, scheduled_transaction: ScheduledTransaction, sqlite_cursor: sqlite3.Cursor) -> None: ...
    @classmethod
    def create_sqlite_schema(cls, sqlite_cursor: sqlite3.Cursor) -> None: ...

class SqliteFileFormat(GnuCashSQLiteReader, GnuCashSQLiteWriter, BaseFileFormat): ...
