import pathlib
from _typeshed import Incomplete
from datetime import datetime
from gnewcash.account import Account as Account
from gnewcash.commodity import Commodity as Commodity
from gnewcash.file_formats.base import BaseFileFormat as BaseFileFormat, BaseFileReader as BaseFileReader, BaseFileWriter as BaseFileWriter
from gnewcash.gnucash_file import Book as Book, Budget as Budget, GnuCashFile as GnuCashFile
from gnewcash.slot import Slot as Slot
from gnewcash.transaction import ScheduledTransaction as ScheduledTransaction, SortingMethod as SortingMethod, Split as Split, Transaction as Transaction, TransactionManager as TransactionManager
from gnewcash.utils import safe_iso_date_formatting as safe_iso_date_formatting, safe_iso_date_parsing as safe_iso_date_parsing
from typing import Any
from xml.etree import ElementTree

XML_NAMESPACES: dict[str, str]

class GnuCashXMLReader(BaseFileReader):
    LOGGER: Incomplete
    @classmethod
    def load(cls, *args: Any, source_file: str = '', sort_transactions: bool = True, sort_method: SortingMethod | None = None, **kwargs: Any) -> GnuCashFile: ...
    @classmethod
    def get_xml_root(cls, source_path: pathlib.Path) -> ElementTree.Element: ...
    @classmethod
    def create_book_from_xml(cls, book_node: ElementTree.Element, sort_transactions: bool = True, sort_method: SortingMethod | None = None) -> Book: ...
    @classmethod
    def create_slot_from_xml(cls, slot_node: ElementTree.Element) -> Slot: ...
    @classmethod
    def create_commodity_from_xml(cls, commodity_node: ElementTree.Element) -> Commodity: ...
    @classmethod
    def create_account_from_xml(cls, account_node: ElementTree.Element, account_objects: list[Account]) -> Account: ...
    @classmethod
    def create_transaction_from_xml(cls, transaction_node: ElementTree.Element, account_objects: list[Account]) -> Transaction: ...
    @classmethod
    def create_split_from_xml(cls, split_node: ElementTree.Element, account_objects: list[Account]) -> Split: ...
    @classmethod
    def create_scheduled_transaction_from_xml(cls, xml_obj: ElementTree.Element, template_account_root: Account | None) -> ScheduledTransaction: ...
    @classmethod
    def create_budget_from_xml(cls, budget_node: ElementTree.Element) -> Budget: ...
    @classmethod
    def read_xml_child_text(cls, xml_object: ElementTree.Element, tag_name: str, namespaces: dict[str, str]) -> str | None: ...
    @classmethod
    def read_xml_child_boolean(cls, xml_object: ElementTree.Element, tag_name: str, namespaces: dict[str, str]) -> bool | None: ...
    @classmethod
    def read_xml_child_int(cls, xml_object: ElementTree.Element, tag_name: str, namespaces: dict[str, str]) -> int | None: ...
    @classmethod
    def read_xml_child_date(cls, xml_object: ElementTree.Element, tag_name: str, namespaces: dict[str, str]) -> datetime | None: ...

class GnuCashXMLWriter(BaseFileWriter):
    LOGGER: Incomplete
    @classmethod
    def dump(cls, gnucash_file: GnuCashFile, *args: Any, target_file: str = '', prettify_xml: bool = False, **kwargs: Any) -> None: ...
    @classmethod
    def cast_book_as_xml(cls, book: Book) -> ElementTree.Element: ...
    @classmethod
    def cast_account_as_xml(cls, account: Account) -> list[ElementTree.Element]: ...
    @classmethod
    def cast_slot_as_xml(cls, slot: Slot) -> ElementTree.Element: ...
    @classmethod
    def cast_commodity_as_xml(cls, commodity: Commodity) -> ElementTree.Element: ...
    @classmethod
    def cast_commodity_as_short_xml(cls, commodity: Commodity, node_tag: str) -> ElementTree.Element: ...
    @classmethod
    def cast_transaction_as_xml(cls, transaction: Transaction) -> ElementTree.Element: ...
    @classmethod
    def cast_split_as_xml(cls, split: Split) -> ElementTree.Element: ...
    @classmethod
    def cast_scheduled_transaction_as_xml(cls, scheduled_transaction: ScheduledTransaction) -> ElementTree.Element: ...
    @classmethod
    def cast_budget_as_xml(cls, budget: Budget) -> ElementTree.Element: ...
    @classmethod
    def write_file_contents(cls, target_file: str, file_contents: bytes) -> None: ...

class XMLFileFormat(GnuCashXMLReader, GnuCashXMLWriter, BaseFileFormat): ...

class GZipXMLFileFormat(XMLFileFormat):
    @classmethod
    def get_xml_root(cls, source_path: pathlib.Path) -> ElementTree.Element: ...
    @classmethod
    def write_file_contents(cls, target_file: str, file_contents: bytes) -> None: ...
