import enum
from _typeshed import Incomplete
from datetime import datetime
from decimal import Decimal
from gnewcash.account import Account as Account
from gnewcash.commodity import Commodity as Commodity
from gnewcash.enums import AccountType as AccountType
from gnewcash.guid_object import GuidObject as GuidObject
from gnewcash.slot import Slot as Slot, SlottableObject as SlottableObject
from typing import Generator, Iterator

class TransactionException(Exception): ...

class Transaction(GuidObject, SlottableObject):
    currency: Incomplete
    date_posted: Incomplete
    date_entered: Incomplete
    description: Incomplete
    splits: Incomplete
    memo: Incomplete
    def __init__(self, guid: str | None = None, slots: list[Slot] | None = None, currency: Commodity | None = None, date_posted: datetime | None = None, date_entered: datetime | None = None, description: str = '', splits: list['Split'] | None = None, memo: str | None = None) -> None: ...
    def __lt__(self, other: Transaction) -> bool: ...
    def __eq__(self, other: object) -> bool: ...
    @property
    def cleared(self) -> bool: ...
    def mark_transaction_cleared(self) -> None: ...
    @property
    def notes(self) -> str: ...
    @notes.setter
    def notes(self, value: str) -> None: ...
    @property
    def reversed_by(self) -> str: ...
    @reversed_by.setter
    def reversed_by(self, value: str) -> None: ...
    @property
    def voided(self) -> str: ...
    @voided.setter
    def voided(self, value: str) -> None: ...
    @property
    def void_time(self) -> str: ...
    @void_time.setter
    def void_time(self, value: str) -> None: ...
    @property
    def void_reason(self) -> str: ...
    @void_reason.setter
    def void_reason(self, value: str) -> None: ...
    @property
    def associated_uri(self) -> str: ...
    @associated_uri.setter
    def associated_uri(self, value: str) -> None: ...
    @property
    def from_splits(self) -> Generator['Split', None, None]: ...
    @property
    def to_splits(self) -> Generator['Split', None, None]: ...
    @property
    def split_accounts(self) -> Generator[Account, None, None]: ...
    @property
    def split_account_names(self) -> Generator[str, None, None]: ...
    @property
    def from_split_accounts(self) -> Generator[Account, None, None]: ...
    @property
    def from_split_account_names(self) -> Generator[str, None, None]: ...
    @property
    def to_split_accounts(self) -> Generator[Account, None, None]: ...
    @property
    def to_split_account_names(self) -> Generator[str, None, None]: ...
    @property
    def splits_total(self) -> Decimal: ...

class Split(GuidObject):
    reconciled_state: Incomplete
    amount: Incomplete
    account: Incomplete
    action: Incomplete
    memo: Incomplete
    quantity_denominator: Incomplete
    reconcile_date: Incomplete
    quantity_num: Incomplete
    lot_guid: Incomplete
    value_num: Incomplete
    value_denom: Incomplete
    def __init__(self, account: Account | None, amount: Decimal | None, reconciled_state: str = 'n', guid: str | None = None, action: str | None = None, memo: str | None = None, quantity_denominator: str = '100', reconcile_date: datetime | None = None, quantity_num: int | None = None, lot_guid: str | None = None, value_num: int | None = None, value_denom: int | None = None) -> None: ...

class TransactionManager:
    transactions: Incomplete
    disable_sort: Incomplete
    deleted_transaction_guids: Incomplete
    sort_method: Incomplete
    def __init__(self, transactions: list[Transaction] | None = None, disable_sort: bool = False, sort_method: SortingMethod | None = None) -> None: ...
    def add(self, new_transaction: Transaction) -> None: ...
    def delete(self, transaction: Transaction) -> None: ...
    def get_transactions(self, account: Account | None = None) -> Iterator[Transaction]: ...
    def get_account_starting_balance(self, account: Account) -> Decimal: ...
    def get_account_ending_balance(self, account: Account) -> Decimal: ...
    def minimum_balance_past_date(self, account: Account, date: datetime) -> tuple[Decimal | None, datetime | None]: ...
    def get_balance_at_date(self, account: Account, date: datetime | None = None) -> Decimal: ...
    def get_balance_at_transaction(self, account: Account, transaction: Transaction) -> Decimal: ...
    def get_cleared_balance(self, account: Account) -> Decimal: ...
    def __getitem__(self, item: int) -> Transaction: ...
    def __len__(self) -> int: ...
    def __eq__(self, other: object) -> bool: ...
    def __iter__(self) -> Iterator[Transaction]: ...

class ScheduledTransaction(GuidObject):
    name: Incomplete
    enabled: Incomplete
    auto_create: Incomplete
    auto_create_notify: Incomplete
    advance_create_days: Incomplete
    advance_remind_days: Incomplete
    instance_count: Incomplete
    start_date: Incomplete
    last_date: Incomplete
    end_date: Incomplete
    template_account: Incomplete
    recurrence_multiplier: Incomplete
    recurrence_period: Incomplete
    recurrence_start: Incomplete
    num_occur: Incomplete
    rem_occur: Incomplete
    recurrence_weekend_adjust: Incomplete
    def __init__(self, guid: str | None = None, name: str | None = None, enabled: bool | None = False, auto_create: bool | None = False, auto_create_notify: bool | None = False, advance_create_days: int | None = -1, advance_remind_days: int | None = -1, instance_count: int | None = 0, start_date: datetime | None = None, last_date: datetime | None = None, end_date: datetime | None = None, template_account: Account | None = None, recurrence_multiplier: int | None = 0, recurrence_period: str | None = None, recurrence_start: datetime | None = None, num_occur: int | None = None, rem_occur: int | None = None, recurrence_weekend_adjust: str | None = None) -> None: ...

class SimpleTransaction(Transaction):
    from_split: Incomplete
    to_split: Incomplete
    splits: Incomplete
    def __init__(self, from_account: Account | None = None, to_account: Account | None = None, amount: Decimal | None = None, currency: Commodity | None = None, date_posted: datetime | None = None, date_entered: datetime | None = None, description: str = '', memo: str | None = None) -> None: ...
    @property
    def from_account(self) -> Account | None: ...
    @from_account.setter
    def from_account(self, value: Account) -> None: ...
    @property
    def to_account(self) -> Account | None: ...
    @to_account.setter
    def to_account(self, value: Account) -> None: ...
    @property
    def amount(self) -> Decimal | None: ...
    @amount.setter
    def amount(self, value: Decimal) -> None: ...
    @classmethod
    def from_transaction(cls, other: Transaction) -> SimpleTransaction: ...

class SortingResult(enum.Enum):
    FIRST_GREATER = 1
    SECOND_GREATER = -1
    EQUAL = 0

class SortingMethod:
    reverse: Incomplete
    def __init__(self, reverse: bool = False) -> None: ...
    def compare(self, transaction1: Transaction, transaction2: Transaction) -> SortingResult: ...

class StandardSort(SortingMethod):
    def compare(self, transaction1: Transaction, transaction2: Transaction) -> SortingResult: ...

class InvalidSortFieldException(Exception): ...

class SortBySingleTransactionFieldMethod(SortingMethod):
    sort_field: Incomplete
    def __init__(self, reverse: bool = False) -> None: ...
    def compare(self, transaction1: Transaction, transaction2: Transaction) -> SortingResult: ...

class SortBySingleSplitFieldMethod(SortingMethod):
    sort_field: Incomplete
    def __init__(self, reverse: bool = False) -> None: ...
    def compare(self, transaction1: Transaction, transaction2: Transaction) -> SortingResult: ...

class DateSort(SortBySingleTransactionFieldMethod):
    sort_field: str
    def __init__(self, reverse: bool = False) -> None: ...

class DateOfEntrySort(SortBySingleTransactionFieldMethod):
    sort_field: str
    def __init__(self, reverse: bool = False) -> None: ...

class TransactionNumberSort(SortBySingleTransactionFieldMethod):
    sort_field: str
    def __init__(self, reverse: bool = False) -> None: ...

class DescriptionSort(SortBySingleTransactionFieldMethod):
    sort_field: str
    def __init__(self, reverse: bool = False) -> None: ...

class AmountSort(SortBySingleSplitFieldMethod):
    sort_field: str
    def __init__(self, reverse: bool = False) -> None: ...

class NumberActionSort(SortBySingleSplitFieldMethod):
    sort_field: str
    def __init__(self, reverse: bool = False) -> None: ...

class MemoSort(SortBySingleSplitFieldMethod):
    sort_field: str
    def __init__(self, reverse: bool = False) -> None: ...
