"""
    HW Mux Reservation System

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 2.24.0
    Generated by: https://openapi-generator.tech
"""

import io
import json
import logging
import re
from urllib.parse import urlencode

from hwmux_client.rest import RESTClientObject as RESTClientObjectBase
from hwmux_client.exceptions import (
    ApiException,
    UnauthorizedException,
    ForbiddenException,
    NotFoundException,
    ServiceException,
    ApiValueError,
)
import httpx
import ssl
from urllib3.util.retry import Retry


logger = logging.getLogger(__name__)


class RESTResponse(io.IOBase):
    def __init__(self, resp: httpx.Response, data):
        self.httpx_response = resp
        self.status = resp.status_code
        self.reason = resp.reason_phrase
        self.data = data

    def getheaders(self):
        """Returns a dictionary of the response headers."""
        return self.httpx_response.headers

    def getheader(self, name, default=None):
        """Returns a given response header."""
        return self.httpx_response.headers.get(name, default)


class RESTClientObject(RESTClientObjectBase):
    def __init__(self, configuration):
        super().__init__(configuration)
        self.pool_manager = None
        ssl_context = ssl.create_default_context()

        if configuration.assert_hostname is not None:
            ssl_context.check_hostname = configuration.assert_hostname
        if configuration.ssl_ca_cert is not None:
            ssl_context.load_verify_locations(cafile=configuration.ssl_ca_cert)
        ssl_context.verify_mode = (
            ssl.CERT_REQUIRED if configuration.verify_ssl else ssl.CERT_NONE
        )

        retries = 0
        if configuration.retries is not None:
            retries = configuration.retries
            if isinstance(configuration.retries, Retry):
                retries = configuration.retries.total

        limits = httpx.Limits(
            max_connections=configuration.connection_pool_maxsize or 4,
            max_keepalive_connections=20,
            keepalive_expiry=5.0,
        )

        proxy = None
        if configuration.proxy:
            proxy = httpx.Proxy(
                url=configuration.proxy,
                ssl_context=ssl_context,
                headers=configuration.proxy_headers,
            )

        client_cert = (
            (configuration.cert_file, configuration.key_file)
            if configuration.cert_file and configuration.key_file
            else configuration.cert_file
        )

        transport = httpx.AsyncHTTPTransport(
            verify=ssl_context,
            cert=client_cert,
            limits=limits,
            retries=retries,
            socket_options=configuration.socket_options,
            proxy=proxy,
        )

        self.async_client = httpx.AsyncClient(
            transport=transport,
        )

    async def close(self):
        await self.async_client.aclose()

    @property
    def client_session(self) -> httpx.AsyncClient:
        return self.async_client

    async def request(
        self,
        method,
        url,
        query_params=None,
        headers=None,
        body=None,
        post_params=None,
        _preload_content=True,
        _request_timeout=None,
    ):
        """Perform requests.

        :param method: http request method
        :param url: http request url
        :param query_params: query parameters in the url
        :param headers: http request headers
        :param body: request json body, for `application/json`
        :param post_params: request post parameters,
                            `application/x-www-form-urlencoded`
                            and `multipart/form-data`
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        """
        method = method.upper()
        assert method in ["GET", "HEAD", "DELETE", "POST", "PUT", "PATCH", "OPTIONS"]

        if post_params and body:
            raise ApiValueError(
                "body parameter cannot be used with post_params parameter."
            )

        post_params = post_params or {}
        headers = headers or {}

        timeout = None
        if _request_timeout:
            if isinstance(_request_timeout, (int, float)):  # noqa: E501,F821
                timeout = httpx.Timeout(_request_timeout)
            elif isinstance(_request_timeout, tuple) and len(_request_timeout) == 2:
                timeout = httpx.Timeout(
                    connect=_request_timeout[0], read=_request_timeout[1]
                )

        if "Content-Type" not in headers:
            headers["Content-Type"] = "application/json"

        args = {"method": method, "url": url, "timeout": timeout, "headers": headers}

        if query_params:
            args["url"] += "?" + urlencode(query_params)

        if method in ["POST", "PUT", "PATCH", "OPTIONS", "DELETE"]:
            if re.search("json", headers["Content-Type"], re.IGNORECASE):
                if body is not None:
                    body = json.dumps(body)
                args["data"] = body
            elif (
                headers["Content-Type"] == "application/x-www-form-urlencoded"
            ):  # noqa: E501
                args["data"] = post_params
            elif headers["Content-Type"] == "multipart/form-data":
                # must del headers['Content-Type'], or the correct
                # Content-Type which generated by aiohttp
                del headers["Content-Type"]
                args["data"] = post_params

            # Pass a `bytes` parameter directly in the body to support
            # other content types than Json when `body` argument is provided
            # in serialized form
            elif isinstance(body, bytes):
                args["data"] = body
            else:
                # Cannot generate the request from given parameters
                msg = """Cannot prepare a request message for provided
                                 arguments. Please check that your arguments match
                                 declared content type."""
                raise ApiException(status=0, reason=msg)

        r = await self.async_client.request(**args)

        if _preload_content:
            data = r.read()
            r = RESTResponse(r, data)

            # log response body
            logger.debug("response body: %s", r.data)

        if not 200 <= r.status <= 299:
            if r.status == 401:
                raise UnauthorizedException(http_resp=r)

            if r.status == 403:
                raise ForbiddenException(http_resp=r)

            if r.status == 404:
                raise NotFoundException(http_resp=r)

            if 500 <= r.status <= 599:
                raise ServiceException(http_resp=r)

            raise ApiException(http_resp=r)

        return r
