"""
CBMPy: MiriamIds module
=======================
Constraint Based Modelling in Python (http://pysces.sourceforge.net/cbm)
Copyright (C) 2009-2017 Brett G. Olivier, VU University Amsterdam, Amsterdam, The Netherlands

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>

Author: Brett G. Olivier
Contact email: bgoli@users.sourceforge.net
Last edit: $Author: bgoli $ ($Id: CBXML.py 1137 2012-10-01 15:36:15Z bgoli $)

"""

# created on 130222:1601

miriamids =\
{'2D-PAGE protein': {'data_entry': 'http://2dbase.techfak.uni-bielefeld.de/cgi-bin/2d/2d.cgi?ac=$id',
                     'example': 'P39172',
                     'name': '2D-PAGE protein',
                     'pattern': '^([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9])$" restricted="true',
                     'url': 'http://identifiers.org/2d-page.protein/'},
 '3DMET': {'data_entry': 'http://www.3dmet.dna.affrc.go.jp/cgi/show_data.php?acc=$id',
           'example': 'B00162',
           'name': '3DMET',
           'pattern': '^B\\d{5}$',
           'url': 'http://identifiers.org/3dmet/'},
 'ABS': {'data_entry': 'http://genome.crg.es/datasets/abs2005/entries/$id.html',
         'example': 'A0014',
         'name': 'ABS',
         'pattern': '^A\\d+$',
         'url': 'http://identifiers.org/abs/'},
 'AFTOL': {'data_entry': 'http://wasabi.lutzonilab.net/pub/displayTaxonInfo?aftol_id=$id',
           'example': '959',
           'name': 'AFTOL',
           'pattern': '^\\d+$" restricted="true',
           'url': 'http://identifiers.org/aftol.taxonomy/'},
 'AGD': {'data_entry': 'http://agd.vital-it.ch/Ashbya_gossypii/geneview?gene=$id',
         'example': 'AGR144C',
         'name': 'AGD',
         'pattern': '^AGR\\w+$',
         'url': 'http://identifiers.org/agd/'},
 'APD': {'data_entry': 'http://aps.unmc.edu/AP/database/query_output.php?ID=$id',
         'example': '01001',
         'name': 'APD',
         'pattern': '^\\d{5}$',
         'url': 'http://identifiers.org/apd/'},
 'ASAP': {'data_entry': 'http://asap.ahabs.wisc.edu/asap/feature_info.php?LocationID=WIS&amp;FeatureID=$id',
          'example': 'ABE-0009634',
          'name': 'ASAP',
          'pattern': '^[A-Za-z0-9-]+$" restricted="true',
          'url': 'http://identifiers.org/asap/'},
 'ATCC': {'data_entry': 'http://www.lgcstandards-atcc.org/Products/All/$id.aspx',
          'example': '11303',
          'name': 'ATCC',
          'pattern': '^\\d+$',
          'url': 'http://identifiers.org/atcc/'},
 'Aceview Worm': {'data_entry': 'http://www.ncbi.nlm.nih.gov/IEB/Research/Acembly/av.cgi?db=worm&amp;c=Gene&amp;l=$id',
                  'example': 'aap-1',
                  'name': 'Aceview Worm',
                  'pattern': '^[a-z0-9-]+$',
                  'url': 'http://identifiers.org/aceview.worm/'},
 'Aclame': {'data_entry': 'http://aclame.ulb.ac.be/perl/Aclame/Genomes/mge_view.cgi?view=info&amp;id=$id',
            'example': 'mge:2',
            'name': 'Aclame',
            'pattern': '^mge:\\d+$',
            'url': 'http://identifiers.org/aclame/'},
 'Affymetrix Probeset': {'data_entry': 'https://www.affymetrix.com/LinkServlet?probeset=$id',
                         'example': '243002_at',
                         'name': 'Affymetrix Probeset',
                         'pattern': '\\d{4,}((_[asx])?_at)?" restricted="true',
                         'url': 'http://identifiers.org/affy.probeset/'},
 'Allergome': {'data_entry': 'http://www.allergome.org/script/dettaglio.php?id_molecule=$id',
               'example': '1948',
               'name': 'Allergome',
               'pattern': '^\\d+$" restricted="true',
               'url': 'http://identifiers.org/allergome/'},
 'AmoebaDB': {'data_entry': 'http://amoebadb.org/amoeba/showRecord.do?name=GeneRecordClasses.GeneRecordClass&amp;source_id=$id',
              'example': 'EDI_244000',
              'name': 'AmoebaDB',
              'pattern': '^EDI_\\d+$',
              'url': 'http://identifiers.org/amoebadb/'},
 'Anatomical Therapeutic Chemical': {'data_entry': 'http://www.whocc.no/atc_ddd_index/?code=$id',
                                     'example': 'A10BA02',
                                     'name': 'Anatomical Therapeutic Chemical',
                                     'pattern': '^\\w(\\d+)?(\\w{1,2})?(\\d+)?$',
                                     'url': 'http://identifiers.org/atc/'},
 'Anatomical Therapeutic Chemical Vetinary': {'data_entry': 'http://www.whocc.no/atcvet/atcvet_index/?code=$id',
                                              'example': 'QJ51RV02',
                                              'name': 'Anatomical Therapeutic Chemical Vetinary',
                                              'pattern': '^Q[A-Z0-9]+$',
                                              'url': 'http://identifiers.org/atcvet/'},
 'Animal TFDB Family': {'data_entry': 'http://www.bioguo.org/AnimalTFDB/family.php?fam=$id',
                        'example': 'CUT',
                        'name': 'Animal TFDB Family',
                        'pattern': '^\\w+$',
                        'url': 'http://identifiers.org/atfdb.family/'},
 'AntWeb': {'data_entry': 'http://www.antweb.org/specimen.do?name=$id',
            'example': 'casent0106247',
            'name': 'AntWeb',
            'pattern': '^casent\\d+(\\-D\\d+)?$',
            'url': 'http://identifiers.org/antweb/'},
 'AphidBase Transcript': {'data_entry': 'http://isyip.genouest.org/apps/grs-2.2/grs?reportID=aphidbase_transcript_report&amp;objectID=$id',
                          'example': 'ACYPI000159',
                          'name': 'AphidBase Transcript',
                          'pattern': '^ACYPI\\d{6}(-RA)?$" restricted="true',
                          'url': 'http://identifiers.org/aphidbase.transcript/'},
 'ArachnoServer': {'data_entry': 'http://www.arachnoserver.org/toxincard.html?id=$id',
                   'example': 'AS000060',
                   'name': 'ArachnoServer',
                   'pattern': '^AS\\d{6}$',
                   'url': 'http://identifiers.org/arachnoserver/'},
 'ArrayExpress': {'data_entry': 'http://www.ebi.ac.uk/arrayexpress/experiments/$id',
                  'example': 'E-MEXP-1712',
                  'name': 'ArrayExpress',
                  'pattern': '^[AEP]-\\w{4}-\\d+$',
                  'url': 'http://identifiers.org/arrayexpress/'},
 'ArrayExpress Platform': {'data_entry': 'http://www.ebi.ac.uk/arrayexpress/arrays/$id',
                           'example': 'A-GEOD-50',
                           'name': 'ArrayExpress Platform',
                           'pattern': '^[AEP]-\\w{4}-\\d+$',
                           'url': 'http://identifiers.org/arrayexpress.platform/'},
 'AspGD Locus': {'data_entry': 'http://www.aspergillusgenome.org/cgi-bin/locus.pl?dbid=$id',
                 'example': 'ASPL0000349247',
                 'name': 'AspGD Locus',
                 'pattern': '^[A-Za-z_0-9]+$',
                 'url': 'http://identifiers.org/aspgd.locus/'},
 'AspGD Protein': {'data_entry': 'http://www.aspergillusgenome.org/cgi-bin/protein/proteinPage.pl?dbid=$id',
                   'example': 'ASPL0000349247',
                   'name': 'AspGD Protein',
                   'pattern': '^[A-Za-z_0-9]+$',
                   'url': 'http://identifiers.org/aspgd.protein/'},
 'BDGP EST': {'data_entry': 'http://www.ncbi.nlm.nih.gov/nucest/$id',
              'example': 'EY223054.1',
              'name': 'BDGP EST',
              'pattern': '^\\w+(\\.)?(\\d+)?$" restricted="true',
              'url': 'http://identifiers.org/bdgp.est/'},
 'BDGP insertion DB': {'data_entry': 'http://flypush.imgen.bcm.tmc.edu/pscreen/details.php?line=$id',
                       'example': 'KG09531',
                       'name': 'BDGP insertion DB',
                       'pattern': '^\\w+$',
                       'url': 'http://identifiers.org/bdgp.insertion/'},
 'BIND': {'data_entry': 'http://www.bind.ca/Action?identifier=bindid&amp;idsearch=$id',
          'example': None,
          'name': 'BIND',
          'pattern': '^\\d+$" restricted="true" obsolete="true" replacement="MIR:00000010',
          'url': 'http://identifiers.org/bind/'},
 'BOLD Taxonomy': {'data_entry': 'http://www.boldsystems.org/index.php/Taxbrowser_Taxonpage?taxid=$id',
                   'example': '27267',
                   'name': 'BOLD Taxonomy',
                   'pattern': '^\\d+$',
                   'url': 'http://identifiers.org/bold.taxonomy/'},
 'BRENDA': {'data_entry': 'http://www.brenda-enzymes.org/php/result_flat.php4?ecno=$id',
            'example': '1.1.1.1',
            'name': 'BRENDA',
            'pattern': '^((\\d+\\.-\\.-\\.-)|(\\d+\\.\\d+\\.-\\.-)|(\\d+\\.\\d+\\.\\d+\\.-)|(\\d+\\.\\d+\\.\\d+\\.\\d+))$',
            'url': 'http://identifiers.org/brenda/'},
 'BYKdb': {'data_entry': 'http://bykdb.ibcp.fr/data/html/$id.html',
           'example': 'A0AYT5',
           'name': 'BYKdb',
           'pattern': '^\\w+$',
           'url': 'http://identifiers.org/bykdb/'},
 'BacMap Biography': {'data_entry': 'http://bacmap.wishartlab.com/organisms/$id',
                      'example': '1050',
                      'name': 'BacMap Biography',
                      'pattern': '^\\d+$',
                      'url': 'http://identifiers.org/bacmap.biog/'},
 'BeetleBase': {'data_entry': 'http://beetlebase.org/cgi-bin/gbrowse/BeetleBase3.gff3/?name=$id',
                'example': 'TC010103',
                'name': 'BeetleBase',
                'pattern': '^TC\\d+$',
                'url': 'http://identifiers.org/beetlebase/'},
 'BindingDB': {'data_entry': 'http://www.bindingdb.org/bind/chemsearch/marvin/MolStructure.jsp?monomerid=$id',
               'example': '22360',
               'name': 'BindingDB',
               'pattern': '^\\d+$',
               'url': 'http://identifiers.org/bindingDB/'},
 'BioCatalogue': {'data_entry': 'http://www.biocatalogue.org/services/$id',
                  'example': '614',
                  'name': 'BioCatalogue',
                  'pattern': '^\\d+$',
                  'url': 'http://identifiers.org/biocatalogue.service/'},
 'BioCyc': {'data_entry': 'http://biocyc.org/getid?id=$id',
            'example': 'ECOLI:CYT-D-UBIOX-CPLX',
            'name': 'BioCyc',
            'pattern': '^\\w+\\:[A-Za-z0-9-]+$" restricted="true',
            'url': 'http://identifiers.org/biocyc/'},
 'BioGRID': {'data_entry': 'http://thebiogrid.org/$id',
             'example': '31623',
             'name': 'BioGRID',
             'pattern': '^\\d+$',
             'url': 'http://identifiers.org/biogrid/'},
 'BioModels Database': {'data_entry': 'http://www.ebi.ac.uk/biomodels-main/$id',
                        'example': 'BIOMD0000000048',
                        'name': 'BioModels Database',
                        'pattern': '^((BIOMD|MODEL)\\d{10})|(BMID\\d{12})$',
                        'url': 'http://identifiers.org/biomodels.db/'},
 'BioNumbers': {'data_entry': 'http://www.bionumbers.hms.harvard.edu/bionumber.aspx?s=y&amp;id=$id&amp;ver=1',
                'example': '104674',
                'name': 'BioNumbers',
                'pattern': '^\\d+$',
                'url': 'http://identifiers.org/bionumbers/'},
 'BioPortal': {'data_entry': 'http://bioportal.bioontology.org/ontologies/$id',
               'example': '1046',
               'name': 'BioPortal',
               'pattern': '^\\d+$',
               'url': 'http://identifiers.org/bioportal/'},
 'BioProject': {'data_entry': 'http://trace.ddbj.nig.ac.jp/BPSearch/bioproject?acc=$id',
                'example': 'PRJDB3',
                'name': 'BioProject',
                'pattern': '^PRJDB\\d+$',
                'url': 'http://identifiers.org/bioproject/'},
 'BioSample': {'data_entry': 'http://www.ebi.ac.uk/biosamples/browse.html?keywords=$id',
               'example': 'SAMEG70402',
               'name': 'BioSample',
               'pattern': '^\\w{3}[NE](\\w)?\\d+$',
               'url': 'http://identifiers.org/biosample/'},
 'BioSharing': {'data_entry': 'http://www.biosharing.org/$id',
                'example': 'bsg-000052',
                'name': 'BioSharing',
                'pattern': '^bsg-\\d{6}$',
                'url': 'http://identifiers.org/biosharing/'},
 'BioSystems': {'data_entry': 'http://www.ncbi.nlm.nih.gov/biosystems/$id',
                'example': '001',
                'name': 'BioSystems',
                'pattern': '^\\d+$',
                'url': 'http://identifiers.org/biosystems/'},
 'BitterDB Compound': {'data_entry': 'http://bitterdb.agri.huji.ac.il/bitterdb/compound.php?id=$id',
                       'example': '46',
                       'name': 'BitterDB Compound',
                       'pattern': '^\\d+$',
                       'url': 'http://identifiers.org/bitterdb.cpd/'},
 'BitterDB Receptor': {'data_entry': 'http://bitterdb.agri.huji.ac.il/bitterdb/Receptor.php?id=$id',
                       'example': '1',
                       'name': 'BitterDB Receptor',
                       'pattern': '^\\d+$',
                       'url': 'http://identifiers.org/bitterdb.rec/'},
 'Brenda Tissue Ontology': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=$id',
                            'example': 'BTO:0000146',
                            'name': 'Brenda Tissue Ontology',
                            'pattern': '^BTO:\\d{7}$',
                            'url': 'http://identifiers.org/obo.bto/'},
 'BugBase Expt': {'data_entry': 'http://bugs.sgul.ac.uk/bugsbase/tabs/experiment.php?expt_id=$id&amp;action=view',
                  'example': '288',
                  'name': 'BugBase Expt',
                  'pattern': '^\\d+$" restricted="true',
                  'url': 'http://identifiers.org/bugbase.expt/'},
 'BugBase Protocol': {'data_entry': 'http://bugs.sgul.ac.uk/bugsbase/tabs/protocol.php?protocol_id=$id&amp;amp;action=view',
                      'example': '67',
                      'name': 'BugBase Protocol',
                      'pattern': '^\\d+$" restricted="true',
                      'url': 'http://identifiers.org/bugbase.protocol/'},
 'CABRI': {'data_entry': 'http://www.cabri.org/CABRI/srs-bin/wgetz?-e+-page+EntryPage+[$id]',
           'example': 'dsmz_mutz-id:ACC 291',
           'name': 'CABRI',
           'pattern': '^([A-Za-z]+)?(\\_)?([A-Za-z-]+)\\:([A-Za-z0-9 ]+)$',
           'url': 'http://identifiers.org/cabri/'},
 'CAPS-DB': {'data_entry': 'http://www.bioinsilico.org/cgi-bin/CAPSDB/getCAPScluster?nidcl=$id',
             'example': '434',
             'name': 'CAPS-DB',
             'pattern': '^\\d+$',
             'url': 'http://identifiers.org/caps/'},
 'CAS': {'data_entry': 'http://commonchemistry.org/ChemicalDetail.aspx?ref=$id',
         'example': '50-00-0',
         'name': 'CAS',
         'pattern': '^\\d{1,7}\\-\\d{2}\\-\\d$" restricted="true',
         'url': 'http://identifiers.org/cas/'},
 'CATH domain': {'data_entry': 'http://www.cathdb.info/domain/$id',
                 'example': '1cukA01',
                 'name': 'CATH domain',
                 'pattern': '^\\w+$',
                 'url': 'http://identifiers.org/cath.domain/'},
 'CATH superfamily': {'data_entry': 'http://www.cathdb.info/cathnode/$id',
                      'example': '1.10.10.200',
                      'name': 'CATH superfamily',
                      'pattern': '^\\d+(\\.\\d+(\\.\\d+(\\.\\d+)?)?)?$',
                      'url': 'http://identifiers.org/cath.superfamily/'},
 'CAZy': {'data_entry': 'http://www.cazy.org/$id.html',
          'example': 'GT10',
          'name': 'CAZy',
          'pattern': '^GT\\d+$',
          'url': 'http://identifiers.org/cazy/'},
 'CGSC Strain': {'data_entry': 'http://cgsc.biology.yale.edu/Strain.php?ID=$id',
                 'example': '11042',
                 'name': 'CGSC Strain',
                 'pattern': '^\\d+$',
                 'url': 'http://identifiers.org/cgsc/'},
 'CLDB': {'data_entry': 'http://bioinformatics.istge.it/hypercldb/$id.html',
          'example': 'cl3603',
          'name': 'CLDB',
          'pattern': '^cl\\d+$',
          'url': 'http://identifiers.org/cldb/'},
 'CMR Gene': {'data_entry': 'http://cmr.jcvi.org/cgi-bin/CMR/shared/GenePage.cgi?locus=$id',
              'example': 'NTL15EF2281',
              'name': 'CMR Gene',
              'pattern': '^\\w+(\\_)?\\w+$',
              'url': 'http://identifiers.org/cmr.gene/'},
 'COGs': {'data_entry': 'http://www.ncbi.nlm.nih.gov/COG/grace/wiew.cgi?$id',
          'example': 'COG0001',
          'name': 'COGs',
          'pattern': '^COG\\d+$',
          'url': 'http://identifiers.org/cogs/'},
 'COMBINE specifications': {'data_entry': 'http://co.mbine.org/specifications/$id',
                            'example': 'sbgn.er.level-1.version-1.2',
                            'name': 'COMBINE specifications',
                            'pattern': '^\\w+(\\-|\\.|\\w)*$',
                            'url': 'http://identifiers.org/combine.specifications/'},
 'CSA': {'data_entry': 'http://www.ebi.ac.uk/thornton-srv/databases/cgi-bin/CSA/CSA_Site_Wrapper.pl?pdb=$id',
         'example': '1a05',
         'name': 'CSA',
         'pattern': '^[0-9][A-Za-z0-9]{3}$',
         'url': 'http://identifiers.org/csa/'},
 'CTD Chemical': {'data_entry': 'http://ctdbase.org/detail.go?type=chem&amp;acc=$id',
                  'example': 'D001151',
                  'name': 'CTD Chemical',
                  'pattern': '^D\\d+$',
                  'url': 'http://identifiers.org/ctd.chemical/'},
 'CTD Disease': {'data_entry': 'http://ctdbase.org/detail.go?type=disease&amp;db=MESH&amp;acc=$id',
                 'example': 'D053716',
                 'name': 'CTD Disease',
                 'pattern': '^D\\d+$',
                 'url': 'http://identifiers.org/ctd.disease/'},
 'CTD Gene': {'data_entry': 'http://ctdbase.org/detail.go?type=gene&amp;acc=$id',
              'example': '101',
              'name': 'CTD Gene',
              'pattern': '^\\d+$',
              'url': 'http://identifiers.org/ctd.gene/'},
 'CYGD': {'data_entry': 'http://mips.helmholtz-muenchen.de/genre/proj/yeast/singleGeneReport.html?entry=$id',
          'example': 'YFL039c',
          'name': 'CYGD',
          'pattern': '^\\w{2,3}\\d{2,4}(\\w)?$" restricted="true',
          'url': 'http://identifiers.org/cygd/'},
 'Canadian Drug Product Database': {'data_entry': 'http://webprod3.hc-sc.gc.ca/dpd-bdpp/info.do?lang=eng&amp;code=$id',
                                    'example': '63250',
                                    'name': 'Canadian Drug Product Database',
                                    'pattern': '^\\d+$" restricted="true',
                                    'url': 'http://identifiers.org/cdpd/'},
 'Candida Genome Database': {'data_entry': 'http://www.candidagenome.org/cgi-bin/locus.pl?dbid=$id',
                             'example': 'CAL0003079',
                             'name': 'Candida Genome Database',
                             'pattern': '^CAL\\d{7}$',
                             'url': 'http://identifiers.org/cgd/'},
 'Cell Cycle Ontology': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=$id',
                         'example': 'CCO:P0000023',
                         'name': 'Cell Cycle Ontology',
                         'pattern': '^CCO\\:\\w+$',
                         'url': 'http://identifiers.org/cco/'},
 'Cell Image Library': {'data_entry': 'http://cellimagelibrary.org/images/$id',
                        'example': '24801',
                        'name': 'Cell Image Library',
                        'pattern': '^\\d+$" restricted="true',
                        'url': 'http://identifiers.org/cellimage/'},
 'Cell Type Ontology': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=$id',
                        'example': 'CL:0000232',
                        'name': 'Cell Type Ontology',
                        'pattern': '^CL:\\d{7}$',
                        'url': 'http://identifiers.org/obo.clo/'},
 'ChEBI': {'data_entry': 'http://www.ebi.ac.uk/chebi/searchId.do?chebiId=$id',
           'example': 'CHEBI:36927',
           'name': 'ChEBI',
           'pattern': '^CHEBI:\\d+$',
           'url': 'http://identifiers.org/chebi/'},
 'ChEMBL compound': {'data_entry': 'https://www.ebi.ac.uk/chembldb/index.php/compound/inspect/$id',
                     'example': 'CHEMBL308052',
                     'name': 'ChEMBL compound',
                     'pattern': '^CHEMBL\\d+$',
                     'url': 'http://identifiers.org/chembl.compound/'},
 'ChEMBL target': {'data_entry': 'https://www.ebi.ac.uk/chembldb/index.php/target/inspect/$id',
                   'example': 'CHEMBL3467',
                   'name': 'ChEMBL target',
                   'pattern': '^CHEMBL\\d+$',
                   'url': 'http://identifiers.org/chembl.target/'},
 'CharProt': {'data_entry': 'http://www.jcvi.org/charprotdb/index.cgi/view/$id',
              'example': 'CH_001923',
              'name': 'CharProt',
              'pattern': '^CH_\\d+$',
              'url': 'http://identifiers.org/charprot/'},
 'ChemBank': {'data_entry': 'http://chembank.broadinstitute.org/chemistry/viewMolecule.htm?cbid=$id',
              'example': '1000000',
              'name': 'ChemBank',
              'pattern': '^\\d+$',
              'url': 'http://identifiers.org/chembank/'},
 'ChemDB': {'data_entry': 'http://cdb.ics.uci.edu/cgibin/ChemicalDetailWeb.py?chemical_id=$id',
            'example': '3966782',
            'name': 'ChemDB',
            'pattern': '^\\d+$" restricted="true',
            'url': 'http://identifiers.org/chemdb/'},
 'ChemIDplus': {'data_entry': 'http://chem.sis.nlm.nih.gov/chemidplus/direct.jsp?regno=$id',
                'example': '000057272',
                'name': 'ChemIDplus',
                'pattern': '^\\d+$',
                'url': 'http://identifiers.org/chemidplus/'},
 'ChemSpider': {'data_entry': 'http://www.chemspider.com/Chemical-Structure.$id.html',
                'example': '56586',
                'name': 'ChemSpider',
                'pattern': '^\\d+$',
                'url': 'http://identifiers.org/chemspider/'},
 'Chemical Component Dictionary': {'data_entry': 'http://www.ebi.ac.uk/pdbe-srv/pdbechem/chemicalCompound/show/$id',
                                   'example': 'AB0',
                                   'name': 'Chemical Component Dictionary',
                                   'pattern': '^\\w{3}$',
                                   'url': 'http://identifiers.org/pdb-ccd/'},
 'ClinicalTrials.gov': {'data_entry': 'http://clinicaltrials.gov/ct2/show/$id',
                        'example': 'NCT00222573',
                        'name': 'ClinicalTrials.gov',
                        'pattern': '^NCT\\d{8}$',
                        'url': 'http://identifiers.org/clinicaltrials/'},
 'CluSTr': {'data_entry': 'http://www.ebi.ac.uk/clustr-srv/CCluster?interpro=yes&amp;cluster_varid=$id',
            'example': 'HUMAN:55140:308.6',
            'name': 'CluSTr',
            'pattern': '^[0-9A-Za-z]+:\\d+:\\d{1,5}(\\.\\d)?$" obsolete="true" replacement="',
            'url': 'http://identifiers.org/clustr/'},
 'Compulyeast': {'data_entry': 'http://compluyeast2dpage.dacya.ucm.es/cgi-bin/2d/2d.cgi?ac=$id',
                 'example': 'O08709',
                 'name': 'Compulyeast',
                 'pattern': '^([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9])$',
                 'url': 'http://identifiers.org/compulyeast/'},
 'Conoserver': {'data_entry': 'http://www.conoserver.org/?page=card&amp;table=protein&amp;id=$id',
                'example': '2639',
                'name': 'Conoserver',
                'pattern': '^\\d+$" restricted="true',
                'url': 'http://identifiers.org/conoserver/'},
 'Consensus CDS': {'data_entry': 'http://www.ncbi.nlm.nih.gov/CCDS/CcdsBrowse.cgi?REQUEST=CCDS&amp;amp;DATA=$id',
                   'example': 'CCDS13573.1',
                   'name': 'Consensus CDS',
                   'pattern': '^CCDS\\d+\\.\\d+$',
                   'url': 'http://identifiers.org/ccds/'},
 'Conserved Domain Database': {'data_entry': 'http://www.ncbi.nlm.nih.gov/Structure/cdd/cddsrv.cgi?uid=$id',
                               'example': 'cd00400',
                               'name': 'Conserved Domain Database',
                               'pattern': '^(cd)?\\d{5}$',
                               'url': 'http://identifiers.org/cdd/'},
 'CryptoDB': {'data_entry': 'http://cryptodb.org/cryptodb/showRecord.do?name=GeneRecordClasses.GeneRecordClass&amp;source_id=$id',
              'example': 'cgd7_230',
              'name': 'CryptoDB',
              'pattern': '^\\w+',
              'url': 'http://identifiers.org/cryptodb/'},
 'Cube db': {'data_entry': 'http://epsf.bmad.bii.a-star.edu.sg/cube/db/data/$id/',
             'example': 'AKR',
             'name': 'Cube db',
             'pattern': '^[A-Za-z_0-9]+$" restricted="true',
             'url': 'http://identifiers.org/cubedb/'},
 'CutDB': {'data_entry': 'http://cutdb.burnham.org/relation/show/$id',
           'example': '25782',
           'name': 'CutDB',
           'pattern': '^\\d+$',
           'url': 'http://identifiers.org/pmap.cutdb/'},
 'DARC': {'data_entry': 'http://darcsite.genzentrum.lmu.de/darc/view.php?id=$id',
          'example': '1250',
          'name': 'DARC',
          'pattern': '^\\d+$',
          'url': 'http://identifiers.org/darc/'},
 'DBG2 Introns': {'data_entry': 'http://webapps2.ucalgary.ca/~groupii/cgi-bin/intron.cgi?name=$id',
                  'example': 'Cu.me.I1',
                  'name': 'DBG2 Introns',
                  'pattern': '^\\w{1,2}\\.(\\w{1,2}\\.)?[A-Za-z0-9]+$" restricted="true',
                  'url': 'http://identifiers.org/dbg2introns/'},
 'DOI': {'data_entry': 'http://dx.doi.org/$id',
         'example': '10.1038/nbt1156',
         'name': 'DOI',
         'pattern': '^(doi\\:)?\\d{2}\\.\\d{4}.*$',
         'url': 'http://identifiers.org/doi/'},
 'DOMMINO': {'data_entry': 'http://orion.rnet.missouri.edu/~nz953/DOMMINO/index.php/result/show_network/$id',
             'example': '2GC4',
             'name': 'DOMMINO',
             'pattern': '^[0-9][A-Za-z0-9]{3}$',
             'url': 'http://identifiers.org/dommino/'},
 'DPV': {'data_entry': 'http://www.dpvweb.net/dpv/showdpv.php?dpvno=$id',
         'example': '100',
         'name': 'DPV',
         'pattern': '^\\d+$" restricted="true',
         'url': 'http://identifiers.org/dpv/'},
 'DRSC': {'data_entry': 'http://www.flyrnai.org/cgi-bin/RNAi_gene_lookup_public.pl?gname=$id',
          'example': 'DRSC05221',
          'name': 'DRSC',
          'pattern': '^DRSC\\d+$',
          'url': 'http://identifiers.org/drsc/'},
 'Database of Interacting Proteins': {'data_entry': 'http://dip.doe-mbi.ucla.edu/dip/DIPview.cgi?ID=$id',
                                      'example': 'DIP-743N',
                                      'name': 'Database of Interacting Proteins',
                                      'pattern': '^DIP[\\:\\-]\\d{3}[EN]$',
                                      'url': 'http://identifiers.org/dip/'},
 'Database of Quantitative Cellular Signaling: Model': {'data_entry': 'http://doqcs.ncbs.res.in/template.php?&amp;y=accessiondetails&amp;an=$id',
                                                        'example': '57',
                                                        'name': 'Database of Quantitative Cellular Signaling: Model',
                                                        'pattern': '^\\d+$',
                                                        'url': 'http://identifiers.org/doqcs.model/'},
 'Database of Quantitative Cellular Signaling: Pathway': {'data_entry': 'http://doqcs.ncbs.res.in/template.php?&amp;y=pathwaydetails&amp;pn=$id',
                                                          'example': '131',
                                                          'name': 'Database of Quantitative Cellular Signaling: Pathway',
                                                          'pattern': '^\\d+$',
                                                          'url': 'http://identifiers.org/doqcs.pathway/'},
 'Dictybase EST': {'data_entry': 'http://dictybase.org/db/cgi-bin/feature_page.pl?primary_id=$id',
                   'example': 'DDB0016567',
                   'name': 'Dictybase EST',
                   'pattern': '^DDB\\d+$',
                   'url': 'http://identifiers.org/dictybase.est/'},
 'Dictybase Gene': {'data_entry': 'http://dictybase.org/gene/$id',
                    'example': 'DDB_G0267522',
                    'name': 'Dictybase Gene',
                    'pattern': '^DDB_G\\d+$',
                    'url': 'http://identifiers.org/dictybase.gene/'},
 'DisProt': {'data_entry': 'http://www.disprot.org/protein.php?id=$id',
             'example': 'DP00001',
             'name': 'DisProt',
             'pattern': '^DP\\d{5}$',
             'url': 'http://identifiers.org/disprot/'},
 'DragonDB Allele': {'data_entry': 'http://antirrhinum.net/cgi-bin/ace/generic/tree/DragonDB?name=$id&amp;amp;class=Allele',
                     'example': 'cho',
                     'name': 'DragonDB Allele',
                     'pattern': '^\\w+$" restricted="true',
                     'url': 'http://identifiers.org/dragondb.allele/'},
 'DragonDB DNA': {'data_entry': 'http://antirrhinum.net/cgi-bin/ace/generic/tree/DragonDB?name=$id;class=DNA',
                  'example': '3hB06',
                  'name': 'DragonDB DNA',
                  'pattern': '^\\d\\w+$',
                  'url': 'http://identifiers.org/dragondb.dna/'},
 'DragonDB Locus': {'data_entry': 'http://antirrhinum.net/cgi-bin/ace/generic/tree/DragonDB?name=$id&amp;amp;class=Locus',
                    'example': 'DEF',
                    'name': 'DragonDB Locus',
                    'pattern': '^\\w+$',
                    'url': 'http://identifiers.org/dragondb.locus/'},
 'DragonDB Protein': {'data_entry': 'http://antirrhinum.net/cgi-bin/ace/generic/tree/DragonDB?name=$id;class=Peptide',
                      'example': 'AMDEFA',
                      'name': 'DragonDB Protein',
                      'pattern': '^\\w+$',
                      'url': 'http://identifiers.org/dragondb.protein/'},
 'DrugBank': {'data_entry': 'http://www.drugbank.ca/drugs/$id',
              'example': 'DB00001',
              'name': 'DrugBank',
              'pattern': '^DB\\d{5}$',
              'url': 'http://identifiers.org/drugbank/'},
 'EDAM Ontology': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=$id',
                   'example': 'EDAM_data:1664',
                   'name': 'EDAM Ontology',
                   'pattern': '^EDAM_(data|topic)\\:\\d{4}$',
                   'url': 'http://identifiers.org/edam/'},
 'ELM': {'data_entry': 'http://elm.eu.org/elms/elmPages/$id.html',
         'example': 'CLV_MEL_PAP_1',
         'name': 'ELM',
         'pattern': '^[A-Za-z_0-9]+$',
         'url': 'http://identifiers.org/elm/'},
 'ENA': {'data_entry': 'http://www.ebi.ac.uk/ena/data/view/$id',
         'example': 'BN000065',
         'name': 'ENA',
         'pattern': '^[A-Z]+[0-9]+$',
         'url': 'http://identifiers.org/ena.embl/'},
 'EPD': {'data_entry': 'http://epd.vital-it.ch/cgi-bin/query_result.pl?out_format=NICE&amp;Entry_0=$id',
         'example': 'TA_H3',
         'name': 'EPD',
         'pattern': '^[A-Z-0-9]+$',
         'url': 'http://identifiers.org/epd/'},
 'EchoBASE': {'data_entry': 'http://www.york.ac.uk/res/thomas/Gene.cfm?recordID=$id',
              'example': 'EB0170',
              'name': 'EchoBASE',
              'pattern': '^EB\\d+$',
              'url': 'http://identifiers.org/echobase/'},
 'EcoGene': {'data_entry': 'http://ecogene.org/?q=gene/$id',
             'example': 'EG10173',
             'name': 'EcoGene',
             'pattern': '^EG\\d+$',
             'url': 'http://identifiers.org/ecogene/'},
 'Ensembl': {'data_entry': 'http://www.ensembl.org/id/$id',
             'example': 'ENSG00000139618',
             'name': 'Ensembl',
             'pattern': '^ENS[A-Z]*[FPTG]\\d{11}(\\.\\d+)?$',
             'url': 'http://identifiers.org/ensembl/'},
 'Ensembl Bacteria': {'data_entry': 'http://bacteria.ensembl.org/id/$id',
                      'example': 'EBESCT00000015660',
                      'name': 'Ensembl Bacteria',
                      'pattern': '^EB\\w+$',
                      'url': 'http://identifiers.org/ensembl.bacteria/'},
 'Ensembl Fungi': {'data_entry': 'http://fungi.ensembl.org/id/$id',
                   'example': 'CADAFLAT00006211',
                   'name': 'Ensembl Fungi',
                   'pattern': '^[A-Z-a-z0-9]+$',
                   'url': 'http://identifiers.org/ensembl.fungi/'},
 'Ensembl Metazoa': {'data_entry': 'http://metazoa.ensembl.org/id/$id',
                     'example': 'FBtr0084214',
                     'name': 'Ensembl Metazoa',
                     'pattern': '^\\w+(\\.)?\\d+$',
                     'url': 'http://identifiers.org/ensembl.metazoa/'},
 'Ensembl Plants': {'data_entry': 'http://plants.ensembl.org/id/$id',
                    'example': 'AT1G73965',
                    'name': 'Ensembl Plants',
                    'pattern': '^\\w+(\\.\\d+)?(\\.\\d+)?$',
                    'url': 'http://identifiers.org/ensembl.plant/'},
 'Ensembl Protists': {'data_entry': 'http://protists.ensembl.org/id/$id',
                      'example': 'PFC0120w',
                      'name': 'Ensembl Protists',
                      'pattern': '^\\w+$',
                      'url': 'http://identifiers.org/ensembl.protist/'},
 'Enzyme Nomenclature': {'data_entry': 'http://www.ebi.ac.uk/intenz/query?cmd=SearchEC&amp;ec=$id',
                         'example': '1.1.1.1',
                         'name': 'Enzyme Nomenclature',
                         'pattern': '^\\d+\\.-\\.-\\.-|\\d+\\.\\d+\\.-\\.-|\\d+\\.\\d+\\.\\d+\\.-|\\d+\\.\\d+\\.\\d+\\.(n)?\\d+$',
                         'url': 'http://identifiers.org/ec-code/'},
 'Evidence Code Ontology': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=$id',
                            'example': 'ECO:0000006',
                            'name': 'Evidence Code Ontology',
                            'pattern': 'ECO:\\d{7}$',
                            'url': 'http://identifiers.org/obo.eco/'},
 'Experimental Factor Ontology': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=EFO:$id',
                                  'example': '0004859',
                                  'name': 'Experimental Factor Ontology',
                                  'pattern': '^\\d{7}$',
                                  'url': 'http://identifiers.org/efo/'},
 'FMA': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=$id',
         'example': 'FMA:67112',
         'name': 'FMA',
         'pattern': '^FMA:\\d+$',
         'url': 'http://identifiers.org/obo.fma/'},
 'FlyBase': {'data_entry': 'http://flybase.org/reports/$id.html',
             'example': 'FBgn0011293',
             'name': 'FlyBase',
             'pattern': '^FB\\w{2}\\d{7}$',
             'url': 'http://identifiers.org/flybase/'},
 'Flystock': {'data_entry': 'http://flystocks.bio.indiana.edu/Reports/$id.html',
              'example': '33159',
              'name': 'Flystock',
              'pattern': '^\\d+$',
              'url': 'http://identifiers.org/flystock/'},
 'Fungal Barcode': {'data_entry': 'http://www.fungalbarcoding.org/BioloMICS.aspx?Table=Fungal barcodes&amp;Rec=$id&amp;Fields=All&amp;ExactMatch=T',
                    'example': '2224',
                    'name': 'Fungal Barcode',
                    'pattern': '^\\d+$',
                    'url': 'http://identifiers.org/fbol/'},
 'FungiDB': {'data_entry': 'http://fungidb.org/gene/$id',
             'example': 'CNBG_0001',
             'name': 'FungiDB',
             'pattern': '^[A-Za-z_0-9]+$" restricted="true',
             'url': 'http://identifiers.org/fungidb/'},
 'GABI': {'data_entry': 'http://gabi.rzpd.de/database/cgi-bin/GreenCards.pl.cgi?BioObjectId=$id&amp;Mode=ShowBioObject',
          'example': '2679240',
          'name': 'GABI',
          'pattern': '^\\w+$',
          'url': 'http://identifiers.org/gabi/'},
 'GEO': {'data_entry': 'http://www.ncbi.nlm.nih.gov/sites/GDSbrowser?acc=$id',
         'example': 'GDS1234',
         'name': 'GEO',
         'pattern': '^GDS\\d+$',
         'url': 'http://identifiers.org/geo/'},
 'GOA': {'data_entry': 'http://www.ebi.ac.uk/QuickGO/GProtein?ac=$id',
         'example': 'P12345',
         'name': 'GOA',
         'pattern': '^([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9])$',
         'url': 'http://identifiers.org/goa/'},
 'GOLD genome': {'data_entry': 'http://www.genomesonline.org/cgi-bin/GOLD/GOLDCards.cgi?goldstamp=$id',
                 'example': 'Gi07796',
                 'name': 'GOLD genome',
                 'pattern': '^[Gi|Gc]\\d+$',
                 'url': 'http://identifiers.org/gold.genome/'},
 'GOLD metadata': {'data_entry': 'http://genomesonline.org/cgi-bin/GOLD/bin/GOLDCards.cgi?goldstamp=$id',
                   'example': 'Gm00047',
                   'name': 'GOLD metadata',
                   'pattern': '^Gm\\d+$',
                   'url': 'http://identifiers.org/gold.meta/'},
 'GPCRDB': {'data_entry': 'http://www.gpcr.org/7tm/proteins/$id',
            'example': 'RL3R1_HUMAN',
            'name': 'GPCRDB',
            'pattern': '^\\w+$',
            'url': 'http://identifiers.org/gpcrdb/'},
 'GRIN Plant Taxonomy': {'data_entry': 'http://www.ars-grin.gov/cgi-bin/npgs/html/taxon.pl?$id',
                         'example': '19333',
                         'name': 'GRIN Plant Taxonomy',
                         'pattern': '^\\d+$',
                         'url': 'http://identifiers.org/grin.taxonomy/'},
 'GXA Expt': {'data_entry': 'http://www.ebi.ac.uk/gxa/experiment/$id',
              'example': 'E-MTAB-62',
              'name': 'GXA Expt',
              'pattern': '^[AEP]-\\w{4}-\\d+$" restricted="true',
              'url': 'http://identifiers.org/gxa.expt/'},
 'GXA Gene': {'data_entry': 'http://www.ebi.ac.uk/gxa/gene/$id',
              'example': 'AT4G01080',
              'name': 'GXA Gene',
              'pattern': '^\\w+$',
              'url': 'http://identifiers.org/gxa.gene/'},
 'GenPept': {'data_entry': 'http://www.ncbi.nlm.nih.gov/protein/$id?report=genpept',
             'example': 'CAA71118.1',
             'name': 'GenPept',
             'pattern': '^\\w{3}\\d{5}(\\.\\d+)?$" restricted="true',
             'url': 'http://identifiers.org/genpept/'},
 'Genatlas': {'data_entry': 'http://genatlas.medecine.univ-paris5.fr/fiche.php?symbol=$id',
              'example': 'HBB',
              'name': 'Genatlas',
              'pattern': '^\\w+$',
              'url': 'http://identifiers.org/genatlas/'},
 'Gene Ontology': {'data_entry': 'http://www.ebi.ac.uk/QuickGO/GTerm?id=$id',
                   'example': 'GO:0006915',
                   'name': 'Gene Ontology',
                   'pattern': '^GO:\\d{7}$',
                   'url': 'http://identifiers.org/obo.go/'},
 'GeneCards': {'data_entry': 'http://www.genecards.org/cgi-bin/carddisp.pl?gene=$id',
               'example': 'ABL1',
               'name': 'GeneCards',
               'pattern': '^\\w+$" restricted="true',
               'url': 'http://identifiers.org/genecards/'},
 'GeneDB': {'data_entry': 'http://www.genedb.org/gene/$id',
            'example': 'Cj1536c',
            'name': 'GeneDB',
            'pattern': '^[\\w\\d\\.-]*$',
            'url': 'http://identifiers.org/genedb/'},
 'GeneFarm': {'data_entry': 'http://urgi.versailles.inra.fr/Genefarm/Gene/display_gene.htpl?GENE_ID=$id',
              'example': '4892',
              'name': 'GeneFarm',
              'pattern': '^\\d+$',
              'url': 'http://identifiers.org/genefarm/'},
 'GeneTree': {'data_entry': 'http://www.ensembl.org/Multi/GeneTree/Image?db=core;gt=$id',
              'example': 'ENSGT00550000074763',
              'name': 'GeneTree',
              'pattern': '^ENSGT\\d+$',
              'url': 'http://identifiers.org/genetree/'},
 'GiardiaDB': {'data_entry': 'http://giardiadb.org/giardiadb/showRecord.do?name=GeneRecordClasses.GeneRecordClass&amp;source_id=$id',
               'example': 'GL50803_102438',
               'name': 'GiardiaDB',
               'pattern': '^\\w+$',
               'url': 'http://identifiers.org/giardiadb/'},
 'GlycomeDB': {'data_entry': 'http://www.glycome-db.org/database/showStructure.action?glycomeId=$id',
               'example': '1',
               'name': 'GlycomeDB',
               'pattern': '^\\d+$',
               'url': 'http://identifiers.org/glycomedb/'},
 'Golm Metabolome Database': {'data_entry': 'http://gmd.mpimp-golm.mpg.de/Metabolites/$id.aspx',
                              'example': '68513255-fc44-4041-bc4b-4fd2fae7541d',
                              'name': 'Golm Metabolome Database',
                              'pattern': '^[A-Za-z-0-9-]+$" restricted="true',
                              'url': 'http://identifiers.org/gmd/'},
 'Gramene QTL': {'data_entry': 'http://www.gramene.org/db/qtl/qtl_display?qtl_accession_id=$id',
                 'example': 'CQG5',
                 'name': 'Gramene QTL',
                 'pattern': '^\\w+$',
                 'url': 'http://identifiers.org/gramene.qtl/'},
 'Gramene Taxonomy': {'data_entry': 'http://www.gramene.org/db/ontology/search?id=$id',
                      'example': 'GR_tax:013681',
                      'name': 'Gramene Taxonomy',
                      'pattern': '^GR\\_tax\\:\\d+$',
                      'url': 'http://identifiers.org/gramene.taxonomy/'},
 'Gramene genes': {'data_entry': 'http://www.gramene.org/db/genes/search_gene?acc=$id',
                   'example': 'GR:0080039',
                   'name': 'Gramene genes',
                   'pattern': '^GR\\:\\d+$',
                   'url': 'http://identifiers.org/gramene.gene/'},
 'Gramene protein': {'data_entry': 'http://www.gramene.org/db/protein/protein_search?protein_id=$id',
                     'example': '78073',
                     'name': 'Gramene protein',
                     'pattern': '^\\d+$',
                     'url': 'http://identifiers.org/gramene.protein/'},
 'GreenGenes': {'data_entry': 'http://greengenes.lbl.gov/cgi-bin/show_one_record_v2.pl?prokMSA_id=$id',
                'example': '100000',
                'name': 'GreenGenes',
                'pattern': '^\\d+$',
                'url': 'http://identifiers.org/greengenes/'},
 'H-InvDb Locus': {'data_entry': 'http://h-invitational.jp/hinv/spsoup/locus_view?hix_id=$id',
                   'example': 'HIX0004394',
                   'name': 'H-InvDb Locus',
                   'pattern': '^HIX\\d{7}(\\.\\d+)?$',
                   'url': 'http://identifiers.org/hinv.locus/'},
 'H-InvDb Protein': {'data_entry': 'http://h-invitational.jp/hinv/protein/protein_view.cgi?hip_id=$id',
                     'example': 'HIP000030660',
                     'name': 'H-InvDb Protein',
                     'pattern': '^HIP\\d{9}(\\.\\d+)?$',
                     'url': 'http://identifiers.org/hinv.protein/'},
 'H-InvDb Transcript': {'data_entry': 'http://h-invitational.jp/hinv/spsoup/transcript_view?hit_id=$id',
                        'example': 'HIT000195363',
                        'name': 'H-InvDb Transcript',
                        'pattern': '^HIT\\d{9}(\\.\\d+)?$',
                        'url': 'http://identifiers.org/hinv.transcript/'},
 'HAMAP': {'data_entry': 'http://hamap.expasy.org/unirule/$id',
           'example': 'MF_01400',
           'name': 'HAMAP',
           'pattern': '^MF_\\d+$',
           'url': 'http://identifiers.org/hamap/'},
 'HCVDB': {'data_entry': 'http://euhcvdb.ibcp.fr/euHCVdb/do/displayHCVEntry?primaryAC=$id',
           'example': 'M58335',
           'name': 'HCVDB',
           'pattern': '^M\\d{5}$',
           'url': 'http://identifiers.org/hcvdb/'},
 'HGMD': {'data_entry': 'http://www.hgmd.cf.ac.uk/ac/gene.php?gene=$id',
          'example': 'CALM1',
          'name': 'HGMD',
          'pattern': '^[A-Z_0-9]+$" restricted="true',
          'url': 'http://identifiers.org/hgmd/'},
 'HGNC': {'data_entry': 'http://www.genenames.org/data/hgnc_data.php?hgnc_id=$id',
          'example': 'HGNC:2674',
          'name': 'HGNC',
          'pattern': '^(HGNC:)?\\d{1,5}$',
          'url': 'http://identifiers.org/hgnc/'},
 'HGNC Symbol': {'data_entry': 'http://www.genenames.org/data/hgnc_data.php?match=$id',
                 'example': 'DAPK1',
                 'name': 'HGNC Symbol',
                 'pattern': '^[A-Za-z0-9]+" restricted="true',
                 'url': 'http://identifiers.org/hgnc.symbol/'},
 'HMDB': {'data_entry': 'http://www.hmdb.ca/metabolites/$id',
          'example': 'HMDB00001',
          'name': 'HMDB',
          'pattern': '^HMDB\\d{5}$',
          'url': 'http://identifiers.org/hmdb/'},
 'HOGENOM': {'data_entry': 'http://pbil.univ-lyon1.fr/cgi-bin/view-tree.pl?db=HOGENOM5&amp;query=$id',
             'example': 'HBG284870',
             'name': 'HOGENOM',
             'pattern': '^\\w+$',
             'url': 'http://identifiers.org/hogenom/'},
 'HOMD Sequence Metainformation': {'data_entry': 'http://www.homd.org/modules.php?op=modload&amp;name=GenomeList&amp;file=index&amp;link=detailinfo&amp;seqid=$id',
                                   'example': 'SEQF1003',
                                   'name': 'HOMD Sequence Metainformation',
                                   'pattern': '^SEQF\\d+$',
                                   'url': 'http://identifiers.org/homd.seq/'},
 'HOMD Taxonomy': {'data_entry': 'http://www.homd.org/modules.php?op=modload&amp;name=HOMD&amp;file=index&amp;oraltaxonid=$id&amp;view=dynamic',
                   'example': '811',
                   'name': 'HOMD Taxonomy',
                   'pattern': '^\\d+$',
                   'url': 'http://identifiers.org/homd.taxon/'},
 'HOVERGEN': {'data_entry': 'http://pbil.univ-lyon1.fr/cgi-bin/view-tree.pl?query=$id&amp;db=HOVERGEN',
              'example': 'HBG004341',
              'name': 'HOVERGEN',
              'pattern': '^HBG\\d+$',
              'url': 'http://identifiers.org/hovergen/'},
 'HPA': {'data_entry': 'http://www.proteinatlas.org/$id',
         'example': 'ENSG00000026508',
         'name': 'HPA',
         'pattern': '^ENSG\\d{11}$" restricted="true',
         'url': 'http://identifiers.org/hpa/'},
 'HPRD': {'data_entry': 'http://www.hprd.org/protein/$id',
          'example': '00001',
          'name': 'HPRD',
          'pattern': '^\\d+$" restricted="true',
          'url': 'http://identifiers.org/hprd/'},
 'HSSP': {'data_entry': 'ftp://ftp.embl-heidelberg.de/pub/databases/protein_extras/hssp/$id.hssp.bz2',
          'example': '102l',
          'name': 'HSSP',
          'pattern': '^\\w{4}$',
          'url': 'http://identifiers.org/hssp/'},
 'HUGE': {'data_entry': 'http://www.kazusa.or.jp/huge/gfpage/$id/',
          'example': 'KIAA0001',
          'name': 'HUGE',
          'pattern': '^KIAA\\d{4}$" restricted="true',
          'url': 'http://identifiers.org/huge/'},
 'HomoloGene': {'data_entry': 'http://www.ncbi.nlm.nih.gov/homologene/$id',
                'example': '1000',
                'name': 'HomoloGene',
                'pattern': '^\\d+$',
                'url': 'http://identifiers.org/homologene/'},
 'Human Disease Ontology': {'data_entry': 'http://bioportal.bioontology.org/ontologies/1009/?p=terms&amp;conceptid=$id',
                            'example': 'DOID:11337',
                            'name': 'Human Disease Ontology',
                            'pattern': '^DOID\\:\\d+$',
                            'url': 'http://identifiers.org/obo.do/'},
 'ICD': {'data_entry': 'http://apps.who.int/classifications/icd10/browse/2010/en#/$id',
         'example': 'C34',
         'name': 'ICD',
         'pattern': '^[A-Z]\\d+(\\.[-\\d+])?$',
         'url': 'http://identifiers.org/icd/'},
 'IDEAL': {'data_entry': 'http://idp1.force.cs.is.nagoya-u.ac.jp/IDEAL/idealItem.php?id=$id',
           'example': 'IID00001',
           'name': 'IDEAL',
           'pattern': '^IID\\d+$',
           'url': 'http://identifiers.org/ideal/'},
 'IMEx': {'data_entry': 'http://www.ebi.ac.uk/intact/imex/main.xhtml?query=$id',
          'example': 'IM-12080-80',
          'name': 'IMEx',
          'pattern': '^IM-\\d+(-?)(\\d+?)$',
          'url': 'http://identifiers.org/imex/'},
 'IMGT HLA': {'data_entry': 'http://www.ebi.ac.uk/cgi-bin/imgt/hla/get_allele.cgi?$id',
              'example': 'A*01:01:01:01',
              'name': 'IMGT HLA',
              'pattern': '^[A-Z0-9*:]+$',
              'url': 'http://identifiers.org/imgt.hla/'},
 'IMGT LIGM': {'data_entry': 'http://srs.ebi.ac.uk/srsbin/cgi-bin/wgetz?-id+1fmSL1g8Xvs+-e+[IMGTLIGM:&apos;$id&apos;]',
               'example': 'M94112',
               'name': 'IMGT LIGM',
               'pattern': '^M\\d+$" restricted="true',
               'url': 'http://identifiers.org/imgt.ligm/'},
 'IPI': {'data_entry': 'http://www.ebi.ac.uk/Tools/dbfetch/dbfetch?db=ipi&amp;id=$id&amp;format=default&amp;style=html',
         'example': 'IPI00000001',
         'name': 'IPI',
         'pattern': '^IPI\\d{8}$',
         'url': 'http://identifiers.org/ipi/'},
 'IRD Segment Sequence': {'data_entry': 'http://www.fludb.org/brc/fluSegmentDetails.do?ncbiGenomicAccession=$id',
                          'example': 'CY077097',
                          'name': 'IRD Segment Sequence',
                          'pattern': '^\\w+(\\_)?\\d+(\\.\\d+)?$',
                          'url': 'http://identifiers.org/ird.segment/'},
 'ISBN': {'data_entry': 'http://isbndb.com/search-all.html?kw=$id',
          'example': '9781584885658',
          'name': 'ISBN',
          'pattern': '^(ISBN)?(-13|-10)?[:]?[ ]?(\\d{2,3}[ -]?)?\\d{1,5}[ -]?\\d{1,7}[ -]?\\d{1,6}[ -]?(\\d|X)$',
          'url': 'http://identifiers.org/isbn/'},
 'ISFinder': {'data_entry': 'http://www-is.biotoul.fr/index.html?is_special_name=$id',
              'example': 'ISA1083-2',
              'name': 'ISFinder',
              'pattern': '^IS\\w+(\\-\\d)?$',
              'url': 'http://identifiers.org/isfinder/'},
 'ISSN': {'data_entry': 'http://catalog.loc.gov/cgi-bin/Pwebrecon.cgi?Search_Arg=0745-4570$id&amp;PID=le0kCQllk84KcxI3gMhUTowLMnn9H',
          'example': '0745-4570',
          'name': 'ISSN',
          'pattern': '^\\d{4}\\-\\d{4}$" restricted="true',
          'url': 'http://identifiers.org/issn/'},
 'IUPHAR family': {'data_entry': 'http://www.iuphar-db.org/DATABASE/FamilyMenuForward?familyId=$id',
                   'example': '78',
                   'name': 'IUPHAR family',
                   'pattern': '^\\d+$" restricted="true',
                   'url': 'http://identifiers.org/iuphar.family/'},
 'IUPHAR receptor': {'data_entry': 'http://www.iuphar-db.org/DATABASE/ObjectDisplayForward?objectId=$id',
                     'example': '101',
                     'name': 'IUPHAR receptor',
                     'pattern': '^\\d+$" restricted="true',
                     'url': 'http://identifiers.org/iuphar.receptor/'},
 'InChI': {'data_entry': 'http://rdf.openmolecules.net/?$id',
           'example': 'InChI=1S/C2H6O/c1-2-3/h3H,2H2,1H3',
           'name': 'InChI',
           'pattern': '^InChI\\=1S\\/[A-Za-z0-9]+(\\/[cnpqbtmsih][A-Za-z0-9\\-\\+\\(\\)\\,]+)+$" restricted="true',
           'url': 'http://identifiers.org/inchi/'},
 'InChIKey': {'data_entry': 'http://www.chemspider.com/inchi-resolver/Resolver.aspx?q=$id',
              'example': 'RYYVLZVUVIJVGH-UHFFFAOYSA-N',
              'name': 'InChIKey',
              'pattern': '^[A-Z]{14}\\-[A-Z]{10}(\\-[A-N])?" restricted="true',
              'url': 'http://identifiers.org/inchikey/'},
 'IntAct': {'data_entry': 'http://www.ebi.ac.uk/intact/pages/details/details.xhtml?interactionAc=$id',
            'example': 'EBI-2307691',
            'name': 'IntAct',
            'pattern': '^EBI\\-[0-9]+$',
            'url': 'http://identifiers.org/intact/'},
 'Integrated Microbial Genomes Gene': {'data_entry': 'http://img.jgi.doe.gov/cgi-bin/w/main.cgi?section=GeneDetail&amp;gene_oid=$id',
                                       'example': '638309541',
                                       'name': 'Integrated Microbial Genomes Gene',
                                       'pattern': '^\\d+$',
                                       'url': 'http://identifiers.org/img.gene/'},
 'Integrated Microbial Genomes Taxon': {'data_entry': 'http://img.jgi.doe.gov/cgi-bin/w/main.cgi?section=TaxonDetail&amp;taxon_oid=$id',
                                        'example': '648028003',
                                        'name': 'Integrated Microbial Genomes Taxon',
                                        'pattern': '^\\d+$',
                                        'url': 'http://identifiers.org/img.taxon/'},
 'InterPro': {'data_entry': 'http://www.ebi.ac.uk/interpro/DisplayIproEntry?ac=$id',
              'example': 'IPR000100',
              'name': 'InterPro',
              'pattern': '^IPR\\d{6}$',
              'url': 'http://identifiers.org/interpro/'},
 'JAX Mice': {'data_entry': 'http://jaxmice.jax.org/strain/$id.html',
              'example': '005012',
              'name': 'JAX Mice',
              'pattern': '^\\d+$" restricted="true',
              'url': 'http://identifiers.org/jaxmice/'},
 'JWS Online': {'data_entry': 'http://jjj.biochem.sun.ac.za/cgi-bin/processModelSelection.py?keytype=modelname&amp;keyword=$id',
                'example': 'curien',
                'name': 'JWS Online',
                'pattern': '^\\w+$',
                'url': 'http://identifiers.org/jws/'},
 'Japan Chemical Substance Dictionary': {'data_entry': 'http://nikkajiweb.jst.go.jp/nikkaji_web/pages/top_e.jsp?CONTENT=syosai&amp;SN=$id',
                                         'example': 'J55.713G',
                                         'name': 'Japan Chemical Substance Dictionary',
                                         'pattern': '^J\\d{1,3}(\\.\\d{3})?(\\.\\d{1,3})?[A-Za-z]$',
                                         'url': 'http://identifiers.org/jcsd/'},
 'Japan Collection of Microorganisms': {'data_entry': 'http://www.jcm.riken.go.jp/cgi-bin/jcm/jcm_number?JCM=$id',
                                        'example': '17254',
                                        'name': 'Japan Collection of Microorganisms',
                                        'pattern': '^\\d+$',
                                        'url': 'http://identifiers.org/jcm/'},
 'KEGG Compound': {'data_entry': 'http://www.genome.jp/dbget-bin/www_bget?cpd:$id',
                   'example': 'C12345',
                   'name': 'KEGG Compound',
                   'pattern': '^C\\d+$',
                   'url': 'http://identifiers.org/kegg.compound/'},
 'KEGG Drug': {'data_entry': 'http://www.genome.jp/dbget-bin/www_bget?dr:$id',
               'example': 'D00123',
               'name': 'KEGG Drug',
               'pattern': '^D\\d+$',
               'url': 'http://identifiers.org/kegg.drug/'},
 'KEGG Environ': {'data_entry': 'http://www.genome.jp/dbget-bin/www_bget?$id',
                  'example': 'ev:E00032',
                  'name': 'KEGG Environ',
                  'pattern': '^ev\\:E\\d+$',
                  'url': 'http://identifiers.org/kegg.environ/'},
 'KEGG Genes': {'data_entry': 'http://www.genome.jp/dbget-bin/www_bget?$id',
                'example': 'syn:ssr3451',
                'name': 'KEGG Genes',
                'pattern': '^\\w+:[\\w\\d\\.-]*$',
                'url': 'http://identifiers.org/kegg.genes/'},
 'KEGG Genome': {'data_entry': 'http://www.genome.jp/kegg-bin/show_organism?org=$id',
                 'example': 'eco',
                 'name': 'KEGG Genome',
                 'pattern': '^(T0\\d+|\\w{3,5})$',
                 'url': 'http://identifiers.org/kegg.genome/'},
 'KEGG Glycan': {'data_entry': 'http://www.genome.jp/dbget-bin/www_bget?gl:$id',
                 'example': 'G00123',
                 'name': 'KEGG Glycan',
                 'pattern': '^G\\d+$',
                 'url': 'http://identifiers.org/kegg.glycan/'},
 'KEGG Metagenome': {'data_entry': 'http://www.genome.jp/kegg-bin/show_organism?org=$id',
                     'example': 'T30002',
                     'name': 'KEGG Metagenome',
                     'pattern': '^T3\\d+$',
                     'url': 'http://identifiers.org/kegg.metagenome/'},
 'KEGG Orthology': {'data_entry': 'http://www.genome.jp/dbget-bin/www_bget?ko+$id',
                    'example': 'K00001',
                    'name': 'KEGG Orthology',
                    'pattern': '^K\\d+$',
                    'url': 'http://identifiers.org/kegg.orthology/'},
 'KEGG Pathway': {'data_entry': 'http://www.genome.jp/dbget-bin/www_bget?pathway+$id',
                  'example': 'hsa00620',
                  'name': 'KEGG Pathway',
                  'pattern': '^\\w{2,4}\\d{5}$',
                  'url': 'http://identifiers.org/kegg.pathway/'},
 'KEGG Reaction': {'data_entry': 'http://www.genome.jp/dbget-bin/www_bget?rn:$id',
                   'example': 'R00100',
                   'name': 'KEGG Reaction',
                   'pattern': '^R\\d+$',
                   'url': 'http://identifiers.org/kegg.reaction/'},
 'KiSAO': {'data_entry': 'http://bioportal.bioontology.org/ontologies/1410?p=terms&amp;conceptid=kisao:$id',
           'example': 'KISAO_0000057',
           'name': 'KiSAO',
           'pattern': '^KISAO_\\d+$',
           'url': 'http://identifiers.org/biomodels.kisao/'},
 'KnapSack': {'data_entry': 'http://kanaya.naist.jp/knapsack_jsp/information.jsp?word=$id',
              'example': 'C00000001',
              'name': 'KnapSack',
              'pattern': '^C\\d{8}',
              'url': 'http://identifiers.org/knapsack/'},
 'LIPID MAPS': {'data_entry': 'http://www.lipidmaps.org/data/get_lm_lipids_dbgif.php?LM_ID=$id',
                'example': 'LMPR0102010012',
                'name': 'LIPID MAPS',
                'pattern': '^LM(FA|GL|GP|SP|ST|PR|SL|PK)[0-9]{4}([0-9a-zA-Z]{4,6})?$',
                'url': 'http://identifiers.org/lipidmaps/'},
 'Ligand Expo': {'data_entry': 'http://ligand-depot.rutgers.edu/pyapps/ldHandler.py?formid=cc-index-search&amp;target=$id&amp;operation=ccid',
                 'example': 'ABC',
                 'name': 'Ligand Expo',
                 'pattern': '^(\\w){3}$',
                 'url': 'http://identifiers.org/ligandexpo/'},
 'Ligand-Gated Ion Channel database': {'data_entry': 'http://www.ebi.ac.uk/compneur-srv/LGICdb/HTML/$id.php',
                                       'example': '5HT3Arano',
                                       'name': 'Ligand-Gated Ion Channel database',
                                       'pattern': '^\\w+$',
                                       'url': 'http://identifiers.org/lgic/'},
 'LipidBank': {'data_entry': 'http://lipidbank.jp/cgi-bin/detail.cgi?id=$id',
               'example': 'BBA0001',
               'name': 'LipidBank',
               'pattern': '^\\w+\\d+$',
               'url': 'http://identifiers.org/lipidbank/'},
 'Locus Reference Genomic': {'data_entry': 'ftp://ftp.ebi.ac.uk/pub/databases/lrgex/$id.xml',
                             'example': 'LRG_1',
                             'name': 'Locus Reference Genomic',
                             'pattern': '^LRG_\\d+$',
                             'url': 'http://identifiers.org/lrg/'},
 'MACiE': {'data_entry': 'http://www.ebi.ac.uk/thornton-srv/databases/cgi-bin/MACiE/entry/getPage.pl?id=$id',
           'example': 'M0001',
           'name': 'MACiE',
           'pattern': '^M\\d{4}$',
           'url': 'http://identifiers.org/macie/'},
 'MEROPS': {'data_entry': 'http://merops.sanger.ac.uk/cgi-bin/pepsum?mid=$id',
            'example': 'S01.001',
            'name': 'MEROPS',
            'pattern': '^S\\d{2}\\.\\d{3}$',
            'url': 'http://identifiers.org/merops/'},
 'MEROPS Family': {'data_entry': 'http://merops.sanger.ac.uk/cgi-bin/famsum?family=$id',
                   'example': 'S1',
                   'name': 'MEROPS Family',
                   'pattern': '^\\w+\\d+$',
                   'url': 'http://identifiers.org/merops.family/'},
 'METLIN': {'data_entry': 'http://metlin.scripps.edu/metabo_info.php?molid=$id',
            'example': '1455',
            'name': 'METLIN',
            'pattern': '^\\d{4}$" restricted="true',
            'url': 'http://identifiers.org/metlin/'},
 'MGED Ontology': {'data_entry': 'http://purl.bioontology.org/ontology/MO/$id',
                   'example': 'ArrayGroup',
                   'name': 'MGED Ontology',
                   'pattern': '^\\w+$',
                   'url': 'http://identifiers.org/mo/'},
 'MINT': {'data_entry': 'http://mint.bio.uniroma2.it/mint/search/inFrameInteraction.do?interactionAc=$id',
          'example': 'MINT-10000',
          'name': 'MINT',
          'pattern': '^MINT\\-\\d{1,5}$',
          'url': 'http://identifiers.org/mint/'},
 'MIPModDB': {'data_entry': 'http://bioinfo.iitk.ac.in/MIPModDB/result.php?code=$id',
              'example': 'HOSAPI0399',
              'name': 'MIPModDB',
              'pattern': '^\\w+$',
              'url': 'http://identifiers.org/mipmod/'},
 'MIRIAM Registry collection': {'data_entry': 'http://www.ebi.ac.uk/miriam/main/$id',
                                'example': 'MIR:00000008',
                                'name': 'MIRIAM Registry collection',
                                'pattern': '^MIR:000\\d{5}$',
                                'url': 'http://identifiers.org/miriam.collection/'},
 'MIRIAM Registry resource': {'data_entry': 'http://www.ebi.ac.uk/miriam/main/resources/$id',
                              'example': 'MIR:00100005',
                              'name': 'MIRIAM Registry resource',
                              'pattern': '^MIR:001\\d{5}$',
                              'url': 'http://identifiers.org/miriam.resource/'},
 'MMRRC': {'data_entry': 'http://www.mmrrc.org/catalog/getSDS.php?mmrrc_id=$id',
           'example': '70',
           'name': 'MMRRC',
           'pattern': '^\\d+$" restricted="true',
           'url': 'http://identifiers.org/mmrrc/'},
 'MaizeGDB Locus': {'data_entry': 'http://www.maizegdb.org/cgi-bin/displaylocusrecord.cgi?id=$id',
                    'example': '25011',
                    'name': 'MaizeGDB Locus',
                    'pattern': '^\\d+$',
                    'url': 'http://identifiers.org/maizegdb.locus/'},
 'MassBank': {'data_entry': 'http://msbi.ipb-halle.de/MassBank/jsp/Dispatcher.jsp?type=disp&amp;id=$id',
              'example': 'PB000166',
              'name': 'MassBank',
              'pattern': '^[A-Z]{2}[A-Z0-9][0-9]{5}$" restricted="true',
              'url': 'http://identifiers.org/massbank/'},
 'MatrixDB': {'data_entry': 'http://matrixdb.ibcp.fr/cgi-bin/model/report/default?name=$id&amp;class=Association',
              'example': 'P00747_P07355',
              'name': 'MatrixDB',
              'pattern': '^([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])_.*|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9]_.*)|(GAG_.*)|(MULT_.*)|(PFRAG_.*)|(LIP_.*)|(CAT_.*)$',
              'url': 'http://identifiers.org/matrixdb.association/'},
 'MeSH': {'data_entry': 'http://www.nlm.nih.gov/cgi/mesh/2012/MB_cgi?mode=&amp;index=$id&amp;view=expanded',
          'example': '17186',
          'name': 'MeSH',
          'pattern': '^[A-Za-z0-9]+$" restricted="true',
          'url': 'http://identifiers.org/mesh/'},
 'Melanoma Molecular Map Project Biomaps': {'data_entry': 'http://www.mmmp.org/MMMP/public/biomap/viewBiomap.mmmp?id=$id',
                                            'example': '37',
                                            'name': 'Melanoma Molecular Map Project Biomaps',
                                            'pattern': '^\\d+$',
                                            'url': 'http://identifiers.org/biomaps/'},
 'MetaboLights': {'data_entry': 'http://www.ebi.ac.uk/metabolights/$id',
                  'example': 'MTBLS1',
                  'name': 'MetaboLights',
                  'pattern': '^MTBLS\\d+$',
                  'url': 'http://identifiers.org/metabolights/'},
 'Microbial Protein Interaction Database': {'data_entry': 'http://www.jcvi.org/mpidb/experiment.php?interaction_id=$id',
                                            'example': '172',
                                            'name': 'Microbial Protein Interaction Database',
                                            'pattern': '^\\d+$',
                                            'url': 'http://identifiers.org/mpid/'},
 'MicrosporidiaDB': {'data_entry': 'http://microsporidiadb.org/micro/showRecord.do?name=GeneRecordClasses.GeneRecordClass&amp;source_id=$id',
                     'example': 'ECU03_0820i',
                     'name': 'MicrosporidiaDB',
                     'pattern': '^\\w+$',
                     'url': 'http://identifiers.org/microsporidia/'},
 'MimoDB': {'data_entry': 'http://immunet.cn/mimodb/browse.php?table=mimoset&amp;ID=$id',
            'example': '1',
            'name': 'MimoDB',
            'pattern': '^\\d+$',
            'url': 'http://identifiers.org/mimodb/'},
 'ModelDB': {'data_entry': 'http://senselab.med.yale.edu/ModelDB/ShowModel.asp?model=$id',
             'example': '45539',
             'name': 'ModelDB',
             'pattern': '^\\d+$',
             'url': 'http://identifiers.org/modeldb/'},
 'Molecular Interactions Ontology': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=$id',
                                     'example': 'MI:0308',
                                     'name': 'Molecular Interactions Ontology',
                                     'pattern': '^MI:\\d{4}$',
                                     'url': 'http://identifiers.org/obo.mi/'},
 'Molecular Modeling Database': {'data_entry': 'http://www.ncbi.nlm.nih.gov/Structure/mmdb/mmdbsrv.cgi?uid=$id',
                                 'example': '50885',
                                 'name': 'Molecular Modeling Database',
                                 'pattern': '^\\d{1,5}$',
                                 'url': 'http://identifiers.org/mmdb/'},
 'Mouse Genome Database': {'data_entry': 'http://www.informatics.jax.org/marker/$id',
                           'example': 'MGI:2442292',
                           'name': 'Mouse Genome Database',
                           'pattern': '^MGI:\\d+$',
                           'url': 'http://identifiers.org/mgd/'},
 'MycoBank': {'data_entry': 'http://www.mycobank.org/Biolomics.aspx?Table=Mycobank&amp;MycoBankNr_=$id',
              'example': '349124',
              'name': 'MycoBank',
              'pattern': '^\\d+$',
              'url': 'http://identifiers.org/mycobank/'},
 'MycoBrowser leprae': {'data_entry': 'http://mycobrowser.epfl.ch/leprosysearch.php?gene+name=$id',
                        'example': 'ML0224',
                        'name': 'MycoBrowser leprae',
                        'pattern': '^ML\\w+$',
                        'url': 'http://identifiers.org/myco.lepra/'},
 'MycoBrowser marinum': {'data_entry': 'http://mycobrowser.epfl.ch/marinosearch.php?gene+name=$id',
                         'example': 'MMAR_2462',
                         'name': 'MycoBrowser marinum',
                         'pattern': '^MMAR\\_\\d+$',
                         'url': 'http://identifiers.org/myco.marinum/'},
 'MycoBrowser smegmatis': {'data_entry': 'http://mycobrowser.epfl.ch/smegmasearch.php?gene+name=$id',
                           'example': 'MSMEG_3769',
                           'name': 'MycoBrowser smegmatis',
                           'pattern': '^MSMEG\\w+$',
                           'url': 'http://identifiers.org/myco.smeg/'},
 'MycoBrowser tuberculosis': {'data_entry': 'http://tuberculist.epfl.ch/quicksearch.php?gene+name=$id',
                              'example': 'Rv1908c',
                              'name': 'MycoBrowser tuberculosis',
                              'pattern': '^\\w+$',
                              'url': 'http://identifiers.org/myco.tuber/'},
 'NAPP': {'data_entry': 'http://napp.u-psud.fr/Niveau2.php?specie=$id',
          'example': '351',
          'name': 'NAPP',
          'pattern': '^\\d+$',
          'url': 'http://identifiers.org/napp/'},
 'NARCIS': {'data_entry': 'http://www.narcis.nl/publication/RecordID/$id',
            'example': 'oai:cwi.nl:4725',
            'name': 'NARCIS',
            'pattern': '^oai\\:cwi\\.nl\\:\\d+$',
            'url': 'http://identifiers.org/narcis/'},
 'NASC code': {'data_entry': 'http://arabidopsis.info/StockInfo?NASC_id=$id',
               'example': 'N1899',
               'name': 'NASC code',
               'pattern': '^(\\w+)?\\d+$',
               'url': 'http://identifiers.org/nasc/'},
 'NCBI Gene': {'data_entry': 'http://www.ncbi.nlm.nih.gov/gene/$id',
               'example': '100010',
               'name': 'NCBI Gene',
               'pattern': '^\\d+$',
               'url': 'http://identifiers.org/ncbigene/'},
 'NCBI Protein': {'data_entry': 'http://www.ncbi.nlm.nih.gov/protein/$id',
                  'example': 'CAA71118.1',
                  'name': 'NCBI Protein',
                  'pattern': '^\\w+\\d+(\\.\\d+)?$" restricted="true',
                  'url': 'http://identifiers.org/ncbiprotein/'},
 'NCI Pathway Interaction Database: Pathway': {'data_entry': 'http://pid.nci.nih.gov/search/pathway_landing.shtml?what=graphic&amp;jpg=on&amp;pathway_id=$id',
                                               'example': 'pi3kcipathway',
                                               'name': 'NCI Pathway Interaction Database: Pathway',
                                               'pattern': '^\\w+$',
                                               'url': 'http://identifiers.org/pid.pathway/'},
 'NCIm': {'data_entry': 'http://ncim.nci.nih.gov/ncimbrowser/ConceptReport.jsp?dictionary=NCI%20MetaThesaurus&amp;code=$id',
          'example': 'C0026339',
          'name': 'NCIm',
          'pattern': '^C\\d+$" restricted="true',
          'url': 'http://identifiers.org/ncim/'},
 'NCIt': {'data_entry': 'http://ncit.nci.nih.gov/ncitbrowser/ConceptReport.jsp?dictionary=NCI%20Thesaurus&amp;code=$id',
          'example': 'C80519',
          'name': 'NCIt',
          'pattern': '^C\\d+$',
          'url': 'http://identifiers.org/ncit/'},
 'NEXTDB': {'data_entry': 'http://nematode.lab.nig.ac.jp/db2/ShowCloneInfo.php?clone=$id',
            'example': '6b1',
            'name': 'NEXTDB',
            'pattern': '^[A-Za-z0-9]+$" restricted="true',
            'url': 'http://identifiers.org/nextdb/'},
 'NIAEST': {'data_entry': 'http://lgsun.grc.nia.nih.gov/cgi-bin/pro3?sname1=$id',
            'example': 'J0705A10',
            'name': 'NIAEST',
            'pattern': '^\\w\\d{4}\\w\\d{2}(\\-[35])?$',
            'url': 'http://identifiers.org/niaest/'},
 'NITE Biological Research Center Catalogue': {'data_entry': 'http://www.nbrc.nite.go.jp/NBRC2/NBRCCatalogueDetailServlet?ID=NBRC&amp;CAT=$id',
                                               'example': '00001234',
                                               'name': 'NITE Biological Research Center Catalogue',
                                               'pattern': '^\\d+$',
                                               'url': 'http://identifiers.org/nbrc/'},
 'NONCODE': {'data_entry': 'http://www.noncode.org/NONCODERv3/ncrna.php?ncid=$id',
             'example': '377550',
             'name': 'NONCODE',
             'pattern': '^\\d+$',
             'url': 'http://identifiers.org/noncode/'},
 'National Bibliography Number': {'data_entry': 'http://nbn-resolving.org/resolver?identifier=$id&amp;verb=full',
                                  'example': 'urn:nbn:fi:tkk-004781',
                                  'name': 'National Bibliography Number',
                                  'pattern': '^urn\\:nbn\\:[A-Za-z_0-9]+\\:([A-Za-z_0-9]+\\:)?[A-Za-z_0-9]+$',
                                  'url': 'http://identifiers.org/nbn/'},
 'NeuroLex': {'data_entry': 'http://www.neurolex.org/wiki/$id',
              'example': 'Birnlex_721',
              'name': 'NeuroLex',
              'pattern': '^([Bb]irnlex_|Sao|nlx_|GO_|CogPO|HDO)\\d+$',
              'url': 'http://identifiers.org/neurolex/'},
 'NeuroMorpho': {'data_entry': 'http://neuromorpho.org/neuroMorpho/neuron_info.jsp?neuron_name=$id',
                 'example': 'Rosa2',
                 'name': 'NeuroMorpho',
                 'pattern': '^\\w+$',
                 'url': 'http://identifiers.org/neuromorpho/'},
 'NeuronDB': {'data_entry': 'http://senselab.med.yale.edu/NeuronDB/NeuronProp.aspx?id=$id',
              'example': '265',
              'name': 'NeuronDB',
              'pattern': '^\\d+$',
              'url': 'http://identifiers.org/neurondb/'},
 'NucleaRDB': {'data_entry': 'http://www.receptors.org/nucleardb/proteins/$id',
               'example': 'prgr_human',
               'name': 'NucleaRDB',
               'pattern': '^\\w+\\_\\w+$',
               'url': 'http://identifiers.org/nuclearbd/'},
 'Nucleotide Sequence Database': {'data_entry': 'http://srs.ebi.ac.uk/srsbin/cgi-bin/wgetz?-page+EntryPage+-e+[EMBL:$id]+-view+EmblEntry',
                                  'example': 'X58356',
                                  'name': 'Nucleotide Sequence Database',
                                  'pattern': '^[A-Z]+\\d+(\\.\\d+)?$',
                                  'url': 'http://identifiers.org/insdc/'},
 'OMA Group': {'data_entry': 'http://omabrowser.org/cgi-bin/gateway.pl?f=DisplayGroup&amp;p1=$id',
               'example': 'LCSCCPN',
               'name': 'OMA Group',
               'pattern': '^[A-Z]+$" restricted="true',
               'url': 'http://identifiers.org/oma.grp/'},
 'OMA Protein': {'data_entry': 'http://omabrowser.org/cgi-bin/gateway.pl?f=DisplayEntry&amp;p1=$id',
                 'example': 'HUMAN16963',
                 'name': 'OMA Protein',
                 'pattern': '^[A-Z0-9]{5}\\d+$" restricted="true',
                 'url': 'http://identifiers.org/oma.protein/'},
 'OMIA': {'data_entry': 'http://omia.angis.org.au/$id/',
          'example': '1000',
          'name': 'OMIA',
          'pattern': '^\\d+$',
          'url': 'http://identifiers.org/omia/'},
 'OMIM': {'data_entry': 'http://omim.org/entry/$id',
          'example': '603903',
          'name': 'OMIM',
          'pattern': '^[*#+%^]?\\d{6}$',
          'url': 'http://identifiers.org/omim/'},
 'OPM': {'data_entry': 'http://opm.phar.umich.edu/protein.php?pdbid=$id',
         'example': '1h68',
         'name': 'OPM',
         'pattern': '^[0-9][A-Za-z0-9]{3}$" restricted="true',
         'url': 'http://identifiers.org/opm/'},
 'ORCID': {'data_entry': 'https://orcid.org/$id',
           'example': '0000-0002-6309-7327',
           'name': 'ORCID',
           'pattern': '^\\d{4}-\\d{4}-\\d{4}-\\d{4}$',
           'url': 'http://identifiers.org/orcid/'},
 'Ontology for Biomedical Investigations': {'data_entry': 'http://purl.obolibrary.org/obo/$id',
                                            'example': 'OBI_0000070',
                                            'name': 'Ontology for Biomedical Investigations',
                                            'pattern': '^OBI_\\d{7}$',
                                            'url': 'http://identifiers.org/obo.obi/'},
 'Ontology of Physics for Biology': {'data_entry': 'http://bioportal.bioontology.org/ontologies/1141?p=terms&amp;conceptid=$id',
                                     'example': 'OPB_00573',
                                     'name': 'Ontology of Physics for Biology',
                                     'pattern': '^OPB_\\d+$',
                                     'url': 'http://identifiers.org/opb/'},
 'OriDB Saccharomyces': {'data_entry': 'http://cerevisiae.oridb.org/details.php?id=$id',
                         'example': '1',
                         'name': 'OriDB Saccharomyces',
                         'pattern': '^\\d+$',
                         'url': 'http://identifiers.org/oridb.sacch/'},
 'OriDB Schizosaccharomyces': {'data_entry': 'http://pombe.oridb.org/details.php?id=$id',
                               'example': '1',
                               'name': 'OriDB Schizosaccharomyces',
                               'pattern': '^\\d+$',
                               'url': 'http://identifiers.org/oridb.schizo/'},
 'Orphanet': {'data_entry': 'http://www.orpha.net/consor/cgi-bin/OC_Exp.php?Lng=EN&amp;Expert=$id',
              'example': '85163',
              'name': 'Orphanet',
              'pattern': '^\\d+$',
              'url': 'http://identifiers.org/orphanet/'},
 'OrthoDB': {'data_entry': 'http://cegg.unige.ch/orthodb/results?searchtext=$id',
             'example': 'Q9P0K8',
             'name': 'OrthoDB',
             'pattern': '^\\w+$',
             'url': 'http://identifiers.org/orthodb/'},
 'PANTHER Family': {'data_entry': 'http://www.pantherdb.org/panther/family.do?clsAccession=$id',
                    'example': 'PTHR12345',
                    'name': 'PANTHER Family',
                    'pattern': '^PTHR\\d{5}(\\:SF\\d{1,3})?$',
                    'url': 'http://identifiers.org/panther.family/'},
 'PANTHER Node': {'data_entry': 'http://www.pantree.org/node/annotationNode.jsp?id=$id',
                  'example': 'PTN000000026',
                  'name': 'PANTHER Node',
                  'pattern': '^PTN\\d{9}$',
                  'url': 'http://identifiers.org/panther.node/'},
 'PANTHER Pathway': {'data_entry': 'http://www.pantherdb.org/pathway/pathwayDiagram.jsp?catAccession=$id',
                     'example': 'P00024',
                     'name': 'PANTHER Pathway',
                     'pattern': '^P\\d{5}$',
                     'url': 'http://identifiers.org/panther.pathway/'},
 'PATO': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=$id',
          'example': 'PATO:0001998',
          'name': 'PATO',
          'pattern': '^PATO:\\d{7}$',
          'url': 'http://identifiers.org/obo.pato/'},
 'PINA': {'data_entry': 'http://cbg.garvan.unsw.edu.au/pina/interactome.oneP.do?ac=$id&amp;showExtend=null',
          'example': 'Q13485',
          'name': 'PINA',
          'pattern': '^([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9])$" restricted="true',
          'url': 'http://identifiers.org/pina/'},
 'PIRSF': {'data_entry': 'http://pir.georgetown.edu/cgi-bin/ipcSF?id=$id',
           'example': 'PIRSF000100',
           'name': 'PIRSF',
           'pattern': '^PIRSF\\d{6}$',
           'url': 'http://identifiers.org/pirsf/'},
 'PMP': {'data_entry': 'http://www.proteinmodelportal.org/query/uniprot/$id',
         'example': 'Q0VCA6',
         'name': 'PMP',
         'pattern': '^([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9])$',
         'url': 'http://identifiers.org/pmp/'},
 'PRIDE': {'data_entry': 'http://www.ebi.ac.uk/pride/experimentLink.do?experimentAccessionNumber=$id',
           'example': '1',
           'name': 'PRIDE',
           'pattern': '^\\d+$',
           'url': 'http://identifiers.org/pride/'},
 'PROSITE': {'data_entry': 'http://prosite.expasy.org/$id',
             'example': 'PS00001',
             'name': 'PROSITE',
             'pattern': '^PS\\d{5}$',
             'url': 'http://identifiers.org/prosite/'},
 'PSCDB': {'data_entry': 'http://idp1.force.cs.is.nagoya-u.ac.jp/pscdb/$id.html',
           'example': '051',
           'name': 'PSCDB',
           'pattern': '^\\d+$',
           'url': 'http://identifiers.org/pscdb/'},
 'PaleoDB': {'data_entry': 'http://paleodb.org/cgi-bin/bridge.pl?a=basicTaxonInfo&amp;taxon_no=$id',
             'example': '83088',
             'name': 'PaleoDB',
             'pattern': '^\\d+$',
             'url': 'http://identifiers.org/paleodb/'},
 'Pathway Commons': {'data_entry': 'http://www.pathwaycommons.org/pc/record2.do?id=$id',
                     'example': '485991',
                     'name': 'Pathway Commons',
                     'pattern': '^\\d+$" restricted="true',
                     'url': 'http://identifiers.org/pathwaycommons/'},
 'Pathway Ontology': {'data_entry': 'http://rgd.mcw.edu/rgdweb/ontology/annot.html?acc_id=$id',
                      'example': 'PW:0000208',
                      'name': 'Pathway Ontology',
                      'pattern': '^PW:\\d{7}$',
                      'url': 'http://identifiers.org/obo.pw/'},
 'Pazar Transcription Factor': {'data_entry': 'http://www.pazar.info/cgi-bin/tf_search.cgi?geneID=$id',
                                'example': 'TF0001053',
                                'name': 'Pazar Transcription Factor',
                                'pattern': '^TF\\w+$',
                                'url': 'http://identifiers.org/pazar/'},
 'PeptideAtlas': {'data_entry': 'https://db.systemsbiology.net/sbeams/cgi/PeptideAtlas/Summarize_Peptide?query=QUERY&amp;searchForThis=$id',
                  'example': 'PAp00000009',
                  'name': 'PeptideAtlas',
                  'pattern': '^PAp[0-9]{8}$',
                  'url': 'http://identifiers.org/peptideatlas/'},
 'Peroxibase': {'data_entry': 'http://peroxibase.toulouse.inra.fr/browse/process/view_perox.php?id=$id',
                'example': '5282',
                'name': 'Peroxibase',
                'pattern': '^\\d+$',
                'url': 'http://identifiers.org/peroxibase/'},
 'Pfam': {'data_entry': 'http://pfam.sanger.ac.uk/family/$id/',
          'example': 'PF01234',
          'name': 'Pfam',
          'pattern': '^PF\\d{5}$',
          'url': 'http://identifiers.org/pfam/'},
 'PharmGKB Disease': {'data_entry': 'http://www.pharmgkb.org/disease/$id',
                      'example': 'PA447218',
                      'name': 'PharmGKB Disease',
                      'pattern': '^PA\\d+$" restricted="true',
                      'url': 'http://identifiers.org/pharmgkb.disease/'},
 'PharmGKB Drug': {'data_entry': 'http://www.pharmgkb.org/drug/$id',
                   'example': 'PA448710',
                   'name': 'PharmGKB Drug',
                   'pattern': '^PA\\d+$" restricted="true',
                   'url': 'http://identifiers.org/pharmgkb.drug/'},
 'PharmGKB Gene': {'data_entry': 'http://www.pharmgkb.org/gene/$id',
                   'example': 'PA131',
                   'name': 'PharmGKB Gene',
                   'pattern': '^PA\\w+$" restricted="true',
                   'url': 'http://identifiers.org/pharmgkb.gene/'},
 'PharmGKB Pathways': {'data_entry': 'http://www.pharmgkb.org/pathway/$id',
                       'example': 'PA146123006',
                       'name': 'PharmGKB Pathways',
                       'pattern': '^PA\\d+$" restricted="true',
                       'url': 'http://identifiers.org/pharmgkb.pathways/'},
 'Phenol-Explorer': {'data_entry': 'http://www.phenol-explorer.eu/contents/total?food_id=$id',
                     'example': '75',
                     'name': 'Phenol-Explorer',
                     'pattern': '^\\d+$',
                     'url': 'http://identifiers.org/phenolexplorer/'},
 'PhosphoPoint Kinase': {'data_entry': 'http://kinase.bioinformatics.tw/showall.jsp?type=Kinase&amp;info=Gene&amp;name=$id&amp;drawing=0&amp;sorting=0&amp;kinome=1',
                         'example': 'AURKA',
                         'name': 'PhosphoPoint Kinase',
                         'pattern': '^\\w+$',
                         'url': 'http://identifiers.org/phosphopoint.kinase/'},
 'PhosphoPoint Phosphoprotein': {'data_entry': 'http://kinase.bioinformatics.tw/showall.jsp?type=PhosphoProtein&amp;info=Gene&amp;name=$id&amp;drawing=0&amp;sorting=0&amp;kinome=0',
                                 'example': 'AURKA',
                                 'name': 'PhosphoPoint Phosphoprotein',
                                 'pattern': '^\\w+$',
                                 'url': 'http://identifiers.org/phosphopoint.protein/'},
 'PhosphoSite Protein': {'data_entry': 'http://www.phosphosite.org/proteinAction.do?id=$id',
                         'example': '12300',
                         'name': 'PhosphoSite Protein',
                         'pattern': '^\\d{5}$',
                         'url': 'http://identifiers.org/phosphosite.protein/'},
 'PhosphoSite Residue': {'data_entry': 'http://www.phosphosite.org/siteAction.do?id=$id',
                         'example': '2842',
                         'name': 'PhosphoSite Residue',
                         'pattern': '^\\d+$',
                         'url': 'http://identifiers.org/phosphosite.residue/'},
 'PhylomeDB': {'data_entry': 'http://phylomedb.org/?seqid=$id',
               'example': 'Phy000CLXM_RAT',
               'name': 'PhylomeDB',
               'pattern': '^\\w+$',
               'url': 'http://identifiers.org/phylomedb/'},
 'PiroplasmaDB': {'data_entry': 'http://piroplasmadb.org/piro/showRecord.do?name=GeneRecordClasses.GeneRecordClass&amp;source_id=$id',
                  'example': 'TA14985',
                  'name': 'PiroplasmaDB',
                  'pattern': '^TA\\d+$',
                  'url': 'http://identifiers.org/piroplasma/'},
 'Plant Genome Network': {'data_entry': 'http://pgn.cornell.edu/unigene/unigene_assembly_contigs.pl?unigene_id=$id',
                          'example': '196828',
                          'name': 'Plant Genome Network',
                          'pattern': '^\\d+$',
                          'url': 'http://identifiers.org/pgn/'},
 'Plant Ontology': {'data_entry': 'http://www.plantontology.org/amigo/go.cgi?view=details&amp;amp;query=$id',
                    'example': 'PO:0009089',
                    'name': 'Plant Ontology',
                    'pattern': '^PO\\:\\d+$',
                    'url': 'http://identifiers.org/obo.po/'},
 'PlasmoDB': {'data_entry': 'http://plasmodb.org/plasmo/showRecord.do?name=GeneRecordClasses.GeneRecordClass&amp;source_id=$id',
              'example': 'PF11_0344',
              'name': 'PlasmoDB',
              'pattern': '^\\w+$',
              'url': 'http://identifiers.org/plasmodb/'},
 'Pocketome': {'data_entry': 'http://www.pocketome.org/files/$id.html',
               'example': '1433C_TOBAC_1_252',
               'name': 'Pocketome',
               'pattern': '^[A-Za-z_0-9]+',
               'url': 'http://identifiers.org/pocketome/'},
 'PolBase': {'data_entry': 'http://polbase.neb.com/polymerases/$id#sequences',
             'example': '19-T4',
             'name': 'PolBase',
             'pattern': '^[A-Za-z-0-9]+$',
             'url': 'http://identifiers.org/polbase/'},
 'PomBase': {'data_entry': 'http://www.pombase.org/spombe/result/$id',
             'example': 'SPCC13B11.01',
             'name': 'PomBase',
             'pattern': '^S\\w+(\\.)?\\w+(\\.)?$',
             'url': 'http://identifiers.org/pombase/'},
 'ProDom': {'data_entry': 'http://prodom.prabi.fr/prodom/current/cgi-bin/request.pl?question=DBEN&amp;query=$id',
            'example': 'PD10000',
            'name': 'ProDom',
            'pattern': '^PD\\d+$',
            'url': 'http://identifiers.org/prodom/'},
 'ProGlycProt': {'data_entry': 'http://www.proglycprot.org/detail.aspx?ProId=$id',
                 'example': 'AC119',
                 'name': 'ProGlycProt',
                 'pattern': '^[A-Z]C\\d{1,3}$',
                 'url': 'http://identifiers.org/proglyc/'},
 'ProtClustDB': {'data_entry': 'http://www.ncbi.nlm.nih.gov/sites/entrez?Db=proteinclusters&amp;Cmd=DetailsSearch&amp;Term=$id',
                 'example': 'O80725',
                 'name': 'ProtClustDB',
                 'pattern': '^\\w+$',
                 'url': 'http://identifiers.org/protclustdb/'},
 'Protein Data Bank': {'data_entry': 'http://www.rcsb.org/pdb/explore/explore.do?structureId=$id',
                       'example': '2gc4',
                       'name': 'Protein Data Bank',
                       'pattern': '^[0-9][A-Za-z0-9]{3}$',
                       'url': 'http://identifiers.org/pdb/'},
 'Protein Model Database': {'data_entry': 'http://mi.caspur.it/PMDB/user/search.php?idsearch=$id',
                            'example': 'PM0012345',
                            'name': 'Protein Model Database',
                            'pattern': '^PM\\d{7}',
                            'url': 'http://identifiers.org/pmdb/'},
 'Protein Modification Ontology': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=$id',
                                   'example': 'MOD:00001',
                                   'name': 'Protein Modification Ontology',
                                   'pattern': '^MOD:\\d{5}',
                                   'url': 'http://identifiers.org/obo.psi-mod/'},
 'Protein Ontology': {'data_entry': 'http://pir.georgetown.edu/cgi-bin/pro/entry_pro?id=$id',
                      'example': 'PR:000000024',
                      'name': 'Protein Ontology',
                      'pattern': '^PR\\:\\d+$',
                      'url': 'http://identifiers.org/obo.pr/'},
 'ProtoNet Cluster': {'data_entry': 'http://www.protonet.cs.huji.ac.il/requested/cluster_card.php?cluster=$id',
                      'example': '4349895',
                      'name': 'ProtoNet Cluster',
                      'pattern': '^\\d+$',
                      'url': 'http://identifiers.org/protonet.cluster/'},
 'ProtoNet ProteinCard': {'data_entry': 'http://www.protonet.cs.huji.ac.il/requested/protein_card.php?protein_id=$id',
                          'example': '16941567',
                          'name': 'ProtoNet ProteinCard',
                          'pattern': '^\\d+$',
                          'url': 'http://identifiers.org/protonet.proteincard/'},
 'Pseudomonas Genome Database': {'data_entry': 'http://www.pseudomonas.com/getAnnotation.do?locusID=$id',
                                 'example': 'PSEEN0001',
                                 'name': 'Pseudomonas Genome Database',
                                 'pattern': '^P\\w+$',
                                 'url': 'http://identifiers.org/pseudomonas/'},
 'PubChem-bioassay': {'data_entry': 'http://pubchem.ncbi.nlm.nih.gov/assay/assay.cgi?aid=$id',
                      'example': '1018',
                      'name': 'PubChem-bioassay',
                      'pattern': '^\\d+$',
                      'url': 'http://identifiers.org/pubchem.bioassay/'},
 'PubChem-compound': {'data_entry': 'http://pubchem.ncbi.nlm.nih.gov/summary/summary.cgi?cid=$id',
                      'example': '100101',
                      'name': 'PubChem-compound',
                      'pattern': '^\\d+$',
                      'url': 'http://identifiers.org/pubchem.compound/'},
 'PubChem-substance': {'data_entry': 'http://pubchem.ncbi.nlm.nih.gov/summary/summary.cgi?sid=$id',
                       'example': '100101',
                       'name': 'PubChem-substance',
                       'pattern': '^\\d+$',
                       'url': 'http://identifiers.org/pubchem.substance/'},
 'PubMed': {'data_entry': 'http://www.ncbi.nlm.nih.gov/pubmed/$id',
            'example': '16333295',
            'name': 'PubMed',
            'pattern': '^\\d+$',
            'url': 'http://identifiers.org/pubmed/'},
 'PubMed Central': {'data_entry': 'http://www.ncbi.nlm.nih.gov/pmc/articles/$id/?tool=pubmed',
                    'example': 'PMC3084216',
                    'name': 'PubMed Central',
                    'pattern': 'PMC\\d+',
                    'url': 'http://identifiers.org/pmc/'},
 'REBASE': {'data_entry': 'http://rebase.neb.com/rebase/enz/$id.html',
            'example': '101',
            'name': 'REBASE',
            'pattern': '^\\d+$',
            'url': 'http://identifiers.org/rebase/'},
 'RESID': {'data_entry': 'http://srs.ebi.ac.uk/srsbin/cgi-bin/wgetz?-id+6JSUg1NA6u4+-e+[RESID:&apos;$id&apos;]',
           'example': 'AA0001',
           'name': 'RESID',
           'pattern': '^AA\\d{4}$',
           'url': 'http://identifiers.org/resid/'},
 'RFAM': {'data_entry': 'http://rfam.sanger.ac.uk/family/$id',
          'example': 'RF00230',
          'name': 'RFAM',
          'pattern': '^RF\\d+$',
          'url': 'http://identifiers.org/rfam/'},
 'RNA Modification Database': {'data_entry': 'http://s59.cas.albany.edu/RNAmods/cgi-bin/rnashow.cgi?$id',
                               'example': '101',
                               'name': 'RNA Modification Database',
                               'pattern': '^\\d{3}$',
                               'url': 'http://identifiers.org/rnamods/'},
 'Rat Genome Database': {'data_entry': 'http://rgd.mcw.edu/rgdweb/report/gene/main.html?id=$id',
                         'example': '2018',
                         'name': 'Rat Genome Database',
                         'pattern': '^\\d{4,7}$',
                         'url': 'http://identifiers.org/rgd/'},
 'Reactome': {'data_entry': 'http://www.reactome.org/cgi-bin/eventbrowser_st_id?FROM_REACTOME=1&amp;ST_ID=$id',
              'example': 'REACT_1590',
              'name': 'Reactome',
              'pattern': '^REACT_\\d+(\\.\\d+)?$',
              'url': 'http://identifiers.org/reactome/'},
 'RefSeq': {'data_entry': 'http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?val=$id',
            'example': 'NP_012345',
            'name': 'RefSeq',
            'pattern': '^(NC|AC|NG|NT|NW|NZ|NM|NR|XM|XR|NP|AP|XP|ZP)_\\d+(\\.\\d+)?$',
            'url': 'http://identifiers.org/refseq/'},
 'Relation Ontology': {'data_entry': 'http://www.obofoundry.org/ro/#$id',
                       'example': 'OBO_REL:is_a',
                       'name': 'Relation Ontology',
                       'pattern': '^OBO_REL:\\w+$',
                       'url': 'http://identifiers.org/obo.ro/'},
 'Rhea': {'data_entry': 'http://www.ebi.ac.uk/rhea/reaction.xhtml?id=$id',
          'example': '12345',
          'name': 'Rhea',
          'pattern': '^\\d{5}$',
          'url': 'http://identifiers.org/rhea/'},
 'Rice Genome Annotation Project': {'data_entry': 'http://rice.plantbiology.msu.edu/cgi-bin/ORF_infopage.cgi?&amp;orf=$id',
                                    'example': 'LOC_Os02g13300',
                                    'name': 'Rice Genome Annotation Project',
                                    'pattern': '^LOC\\_Os\\d{1,2}g\\d{5}$',
                                    'url': 'http://identifiers.org/ricegap/'},
 'Rouge': {'data_entry': 'http://www.kazusa.or.jp/rouge/gfpage/$id/',
           'example': 'mKIAA4200',
           'name': 'Rouge',
           'pattern': '^m\\w+$" restricted="true',
           'url': 'http://identifiers.org/rouge/'},
 'SABIO-RK EC Record': {'data_entry': 'http://sabiork.h-its.org/newSearch?q=ecnumber:$id',
                        'example': '2.7.1.1',
                        'name': 'SABIO-RK EC Record',
                        'pattern': '^((\\d+)|(\\d+\\.\\d+)|(\\d+\\.\\d+\\.\\d+)|(\\d+\\.\\d+\\.\\d+\\.\\d+))$',
                        'url': 'http://identifiers.org/sabiork.ec/'},
 'SABIO-RK Kinetic Record': {'data_entry': 'http://sabiork.h-its.org/newSearch?q=entryid:$id',
                             'example': '5046',
                             'name': 'SABIO-RK Kinetic Record',
                             'pattern': '^\\d+$',
                             'url': 'http://identifiers.org/sabiork.kineticrecord/'},
 'SABIO-RK Reaction': {'data_entry': 'http://sabiork.h-its.org/newSearch?q=sabioreactionid:$id',
                       'example': '75',
                       'name': 'SABIO-RK Reaction',
                       'pattern': '^\\d+$',
                       'url': 'http://identifiers.org/sabiork.reaction/'},
 'SCOP': {'data_entry': 'http://scop.mrc-lmb.cam.ac.uk/scop/search.cgi?sunid=$id',
          'example': '47419',
          'name': 'SCOP',
          'pattern': '^\\d+$',
          'url': 'http://identifiers.org/scop/'},
 'SGD': {'data_entry': 'http://www.yeastgenome.org/cgi-bin/locus.fpl?dbid=$id',
         'example': 'S000028457',
         'name': 'SGD',
         'pattern': '^S\\d+$',
         'url': 'http://identifiers.org/sgd/'},
 'SMART': {'data_entry': 'http://smart.embl-heidelberg.de/smart/do_annotation.pl?DOMAIN=$id',
           'example': 'SM00015',
           'name': 'SMART',
           'pattern': '^SM\\d{5}$',
           'url': 'http://identifiers.org/smart/'},
 'SNOMED CT': {'data_entry': 'http://vtsl.vetmed.vt.edu/TerminologyMgt/Browser/ISA.cfm?SCT_ConceptID=$id',
               'example': '284196006',
               'name': 'SNOMED CT',
               'pattern': '^(\\w+)?\\d+$" restricted="true',
               'url': 'http://identifiers.org/snomedct/'},
 'SPIKE Map': {'data_entry': 'http://www.cs.tau.ac.il/~spike/maps/$id.html',
               'example': 'spike00001',
               'name': 'SPIKE Map',
               'pattern': '^spike\\d{5}$',
               'url': 'http://identifiers.org/spike.map/'},
 'SPRINT': {'data_entry': 'http://www.bioinf.manchester.ac.uk/cgi-bin/dbbrowser/sprint/searchprintss.cgi?prints_accn=$id&amp;display_opts=Prints&amp;category=None&amp;queryform=false&amp;regexpr=off',
            'example': 'PR00001',
            'name': 'SPRINT',
            'pattern': '^PR\\d{5}$',
            'url': 'http://identifiers.org/sprint/'},
 'STAP': {'data_entry': 'http://psb.kobic.re.kr/STAP/refinement/result.php?search=$id',
          'example': '1a24',
          'name': 'STAP',
          'pattern': '^[0-9][A-Za-z0-9]{3}$',
          'url': 'http://identifiers.org/stap/'},
 'STITCH': {'data_entry': 'http://stitch.embl.de/interactions/$id',
            'example': 'ICXJVZHDZFXYQC',
            'name': 'STITCH',
            'pattern': '^\\w{14}$" restricted="true',
            'url': 'http://identifiers.org/stitch/'},
 'STRING': {'data_entry': 'http://string.embl.de/interactions/$id',
            'example': 'P53350',
            'name': 'STRING',
            'pattern': '^([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9])|([0-9][A-Za-z0-9]{3})$" restricted="true',
            'url': 'http://identifiers.org/string/'},
 'SUPFAM': {'data_entry': 'http://supfam.org/SUPERFAMILY/cgi-bin/scop.cgi?ipid=$id',
            'example': 'SSF57615',
            'name': 'SUPFAM',
            'pattern': '^\\w+$',
            'url': 'http://identifiers.org/supfam/'},
 'SWISS-MODEL': {'data_entry': 'http://swissmodel.expasy.org/repository/smr.php?sptr_ac=$id',
                 'example': 'P23298',
                 'name': 'SWISS-MODEL',
                 'pattern': '^\\w+$" restricted="true',
                 'url': 'http://identifiers.org/swiss-model/'},
 'Saccharomyces genome database pathways': {'data_entry': 'http://pathway.yeastgenome.org/YEAST/new-image?type=PATHWAY&amp;object=$id',
                                            'example': 'PWY3O-214',
                                            'name': 'Saccharomyces genome database pathways',
                                            'pattern': '^PWY\\w{2}\\-\\d{3}$',
                                            'url': 'http://identifiers.org/sgd.pathways/'},
 'ScerTF': {'data_entry': 'http://stormo.wustl.edu/ScerTF/details/$id/',
            'example': 'RSC3',
            'name': 'ScerTF',
            'pattern': '^\\w+$',
            'url': 'http://identifiers.org/scretf/'},
 'Science Signaling Pathway': {'data_entry': 'http://stke.sciencemag.org/cgi/cm/stkecm;$id',
                               'example': 'CMP_18019',
                               'name': 'Science Signaling Pathway',
                               'pattern': '^CMP_\\d+$" restricted="true',
                               'url': 'http://identifiers.org/sciencesignaling.path/'},
 'Science Signaling Pathway-Dependent Component': {'data_entry': 'http://stke.sciencemag.org/cgi/cm/stkecm;$id',
                                                   'example': 'CMN_15494',
                                                   'name': 'Science Signaling Pathway-Dependent Component',
                                                   'pattern': '^CMN_\\d+$" restricted="true',
                                                   'url': 'http://identifiers.org/sciencesignaling.pdc/'},
 'Science Signaling Pathway-Independent Component': {'data_entry': 'http://stke.sciencemag.org/cgi/cm/stkecm;$id',
                                                     'example': 'CMC_15493',
                                                     'name': 'Science Signaling Pathway-Independent Component',
                                                     'pattern': '^CMC_\\d+$" restricted="true',
                                                     'url': 'http://identifiers.org/sciencesignaling.pic/'},
 'Sequence Ontology': {'data_entry': 'http://www.sequenceontology.org/miso/current_release/term/$id',
                       'example': 'SO:0000704',
                       'name': 'Sequence Ontology',
                       'pattern': '^SO:\\d{7}$',
                       'url': 'http://identifiers.org/obo.so/'},
 'Sequence Read Archive': {'data_entry': 'http://www.ncbi.nlm.nih.gov/sra/$id?&amp;report=full',
                           'example': 'SRX000007',
                           'name': 'Sequence Read Archive',
                           'pattern': '^[SED]R\\w\\d{6}',
                           'url': 'http://identifiers.org/insdc.sra/'},
 'Signaling Gateway': {'data_entry': 'http://www.signaling-gateway.org/molecule/query?afcsid=$id',
                       'example': 'A001094',
                       'name': 'Signaling Gateway',
                       'pattern': 'A\\d{6}$',
                       'url': 'http://identifiers.org/signaling-gateway/'},
 'SitEx': {'data_entry': 'http://www-bionet.sscc.ru/sitex/index.php?siteid=$id',
           'example': '1000',
           'name': 'SitEx',
           'pattern': '^\\d+$',
           'url': 'http://identifiers.org/sitex/'},
 'Small Molecule Pathway Database': {'data_entry': 'http://pathman.smpdb.ca/pathways/$id/pathway',
                                     'example': 'SMP00001',
                                     'name': 'Small Molecule Pathway Database',
                                     'pattern': '^SMP\\d{5}$',
                                     'url': 'http://identifiers.org/smpdb/'},
 'Sol Genomics Network': {'data_entry': 'http://solgenomics.net/phenome/locus_display.pl?locus_id=$id',
                          'example': '0001',
                          'name': 'Sol Genomics Network',
                          'pattern': '^\\d+$',
                          'url': 'http://identifiers.org/sgn/'},
 'SoyBase': {'data_entry': 'http://soybeanbreederstoolbox.org/search/search_results.php?category=SNP&amp;search_term=$id',
             'example': 'BARC-013845-01256',
             'name': 'SoyBase',
             'pattern': '^\\w+(\\-)?\\w+(\\-)?\\w+$',
             'url': 'http://identifiers.org/soybase/'},
 'Spectral Database for Organic Compounds': {'data_entry': 'http://riodb01.ibase.aist.go.jp/sdbs/cgi-bin/cre_frame_disp.cgi?sdbsno=$id',
                                             'example': '4544',
                                             'name': 'Spectral Database for Organic Compounds',
                                             'pattern': '\\d+$" restricted="true',
                                             'url': 'http://identifiers.org/sdbs/'},
 'SubstrateDB': {'data_entry': 'http://substrate.burnham.org/protein/annotation/$id/html',
                 'example': '1915',
                 'name': 'SubstrateDB',
                 'pattern': '^\\w+$',
                 'url': 'http://identifiers.org/pmap.substratedb/'},
 'SubtiWiki': {'data_entry': 'http://www.subtiwiki.uni-goettingen.de/wiki/index.php/$id',
               'example': 'BSU29180',
               'name': 'SubtiWiki',
               'pattern': '^BSU\\d{5}$',
               'url': 'http://identifiers.org/subtiwiki/'},
 'Systems Biology Ontology': {'data_entry': 'http://www.ebi.ac.uk/sbo/main/$id',
                              'example': 'SBO:0000262',
                              'name': 'Systems Biology Ontology',
                              'pattern': '^SBO:\\d{7}$',
                              'url': 'http://identifiers.org/biomodels.sbo/'},
 'T3DB': {'data_entry': 'http://www.t3db.org/toxins/$id',
          'example': 'T3D0001',
          'name': 'T3DB',
          'pattern': '^T3D\\d+$',
          'url': 'http://identifiers.org/t3db/'},
 'TAIR Gene': {'data_entry': 'http://arabidopsis.org/servlets/TairObject?accession=$id',
               'example': 'Gene:2200934',
               'name': 'TAIR Gene',
               'pattern': '^Gene:\\d{7}$',
               'url': 'http://identifiers.org/tair.gene/'},
 'TAIR Locus': {'data_entry': 'http://arabidopsis.org/servlets/TairObject?type=locus&amp;name=$id',
                'example': 'AT1G01030',
                'name': 'TAIR Locus',
                'pattern': '^AT[1-5]G\\d{5}$',
                'url': 'http://identifiers.org/tair.locus/'},
 'TAIR Protein': {'data_entry': 'http://arabidopsis.org/servlets/TairObject?accession=$id',
                  'example': 'AASequence:1009107926',
                  'name': 'TAIR Protein',
                  'pattern': '^AASequence:\\d{10}$',
                  'url': 'http://identifiers.org/tair.protein/'},
 'TEDDY': {'data_entry': 'http://bioportal.bioontology.org/ontologies/1407?p=terms&amp;conceptid=$id',
           'example': 'TEDDY_0000066',
           'name': 'TEDDY',
           'pattern': '^TEDDY_\\d{7}$',
           'url': 'http://identifiers.org/biomodels.teddy/'},
 'TIGRFAMS': {'data_entry': 'http://www.jcvi.org/cgi-bin/tigrfams/HmmReportPage.cgi?acc=$id',
              'example': 'TIGR00010',
              'name': 'TIGRFAMS',
              'pattern': '^TIGR\\d+$',
              'url': 'http://identifiers.org/tigrfam/'},
 'TTD Drug': {'data_entry': 'http://bidd.nus.edu.sg/group/cjttd/ZFTTDDRUG.asp?ID=$id',
              'example': 'DAP000773',
              'name': 'TTD Drug',
              'pattern': '^DAP\\d+$',
              'url': 'http://identifiers.org/ttd.drug/'},
 'TTD Target': {'data_entry': 'http://bidd.nus.edu.sg/group/cjttd/ZFTTDDetail.asp?ID=$id',
                'example': 'TTDS00056',
                'name': 'TTD Target',
                'pattern': '^TTDS\\d+$',
                'url': 'http://identifiers.org/ttd.target/'},
 'TarBase': {'data_entry': 'http://diana.cslab.ece.ntua.gr/DianaToolsNew/index.php?r=tarbase/index&amp;mirnas=$id',
             'example': 'hsa-let-7',
             'name': 'TarBase',
             'pattern': '^\\w+\\-\\w+\\-\\w+',
             'url': 'http://identifiers.org/tarbase/'},
 'Taxonomy': {'data_entry': 'http://www.ncbi.nlm.nih.gov/Taxonomy/Browser/wwwtax.cgi?mode=Info&amp;id=$id',
              'example': '9606',
              'name': 'Taxonomy',
              'pattern': '^\\d+$',
              'url': 'http://identifiers.org/taxonomy/'},
 'Tetrahymena Genome Database': {'data_entry': 'http://ciliate.org/index.php/feature/details/$id',
                                 'example': 'TTHERM_00648910',
                                 'name': 'Tetrahymena Genome Database',
                                 'pattern': '^TTHERM\\_\\d+$',
                                 'url': 'http://identifiers.org/tgd/'},
 'Tissue List': {'data_entry': 'http://www.uniprot.org/tissues/$id',
                 'example': 'TS-0285',
                 'name': 'Tissue List',
                 'pattern': '^TS-\\d{4}$',
                 'url': 'http://identifiers.org/tissuelist/'},
 'TopFind': {'data_entry': 'http://clipserve.clip.ubc.ca/topfind/proteins/$id',
             'example': 'Q9UKQ2',
             'name': 'TopFind',
             'pattern': '^([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9])$',
             'url': 'http://identifiers.org/topfind/'},
 'ToxoDB': {'data_entry': 'http://toxodb.org/toxo/showRecord.do?name=GeneRecordClasses.GeneRecordClass&amp;source_id=$id',
            'example': 'TGME49_053730',
            'name': 'ToxoDB',
            'pattern': '^\\w+$',
            'url': 'http://identifiers.org/toxoplasma/'},
 'Transport Classification Database': {'data_entry': 'http://www.tcdb.org/search/result.php?tc=$id',
                                       'example': '5.A.1.1.1',
                                       'name': 'Transport Classification Database',
                                       'pattern': '^\\d+\\.[A-Z]\\.\\d+\\.\\d+\\.\\d+$',
                                       'url': 'http://identifiers.org/tcdb/'},
 'Tree of Life': {'data_entry': 'http://tolweb.org/$id',
                  'example': '98034',
                  'name': 'Tree of Life',
                  'pattern': '^\\d+$',
                  'url': 'http://identifiers.org/tol/'},
 'TreeBASE': {'data_entry': 'http://purl.org/phylo/treebase/phylows/study/$id?format=html',
              'example': 'TB2:S1000',
              'name': 'TreeBASE',
              'pattern': '^TB[1,2]?:[A-Z][a-z]?\\d+$',
              'url': 'http://identifiers.org/treebase/'},
 'TreeFam': {'data_entry': 'http://www.treefam.org/cgi-bin/TFinfo.pl?ac=$id',
             'example': 'TF101014',
             'name': 'TreeFam',
             'pattern': '^\\w{1,2}\\d+$',
             'url': 'http://identifiers.org/treefam/'},
 'TriTrypDB': {'data_entry': 'http://tritrypdb.org/tritrypdb/showRecord.do?name=GeneRecordClasses.GeneRecordClass&amp;source_id=$id',
               'example': 'Tb927.8.620',
               'name': 'TriTrypDB',
               'pattern': '^\\w+(\\.)?\\w+(\\.)?\\w+',
               'url': 'http://identifiers.org/tritrypdb/'},
 'TrichDB': {'data_entry': 'http://trichdb.org/trichdb/showRecord.do?name=GeneRecordClasses.GeneRecordClass&amp;source_id=$id',
             'example': 'TVAG_386080',
             'name': 'TrichDB',
             'pattern': '^\\w+$',
             'url': 'http://identifiers.org/trichdb/'},
 'UM-BBD Biotransformation Rule': {'data_entry': 'http://www.umbbd.ethz.ch/servlets/rule.jsp?rule=$id',
                                   'example': 'bt0001',
                                   'name': 'UM-BBD Biotransformation Rule',
                                   'pattern': '^bt\\d+$',
                                   'url': 'http://identifiers.org/umbbd.rule/'},
 'UM-BBD Compound': {'data_entry': 'http://umbbd.ethz.ch/servlets/pageservlet?ptype=c&amp;compID=$id',
                     'example': 'c0001',
                     'name': 'UM-BBD Compound',
                     'pattern': '^c\\d+$',
                     'url': 'http://identifiers.org/umbbd.compound/'},
 'UM-BBD Enzyme': {'data_entry': 'http://umbbd.ethz.ch/servlets/pageservlet?ptype=ep&amp;enzymeID=$id',
                   'example': 'e0333',
                   'name': 'UM-BBD Enzyme',
                   'pattern': '^e\\d+$',
                   'url': 'http://identifiers.org/umbbd.enzyme/'},
 'UM-BBD Pathway': {'data_entry': 'http://umbbd.ethz.ch/servlets/pageservlet?ptype=p&amp;pathway_abbr=$id',
                    'example': 'ala',
                    'name': 'UM-BBD Pathway',
                    'pattern': '^\\w+$',
                    'url': 'http://identifiers.org/umbbd.pathway/'},
 'UM-BBD Reaction': {'data_entry': 'http://umbbd.ethz.ch/servlets/pageservlet?ptype=r&amp;reacID=$id',
                     'example': 'r0001',
                     'name': 'UM-BBD Reaction',
                     'pattern': '^r\\d+$',
                     'url': 'http://identifiers.org/umbbd.reaction/'},
 'UniGene': {'data_entry': 'http://www.ncbi.nlm.nih.gov/unigene?term=$id',
             'example': '4900',
             'name': 'UniGene',
             'pattern': '^\\d+$" restricted="true',
             'url': 'http://identifiers.org/unigene/'},
 'UniParc': {'data_entry': 'http://www.ebi.ac.uk/cgi-bin/dbfetch?db=uniparc&amp;id=$id',
             'example': 'UPI000000000A',
             'name': 'UniParc',
             'pattern': '^UPI[A-F0-9]{10}$',
             'url': 'http://identifiers.org/uniparc/'},
 'UniProt Isoform': {'data_entry': 'http://www.uniprot.org/uniprot/$id',
                     'example': 'Q5BJF6-3',
                     'name': 'UniProt Isoform',
                     'pattern': '^([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9])(\\-\\d+)$" restricted="true',
                     'url': 'http://identifiers.org/uniprot.isoform/'},
 'UniProt Knowledgebase': {'data_entry': 'http://www.uniprot.org/uniprot/$id',
                           'example': 'P62158',
                           'name': 'UniProt Knowledgebase',
                           'pattern': '^([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9])(\\.\\d+)?$',
                           'url': 'http://identifiers.org/uniprot/'},
 'UniSTS': {'data_entry': 'http://www.ncbi.nlm.nih.gov/genome/sts/sts.cgi?uid=$id',
            'example': '456789',
            'name': 'UniSTS',
            'pattern': '^\\d+$',
            'url': 'http://identifiers.org/unists/'},
 'Unipathway': {'data_entry': 'http://www.grenoble.prabi.fr/obiwarehouse/unipathway/upa?upid=$id',
                'example': 'UPA00206',
                'name': 'Unipathway',
                'pattern': '^UPA\\d{5}$',
                'url': 'http://identifiers.org/unipathway/'},
 'Unit Ontology': {'data_entry': 'http://www.ebi.ac.uk/ontology-lookup/?termId=$id',
                   'example': 'UO:0000080',
                   'name': 'Unit Ontology',
                   'pattern': '^UO:\\d{7}?',
                   'url': 'http://identifiers.org/obo.unit/'},
 'Unite': {'data_entry': 'http://unite.ut.ee/bl_forw.php?nimi=$id',
           'example': 'UDB000691',
           'name': 'Unite',
           'pattern': '^UDB\\d{6}$',
           'url': 'http://identifiers.org/unite/'},
 'VIRsiRNA': {'data_entry': 'http://crdd.osdd.net/servers/virsirnadb/record.php?details=$id',
              'example': 'virsi1909',
              'name': 'VIRsiRNA',
              'pattern': '^virsi\\d+$',
              'url': 'http://identifiers.org/virsirna/'},
 'VariO': {'data_entry': 'http://www.variationontology.org/cgi-bin/amivario/term-details.cgi?term=$id',
           'example': 'VariO:0294',
           'name': 'VariO',
           'pattern': '^VariO:\\d+$',
           'url': 'http://identifiers.org/vario/'},
 'Vbase2': {'data_entry': 'http://www.vbase2.org/vgene.php?id=$id',
            'example': 'humIGHV025',
            'name': 'Vbase2',
            'pattern': '^\\w+$" restricted="true',
            'url': 'http://identifiers.org/vbase2/'},
 'VectorBase': {'data_entry': 'http://classic.vectorbase.org/Search/Keyword/?offset=0&amp;term=$id&amp;domain=genome&amp;category=all_organisms',
                'example': 'ISCW007415',
                'name': 'VectorBase',
                'pattern': '^\\D{4}\\d{6}(\\-\\D{2})?$',
                'url': 'http://identifiers.org/vectorbase/'},
 'ViPR Strain': {'data_entry': 'http://www.viprbrc.org/brc/viprStrainDetails.do?strainName=$id&amp;decorator=arena',
                 'example': 'BeAn 70563',
                 'name': 'ViPR Strain',
                 'pattern': '^[A-Za-z 0-9]+$',
                 'url': 'http://identifiers.org/vipr/'},
 'WikiPathways': {'data_entry': 'http://www.wikipathways.org/instance/$id',
                  'example': 'WP100',
                  'name': 'WikiPathways',
                  'pattern': 'WP\\d{1,5}(\\_r\\d+)?$',
                  'url': 'http://identifiers.org/wikipathways/'},
 'Wikipedia (En)': {'data_entry': 'http://en.wikipedia.org/wiki/$id',
                    'example': 'SM_UB-81',
                    'name': 'Wikipedia (En)',
                    'pattern': '^[A-Za-z0-9_]+$" restricted="true',
                    'url': 'http://identifiers.org/wikipedia.en/'},
 'Worfdb': {'data_entry': 'http://worfdb.dfci.harvard.edu/index.php?search_type=name&amp;page=showresultrc&amp;race_query=$id',
            'example': 'T01B6.1',
            'name': 'Worfdb',
            'pattern': '^\\w+(\\.\\d+)?',
            'url': 'http://identifiers.org/worfdb/'},
 'WormBase': {'data_entry': 'http://www.wormbase.org/db/gene/gene?name=$id;class=Gene',
              'example': 'WBGene00000001',
              'name': 'WormBase',
              'pattern': '^WBGene\\d{8}$',
              'url': 'http://identifiers.org/wormbase/'},
 'Wormpep': {'data_entry': 'http://www.wormbase.org/db/seq/protein?name=$id',
             'example': 'CE28239',
             'name': 'Wormpep',
             'pattern': '^CE\\d{5}$',
             'url': 'http://identifiers.org/wormpep/'},
 'Xenbase': {'data_entry': 'http://www.xenbase.org/gene/showgene.do?method=displayGeneSummary&amp;geneId=$id',
             'example': '922462',
             'name': 'Xenbase',
             'pattern': '^(XB-GENE-)?\\d+$',
             'url': 'http://identifiers.org/xenbase/'},
 'YeTFasCo': {'data_entry': 'http://yetfasco.ccbr.utoronto.ca/showPFM.php?mot=$id',
              'example': 'YOR172W_571.0',
              'name': 'YeTFasCo',
              'pattern': '^\\w+\\_\\d+(\\.\\d+)?$',
              'url': 'http://identifiers.org/yetfasco/'},
 'ZFIN Expression': {'data_entry': 'http://zfin.org/action/genotype/show_all_expression?genoID=$id',
                     'example': 'ZDB-GENO-980202-899',
                     'name': 'ZFIN Expression',
                     'pattern': '^ZDB\\-GEN0\\-\\d+\\-\\d+$',
                     'url': 'http://identifiers.org/zfin.expression/'},
 'ZFIN Gene': {'data_entry': 'http://zfin.org/action/marker/view/$id',
               'example': 'ZDB-GENE-041118-11',
               'name': 'ZFIN Gene',
               'pattern': 'ZDB\\-GENE\\-\\d+\\-\\d+',
               'url': 'http://identifiers.org/zfin/'},
 'ZFIN Phenotype': {'data_entry': 'http://zfin.org/action/genotype/show_all_phenotype?zdbID=$id',
                    'example': 'ZDB-GENO-980202-899',
                    'name': 'ZFIN Phenotype',
                    'pattern': '^ZDB\\-GEN0\\-\\d+\\-\\d+$',
                    'url': 'http://identifiers.org/zfin.phenotype/'},
 'arXiv': {'data_entry': 'http://arxiv.org/abs/$id',
           'example': '0807.4956v1',
           'name': 'arXiv',
           'pattern': '^(\\w+(\\-\\w+)?(\\.\\w+)?/)?\\d{4,7}(\\.\\d{4}(v\\d+)?)?$',
           'url': 'http://identifiers.org/arxiv/'},
 'dbEST': {'data_entry': 'http://www.ncbi.nlm.nih.gov/nucest/$id',
           'example': 'BP100000',
           'name': 'dbEST',
           'pattern': '^BP\\d+(\\.\\d+)?$',
           'url': 'http://identifiers.org/dbest/'},
 'dbProbe': {'data_entry': 'http://www.ncbi.nlm.nih.gov/projects/genome/probe/reports/probereport.cgi?uid=$id',
             'example': '1000000',
             'name': 'dbProbe',
             'pattern': '^\\d+$',
             'url': 'http://identifiers.org/dbprobe/'},
 'dbSNP': {'data_entry': 'http://www.ncbi.nlm.nih.gov/projects/SNP/snp_ref.cgi?rs=$id',
           'example': '121909098',
           'name': 'dbSNP',
           'pattern': '^\\d+$',
           'url': 'http://identifiers.org/dbsnp/'},
 'eggNOG': {'data_entry': 'http://eggnog.embl.de/version_3.0/cgi/search.py?search_term_0=$id',
            'example': 'veNOG12876',
            'name': 'eggNOG',
            'pattern': '^\\w+$',
            'url': 'http://identifiers.org/eggnog/'},
 'iRefWeb': {'data_entry': 'http://wodaklab.org/iRefWeb/interaction/show/$id',
             'example': '617102',
             'name': 'iRefWeb',
             'pattern': '^\\d+$',
             'url': 'http://identifiers.org/irefweb/'},
 'miRBase Sequence': {'data_entry': 'http://www.mirbase.org/cgi-bin/mirna_entry.pl?acc=$id',
                      'example': 'MI0000001',
                      'name': 'miRBase Sequence',
                      'pattern': 'MI\\d{7}',
                      'url': 'http://identifiers.org/mirbase/'},
 'miRBase mature sequence': {'data_entry': 'http://www.mirbase.org/cgi-bin/mature.pl?mature_acc=$id',
                             'example': 'MIMAT0000001',
                             'name': 'miRBase mature sequence',
                             'pattern': 'MIMAT\\d{7}',
                             'url': 'http://identifiers.org/mirbase.mature/'},
 'miRNEST': {'data_entry': 'http://lemur.amu.edu.pl/share/php/mirnest/search.php?search_term=$id',
             'example': 'MNEST029358',
             'name': 'miRNEST',
             'pattern': '^MNEST\\d+$',
             'url': 'http://identifiers.org/mirnest/'},
 'mirEX': {'data_entry': 'http://comgen.pl/mirex/?page=results/record&amp;name=$id&amp;web_temp=1683440&amp;exref=pp2a&amp;limit=yes',
           'example': '165a',
           'name': 'mirEX',
           'pattern': '^\\d+(\\w+)?$',
           'url': 'http://identifiers.org/mirex/'},
 'nextProt': {'data_entry': 'http://www.nextprot.org/db/entry/$id',
              'example': 'NX_O00165',
              'name': 'nextProt',
              'pattern': '^NX_\\w+',
              'url': 'http://identifiers.org/nextprot/'},
 'uBio NameBank': {'data_entry': 'http://www.ubio.org/browser/details.php?namebankID=$id',
                   'example': '2555646',
                   'name': 'uBio NameBank',
                   'pattern': '^\\d+$',
                   'url': 'http://identifiers.org/ubio.namebank/'}}
