/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.main.conformhelpers.encode;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.siemens.ct.exi.main.conformhelpers.encode.ChargeParameterDiscoveryRes;
import java.io.IOException;

public class ChargeParameterDiscoveryResEncodeDeserializer
extends StdDeserializer<ChargeParameterDiscoveryRes> {
    public ChargeParameterDiscoveryResEncodeDeserializer() {
        this((Class<?>)null);
    }

    protected ChargeParameterDiscoveryResEncodeDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public ChargeParameterDiscoveryRes deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        ChargeParameterDiscoveryRes cpdr = new ChargeParameterDiscoveryRes();
        cpdr.getAdditionalProperties().put("ResponseCode", node.get("ResponseCode"));
        cpdr.getAdditionalProperties().put("EVSEProcessing", node.get("EVSEProcessing"));
        if (node.has("AC_EVSEChargeParameter")) {
            cpdr.getAdditionalProperties().put("AC_EVSEChargeParameter", node.get("AC_EVSEChargeParameter"));
        }
        if (node.has("SAScheduleList")) {
            cpdr.getAdditionalProperties().put("SAScheduleList", this.GetSAScheduleList(node));
        }
        return cpdr;
    }

    private JsonNode GetSAScheduleList(JsonNode node) throws JsonMappingException, JsonProcessingException {
        ObjectMapper om = new ObjectMapper();
        ObjectNode on = om.createObjectNode();
        ArrayNode services = on.putArray("SAScheduleTuple");
        JsonNode scheduleList = node.get("SAScheduleList");
        for (JsonNode jn : scheduleList) {
            JsonNode scheduleTuple = jn.get("SAScheduleTuple");
            JsonNode pmaxSchedule = this.GetPMAXSchedule(scheduleTuple);
            ObjectNode objectNode = (ObjectNode)scheduleTuple.deepCopy();
            objectNode.replace("PMaxSchedule", pmaxSchedule);
            services.add(objectNode);
        }
        return om.readTree(on.toString());
    }

    private JsonNode GetPMAXSchedule(JsonNode node) throws JsonMappingException, JsonProcessingException {
        ObjectMapper om = new ObjectMapper();
        ObjectNode on = om.createObjectNode();
        ArrayNode services = on.putArray("PMaxScheduleEntry");
        JsonNode scheduleList = node.get("PMaxSchedule");
        for (JsonNode jn : scheduleList) {
            services.add(jn.get("PMaxScheduleEntry"));
        }
        return om.readTree(on.toString());
    }
}

