/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.context;

import com.siemens.ct.exi.core.context.AbstractUriContext;
import com.siemens.ct.exi.core.context.QNameContext;
import java.util.Arrays;

public class GrammarUriContext
extends AbstractUriContext {
    public static String[] EMPTY_PREFIXES = new String[0];
    final QNameContext[] grammarQNames;
    final String[] grammarPrefixes;
    final String defaultPrefix;

    public GrammarUriContext(int namespaceUriID, String namespaceUri, QNameContext[] grammarQNames, String[] grammarPrefixes) {
        super(namespaceUriID, namespaceUri);
        this.grammarQNames = grammarQNames;
        this.grammarPrefixes = grammarPrefixes;
        switch (namespaceUriID) {
            case 0: {
                this.defaultPrefix = "";
                break;
            }
            case 1: {
                this.defaultPrefix = "xml";
                break;
            }
            case 2: {
                this.defaultPrefix = "xsi";
                break;
            }
            default: {
                this.defaultPrefix = "ns" + namespaceUriID;
            }
        }
    }

    public String getDefaultPrefix() {
        return this.defaultPrefix;
    }

    public GrammarUriContext(int namespaceUriID, String namespaceUri, QNameContext[] grammarQNames) {
        this(namespaceUriID, namespaceUri, grammarQNames, EMPTY_PREFIXES);
    }

    @Override
    public int getNumberOfQNames() {
        return this.grammarQNames.length;
    }

    @Override
    public QNameContext getQNameContext(int localNameID) {
        if (localNameID < this.grammarQNames.length) {
            return this.grammarQNames[localNameID];
        }
        return null;
    }

    @Override
    public QNameContext getQNameContext(String localName) {
        assert (localName != null);
        return GrammarUriContext.binarySearch(this.grammarQNames, localName);
    }

    protected static QNameContext binarySearch(QNameContext[] grammarQNames, String localName) {
        if (grammarQNames == null) {
            System.err.println("ERROR null");
        }
        assert (grammarQNames != null);
        int low = 0;
        int high = grammarQNames.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            QNameContext midVal = grammarQNames[mid];
            int cmp = midVal.compareTo(localName);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return midVal;
        }
        return null;
    }

    @Override
    public int getNumberOfPrefixes() {
        return this.grammarPrefixes.length;
    }

    @Override
    public String getPrefix(int prefixID) {
        assert (prefixID >= 0);
        String pfx = null;
        if (prefixID < this.grammarPrefixes.length) {
            pfx = this.grammarPrefixes[prefixID];
        }
        return pfx;
    }

    @Override
    public int getPrefixID(String prefix) {
        int i = 0;
        while (i < this.grammarPrefixes.length) {
            String pfx = this.grammarPrefixes[i];
            if (pfx.equals(prefix)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GrammarUriContext)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GrammarUriContext that = (GrammarUriContext)o;
        if (!super.equals(that)) {
            return false;
        }
        if (!Arrays.equals(this.grammarQNames, that.grammarQNames)) {
            return false;
        }
        if (!Arrays.equals(this.grammarPrefixes, that.grammarPrefixes)) {
            return false;
        }
        return this.defaultPrefix != null ? this.defaultPrefix.equals(that.defaultPrefix) : that.defaultPrefix == null;
    }
}

