# coding: utf-8

"""
    42videobricks

    42videobricks is a Video Platform As A Service (VPaaS)

    The version of the OpenAPI document: 1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic import Field, StrictBool, StrictBytes, StrictInt, StrictStr, conint, constr, validator

from typing import Optional, Union

from Api42Vb.models.video import Video
from Api42Vb.models.video_attachment_list import VideoAttachmentList
from Api42Vb.models.video_list import VideoList
from Api42Vb.models.video_multipart_upload_finalize import VideoMultipartUploadFinalize
from Api42Vb.models.video_multipart_upload_init import VideoMultipartUploadInit
from Api42Vb.models.video_multipart_upload_init_response import VideoMultipartUploadInitResponse
from Api42Vb.models.video_properties import VideoProperties
from Api42Vb.models.video_upload_init_response import VideoUploadInitResponse

from Api42Vb.api_client import ApiClient
from Api42Vb.api_response import ApiResponse
from Api42Vb.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class VideosApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def add_attachment_by_video_id(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], attachment_type : Annotated[StrictStr, Field(..., description="Type of attachment")], locale : Annotated[constr(strict=True), Field(..., description="Le locale value of the attachment")], file : Annotated[Optional[Union[StrictBytes, StrictStr]], Field(description="The file to upload")] = None, **kwargs) -> None:  # noqa: E501
        """Upload an attachement  # noqa: E501

        Upload an attachement file and attached it to a video Currently: - attachement file type is limited to \"subtitle\" and \"caption\" (close caption) - supported file types: SRT (text/plain), VTT (text/vtt)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_attachment_by_video_id(video_id, attachment_type, locale, file, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param attachment_type: Type of attachment (required)
        :type attachment_type: str
        :param locale: Le locale value of the attachment (required)
        :type locale: str
        :param file: The file to upload
        :type file: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the add_attachment_by_video_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.add_attachment_by_video_id_with_http_info(video_id, attachment_type, locale, file, **kwargs)  # noqa: E501

    @validate_arguments
    def add_attachment_by_video_id_with_http_info(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], attachment_type : Annotated[StrictStr, Field(..., description="Type of attachment")], locale : Annotated[constr(strict=True), Field(..., description="Le locale value of the attachment")], file : Annotated[Optional[Union[StrictBytes, StrictStr]], Field(description="The file to upload")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Upload an attachement  # noqa: E501

        Upload an attachement file and attached it to a video Currently: - attachement file type is limited to \"subtitle\" and \"caption\" (close caption) - supported file types: SRT (text/plain), VTT (text/vtt)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_attachment_by_video_id_with_http_info(video_id, attachment_type, locale, file, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param attachment_type: Type of attachment (required)
        :type attachment_type: str
        :param locale: Le locale value of the attachment (required)
        :type locale: str
        :param file: The file to upload
        :type file: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'video_id',
            'attachment_type',
            'locale',
            'file'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_attachment_by_video_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['video_id'] is not None:
            _path_params['videoId'] = _params['video_id']

        if _params['attachment_type'] is not None:
            _path_params['attachmentType'] = _params['attachment_type']

        if _params['locale'] is not None:
            _path_params['locale'] = _params['locale']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        if _params['file'] is not None:
            _files['file'] = _params['file']

        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['api_key']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/videos/{videoId}/attachments/{attachmentType}/{locale}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def add_thumbnail_by_video_id(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], file : Annotated[Optional[Union[StrictBytes, StrictStr]], Field(description="The file to upload")] = None, **kwargs) -> None:  # noqa: E501
        """Upload a thumbnail  # noqa: E501

        Upload an image file and set it as Thumbnail to the video  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_thumbnail_by_video_id(video_id, file, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param file: The file to upload
        :type file: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the add_thumbnail_by_video_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.add_thumbnail_by_video_id_with_http_info(video_id, file, **kwargs)  # noqa: E501

    @validate_arguments
    def add_thumbnail_by_video_id_with_http_info(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], file : Annotated[Optional[Union[StrictBytes, StrictStr]], Field(description="The file to upload")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Upload a thumbnail  # noqa: E501

        Upload an image file and set it as Thumbnail to the video  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_thumbnail_by_video_id_with_http_info(video_id, file, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param file: The file to upload
        :type file: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'video_id',
            'file'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_thumbnail_by_video_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['video_id'] is not None:
            _path_params['videoId'] = _params['video_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        if _params['file'] is not None:
            _files['file'] = _params['file']

        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['api_key']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/videos/{videoId}/thumbnail', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def add_video(self, video_properties : VideoProperties, **kwargs) -> Video:  # noqa: E501
        """Add a new video  # noqa: E501

        You can create a video object by using this endpoint.  Once the video is created you can then upload the video.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_video(video_properties, async_req=True)
        >>> result = thread.get()

        :param video_properties: (required)
        :type video_properties: VideoProperties
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Video
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the add_video_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.add_video_with_http_info(video_properties, **kwargs)  # noqa: E501

    @validate_arguments
    def add_video_with_http_info(self, video_properties : VideoProperties, **kwargs) -> ApiResponse:  # noqa: E501
        """Add a new video  # noqa: E501

        You can create a video object by using this endpoint.  Once the video is created you can then upload the video.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_video_with_http_info(video_properties, async_req=True)
        >>> result = thread.get()

        :param video_properties: (required)
        :type video_properties: VideoProperties
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Video, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'video_properties'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_video" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['video_properties'] is not None:
            _body_params = _params['video_properties']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['api_key']  # noqa: E501

        _response_types_map = {
            '201': "Video",
            '400': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/videos', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_attachment_by_video_id(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], attachment_type : Annotated[StrictStr, Field(..., description="Type of attachment")], locale : Annotated[constr(strict=True), Field(..., description="Le locale value of the attachment")], **kwargs) -> None:  # noqa: E501
        """Delete an attachment  # noqa: E501

        Delete an attachment (and the attached file)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_attachment_by_video_id(video_id, attachment_type, locale, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param attachment_type: Type of attachment (required)
        :type attachment_type: str
        :param locale: Le locale value of the attachment (required)
        :type locale: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_attachment_by_video_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_attachment_by_video_id_with_http_info(video_id, attachment_type, locale, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_attachment_by_video_id_with_http_info(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], attachment_type : Annotated[StrictStr, Field(..., description="Type of attachment")], locale : Annotated[constr(strict=True), Field(..., description="Le locale value of the attachment")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete an attachment  # noqa: E501

        Delete an attachment (and the attached file)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_attachment_by_video_id_with_http_info(video_id, attachment_type, locale, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param attachment_type: Type of attachment (required)
        :type attachment_type: str
        :param locale: Le locale value of the attachment (required)
        :type locale: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'video_id',
            'attachment_type',
            'locale'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_attachment_by_video_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['video_id'] is not None:
            _path_params['videoId'] = _params['video_id']

        if _params['attachment_type'] is not None:
            _path_params['attachmentType'] = _params['attachment_type']

        if _params['locale'] is not None:
            _path_params['locale'] = _params['locale']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['api_key']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/videos/{videoId}/attachments/{attachmentType}/{locale}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_thumbnail_by_video_id(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], **kwargs) -> None:  # noqa: E501
        """Delete a thumbnail  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_thumbnail_by_video_id(video_id, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_thumbnail_by_video_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_thumbnail_by_video_id_with_http_info(video_id, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_thumbnail_by_video_id_with_http_info(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete a thumbnail  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_thumbnail_by_video_id_with_http_info(video_id, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'video_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_thumbnail_by_video_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['video_id'] is not None:
            _path_params['videoId'] = _params['video_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['api_key']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/videos/{videoId}/thumbnail', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_video_by_id(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], **kwargs) -> None:  # noqa: E501
        """Delete a video  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_video_by_id(video_id, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_video_by_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_video_by_id_with_http_info(video_id, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_video_by_id_with_http_info(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete a video  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_video_by_id_with_http_info(video_id, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'video_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_video_by_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['video_id'] is not None:
            _path_params['videoId'] = _params['video_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['api_key']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/videos/{videoId}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def finalize_multipart_upload_video_by_id(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], video_multipart_upload_finalize : Optional[VideoMultipartUploadFinalize] = None, **kwargs) -> None:  # noqa: E501
        """Multipart upload finalization  # noqa: E501

        Once video parts are uploaded, finalize the upload by requesting to transcode the file.  New video file is replacing previous video file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.finalize_multipart_upload_video_by_id(video_id, video_multipart_upload_finalize, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param video_multipart_upload_finalize:
        :type video_multipart_upload_finalize: VideoMultipartUploadFinalize
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the finalize_multipart_upload_video_by_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.finalize_multipart_upload_video_by_id_with_http_info(video_id, video_multipart_upload_finalize, **kwargs)  # noqa: E501

    @validate_arguments
    def finalize_multipart_upload_video_by_id_with_http_info(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], video_multipart_upload_finalize : Optional[VideoMultipartUploadFinalize] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Multipart upload finalization  # noqa: E501

        Once video parts are uploaded, finalize the upload by requesting to transcode the file.  New video file is replacing previous video file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.finalize_multipart_upload_video_by_id_with_http_info(video_id, video_multipart_upload_finalize, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param video_multipart_upload_finalize:
        :type video_multipart_upload_finalize: VideoMultipartUploadFinalize
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'video_id',
            'video_multipart_upload_finalize'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method finalize_multipart_upload_video_by_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['video_id'] is not None:
            _path_params['videoId'] = _params['video_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['video_multipart_upload_finalize'] is not None:
            _body_params = _params['video_multipart_upload_finalize']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['api_key']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/videos/{videoId}/multipart-upload/finalize', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def finalize_upload_video_by_id(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], **kwargs) -> None:  # noqa: E501
        """Single file upload finalization  # noqa: E501

        Once video file is uploaded, finalize the upload by requesting to transcode the file. Finalize apply to the last signedurl provided by the upload initialization.  New video file is replacing previous video file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.finalize_upload_video_by_id(video_id, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the finalize_upload_video_by_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.finalize_upload_video_by_id_with_http_info(video_id, **kwargs)  # noqa: E501

    @validate_arguments
    def finalize_upload_video_by_id_with_http_info(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], **kwargs) -> ApiResponse:  # noqa: E501
        """Single file upload finalization  # noqa: E501

        Once video file is uploaded, finalize the upload by requesting to transcode the file. Finalize apply to the last signedurl provided by the upload initialization.  New video file is replacing previous video file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.finalize_upload_video_by_id_with_http_info(video_id, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'video_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method finalize_upload_video_by_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['video_id'] is not None:
            _path_params['videoId'] = _params['video_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['api_key']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/videos/{videoId}/upload/finalize', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_attachment_by_video_id(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], attachment_type : Annotated[StrictStr, Field(..., description="Type of attachment")], locale : Annotated[constr(strict=True), Field(..., description="Le locale value of the attachment")], **kwargs) -> None:  # noqa: E501
        """Get the attachment  # noqa: E501

        Get a video attachement object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attachment_by_video_id(video_id, attachment_type, locale, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param attachment_type: Type of attachment (required)
        :type attachment_type: str
        :param locale: Le locale value of the attachment (required)
        :type locale: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_attachment_by_video_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_attachment_by_video_id_with_http_info(video_id, attachment_type, locale, **kwargs)  # noqa: E501

    @validate_arguments
    def get_attachment_by_video_id_with_http_info(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], attachment_type : Annotated[StrictStr, Field(..., description="Type of attachment")], locale : Annotated[constr(strict=True), Field(..., description="Le locale value of the attachment")], **kwargs) -> ApiResponse:  # noqa: E501
        """Get the attachment  # noqa: E501

        Get a video attachement object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attachment_by_video_id_with_http_info(video_id, attachment_type, locale, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param attachment_type: Type of attachment (required)
        :type attachment_type: str
        :param locale: Le locale value of the attachment (required)
        :type locale: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'video_id',
            'attachment_type',
            'locale'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_attachment_by_video_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['video_id'] is not None:
            _path_params['videoId'] = _params['video_id']

        if _params['attachment_type'] is not None:
            _path_params['attachmentType'] = _params['attachment_type']

        if _params['locale'] is not None:
            _path_params['locale'] = _params['locale']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['api_key']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/videos/{videoId}/attachments/{attachmentType}/{locale}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_attachment_file_by_video_id(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], attachment_type : Annotated[StrictStr, Field(..., description="Type of attachment")], locale : Annotated[constr(strict=True), Field(..., description="Le locale value of the attachment")], **kwargs) -> None:  # noqa: E501
        """Get attachement file  # noqa: E501

        Get the attachement file Currently only text/plain files are handled.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attachment_file_by_video_id(video_id, attachment_type, locale, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param attachment_type: Type of attachment (required)
        :type attachment_type: str
        :param locale: Le locale value of the attachment (required)
        :type locale: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_attachment_file_by_video_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_attachment_file_by_video_id_with_http_info(video_id, attachment_type, locale, **kwargs)  # noqa: E501

    @validate_arguments
    def get_attachment_file_by_video_id_with_http_info(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], attachment_type : Annotated[StrictStr, Field(..., description="Type of attachment")], locale : Annotated[constr(strict=True), Field(..., description="Le locale value of the attachment")], **kwargs) -> ApiResponse:  # noqa: E501
        """Get attachement file  # noqa: E501

        Get the attachement file Currently only text/plain files are handled.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attachment_file_by_video_id_with_http_info(video_id, attachment_type, locale, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param attachment_type: Type of attachment (required)
        :type attachment_type: str
        :param locale: Le locale value of the attachment (required)
        :type locale: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'video_id',
            'attachment_type',
            'locale'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_attachment_file_by_video_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['video_id'] is not None:
            _path_params['videoId'] = _params['video_id']

        if _params['attachment_type'] is not None:
            _path_params['attachmentType'] = _params['attachment_type']

        if _params['locale'] is not None:
            _path_params['locale'] = _params['locale']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['api_key']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/videos/{videoId}/attachments/{attachmentType}/{locale}/file', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_attachments_by_video_id(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], attachment_type : Annotated[Optional[StrictStr], Field(description="The type of attachments")] = None, locale : Annotated[Optional[constr(strict=True)], Field(description="The locale")] = None, limit : Annotated[Optional[conint(strict=True, le=1000, ge=1)], Field(description="Number of elements to return (default=10)")] = None, offset : Annotated[Optional[StrictInt], Field(description="offset for pagination")] = None, **kwargs) -> VideoAttachmentList:  # noqa: E501
        """List of attachments  # noqa: E501

        Return a list of attachments to a videos  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attachments_by_video_id(video_id, attachment_type, locale, limit, offset, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param attachment_type: The type of attachments
        :type attachment_type: str
        :param locale: The locale
        :type locale: str
        :param limit: Number of elements to return (default=10)
        :type limit: int
        :param offset: offset for pagination
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoAttachmentList
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_attachments_by_video_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_attachments_by_video_id_with_http_info(video_id, attachment_type, locale, limit, offset, **kwargs)  # noqa: E501

    @validate_arguments
    def get_attachments_by_video_id_with_http_info(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], attachment_type : Annotated[Optional[StrictStr], Field(description="The type of attachments")] = None, locale : Annotated[Optional[constr(strict=True)], Field(description="The locale")] = None, limit : Annotated[Optional[conint(strict=True, le=1000, ge=1)], Field(description="Number of elements to return (default=10)")] = None, offset : Annotated[Optional[StrictInt], Field(description="offset for pagination")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List of attachments  # noqa: E501

        Return a list of attachments to a videos  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attachments_by_video_id_with_http_info(video_id, attachment_type, locale, limit, offset, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param attachment_type: The type of attachments
        :type attachment_type: str
        :param locale: The locale
        :type locale: str
        :param limit: Number of elements to return (default=10)
        :type limit: int
        :param offset: offset for pagination
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoAttachmentList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'video_id',
            'attachment_type',
            'locale',
            'limit',
            'offset'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_attachments_by_video_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['video_id'] is not None:
            _path_params['videoId'] = _params['video_id']


        # process the query parameters
        _query_params = []
        if _params.get('attachment_type') is not None:  # noqa: E501
            _query_params.append(('attachmentType', _params['attachment_type']))

        if _params.get('locale') is not None:  # noqa: E501
            _query_params.append(('locale', _params['locale']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['api_key']  # noqa: E501

        _response_types_map = {
            '200': "VideoAttachmentList",
            '400': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/videos/{videoId}/attachments', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_video_by_id(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], token : Annotated[Optional[StrictBool], Field(description="add a token to assets to alloaw access to private video")] = None, **kwargs) -> Video:  # noqa: E501
        """Retun a single video  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_video_by_id(video_id, token, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param token: add a token to assets to alloaw access to private video
        :type token: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Video
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_video_by_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_video_by_id_with_http_info(video_id, token, **kwargs)  # noqa: E501

    @validate_arguments
    def get_video_by_id_with_http_info(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], token : Annotated[Optional[StrictBool], Field(description="add a token to assets to alloaw access to private video")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Retun a single video  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_video_by_id_with_http_info(video_id, token, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param token: add a token to assets to alloaw access to private video
        :type token: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Video, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'video_id',
            'token'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_video_by_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['video_id'] is not None:
            _path_params['videoId'] = _params['video_id']


        # process the query parameters
        _query_params = []
        if _params.get('token') is not None:  # noqa: E501
            _query_params.append(('token', _params['token']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['api_key']  # noqa: E501

        _response_types_map = {
            '200': "Video",
            '400': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/videos/{videoId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_videos(self, limit : Annotated[Optional[conint(strict=True, le=1000, ge=1)], Field(description="Number of elements to return (default=10)")] = None, offset : Annotated[Optional[StrictInt], Field(description="offset for pagination")] = None, search : Annotated[Optional[StrictStr], Field(description="Keywords search in all indexed fields")] = None, sort : Annotated[Optional[StrictStr], Field(description="Sorting results")] = None, **kwargs) -> VideoList:  # noqa: E501
        """List videos  # noqa: E501

        Return the list of videos.  Return an empty list it there is no video to return.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_videos(limit, offset, search, sort, async_req=True)
        >>> result = thread.get()

        :param limit: Number of elements to return (default=10)
        :type limit: int
        :param offset: offset for pagination
        :type offset: int
        :param search: Keywords search in all indexed fields
        :type search: str
        :param sort: Sorting results
        :type sort: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoList
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_videos_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_videos_with_http_info(limit, offset, search, sort, **kwargs)  # noqa: E501

    @validate_arguments
    def get_videos_with_http_info(self, limit : Annotated[Optional[conint(strict=True, le=1000, ge=1)], Field(description="Number of elements to return (default=10)")] = None, offset : Annotated[Optional[StrictInt], Field(description="offset for pagination")] = None, search : Annotated[Optional[StrictStr], Field(description="Keywords search in all indexed fields")] = None, sort : Annotated[Optional[StrictStr], Field(description="Sorting results")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List videos  # noqa: E501

        Return the list of videos.  Return an empty list it there is no video to return.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_videos_with_http_info(limit, offset, search, sort, async_req=True)
        >>> result = thread.get()

        :param limit: Number of elements to return (default=10)
        :type limit: int
        :param offset: offset for pagination
        :type offset: int
        :param search: Keywords search in all indexed fields
        :type search: str
        :param sort: Sorting results
        :type sort: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'offset',
            'search',
            'sort'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_videos" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('search') is not None:  # noqa: E501
            _query_params.append(('search', _params['search']))

        if _params.get('sort') is not None:  # noqa: E501
            _query_params.append(('sort', _params['sort']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['api_key']  # noqa: E501

        _response_types_map = {
            '200': "VideoList",
            '400': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/videos', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def init_multipart_upload_video_by_id(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], video_multipart_upload_init : Optional[VideoMultipartUploadInit] = None, **kwargs) -> VideoMultipartUploadInitResponse:  # noqa: E501
        """Multipart upload intialization  # noqa: E501

        Get signed urls to upload a big file split in multiparts Once the video is uploaded, do not forget to call the multipart upload finalize  New video file is replacing previous video file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.init_multipart_upload_video_by_id(video_id, video_multipart_upload_init, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param video_multipart_upload_init:
        :type video_multipart_upload_init: VideoMultipartUploadInit
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoMultipartUploadInitResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the init_multipart_upload_video_by_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.init_multipart_upload_video_by_id_with_http_info(video_id, video_multipart_upload_init, **kwargs)  # noqa: E501

    @validate_arguments
    def init_multipart_upload_video_by_id_with_http_info(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], video_multipart_upload_init : Optional[VideoMultipartUploadInit] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Multipart upload intialization  # noqa: E501

        Get signed urls to upload a big file split in multiparts Once the video is uploaded, do not forget to call the multipart upload finalize  New video file is replacing previous video file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.init_multipart_upload_video_by_id_with_http_info(video_id, video_multipart_upload_init, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param video_multipart_upload_init:
        :type video_multipart_upload_init: VideoMultipartUploadInit
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoMultipartUploadInitResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'video_id',
            'video_multipart_upload_init'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method init_multipart_upload_video_by_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['video_id'] is not None:
            _path_params['videoId'] = _params['video_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['video_multipart_upload_init'] is not None:
            _body_params = _params['video_multipart_upload_init']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['api_key']  # noqa: E501

        _response_types_map = {
            '200': "VideoMultipartUploadInitResponse",
            '400': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/videos/{videoId}/multipart-upload/init', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def init_upload_video_by_id(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], **kwargs) -> VideoUploadInitResponse:  # noqa: E501
        """Single file upload intialization  # noqa: E501

        Get a single signed url to upload a file Once the video is uploaded, do not forget to call the single upload finalize  File formats currently supported: avi, mov, mp4, mpeg, mpg, mxf, ts. New video file is replacing previous video file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.init_upload_video_by_id(video_id, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoUploadInitResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the init_upload_video_by_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.init_upload_video_by_id_with_http_info(video_id, **kwargs)  # noqa: E501

    @validate_arguments
    def init_upload_video_by_id_with_http_info(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], **kwargs) -> ApiResponse:  # noqa: E501
        """Single file upload intialization  # noqa: E501

        Get a single signed url to upload a file Once the video is uploaded, do not forget to call the single upload finalize  File formats currently supported: avi, mov, mp4, mpeg, mpg, mxf, ts. New video file is replacing previous video file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.init_upload_video_by_id_with_http_info(video_id, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoUploadInitResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'video_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method init_upload_video_by_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['video_id'] is not None:
            _path_params['videoId'] = _params['video_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['api_key']  # noqa: E501

        _response_types_map = {
            '200': "VideoUploadInitResponse",
            '400': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/videos/{videoId}/upload/init', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_video_by_id(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], video_properties : VideoProperties, **kwargs) -> None:  # noqa: E501
        """Update an existing video  # noqa: E501

        Update video properties  Only properties provided are updated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_video_by_id(video_id, video_properties, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param video_properties: (required)
        :type video_properties: VideoProperties
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_video_by_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.update_video_by_id_with_http_info(video_id, video_properties, **kwargs)  # noqa: E501

    @validate_arguments
    def update_video_by_id_with_http_info(self, video_id : Annotated[StrictStr, Field(..., description="Id of the video")], video_properties : VideoProperties, **kwargs) -> ApiResponse:  # noqa: E501
        """Update an existing video  # noqa: E501

        Update video properties  Only properties provided are updated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_video_by_id_with_http_info(video_id, video_properties, async_req=True)
        >>> result = thread.get()

        :param video_id: Id of the video (required)
        :type video_id: str
        :param video_properties: (required)
        :type video_properties: VideoProperties
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'video_id',
            'video_properties'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_video_by_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['video_id'] is not None:
            _path_params['videoId'] = _params['video_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['video_properties'] is not None:
            _body_params = _params['video_properties']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['api_key']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/videos/{videoId}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
