# coding: utf-8

"""
    42videobricks

    42videobricks is a Video Platform As A Service (VPaaS)

    The version of the OpenAPI document: 1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, validator

class VideoAttachment(BaseModel):
    """
    Video Attachment Object  # noqa: E501
    """
    video_id: StrictStr = Field(..., alias="videoId", description="id of the video")
    attachment_type: Optional[StrictStr] = Field('caption', alias="attachmentType", description="Attachment type")
    name: Optional[StrictStr] = Field(None, description="the name of file")
    url: Optional[StrictStr] = Field(None, description="the path of the content")
    locale: Optional[StrictStr] = Field(None, description="the local of attachment")
    __properties = ["videoId", "attachmentType", "name", "url", "locale"]

    @validator('attachment_type')
    def attachment_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('caption', 'subtitle'):
            raise ValueError("must be one of enum values ('caption', 'subtitle')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VideoAttachment:
        """Create an instance of VideoAttachment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VideoAttachment:
        """Create an instance of VideoAttachment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return VideoAttachment.parse_obj(obj)

        _obj = VideoAttachment.parse_obj({
            "video_id": obj.get("videoId"),
            "attachment_type": obj.get("attachmentType") if obj.get("attachmentType") is not None else 'caption',
            "name": obj.get("name"),
            "url": obj.get("url"),
            "locale": obj.get("locale")
        })
        return _obj


