# coding: utf-8

"""
    42videobricks

    42videobricks is a Video Platform As A Service (VPaaS)

    The version of the OpenAPI document: 1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, StrictStr, conlist
from Api42Vb.models.video_multipart_upload_finalize_parts_inner import VideoMultipartUploadFinalizePartsInner

class VideoMultipartUploadFinalize(BaseModel):
    """
    Video Multipart upload finalization  # noqa: E501
    """
    file_id: StrictStr = Field(..., alias="fileId", description="file id")
    file_key: StrictStr = Field(..., alias="fileKey", description="file key")
    parts: conlist(VideoMultipartUploadFinalizePartsInner) = Field(...)
    __properties = ["fileId", "fileKey", "parts"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VideoMultipartUploadFinalize:
        """Create an instance of VideoMultipartUploadFinalize from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in parts (list)
        _items = []
        if self.parts:
            for _item in self.parts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['parts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VideoMultipartUploadFinalize:
        """Create an instance of VideoMultipartUploadFinalize from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return VideoMultipartUploadFinalize.parse_obj(obj)

        _obj = VideoMultipartUploadFinalize.parse_obj({
            "file_id": obj.get("fileId"),
            "file_key": obj.get("fileKey"),
            "parts": [VideoMultipartUploadFinalizePartsInner.from_dict(_item) for _item in obj.get("parts")] if obj.get("parts") is not None else None
        })
        return _obj


