# coding: utf-8

"""
    42videobricks

    42videobricks is a Video Platform As A Service (VPaaS)

    The version of the OpenAPI document: 1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist
from Api42Vb.models.video_multipart_upload_init_response_parts_inner import VideoMultipartUploadInitResponsePartsInner

class VideoMultipartUploadInitResponse(BaseModel):
    """
    Video Mutlipart Upload Init response object  # noqa: E501
    """
    chunk_size: Optional[StrictInt] = Field(None, alias="chunkSize", description="part chunk size")
    file_id: Optional[StrictStr] = Field(None, alias="fileId", description="file id")
    file_key: Optional[StrictStr] = Field(None, alias="fileKey", description="file key")
    parts: Optional[conlist(VideoMultipartUploadInitResponsePartsInner)] = None
    __properties = ["chunkSize", "fileId", "fileKey", "parts"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VideoMultipartUploadInitResponse:
        """Create an instance of VideoMultipartUploadInitResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in parts (list)
        _items = []
        if self.parts:
            for _item in self.parts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['parts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VideoMultipartUploadInitResponse:
        """Create an instance of VideoMultipartUploadInitResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return VideoMultipartUploadInitResponse.parse_obj(obj)

        _obj = VideoMultipartUploadInitResponse.parse_obj({
            "chunk_size": obj.get("chunkSize"),
            "file_id": obj.get("fileId"),
            "file_key": obj.get("fileKey"),
            "parts": [VideoMultipartUploadInitResponsePartsInner.from_dict(_item) for _item in obj.get("parts")] if obj.get("parts") is not None else None
        })
        return _obj


