"""Simple agents that can be used as a baseline or for testing purposes."""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/40_base_agents/11_basic_agents.ipynb.

# %% auto 0
__all__ = ['RandomAgent']

# %% ../../nbs/40_base_agents/11_basic_agents.ipynb 3
from abc import ABC, abstractmethod
from typing import Union, Optional, List
import numpy as np

from ..envs.base import BaseEnvironment
from .base import BaseAgent
from ..utils import MDPInfo

# %% ../../nbs/40_base_agents/11_basic_agents.ipynb 4
class RandomAgent(BaseAgent):

    """
    A random agent that samples actions from the environment's action space. Useful for testing and as minimal baseline.
    """

    def __init__(self,
                environment_info: MDPInfo,
                obsprocessors: list[object] | None = None,
                agent_name: str = "RandomAgent",
                *args,
                **kwargs,
                ):

        super().__init__(environment_info = environment_info, obsprocessors = obsprocessors, agent_name = agent_name)

    def draw_action_(self, observation):
        return self.environment_info.action_space.sample()

    def fit(self, X, Y):
        assert self.mode == "train"
        pass

    def save(self, path):
        pass

    def load(self, path):
        pass
