"""Dict of agent classes and (standard) agent names to allow for dynamic loading of agents."""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/40_base_agents/10_AGENT_CLASSES.ipynb.

# %% auto 0
__all__ = ['AGENT_CLASSES']

# %% ../../nbs/40_base_agents/10_AGENT_CLASSES.ipynb 3
AGENT_CLASSES = {
    "RandomAgent": "ddopai.agents.saa.SAA",

    "SAA": "ddopai.agents.newsvendor.saa.NewsvendorSAAagent",
    "wSAA": "ddopai.agents.newsvendor.saa.NewsvendorRFwSAAagent",
    "RFwSAA": "ddopai.agents.newsvendor.saa.NewsvendorRFwSAAagent",

    "XGB": "ddopai.agents.newsvendor.erm.NewsvendorXGBAgent",

    "lERM": "ddopai.agents.newsvendor.erm.NewsvendorlERMAgent",
    "DLNV": "ddopai.agents.newsvendor.erm.NewsvendorDLAgent",
    "DLNVRNN": "ddopai.agents.newsvendor.erm.NewsvendorDLRNNAgent",
    "DLNVTransformer": "ddopai.agents.newsvendor.erm.NewsvendorDLTransformerAgent",

    "lERMMeta": "ddopai.agents.newsvendor.erm.NewsvendorlERMMetaAgent",
    "DLNVMeta": "ddopai.agents.newsvendor.erm.NewsvendorDLMetaAgent",
    "DLNVRNNMeta": "ddopai.agents.newsvendor.erm.NewsvendorDLRNNMetaAgent",
    "DLNVTransformerMeta": "ddopai.agents.newsvendor.erm.NewsvendorDLTransformerMetaAgent",

    "SAC": "ddopai.agents.rl.sac.SACAgent",
    "SACRNN": "ddopai.agents.rl.sac.SACRNNAgent",

    "TD3": "ddopai.agents.rl.td3.TD3Agent",
    "PPO": "ddopai.agents.rl.ppo.PPOAgent",
}
