"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DetectorModel = exports.EventEvaluation = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iotevents_1 = require("aws-cdk-lib/aws-iotevents");
/**
 * Information about the order in which events are evaluated and how actions are executed.
 */
var EventEvaluation;
(function (EventEvaluation) {
    /**
     * When setting to BATCH, variables within a state are updated and events within a state are
     * performed only after all event conditions are evaluated.
     */
    EventEvaluation["BATCH"] = "BATCH";
    /**
     * When setting to SERIAL, variables are updated and event conditions are evaluated in the order
     * that the events are defined.
     */
    EventEvaluation["SERIAL"] = "SERIAL";
})(EventEvaluation = exports.EventEvaluation || (exports.EventEvaluation = {}));
/**
 * Defines an AWS IoT Events detector model in this stack.
 */
class DetectorModel extends aws_cdk_lib_1.Resource {
    /**
     * Import an existing detector model.
     */
    static fromDetectorModelName(scope, id, detectorModelName) {
        return new class extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.detectorModelName = detectorModelName;
            }
        }(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.detectorModelName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_DetectorModelProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DetectorModel);
            }
            throw error;
        }
        if (!props.initialState._onEnterEventsHaveAtLeastOneCondition()) {
            throw new Error('Detector Model must have at least one Input with a condition');
        }
        const role = props.role ?? new iam.Role(this, 'DetectorModelRole', {
            assumedBy: new iam.ServicePrincipal('iotevents.amazonaws.com'),
        });
        const resource = new aws_iotevents_1.CfnDetectorModel(this, 'Resource', {
            detectorModelName: this.physicalName,
            detectorModelDescription: props.description,
            evaluationMethod: props.evaluationMethod,
            key: props.detectorKey,
            detectorModelDefinition: {
                initialStateName: props.initialState.stateName,
                states: props.initialState._collectStateJsons(this, { role }, new Set()),
            },
            roleArn: role.roleArn,
        });
        this.detectorModelName = this.getResourceNameAttribute(resource.ref);
    }
}
_a = JSII_RTTI_SYMBOL_1;
DetectorModel[_a] = { fqn: "@aws-cdk/aws-iotevents-alpha.DetectorModel", version: "2.83.1-alpha.0" };
exports.DetectorModel = DetectorModel;
//# sourceMappingURL=data:application/json;base64,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