"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from orq_poc_python_client.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional, Union
from typing_extensions import NotRequired, TypedDict


class Quality(str, Enum):
    r"""The quality of the image"""

    STANDARD = "standard"
    HD = "hd"


class ResponseFormat(str, Enum):
    r"""The format of the image"""

    URL = "url"
    B64_JSON = "b64_json"


class Size(str, Enum):
    r"""The size of the image"""

    TWO_HUNDRED_AND_FIFTY_SIXX256 = "256x256"
    FIVE_HUNDRED_AND_TWELVEX512 = "512x512"
    ONE_THOUSAND_AND_TWENTY_FOURX1024 = "1024x1024"


class RouterImageGenerationsRequestBodyTypedDict(TypedDict):
    r"""A request body that follows the official OpenAI schema"""

    prompt: str
    r"""The prompt to generate an image"""
    model: NotRequired[str]
    r"""The model to use for generation"""
    n: NotRequired[float]
    r"""The number of images to generate"""
    quality: NotRequired[Quality]
    r"""The quality of the image"""
    response_format: NotRequired[ResponseFormat]
    r"""The format of the image"""
    size: NotRequired[Size]
    r"""The size of the image"""
    style: NotRequired[str]
    r"""The style of the image"""
    user: NotRequired[str]
    r"""The user who created the image"""


class RouterImageGenerationsRequestBody(BaseModel):
    r"""A request body that follows the official OpenAI schema"""

    prompt: str
    r"""The prompt to generate an image"""

    model: Optional[str] = "openai/dall-e-2"
    r"""The model to use for generation"""

    n: Optional[float] = 1
    r"""The number of images to generate"""

    quality: Optional[Quality] = Quality.STANDARD
    r"""The quality of the image"""

    response_format: Optional[ResponseFormat] = ResponseFormat.URL
    r"""The format of the image"""

    size: Optional[Size] = Size.ONE_THOUSAND_AND_TWENTY_FOURX1024
    r"""The size of the image"""

    style: Optional[str] = "vivid"
    r"""The style of the image"""

    user: Optional[str] = None
    r"""The user who created the image"""


class RouterImageGenerationsMessageRouterImagesResponseRole(str, Enum):
    r"""The role of the prompt message"""

    SYSTEM = "system"
    ASSISTANT = "assistant"
    USER = "user"
    EXCEPTION = "exception"
    TOOL = "tool"
    PROMPT = "prompt"
    CORRECTION = "correction"
    EXPECTED_OUTPUT = "expected_output"


class RouterImageGenerationsMessageType(str, Enum):
    FUNCTION = "function"


class RouterImageGenerationsMessageFunctionTypedDict(TypedDict):
    name: str
    arguments: str
    r"""JSON string arguments for the functions"""


class RouterImageGenerationsMessageFunction(BaseModel):
    name: str

    arguments: str
    r"""JSON string arguments for the functions"""


class RouterImageGenerationsMessageToolCallsTypedDict(TypedDict):
    type: RouterImageGenerationsMessageType
    function: RouterImageGenerationsMessageFunctionTypedDict
    id: NotRequired[str]
    index: NotRequired[float]


class RouterImageGenerationsMessageToolCalls(BaseModel):
    type: RouterImageGenerationsMessageType

    function: RouterImageGenerationsMessageFunction

    id: Optional[str] = None

    index: Optional[float] = None


class RouterImageGenerationsMessage3TypedDict(TypedDict):
    role: RouterImageGenerationsMessageRouterImagesResponseRole
    r"""The role of the prompt message"""
    tool_calls: List[RouterImageGenerationsMessageToolCallsTypedDict]


class RouterImageGenerationsMessage3(BaseModel):
    role: RouterImageGenerationsMessageRouterImagesResponseRole
    r"""The role of the prompt message"""

    tool_calls: List[RouterImageGenerationsMessageToolCalls]


class RouterImageGenerationsMessageRouterImagesRole(str, Enum):
    r"""The role of the prompt message"""

    SYSTEM = "system"
    ASSISTANT = "assistant"
    USER = "user"
    EXCEPTION = "exception"
    TOOL = "tool"
    PROMPT = "prompt"
    CORRECTION = "correction"
    EXPECTED_OUTPUT = "expected_output"


class RouterImageGenerationsMessage2TypedDict(TypedDict):
    role: RouterImageGenerationsMessageRouterImagesRole
    r"""The role of the prompt message"""
    url: str


class RouterImageGenerationsMessage2(BaseModel):
    role: RouterImageGenerationsMessageRouterImagesRole
    r"""The role of the prompt message"""

    url: str


class RouterImageGenerationsMessageRole(str, Enum):
    r"""The role of the prompt message"""

    SYSTEM = "system"
    ASSISTANT = "assistant"
    USER = "user"
    EXCEPTION = "exception"
    TOOL = "tool"
    PROMPT = "prompt"
    CORRECTION = "correction"
    EXPECTED_OUTPUT = "expected_output"


class RouterImageGenerationsMessage1TypedDict(TypedDict):
    role: RouterImageGenerationsMessageRole
    r"""The role of the prompt message"""
    content: Nullable[str]


class RouterImageGenerationsMessage1(BaseModel):
    role: RouterImageGenerationsMessageRole
    r"""The role of the prompt message"""

    content: Nullable[str]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["content"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


RouterImageGenerationsMessageTypedDict = Union[
    RouterImageGenerationsMessage1TypedDict,
    RouterImageGenerationsMessage2TypedDict,
    RouterImageGenerationsMessage3TypedDict,
]


RouterImageGenerationsMessage = Union[
    RouterImageGenerationsMessage1,
    RouterImageGenerationsMessage2,
    RouterImageGenerationsMessage3,
]


class RouterImageGenerationsChoicesTypedDict(TypedDict):
    index: float
    r"""The index of the choice in the list of choices."""
    finish_reason: NotRequired[Nullable[str]]
    r"""The reason for finishing the generation"""
    message: NotRequired[RouterImageGenerationsMessageTypedDict]


class RouterImageGenerationsChoices(BaseModel):
    index: float
    r"""The index of the choice in the list of choices."""

    finish_reason: OptionalNullable[str] = UNSET
    r"""The reason for finishing the generation"""

    message: Optional[RouterImageGenerationsMessage] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["finish_reason", "message"]
        nullable_fields = ["finish_reason"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class RouterImageGenerationsResponseBodyTypedDict(TypedDict):
    r"""A response body that follows the official OpenAI schema"""

    id: str
    r"""The unique identifier of the created image"""
    created: float
    choices: List[RouterImageGenerationsChoicesTypedDict]
    r"""The list of create image choices the model generated for the prompt."""
    model: str
    r"""The model used for the image creation."""
    object: str
    r"""The object type"""


class RouterImageGenerationsResponseBody(BaseModel):
    r"""A response body that follows the official OpenAI schema"""

    id: str
    r"""The unique identifier of the created image"""

    created: float

    choices: List[RouterImageGenerationsChoices]
    r"""The list of create image choices the model generated for the prompt."""

    model: str
    r"""The model used for the image creation."""

    object: str
    r"""The object type"""
