import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [iotfleethub](https://docs.aws.amazon.com/service-authorization/latest/reference/list_fleethubforawsiotdevicemanagement.html).
 *
 * @experimental
 */
export declare class Iotfleethub extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to create an application.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sso:CreateManagedApplicationInstance
     * - sso:DescribeRegisteredRegions
     *
     * @experimental
     */
    toCreateApplication(): this;
    /**
     * (experimental) Grants permission to create an dashboard.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * @experimental
     */
    toCreateDashboard(): this;
    /**
     * (experimental) Grants permission to delete an application.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso:DeleteManagedApplicationInstance
     *
     * @experimental
     */
    toDeleteApplication(): this;
    /**
     * (experimental) Grants permission to delete an dashboard.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toDeleteDashboard(): this;
    /**
     * (experimental) Grants permission to describe an application.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toDescribeApplication(): this;
    /**
     * (experimental) Grants permission to describe an dashboard.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toDescribeDashboard(): this;
    /**
     * (experimental) Grants permission to list all applications.
     *
     * Access Level: List
     *
     * @experimental
     */
    toListApplications(): this;
    /**
     * (experimental) Grants permission to list all dashboards.
     *
     * Access Level: List
     *
     * @experimental
     */
    toListDashboards(): this;
    /**
     * (experimental) Grants permission to list all tags for a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/APIReference/API_Operations.htmlAPI_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to tag a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/iot/latest/APIReference/API_Operations.htmlAPI_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to untag a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/APIReference/API_Operations.htmlAPI_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update an application.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toUpdateApplication(): this;
    /**
     * (experimental) Grants permission to update an dashboard.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toUpdateDashboard(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type application to the statement.
     *
     * @param applicationId - Identifier for the applicationId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onApplication(applicationId: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type dashboard to the statement.
     *
     * @param dashboardId - Identifier for the dashboardId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDashboard(dashboardId: string, account?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [iotfleethub](https://docs.aws.amazon.com/service-authorization/latest/reference/list_fleethubforawsiotdevicemanagement.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
