"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 400.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  # noqa: E501

    The version of the OpenAPI document: 2.0.13
    Contact: info@fattureincloud.it
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from fattureincloud_python_sdk.api_client import ApiClient, Endpoint as _Endpoint
from fattureincloud_python_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fattureincloud_python_sdk.model.create_payment_account_request import CreatePaymentAccountRequest
from fattureincloud_python_sdk.model.create_payment_account_response import CreatePaymentAccountResponse
from fattureincloud_python_sdk.model.create_payment_method_request import CreatePaymentMethodRequest
from fattureincloud_python_sdk.model.create_payment_method_response import CreatePaymentMethodResponse
from fattureincloud_python_sdk.model.create_vat_type_request import CreateVatTypeRequest
from fattureincloud_python_sdk.model.create_vat_type_response import CreateVatTypeResponse
from fattureincloud_python_sdk.model.get_payment_account_response import GetPaymentAccountResponse
from fattureincloud_python_sdk.model.get_payment_method_response import GetPaymentMethodResponse
from fattureincloud_python_sdk.model.get_vat_type_response import GetVatTypeResponse
from fattureincloud_python_sdk.model.modify_payment_account_request import ModifyPaymentAccountRequest
from fattureincloud_python_sdk.model.modify_payment_account_response import ModifyPaymentAccountResponse
from fattureincloud_python_sdk.model.modify_payment_method_request import ModifyPaymentMethodRequest
from fattureincloud_python_sdk.model.modify_payment_method_response import ModifyPaymentMethodResponse
from fattureincloud_python_sdk.model.modify_vat_type_request import ModifyVatTypeRequest
from fattureincloud_python_sdk.model.modify_vat_type_response import ModifyVatTypeResponse


class SettingsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_payment_account_endpoint = _Endpoint(
            settings={
                'response_type': (CreatePaymentAccountResponse,),
                'auth': [
                    'OAuth2AuthenticationCodeFlow'
                ],
                'endpoint_path': '/c/{company_id}/settings/payment_accounts',
                'operation_id': 'create_payment_account',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'company_id',
                    'create_payment_account_request',
                ],
                'required': [
                    'company_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'company_id':
                        (int,),
                    'create_payment_account_request':
                        (CreatePaymentAccountRequest,),
                },
                'attribute_map': {
                    'company_id': 'company_id',
                },
                'location_map': {
                    'company_id': 'path',
                    'create_payment_account_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_payment_method_endpoint = _Endpoint(
            settings={
                'response_type': (CreatePaymentMethodResponse,),
                'auth': [
                    'OAuth2AuthenticationCodeFlow'
                ],
                'endpoint_path': '/c/{company_id}/settings/payment_methods',
                'operation_id': 'create_payment_method',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'company_id',
                    'create_payment_method_request',
                ],
                'required': [
                    'company_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'company_id':
                        (int,),
                    'create_payment_method_request':
                        (CreatePaymentMethodRequest,),
                },
                'attribute_map': {
                    'company_id': 'company_id',
                },
                'location_map': {
                    'company_id': 'path',
                    'create_payment_method_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_vat_type_endpoint = _Endpoint(
            settings={
                'response_type': (CreateVatTypeResponse,),
                'auth': [
                    'OAuth2AuthenticationCodeFlow'
                ],
                'endpoint_path': '/c/{company_id}/settings/vat_types',
                'operation_id': 'create_vat_type',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'company_id',
                    'create_vat_type_request',
                ],
                'required': [
                    'company_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'company_id':
                        (int,),
                    'create_vat_type_request':
                        (CreateVatTypeRequest,),
                },
                'attribute_map': {
                    'company_id': 'company_id',
                },
                'location_map': {
                    'company_id': 'path',
                    'create_vat_type_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_payment_account_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth2AuthenticationCodeFlow'
                ],
                'endpoint_path': '/c/{company_id}/settings/payment_accounts/{payment_account_id}',
                'operation_id': 'delete_payment_account',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'company_id',
                    'payment_account_id',
                ],
                'required': [
                    'company_id',
                    'payment_account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'company_id':
                        (int,),
                    'payment_account_id':
                        (int,),
                },
                'attribute_map': {
                    'company_id': 'company_id',
                    'payment_account_id': 'payment_account_id',
                },
                'location_map': {
                    'company_id': 'path',
                    'payment_account_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_payment_method_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth2AuthenticationCodeFlow'
                ],
                'endpoint_path': '/c/{company_id}/settings/payment_methods/{payment_method_id}',
                'operation_id': 'delete_payment_method',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'company_id',
                    'payment_method_id',
                ],
                'required': [
                    'company_id',
                    'payment_method_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'company_id':
                        (int,),
                    'payment_method_id':
                        (int,),
                },
                'attribute_map': {
                    'company_id': 'company_id',
                    'payment_method_id': 'payment_method_id',
                },
                'location_map': {
                    'company_id': 'path',
                    'payment_method_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_vat_type_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth2AuthenticationCodeFlow'
                ],
                'endpoint_path': '/c/{company_id}/settings/vat_types/{vat_type_id}',
                'operation_id': 'delete_vat_type',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'company_id',
                    'vat_type_id',
                ],
                'required': [
                    'company_id',
                    'vat_type_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'company_id':
                        (int,),
                    'vat_type_id':
                        (int,),
                },
                'attribute_map': {
                    'company_id': 'company_id',
                    'vat_type_id': 'vat_type_id',
                },
                'location_map': {
                    'company_id': 'path',
                    'vat_type_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_payment_account_endpoint = _Endpoint(
            settings={
                'response_type': (GetPaymentAccountResponse,),
                'auth': [
                    'OAuth2AuthenticationCodeFlow'
                ],
                'endpoint_path': '/c/{company_id}/settings/payment_accounts/{payment_account_id}',
                'operation_id': 'get_payment_account',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'company_id',
                    'payment_account_id',
                    'fields',
                    'fieldset',
                ],
                'required': [
                    'company_id',
                    'payment_account_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fieldset',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fieldset',): {

                        "BASIC": "basic",
                        "DETAILED": "detailed"
                    },
                },
                'openapi_types': {
                    'company_id':
                        (int,),
                    'payment_account_id':
                        (int,),
                    'fields':
                        (str,),
                    'fieldset':
                        (str,),
                },
                'attribute_map': {
                    'company_id': 'company_id',
                    'payment_account_id': 'payment_account_id',
                    'fields': 'fields',
                    'fieldset': 'fieldset',
                },
                'location_map': {
                    'company_id': 'path',
                    'payment_account_id': 'path',
                    'fields': 'query',
                    'fieldset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_payment_method_endpoint = _Endpoint(
            settings={
                'response_type': (GetPaymentMethodResponse,),
                'auth': [
                    'OAuth2AuthenticationCodeFlow'
                ],
                'endpoint_path': '/c/{company_id}/settings/payment_methods/{payment_method_id}',
                'operation_id': 'get_payment_method',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'company_id',
                    'payment_method_id',
                    'fields',
                    'fieldset',
                ],
                'required': [
                    'company_id',
                    'payment_method_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fieldset',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fieldset',): {

                        "BASIC": "basic",
                        "DETAILED": "detailed"
                    },
                },
                'openapi_types': {
                    'company_id':
                        (int,),
                    'payment_method_id':
                        (int,),
                    'fields':
                        (str,),
                    'fieldset':
                        (str,),
                },
                'attribute_map': {
                    'company_id': 'company_id',
                    'payment_method_id': 'payment_method_id',
                    'fields': 'fields',
                    'fieldset': 'fieldset',
                },
                'location_map': {
                    'company_id': 'path',
                    'payment_method_id': 'path',
                    'fields': 'query',
                    'fieldset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_vat_type_endpoint = _Endpoint(
            settings={
                'response_type': (GetVatTypeResponse,),
                'auth': [
                    'OAuth2AuthenticationCodeFlow'
                ],
                'endpoint_path': '/c/{company_id}/settings/vat_types/{vat_type_id}',
                'operation_id': 'get_vat_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'company_id',
                    'vat_type_id',
                ],
                'required': [
                    'company_id',
                    'vat_type_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'company_id':
                        (int,),
                    'vat_type_id':
                        (int,),
                },
                'attribute_map': {
                    'company_id': 'company_id',
                    'vat_type_id': 'vat_type_id',
                },
                'location_map': {
                    'company_id': 'path',
                    'vat_type_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.modify_payment_account_endpoint = _Endpoint(
            settings={
                'response_type': (ModifyPaymentAccountResponse,),
                'auth': [
                    'OAuth2AuthenticationCodeFlow'
                ],
                'endpoint_path': '/c/{company_id}/settings/payment_accounts/{payment_account_id}',
                'operation_id': 'modify_payment_account',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'company_id',
                    'payment_account_id',
                    'modify_payment_account_request',
                ],
                'required': [
                    'company_id',
                    'payment_account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'company_id':
                        (int,),
                    'payment_account_id':
                        (int,),
                    'modify_payment_account_request':
                        (ModifyPaymentAccountRequest,),
                },
                'attribute_map': {
                    'company_id': 'company_id',
                    'payment_account_id': 'payment_account_id',
                },
                'location_map': {
                    'company_id': 'path',
                    'payment_account_id': 'path',
                    'modify_payment_account_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.modify_payment_method_endpoint = _Endpoint(
            settings={
                'response_type': (ModifyPaymentMethodResponse,),
                'auth': [
                    'OAuth2AuthenticationCodeFlow'
                ],
                'endpoint_path': '/c/{company_id}/settings/payment_methods/{payment_method_id}',
                'operation_id': 'modify_payment_method',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'company_id',
                    'payment_method_id',
                    'modify_payment_method_request',
                ],
                'required': [
                    'company_id',
                    'payment_method_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'company_id':
                        (int,),
                    'payment_method_id':
                        (int,),
                    'modify_payment_method_request':
                        (ModifyPaymentMethodRequest,),
                },
                'attribute_map': {
                    'company_id': 'company_id',
                    'payment_method_id': 'payment_method_id',
                },
                'location_map': {
                    'company_id': 'path',
                    'payment_method_id': 'path',
                    'modify_payment_method_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.modify_vat_type_endpoint = _Endpoint(
            settings={
                'response_type': (ModifyVatTypeResponse,),
                'auth': [
                    'OAuth2AuthenticationCodeFlow'
                ],
                'endpoint_path': '/c/{company_id}/settings/vat_types/{vat_type_id}',
                'operation_id': 'modify_vat_type',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'company_id',
                    'vat_type_id',
                    'modify_vat_type_request',
                ],
                'required': [
                    'company_id',
                    'vat_type_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'company_id':
                        (int,),
                    'vat_type_id':
                        (int,),
                    'modify_vat_type_request':
                        (ModifyVatTypeRequest,),
                },
                'attribute_map': {
                    'company_id': 'company_id',
                    'vat_type_id': 'vat_type_id',
                },
                'location_map': {
                    'company_id': 'path',
                    'vat_type_id': 'path',
                    'modify_vat_type_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_payment_account(
        self,
        company_id,
        **kwargs
    ):
        """Create Payment Account  # noqa: E501

        Creates a new payment account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_payment_account(company_id, async_req=True)
        >>> result = thread.get()

        Args:
            company_id (int): The ID of the company.

        Keyword Args:
            create_payment_account_request (CreatePaymentAccountRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreatePaymentAccountResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['company_id'] = \
            company_id
        return self.create_payment_account_endpoint.call_with_http_info(**kwargs)

    def create_payment_method(
        self,
        company_id,
        **kwargs
    ):
        """Create Payment Method  # noqa: E501

        Creates a new payment method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_payment_method(company_id, async_req=True)
        >>> result = thread.get()

        Args:
            company_id (int): The ID of the company.

        Keyword Args:
            create_payment_method_request (CreatePaymentMethodRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreatePaymentMethodResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['company_id'] = \
            company_id
        return self.create_payment_method_endpoint.call_with_http_info(**kwargs)

    def create_vat_type(
        self,
        company_id,
        **kwargs
    ):
        """Create Vat Type  # noqa: E501

        Creates a vat type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_vat_type(company_id, async_req=True)
        >>> result = thread.get()

        Args:
            company_id (int): The ID of the company.

        Keyword Args:
            create_vat_type_request (CreateVatTypeRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CreateVatTypeResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['company_id'] = \
            company_id
        return self.create_vat_type_endpoint.call_with_http_info(**kwargs)

    def delete_payment_account(
        self,
        company_id,
        payment_account_id,
        **kwargs
    ):
        """Delete Payment Account  # noqa: E501

        Deletes the specified payment account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_payment_account(company_id, payment_account_id, async_req=True)
        >>> result = thread.get()

        Args:
            company_id (int): The ID of the company.
            payment_account_id (int): The Referred Payment Account Id.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['company_id'] = \
            company_id
        kwargs['payment_account_id'] = \
            payment_account_id
        return self.delete_payment_account_endpoint.call_with_http_info(**kwargs)

    def delete_payment_method(
        self,
        company_id,
        payment_method_id,
        **kwargs
    ):
        """Delete Payment Method  # noqa: E501

        Deletes the specified payment method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_payment_method(company_id, payment_method_id, async_req=True)
        >>> result = thread.get()

        Args:
            company_id (int): The ID of the company.
            payment_method_id (int): The Referred Payment Method Id.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['company_id'] = \
            company_id
        kwargs['payment_method_id'] = \
            payment_method_id
        return self.delete_payment_method_endpoint.call_with_http_info(**kwargs)

    def delete_vat_type(
        self,
        company_id,
        vat_type_id,
        **kwargs
    ):
        """Delete Vat Type  # noqa: E501

        Deletes the specified vat type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_vat_type(company_id, vat_type_id, async_req=True)
        >>> result = thread.get()

        Args:
            company_id (int): The ID of the company.
            vat_type_id (int): The Referred Vat Type Id.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['company_id'] = \
            company_id
        kwargs['vat_type_id'] = \
            vat_type_id
        return self.delete_vat_type_endpoint.call_with_http_info(**kwargs)

    def get_payment_account(
        self,
        company_id,
        payment_account_id,
        **kwargs
    ):
        """Get Payment Account  # noqa: E501

        Gets the specified payment account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_payment_account(company_id, payment_account_id, async_req=True)
        >>> result = thread.get()

        Args:
            company_id (int): The ID of the company.
            payment_account_id (int): The Referred Payment Account Id.

        Keyword Args:
            fields (str): List of comma-separated fields.. [optional]
            fieldset (str): Name of the fieldset.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetPaymentAccountResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['company_id'] = \
            company_id
        kwargs['payment_account_id'] = \
            payment_account_id
        return self.get_payment_account_endpoint.call_with_http_info(**kwargs)

    def get_payment_method(
        self,
        company_id,
        payment_method_id,
        **kwargs
    ):
        """Get Payment Method  # noqa: E501

        Gets the specified payment method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_payment_method(company_id, payment_method_id, async_req=True)
        >>> result = thread.get()

        Args:
            company_id (int): The ID of the company.
            payment_method_id (int): The Referred Payment Method Id.

        Keyword Args:
            fields (str): List of comma-separated fields.. [optional]
            fieldset (str): Name of the fieldset.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetPaymentMethodResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['company_id'] = \
            company_id
        kwargs['payment_method_id'] = \
            payment_method_id
        return self.get_payment_method_endpoint.call_with_http_info(**kwargs)

    def get_vat_type(
        self,
        company_id,
        vat_type_id,
        **kwargs
    ):
        """Get Vat Type  # noqa: E501

        Gets the specified vat type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vat_type(company_id, vat_type_id, async_req=True)
        >>> result = thread.get()

        Args:
            company_id (int): The ID of the company.
            vat_type_id (int): The Referred Vat Type Id.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetVatTypeResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['company_id'] = \
            company_id
        kwargs['vat_type_id'] = \
            vat_type_id
        return self.get_vat_type_endpoint.call_with_http_info(**kwargs)

    def modify_payment_account(
        self,
        company_id,
        payment_account_id,
        **kwargs
    ):
        """Modify Payment Account  # noqa: E501

        Modifies the specified payment account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.modify_payment_account(company_id, payment_account_id, async_req=True)
        >>> result = thread.get()

        Args:
            company_id (int): The ID of the company.
            payment_account_id (int): The Referred Payment Account Id.

        Keyword Args:
            modify_payment_account_request (ModifyPaymentAccountRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ModifyPaymentAccountResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['company_id'] = \
            company_id
        kwargs['payment_account_id'] = \
            payment_account_id
        return self.modify_payment_account_endpoint.call_with_http_info(**kwargs)

    def modify_payment_method(
        self,
        company_id,
        payment_method_id,
        **kwargs
    ):
        """Modify Payment Method  # noqa: E501

        Modifies the specified payment method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.modify_payment_method(company_id, payment_method_id, async_req=True)
        >>> result = thread.get()

        Args:
            company_id (int): The ID of the company.
            payment_method_id (int): The Referred Payment Method Id.

        Keyword Args:
            modify_payment_method_request (ModifyPaymentMethodRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ModifyPaymentMethodResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['company_id'] = \
            company_id
        kwargs['payment_method_id'] = \
            payment_method_id
        return self.modify_payment_method_endpoint.call_with_http_info(**kwargs)

    def modify_vat_type(
        self,
        company_id,
        vat_type_id,
        **kwargs
    ):
        """Modify Vat Type  # noqa: E501

        Modifies the specified vat type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.modify_vat_type(company_id, vat_type_id, async_req=True)
        >>> result = thread.get()

        Args:
            company_id (int): The ID of the company.
            vat_type_id (int): The Referred Vat Type Id.

        Keyword Args:
            modify_vat_type_request (ModifyVatTypeRequest): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ModifyVatTypeResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['company_id'] = \
            company_id
        kwargs['vat_type_id'] = \
            vat_type_id
        return self.modify_vat_type_endpoint.call_with_http_info(**kwargs)

