"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompositePrincipal = exports.StarPrincipal = exports.Anyone = exports.AnyPrincipal = exports.AccountRootPrincipal = exports.SamlConsolePrincipal = exports.SamlPrincipal = exports.OpenIdConnectPrincipal = exports.WebIdentityPrincipal = exports.FederatedPrincipal = exports.CanonicalUserPrincipal = exports.OrganizationPrincipal = exports.ServicePrincipal = exports.AccountPrincipal = exports.ArnPrincipal = exports.PrincipalPolicyFragment = exports.SessionTagsPrincipal = exports.PrincipalWithConditions = exports.PrincipalBase = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const region_info_1 = require("@aws-cdk/region-info");
const policy_statement_1 = require("./policy-statement");
const assume_role_policy_1 = require("./private/assume-role-policy");
const util_1 = require("./util");
/**
 * Base class for policy principals
 */
class PrincipalBase {
    constructor() {
        this.grantPrincipal = this;
        this.principalAccount = undefined;
        /**
         * When this Principal is used in an AssumeRole policy, the action to use.
         */
        this.assumeRoleAction = 'sts:AssumeRole';
    }
    addToPolicy(statement) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_PolicyStatement(statement);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addToPolicy);
            }
            throw error;
        }
        return this.addToPrincipalPolicy(statement).statementAdded;
    }
    addToPrincipalPolicy(_statement) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_PolicyStatement(_statement);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addToPrincipalPolicy);
            }
            throw error;
        }
        // This base class is used for non-identity principals. None of them
        // have a PolicyDocument to add to.
        return { statementAdded: false };
    }
    addToAssumeRolePolicy(document) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_PolicyDocument(document);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addToAssumeRolePolicy);
            }
            throw error;
        }
        // Default implementation of this protocol, compatible with the legacy behavior
        document.addStatements(new policy_statement_1.PolicyStatement({
            actions: [this.assumeRoleAction],
            principals: [this],
        }));
    }
    toString() {
        // This is a first pass to make the object readable. Descendant principals
        // should return something nicer.
        return JSON.stringify(this.policyFragment.principalJson);
    }
    /**
     * JSON-ify the principal
     *
     * Used when JSON.stringify() is called
     */
    toJSON() {
        // Have to implement toJSON() because the default will lead to infinite recursion.
        return this.policyFragment.principalJson;
    }
    /**
     * Returns a new PrincipalWithConditions using this principal as the base, with the
     * passed conditions added.
     *
     * When there is a value for the same operator and key in both the principal and the
     * conditions parameter, the value from the conditions parameter will be used.
     *
     * @returns a new PrincipalWithConditions object.
     */
    withConditions(conditions) {
        return new PrincipalWithConditions(this, conditions);
    }
    /**
     * Returns a new principal using this principal as the base, with session tags enabled.
     *
     * @returns a new SessionTagsPrincipal object.
     */
    withSessionTags() {
        return new SessionTagsPrincipal(this);
    }
}
exports.PrincipalBase = PrincipalBase;
_a = JSII_RTTI_SYMBOL_1;
PrincipalBase[_a] = { fqn: "@aws-cdk/aws-iam.PrincipalBase", version: "1.157.0" };
/**
 * Base class for Principals that wrap other principals
 */
class PrincipalAdapter extends PrincipalBase {
    constructor(wrapped) {
        super();
        this.wrapped = wrapped;
        this.assumeRoleAction = this.wrapped.assumeRoleAction;
        this.principalAccount = this.wrapped.principalAccount;
    }
    get policyFragment() { return this.wrapped.policyFragment; }
    addToPolicy(statement) {
        return this.wrapped.addToPolicy(statement);
    }
    addToPrincipalPolicy(statement) {
        return this.wrapped.addToPrincipalPolicy(statement);
    }
}
/**
 * An IAM principal with additional conditions specifying when the policy is in effect.
 *
 * For more information about conditions, see:
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html
 */
class PrincipalWithConditions extends PrincipalAdapter {
    constructor(principal, conditions) {
        super(principal);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_IPrincipal(principal);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.additionalConditions = conditions;
    }
    /**
     * Add a condition to the principal
     */
    addCondition(key, value) {
        const existingValue = this.additionalConditions[key];
        this.additionalConditions[key] = existingValue ? { ...existingValue, ...value } : value;
    }
    /**
     * Adds multiple conditions to the principal
     *
     * Values from the conditions parameter will overwrite existing values with the same operator
     * and key.
     */
    addConditions(conditions) {
        Object.entries(conditions).forEach(([key, value]) => {
            this.addCondition(key, value);
        });
    }
    /**
     * The conditions under which the policy is in effect.
     * See [the IAM documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
     */
    get conditions() {
        return this.mergeConditions(this.wrapped.policyFragment.conditions, this.additionalConditions);
    }
    get policyFragment() {
        return new PrincipalPolicyFragment(this.wrapped.policyFragment.principalJson, this.conditions);
    }
    toString() {
        return this.wrapped.toString();
    }
    /**
     * JSON-ify the principal
     *
     * Used when JSON.stringify() is called
     */
    toJSON() {
        // Have to implement toJSON() because the default will lead to infinite recursion.
        return this.policyFragment.principalJson;
    }
    mergeConditions(principalConditions, additionalConditions) {
        const mergedConditions = {};
        Object.entries(principalConditions).forEach(([operator, condition]) => {
            mergedConditions[operator] = condition;
        });
        Object.entries(additionalConditions).forEach(([operator, condition]) => {
            // merge the conditions if one of the additional conditions uses an
            // operator that's already used by the principal's conditions merge the
            // inner structure.
            const existing = mergedConditions[operator];
            if (!existing) {
                mergedConditions[operator] = condition;
                return; // continue
            }
            // if either the existing condition or the new one contain unresolved
            // tokens, fail the merge. this is as far as we go at this point.
            if (cdk.Token.isUnresolved(condition) || cdk.Token.isUnresolved(existing)) {
                throw new Error(`multiple "${operator}" conditions cannot be merged if one of them contains an unresolved token`);
            }
            mergedConditions[operator] = { ...existing, ...condition };
        });
        return mergedConditions;
    }
}
exports.PrincipalWithConditions = PrincipalWithConditions;
_b = JSII_RTTI_SYMBOL_1;
PrincipalWithConditions[_b] = { fqn: "@aws-cdk/aws-iam.PrincipalWithConditions", version: "1.157.0" };
/**
 * Enables session tags on role assumptions from a principal
 *
 * For more information on session tags, see:
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html
 */
class SessionTagsPrincipal extends PrincipalAdapter {
    constructor(principal) {
        super(principal);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_IPrincipal(principal);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    addToAssumeRolePolicy(doc) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_PolicyDocument(doc);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addToAssumeRolePolicy);
            }
            throw error;
        }
        // Lazy import to avoid circular import dependencies during startup
        // eslint-disable-next-line @typescript-eslint/no-require-imports
        const adapter = require('./private/policydoc-adapter');
        assume_role_policy_1.defaultAddPrincipalToAssumeRole(this.wrapped, new adapter.MutatingPolicyDocumentAdapter(doc, (statement) => {
            statement.addActions('sts:TagSession');
            return statement;
        }));
    }
}
exports.SessionTagsPrincipal = SessionTagsPrincipal;
_c = JSII_RTTI_SYMBOL_1;
SessionTagsPrincipal[_c] = { fqn: "@aws-cdk/aws-iam.SessionTagsPrincipal", version: "1.157.0" };
/**
 * A collection of the fields in a PolicyStatement that can be used to identify a principal.
 *
 * This consists of the JSON used in the "Principal" field, and optionally a
 * set of "Condition"s that need to be applied to the policy.
 *
 * Generally, a principal looks like:
 *
 *     { '<TYPE>': ['ID', 'ID', ...] }
 *
 * And this is also the type of the field `principalJson`.  However, there is a
 * special type of principal that is just the string '*', which is treated
 * differently by some services. To represent that principal, `principalJson`
 * should contain `{ 'LiteralString': ['*'] }`.
 */
class PrincipalPolicyFragment {
    /**
     *
     * @param principalJson JSON of the "Principal" section in a policy statement
     * @param conditions conditions that need to be applied to this policy
     */
    constructor(principalJson, 
    /**
     * The conditions under which the policy is in effect.
     * See [the IAM documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
     */
    conditions = {}) {
        this.principalJson = principalJson;
        this.conditions = conditions;
    }
}
exports.PrincipalPolicyFragment = PrincipalPolicyFragment;
_d = JSII_RTTI_SYMBOL_1;
PrincipalPolicyFragment[_d] = { fqn: "@aws-cdk/aws-iam.PrincipalPolicyFragment", version: "1.157.0" };
/**
 * Specify a principal by the Amazon Resource Name (ARN).
 * You can specify AWS accounts, IAM users, Federated SAML users, IAM roles, and specific assumed-role sessions.
 * You cannot specify IAM groups or instance profiles as principals
 *
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html
 */
class ArnPrincipal extends PrincipalBase {
    /**
     *
     * @param arn Amazon Resource Name (ARN) of the principal entity (i.e. arn:aws:iam::123456789012:user/user-name)
     */
    constructor(arn) {
        super();
        this.arn = arn;
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({ AWS: [this.arn] });
    }
    toString() {
        return `ArnPrincipal(${this.arn})`;
    }
    /**
     * A convenience method for adding a condition that the principal is part of the specified
     * AWS Organization.
     */
    inOrganization(organizationId) {
        return this.withConditions({
            StringEquals: {
                'aws:PrincipalOrgID': organizationId,
            },
        });
    }
}
exports.ArnPrincipal = ArnPrincipal;
_e = JSII_RTTI_SYMBOL_1;
ArnPrincipal[_e] = { fqn: "@aws-cdk/aws-iam.ArnPrincipal", version: "1.157.0" };
/**
 * Specify AWS account ID as the principal entity in a policy to delegate authority to the account.
 */
class AccountPrincipal extends ArnPrincipal {
    /**
     *
     * @param accountId AWS account ID (i.e. 123456789012)
     */
    constructor(accountId) {
        super(new StackDependentToken(stack => `arn:${stack.partition}:iam::${accountId}:root`).toString());
        this.accountId = accountId;
        if (!cdk.Token.isUnresolved(accountId) && typeof accountId !== 'string') {
            throw new Error('accountId should be of type string');
        }
        this.principalAccount = accountId;
    }
    toString() {
        return `AccountPrincipal(${this.accountId})`;
    }
}
exports.AccountPrincipal = AccountPrincipal;
_f = JSII_RTTI_SYMBOL_1;
AccountPrincipal[_f] = { fqn: "@aws-cdk/aws-iam.AccountPrincipal", version: "1.157.0" };
/**
 * An IAM principal that represents an AWS service (i.e. sqs.amazonaws.com).
 */
class ServicePrincipal extends PrincipalBase {
    /**
     *
     * @param service AWS service (i.e. sqs.amazonaws.com)
     */
    constructor(service, opts = {}) {
        super();
        this.service = service;
        this.opts = opts;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_ServicePrincipalOpts(opts);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({
            Service: [
                new ServicePrincipalToken(this.service, this.opts).toString(),
            ],
        }, this.opts.conditions);
    }
    toString() {
        return `ServicePrincipal(${this.service})`;
    }
}
exports.ServicePrincipal = ServicePrincipal;
_g = JSII_RTTI_SYMBOL_1;
ServicePrincipal[_g] = { fqn: "@aws-cdk/aws-iam.ServicePrincipal", version: "1.157.0" };
/**
 * A principal that represents an AWS Organization
 */
class OrganizationPrincipal extends PrincipalBase {
    /**
     *
     * @param organizationId The unique identifier (ID) of an organization (i.e. o-12345abcde)
     */
    constructor(organizationId) {
        super();
        this.organizationId = organizationId;
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({ AWS: ['*'] }, { StringEquals: { 'aws:PrincipalOrgID': this.organizationId } });
    }
    toString() {
        return `OrganizationPrincipal(${this.organizationId})`;
    }
}
exports.OrganizationPrincipal = OrganizationPrincipal;
_h = JSII_RTTI_SYMBOL_1;
OrganizationPrincipal[_h] = { fqn: "@aws-cdk/aws-iam.OrganizationPrincipal", version: "1.157.0" };
/**
 * A policy principal for canonicalUserIds - useful for S3 bucket policies that use
 * Origin Access identities.
 *
 * See https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html
 *
 * and
 *
 * https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html
 *
 * for more details.
 *
 */
class CanonicalUserPrincipal extends PrincipalBase {
    /**
     *
     * @param canonicalUserId unique identifier assigned by AWS for every account.
     *   root user and IAM users for an account all see the same ID.
     *   (i.e. 79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be)
     */
    constructor(canonicalUserId) {
        super();
        this.canonicalUserId = canonicalUserId;
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({ CanonicalUser: [this.canonicalUserId] });
    }
    toString() {
        return `CanonicalUserPrincipal(${this.canonicalUserId})`;
    }
}
exports.CanonicalUserPrincipal = CanonicalUserPrincipal;
_j = JSII_RTTI_SYMBOL_1;
CanonicalUserPrincipal[_j] = { fqn: "@aws-cdk/aws-iam.CanonicalUserPrincipal", version: "1.157.0" };
/**
 * Principal entity that represents a federated identity provider such as Amazon Cognito,
 * that can be used to provide temporary security credentials to users who have been authenticated.
 * Additional condition keys are available when the temporary security credentials are used to make a request.
 * You can use these keys to write policies that limit the access of federated users.
 *
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#condition-keys-wif
 */
class FederatedPrincipal extends PrincipalBase {
    /**
     *
     * @param federated federated identity provider (i.e. 'cognito-identity.amazonaws.com' for users authenticated through Cognito)
     * @param conditions The conditions under which the policy is in effect.
     *   See [the IAM documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
     * @param sessionTags Whether to enable session tagging (see https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html)
     */
    constructor(federated, conditions, assumeRoleAction = 'sts:AssumeRole') {
        super();
        this.federated = federated;
        this.conditions = conditions;
        this.assumeRoleAction = assumeRoleAction;
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({ Federated: [this.federated] }, this.conditions);
    }
    toString() {
        return `FederatedPrincipal(${this.federated})`;
    }
}
exports.FederatedPrincipal = FederatedPrincipal;
_k = JSII_RTTI_SYMBOL_1;
FederatedPrincipal[_k] = { fqn: "@aws-cdk/aws-iam.FederatedPrincipal", version: "1.157.0" };
/**
 * A principal that represents a federated identity provider as Web Identity such as Cognito, Amazon,
 * Facebook, Google, etc.
 */
class WebIdentityPrincipal extends FederatedPrincipal {
    /**
     *
     * @param identityProvider identity provider (i.e. 'cognito-identity.amazonaws.com' for users authenticated through Cognito)
     * @param conditions The conditions under which the policy is in effect.
     *   See [the IAM documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
     * @param sessionTags Whether to enable session tagging (see https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html)
     */
    constructor(identityProvider, conditions = {}) {
        super(identityProvider, conditions !== null && conditions !== void 0 ? conditions : {}, 'sts:AssumeRoleWithWebIdentity');
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({ Federated: [this.federated] }, this.conditions);
    }
    toString() {
        return `WebIdentityPrincipal(${this.federated})`;
    }
}
exports.WebIdentityPrincipal = WebIdentityPrincipal;
_l = JSII_RTTI_SYMBOL_1;
WebIdentityPrincipal[_l] = { fqn: "@aws-cdk/aws-iam.WebIdentityPrincipal", version: "1.157.0" };
/**
 * A principal that represents a federated identity provider as from a OpenID Connect provider.
 */
class OpenIdConnectPrincipal extends WebIdentityPrincipal {
    /**
     *
     * @param openIdConnectProvider OpenID Connect provider
     * @param conditions The conditions under which the policy is in effect.
     *   See [the IAM documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
     */
    constructor(openIdConnectProvider, conditions = {}) {
        super(openIdConnectProvider.openIdConnectProviderArn, conditions !== null && conditions !== void 0 ? conditions : {});
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_IOpenIdConnectProvider(openIdConnectProvider);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({ Federated: [this.federated] }, this.conditions);
    }
    toString() {
        return `OpenIdConnectPrincipal(${this.federated})`;
    }
}
exports.OpenIdConnectPrincipal = OpenIdConnectPrincipal;
_m = JSII_RTTI_SYMBOL_1;
OpenIdConnectPrincipal[_m] = { fqn: "@aws-cdk/aws-iam.OpenIdConnectPrincipal", version: "1.157.0" };
/**
 * Principal entity that represents a SAML federated identity provider
 */
class SamlPrincipal extends FederatedPrincipal {
    constructor(samlProvider, conditions) {
        super(samlProvider.samlProviderArn, conditions, 'sts:AssumeRoleWithSAML');
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_ISamlProvider(samlProvider);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    toString() {
        return `SamlPrincipal(${this.federated})`;
    }
}
exports.SamlPrincipal = SamlPrincipal;
_o = JSII_RTTI_SYMBOL_1;
SamlPrincipal[_o] = { fqn: "@aws-cdk/aws-iam.SamlPrincipal", version: "1.157.0" };
/**
 * Principal entity that represents a SAML federated identity provider for
 * programmatic and AWS Management Console access.
 */
class SamlConsolePrincipal extends SamlPrincipal {
    constructor(samlProvider, conditions = {}) {
        super(samlProvider, {
            ...conditions,
            StringEquals: {
                'SAML:aud': 'https://signin.aws.amazon.com/saml',
            },
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_ISamlProvider(samlProvider);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    toString() {
        return `SamlConsolePrincipal(${this.federated})`;
    }
}
exports.SamlConsolePrincipal = SamlConsolePrincipal;
_p = JSII_RTTI_SYMBOL_1;
SamlConsolePrincipal[_p] = { fqn: "@aws-cdk/aws-iam.SamlConsolePrincipal", version: "1.157.0" };
/**
 * Use the AWS account into which a stack is deployed as the principal entity in a policy
 */
class AccountRootPrincipal extends AccountPrincipal {
    constructor() {
        super(new StackDependentToken(stack => stack.account).toString());
    }
    toString() {
        return 'AccountRootPrincipal()';
    }
}
exports.AccountRootPrincipal = AccountRootPrincipal;
_q = JSII_RTTI_SYMBOL_1;
AccountRootPrincipal[_q] = { fqn: "@aws-cdk/aws-iam.AccountRootPrincipal", version: "1.157.0" };
/**
 * A principal representing all AWS identities in all accounts
 *
 * Some services behave differently when you specify `Principal: '*'`
 * or `Principal: { AWS: "*" }` in their resource policy.
 *
 * `AnyPrincipal` renders to `Principal: { AWS: "*" }`. This is correct
 * most of the time, but in cases where you need the other principal,
 * use `StarPrincipal` instead.
 */
class AnyPrincipal extends ArnPrincipal {
    constructor() {
        super('*');
    }
    toString() {
        return 'AnyPrincipal()';
    }
}
exports.AnyPrincipal = AnyPrincipal;
_r = JSII_RTTI_SYMBOL_1;
AnyPrincipal[_r] = { fqn: "@aws-cdk/aws-iam.AnyPrincipal", version: "1.157.0" };
/**
 * A principal representing all identities in all accounts
 * @deprecated use `AnyPrincipal`
 */
class Anyone extends AnyPrincipal {
}
exports.Anyone = Anyone;
_s = JSII_RTTI_SYMBOL_1;
Anyone[_s] = { fqn: "@aws-cdk/aws-iam.Anyone", version: "1.157.0" };
/**
 * A principal that uses a literal '*' in the IAM JSON language
 *
 * Some services behave differently when you specify `Principal: "*"`
 * or `Principal: { AWS: "*" }` in their resource policy.
 *
 * `StarPrincipal` renders to `Principal: *`. Most of the time, you
 * should use `AnyPrincipal` instead.
 */
class StarPrincipal extends PrincipalBase {
    constructor() {
        super(...arguments);
        this.policyFragment = {
            principalJson: { [util_1.LITERAL_STRING_KEY]: ['*'] },
            conditions: {},
        };
    }
    toString() {
        return 'StarPrincipal()';
    }
}
exports.StarPrincipal = StarPrincipal;
_t = JSII_RTTI_SYMBOL_1;
StarPrincipal[_t] = { fqn: "@aws-cdk/aws-iam.StarPrincipal", version: "1.157.0" };
/**
 * Represents a principal that has multiple types of principals. A composite principal cannot
 * have conditions. i.e. multiple ServicePrincipals that form a composite principal
 */
class CompositePrincipal extends PrincipalBase {
    constructor(...principals) {
        super();
        this.principals = new Array();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_IPrincipal(principals);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (principals.length === 0) {
            throw new Error('CompositePrincipals must be constructed with at least 1 Principal but none were passed.');
        }
        this.assumeRoleAction = principals[0].assumeRoleAction;
        this.addPrincipals(...principals);
    }
    /**
     * Adds IAM principals to the composite principal. Composite principals cannot have
     * conditions.
     *
     * @param principals IAM principals that will be added to the composite principal
     */
    addPrincipals(...principals) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_IPrincipal(principals);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addPrincipals);
            }
            throw error;
        }
        this.principals.push(...principals);
        return this;
    }
    addToAssumeRolePolicy(doc) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_PolicyDocument(doc);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addToAssumeRolePolicy);
            }
            throw error;
        }
        for (const p of this.principals) {
            assume_role_policy_1.defaultAddPrincipalToAssumeRole(p, doc);
        }
    }
    get policyFragment() {
        // We only have a problem with conditions if we are trying to render composite
        // princpals into a single statement (which is when `policyFragment` would get called)
        for (const p of this.principals) {
            const fragment = p.policyFragment;
            if (fragment.conditions && Object.keys(fragment.conditions).length > 0) {
                throw new Error('Components of a CompositePrincipal must not have conditions. ' +
                    `Tried to add the following fragment: ${JSON.stringify(fragment)}`);
            }
        }
        const principalJson = {};
        for (const p of this.principals) {
            util_1.mergePrincipal(principalJson, p.policyFragment.principalJson);
        }
        return new PrincipalPolicyFragment(principalJson);
    }
    toString() {
        return `CompositePrincipal(${this.principals})`;
    }
}
exports.CompositePrincipal = CompositePrincipal;
_u = JSII_RTTI_SYMBOL_1;
CompositePrincipal[_u] = { fqn: "@aws-cdk/aws-iam.CompositePrincipal", version: "1.157.0" };
/**
 * A lazy token that requires an instance of Stack to evaluate
 */
class StackDependentToken {
    constructor(fn) {
        this.fn = fn;
        this.creationStack = cdk.captureStackTrace();
    }
    resolve(context) {
        return this.fn(cdk.Stack.of(context.scope));
    }
    toString() {
        return cdk.Token.asString(this);
    }
    /**
     * JSON-ify the token
     *
     * Used when JSON.stringify() is called
     */
    toJSON() {
        return '<unresolved-token>';
    }
}
class ServicePrincipalToken {
    constructor(service, opts) {
        this.service = service;
        this.opts = opts;
        this.creationStack = cdk.captureStackTrace();
    }
    resolve(ctx) {
        var _v;
        if (this.opts.region) {
            // Special case, handle it separately to not break legacy behavior.
            return (_v = region_info_1.RegionInfo.get(this.opts.region).servicePrincipal(this.service)) !== null && _v !== void 0 ? _v : region_info_1.Default.servicePrincipal(this.service, this.opts.region, cdk.Aws.URL_SUFFIX);
        }
        const stack = cdk.Stack.of(ctx.scope);
        return stack.regionalFact(region_info_1.FactName.servicePrincipal(this.service), region_info_1.Default.servicePrincipal(this.service, stack.region, cdk.Aws.URL_SUFFIX));
    }
    toString() {
        return cdk.Token.asString(this, {
            displayHint: this.service,
        });
    }
    /**
     * JSON-ify the token
     *
     * Used when JSON.stringify() is called
     */
    toJSON() {
        return `<${this.service}>`;
    }
}
//# sourceMappingURL=data:application/json;base64,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