#!/usr/bin/env python3
# -*- encoding: utf8 -*-
"""
Copyright 2015 Hippos Technical Systems BV.
(but borrows somme code from the painting/svgviewer example of PyQt v4.x)

@author: larry
"""

import os

from .. import (dbg_print, QtGui, WebView,
                WithPrinter, AddMenu)


class HtmlView(WebView, WithPrinter):

    menuTag = '&Html'

    def menuItems(self):
        return [
                    ('&Print',         None,  self.printAll,),
                    ('E&xport to PDF', None,  self.printAllToPDF,),
        ]

    def __init__(self):
        dbg_print(1, "HtmlView.__init__")
        WebView.__init__(self)
        WithPrinter.__init__(self)
        AddMenu(self, '&Html',
                [
                    ('&Print', None, self.printAll,),
                    ('E&xport to PDF', None, self.printAllToPDF,),
                ]
                )
    def showOutput(self, html_bytes):
        self.setHtml(html_bytes)
        with open(self.fileName, 'w') as output:
            output.write(html_bytes)

    def showAtRowAndCol(self, row, colhtml_bytes):
        pass  # for now!q

    def locateXY(self, x, y):
        pass  # for now!

    def printAll(self, toPDF=False):
        dbg_print(1, "printAll!")
        self.printer.setPageSize(QtGui.QPrinter.A4)
        self.printer.setOutputFormat(QtGui.QPrinter.PdfFormat)
        #self.printer.setOutputFileName(toPDF and self.compositeName or '')
        # see quick fix in .external! ...
        printName = toPDF and (os.path.splitext(self.fileName)[0] + '.pdf') or ''
        printName = printName.replace('autosave_', '')
        dbg_print(1, "printing to file ", printName)
        self.printer.setOutputFileName(printName)
        self.print_(self.printer)
