"""
    jast
    ~~~

    The `jast` body helps Python applications to process trees of the Java
    abstract syntax grammar.

    An abstract syntax tree can be generated by using the `parse()`
    func from this body.  The result will be a tree of objects whose
    classes all inherit from `jast.JAST`.

    A modified abstract syntax tree can be written back to Java source code
    by using the `unparse()` func.  This func takes a tree of objects
    and returns a string with the Java source code.

    Additionally various helper functions are provided that make working with
    the trees simpler. The main intention of the helper functions and this
    body in general is to provide an easy to use interface for libraries
    that work tightly with Java.


    :copyright: Copyright 2025 by Marius Smytzek and Martin Eberlein.
    :license: MIT License.
"""

from jast._jast import (
    JASTError,
    JAST,
    mod,
    CompilationUnit,
    ModularUnit,
    declaration,
    EmptyDecl,
    Package,
    Import,
    Module,
    Field,
    Method,
    Constructor,
    AnnotationMethod,
    Initializer,
    Class,
    Enum,
    Interface,
    AnnotationDecl,
    Record,
    directive,
    Requires,
    Exports,
    Opens,
    Uses,
    Provides,
    stmt,
    Empty,
    Block,
    Compound,
    LocalType,
    LocalVariable,
    Labeled,
    If,
    Switch,
    While,
    DoWhile,
    For,
    ForEach,
    Try,
    TryWithResources,
    Assert,
    Throw,
    Expression,
    Return,
    Yield,
    Break,
    Continue,
    Synch,
    expr,
    Lambda,
    Assign,
    IfExp,
    BinOp,
    InstanceOf,
    UnaryOp,
    PostOp,
    Cast,
    NewObject,
    NewArray,
    SwitchExp,
    This,
    Super,
    Constant,
    Name,
    ClassExpr,
    ExplicitGenericInvocation,
    Subscript,
    Member,
    Call,
    Reference,
    Match,
    operator,
    Or,
    And,
    BitOr,
    BitXor,
    BitAnd,
    Eq,
    NotEq,
    Lt,
    LtE,
    Gt,
    GtE,
    LShift,
    RShift,
    URShift,
    Add,
    Sub,
    Mult,
    Div,
    Mod,
    unaryop,
    PreInc,
    PreDec,
    UAdd,
    USub,
    Invert,
    Not,
    postop,
    PostInc,
    PostDec,
    enumconstant,
    recordcomponent,
    switchlabel,
    Case,
    DefaultCase,
    switchgroup,
    switchblock,
    catch,
    resource,
    ExpCase,
    ExpDefault,
    switchexprule,
    arrayinit,
    receiver,
    param,
    arity,
    params,
    qname,
    literal,
    IntLiteral,
    FloatLiteral,
    BoolLiteral,
    CharLiteral,
    StringLiteral,
    TextBlock,
    NullLiteral,
    modifier,
    Abstract,
    Default,
    Final,
    Native,
    NonSealed,
    Private,
    Protected,
    Public,
    Sealed,
    Static,
    Strictfp,
    Synchronized,
    Transient,
    Transitive,
    Volatile,
    Annotation,
    elementvaluepair,
    elementarrayinit,
    jtype,
    Void,
    Var,
    primitivetype,
    Boolean,
    Byte,
    Short,
    Int,
    Long,
    Char,
    Float,
    Double,
    Wildcard,
    Coit,
    ClassType,
    ArrayType,
    wildcardbound,
    typeargs,
    dim,
    variabledeclaratorid,
    declarator,
    typebound,
    typeparam,
    typeparams,
    pattern,
    guardedpattern,
    identifier,
)
from jast._parse import parse, ParseMode
from jast._unparse import unparse
from jast._visitors import JNodeVisitor, JNodeTransformer, JNodeKeepTransformer

__all__ = [
    "JASTError",
    "JAST",
    "mod",
    "CompilationUnit",
    "ModularUnit",
    "declaration",
    "EmptyDecl",
    "Package",
    "Import",
    "Module",
    "Field",
    "Method",
    "Constructor",
    "AnnotationMethod",
    "Initializer",
    "Class",
    "Enum",
    "Interface",
    "AnnotationDecl",
    "Record",
    "directive",
    "Requires",
    "Exports",
    "Opens",
    "Uses",
    "Provides",
    "stmt",
    "Empty",
    "Block",
    "Compound",
    "LocalType",
    "LocalVariable",
    "Labeled",
    "If",
    "Switch",
    "While",
    "DoWhile",
    "For",
    "ForEach",
    "Try",
    "TryWithResources",
    "Assert",
    "Throw",
    "Expression",
    "Return",
    "Yield",
    "Break",
    "Continue",
    "Synch",
    "expr",
    "Lambda",
    "Assign",
    "IfExp",
    "BinOp",
    "InstanceOf",
    "UnaryOp",
    "PostOp",
    "Cast",
    "NewObject",
    "NewArray",
    "SwitchExp",
    "This",
    "Super",
    "Constant",
    "Name",
    "ClassExpr",
    "ExplicitGenericInvocation",
    "Subscript",
    "Member",
    "Call",
    "Reference",
    "Match",
    "operator",
    "Or",
    "And",
    "BitOr",
    "BitXor",
    "BitAnd",
    "Eq",
    "NotEq",
    "Lt",
    "LtE",
    "Gt",
    "GtE",
    "LShift",
    "RShift",
    "URShift",
    "Add",
    "Sub",
    "Mult",
    "Div",
    "Mod",
    "unaryop",
    "PreInc",
    "PreDec",
    "UAdd",
    "USub",
    "Invert",
    "Not",
    "postop",
    "PostInc",
    "PostDec",
    "enumconstant",
    "recordcomponent",
    "switchlabel",
    "Case",
    "DefaultCase",
    "switchgroup",
    "switchblock",
    "catch",
    "resource",
    "ExpCase",
    "ExpDefault",
    "switchexprule",
    "arrayinit",
    "receiver",
    "param",
    "arity",
    "params",
    "qname",
    "literal",
    "IntLiteral",
    "FloatLiteral",
    "BoolLiteral",
    "CharLiteral",
    "StringLiteral",
    "TextBlock",
    "NullLiteral",
    "modifier",
    "Abstract",
    "Default",
    "Final",
    "Native",
    "NonSealed",
    "Private",
    "Protected",
    "Public",
    "Sealed",
    "Static",
    "Strictfp",
    "Synchronized",
    "Transient",
    "Transitive",
    "Volatile",
    "Annotation",
    "elementvaluepair",
    "elementarrayinit",
    "jtype",
    "Void",
    "Var",
    "primitivetype",
    "Boolean",
    "Byte",
    "Short",
    "Int",
    "Long",
    "Char",
    "Float",
    "Double",
    "Wildcard",
    "Coit",
    "ClassType",
    "ArrayType",
    "wildcardbound",
    "typeargs",
    "dim",
    "variabledeclaratorid",
    "declarator",
    "typebound",
    "typeparam",
    "typeparams",
    "pattern",
    "guardedpattern",
    "identifier",
    "parse",
    "ParseMode",
    "unparse",
    "JNodeVisitor",
    "JNodeTransformer",
]
