from typing import Any

import jast._jast as jast

class JNodeVisitor:
    def visit(self, node: jast.JAST): ...
    def generic_visit(self, node: jast.JAST): ...
    def default_result(self) -> Any: ...
    def aggregate_result(self, aggregate, result) -> Any: ...

    # Units
    def visit_CompilationUnit(self, node: jast.CompilationUnit): ...
    def visit_ModularUnit(self, node: jast.ModularUnit): ...

    # Declarations
    def visit_EmptyDecl(self, node: jast.EmptyDecl): ...
    def visit_Package(self, node: jast.Package): ...
    def visit_Import(self, node: jast.Import): ...
    def visit_Module(self, node: jast.Module): ...
    def visit_Field(self, node: jast.Field): ...
    def visit_Method(self, node: jast.Method): ...
    def visit_Constructor(self, node: jast.Constructor): ...
    def visit_AnnotationMethod(self, node: jast.AnnotationMethod): ...
    def visit_Initializer(self, node: jast.Initializer): ...
    def visit_Class(self, node: jast.Class): ...
    def visit_Enum(self, node: jast.Enum): ...
    def visit_Interface(self, node: jast.Interface): ...
    def visit_AnnotationDecl(self, node: jast.AnnotationDecl): ...
    def visit_Record(self, node: jast.Record): ...

    # Directives
    def visit_Requires(self, node: jast.Requires): ...
    def visit_Exports(self, node: jast.Exports): ...
    def visit_Opens(self, node: jast.Opens): ...
    def visit_Uses(self, node: jast.Uses): ...
    def visit_Provides(self, node: jast.Provides): ...

    # Statements
    def visit_Empty(self, node: jast.Empty): ...
    def visit_Block(self, node: jast.Block): ...
    def visit_Compound(self, node: jast.Compound): ...
    def visit_LocalType(self, node: jast.LocalType): ...
    def visit_LocalVariable(self, node: jast.LocalVariable): ...
    def visit_Labeled(self, node: jast.Labeled): ...
    def visit_If(self, node: jast.If): ...
    def visit_Switch(self, node: jast.Switch): ...
    def visit_While(self, node: jast.While): ...
    def visit_DoWhile(self, node: jast.DoWhile): ...
    def visit_For(self, node: jast.For): ...
    def visit_ForEach(self, node: jast.ForEach): ...
    def visit_Try(self, node: jast.Try): ...
    def visit_TryWithResources(self, node: jast.TryWithResources): ...
    def visit_Assert(self, node: jast.Assert): ...
    def visit_Throw(self, node: jast.Throw): ...
    def visit_Expression(self, node: jast.Expression): ...
    def visit_Return(self, node: jast.Return): ...
    def visit_Yield(self, node: jast.Yield): ...
    def visit_Break(self, node: jast.Break): ...
    def visit_Continue(self, node: jast.Continue): ...
    def visit_Synch(self, node: jast.Synch): ...

    # Expressions
    def visit_Lambda(self, node: jast.Lambda): ...
    def visit_Assign(self, node: jast.Assign): ...
    def visit_IfExp(self, node: jast.IfExp): ...
    def visit_BinOp(self, node: jast.BinOp): ...
    def visit_InstanceOf(self, node: jast.InstanceOf): ...
    def visit_UnaryOp(self, node: jast.UnaryOp): ...
    def visit_PostOp(self, node: jast.PostOp): ...
    def visit_Cast(self, node: jast.Cast): ...
    def visit_NewObject(self, node: jast.NewObject): ...
    def visit_NewArray(self, node: jast.NewArray): ...
    def visit_SwitchExp(self, node: jast.SwitchExp): ...
    def visit_This(self, node: jast.This): ...
    def visit_Super(self, node: jast.Super): ...
    def visit_Constant(self, node: jast.Constant): ...
    def visit_Name(self, node: jast.Name): ...
    def visit_ClassExpr(self, node: jast.ClassExpr): ...
    def visit_ExplicitGenericInvocation(self, node: jast.ExplicitGenericInvocation): ...
    def visit_Subscript(self, node: jast.Subscript): ...
    def visit_Member(self, node: jast.Member): ...
    def visit_Call(self, node: jast.Call): ...
    def visit_Reference(self, node: jast.Reference): ...
    def visit_Match(self, node: jast.Match): ...

    # Operators
    def visit_Or(self, node: jast.Or): ...
    def visit_And(self, node: jast.And): ...
    def visit_BitOr(self, node: jast.BitOr): ...
    def visit_BitXor(self, node: jast.BitXor): ...
    def visit_BitAnd(self, node: jast.BitAnd): ...
    def visit_Eq(self, node: jast.Eq): ...
    def visit_NotEq(self, node: jast.NotEq): ...
    def visit_Lt(self, node: jast.Lt): ...
    def visit_Gt(self, node: jast.Gt): ...
    def visit_LtE(self, node: jast.LtE): ...
    def visit_GtE(self, node: jast.GtE): ...
    def visit_LShift(self, node: jast.LShift): ...
    def visit_RShift(self, node: jast.RShift): ...
    def visit_URShift(self, node: jast.URShift): ...
    def visit_Add(self, node: jast.Add): ...
    def visit_Sub(self, node: jast.Sub): ...
    def visit_Mult(self, node: jast.Mult): ...
    def visit_Div(self, node: jast.Div): ...
    def visit_Mod(self, node: jast.Mod): ...
    def visit_PreInc(self, node: jast.PreInc): ...
    def visit_PreDec(self, node: jast.PreDec): ...
    def visit_UAdd(self, node: jast.UAdd): ...
    def visit_USub(self, node: jast.USub): ...
    def visit_Invert(self, node: jast.Invert): ...
    def visit_Not(self, node: jast.Not): ...
    def visit_PostInc(self, node: jast.PostInc): ...
    def visit_PostDec(self, node: jast.PostDec): ...

    # Utils
    def visit_enumconstant(self, node: jast.enumconstant): ...
    def visit_recordcomponent(self, node: jast.recordcomponent): ...
    def visit_Case(self, node: jast.Case): ...
    def visit_DefaultCase(self, node: jast.DefaultCase): ...
    def visit_switchgroup(self, node: jast.switchgroup): ...
    def visit_switchblock(self, node: jast.switchblock): ...
    def visit_catch(self, node: jast.catch): ...
    def visit_resource(self, node: jast.resource): ...
    def visit_ExpCase(self, node: jast.ExpCase): ...
    def visit_ExpDefault(self, node: jast.ExpDefault): ...
    def visit_switchexprule(self, node: jast.switchexprule): ...
    def visit_arrayinit(self, node: jast.arrayinit): ...

    # Parameters
    def visit_receiver(self, node: jast.receiver): ...
    def visit_param(self, node: jast.param): ...
    def visit_arity(self, node: jast.arity): ...
    def visit_params(self, node: jast.params): ...

    # Literals
    def visit_IntLiteral(self, node: jast.IntLiteral): ...
    def visit_FloatLiteral(self, node: jast.FloatLiteral): ...
    def visit_BoolLiteral(self, node: jast.BoolLiteral): ...
    def visit_CharLiteral(self, node: jast.CharLiteral): ...
    def visit_StringLiteral(self, node: jast.StringLiteral): ...
    def visit_TextBlock(self, node: jast.TextBlock): ...
    def visit_NullLiteral(self, node: jast.NullLiteral): ...

    # Modifiers
    def visit_Abstract(self, node: jast.Abstract): ...
    def visit_Default(self, node: jast.Default): ...
    def visit_Final(self, node: jast.Final): ...
    def visit_Native(self, node: jast.Native): ...
    def visit_NonSealed(self, node: jast.NonSealed): ...
    def visit_Private(self, node: jast.Private): ...
    def visit_Protected(self, node: jast.Protected): ...
    def visit_Public(self, node: jast.Public): ...
    def visit_Sealed(self, node: jast.Sealed): ...
    def visit_Static(self, node: jast.Static): ...
    def visit_Strictfp(self, node: jast.Strictfp): ...
    def visit_Synchronized(self, node: jast.Synchronized): ...
    def visit_Transient(self, node: jast.Transient): ...
    def visit_Transitive(self, node: jast.Transitive): ...
    def visit_Volatile(self, node: jast.Volatile): ...
    def visit_Annotation(self, node: jast.Annotation): ...

    # Elements
    def visit_elementvaluepair(self, node: jast.elementvaluepair): ...
    def visit_elementarrayinit(self, node: jast.elementarrayinit): ...

    # Types
    def visit_Void(self, node: jast.Void): ...
    def visit_Var(self, node: jast.Var): ...
    def visit_Boolean(self, node: jast.Boolean): ...
    def visit_Byte(self, node: jast.Byte): ...
    def visit_Short(self, node: jast.Short): ...
    def visit_Int(self, node: jast.Int): ...
    def visit_Long(self, node: jast.Long): ...
    def visit_Char(self, node: jast.Char): ...
    def visit_Float(self, node: jast.Float): ...
    def visit_Double(self, node: jast.Double): ...
    def visit_Wildcard(self, node: jast.Wildcard): ...
    def visit_Coit(self, node: jast.Coit): ...
    def visit_ClassType(self, node: jast.ClassType): ...
    def visit_ArrayType(self, node: jast.ArrayType): ...
    def visit_wildcardbound(self, node: jast.wildcardbound): ...
    def visit_typeargs(self, node: jast.typeargs): ...
    def visit_dim(self, node: jast.dim): ...
    def visit_variabledeclaratorid(self, node: jast.variabledeclaratorid): ...
    def visit_declarator(self, node: jast.declarator): ...
    def visit_typebound(self, node: jast.typebound): ...
    def visit_typeparam(self, node: jast.typeparam): ...
    def visit_typeparams(self, node: jast.typeparams): ...
    def visit_pattern(self, node: jast.pattern): ...
    def visit_guardedpattern(self, node: jast.guardedpattern): ...
    def visit_qname(self, node: jast.qname): ...
    def visit_identifier(self, node: jast.identifier): ...

class JNodeTransformer(JNodeVisitor):
    pass

class JNodeKeepTransformer(JNodeVisitor):
    pass
